/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.6.1/LICENSE.txt
 */
var maplibregl=function(){"use strict";function t(t,e,r,n){return new(r||(r=Promise))((function(i,s){function o(t){try{l(n.next(t))}catch(t){s(t)}}function a(t){try{l(n.throw(t))}catch(t){s(t)}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(o,a)}l((n=n.apply(t,e||[])).next())}))}function e(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var r,n;function i(){if(n)return r;function t(t,e){this.x=t,this.y=e}return n=1,r=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},r}"function"==typeof SuppressedError&&SuppressedError;var s,o,a=e(i()),l=function(){if(o)return s;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return o=1,s=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},s}(),u=e(l);let c,h;var p,f="undefined"!=typeof Float32Array?Float32Array:Array;function d(t,e,r){var n=e[0],i=e[1],s=e[2],o=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)}),p=new f(4),f!=Float32Array&&(p[0]=0,p[1]=0,p[2]=0,p[3]=0);const y=8192;function m(t,e,r){return Math.min(r,Math.max(e,t))}function g(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function x(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function v(t){return Array.isArray(t)?t.map(v):"object"==typeof t&&t?x(t,v):t}new u(.25,.1,.25,1);const b={};function w(t){b[t]||("undefined"!=typeof console&&console.warn(t),b[t]=!0)}function _(t,e,r){return(r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function S(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}function k(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}let A,I;function M(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n)}}}function z(t){return t*Math.PI/180}class P{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r))}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly}else{this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s)}query(t,e,r,n,i){const s=this.min,o=this.max;if(t<=s&&e<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,o,a){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===o[h]){const l=4*h;(a?a(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(o[h]=!0,s.push(i[h])):o[h]=!1}}}}_forEachCell(t,e,r,n,i,s,o,a){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,o,a))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new P(t.buffer)}}var T={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const C=["type","source","source-layer","minzoom","maxzoom","filter","layout"];class B{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__)}}function E(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class V extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class F{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r}concat(t){return new F(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const D={kind:"null"},L={kind:"number"},$={kind:"string"},O={kind:"boolean"},R={kind:"color"},N={kind:"projectionDefinition"},j={kind:"object"},U={kind:"value"},q={kind:"collator"},G={kind:"formatted"},X={kind:"padding"},Z={kind:"colorArray"},Y={kind:"numberArray"},H={kind:"resolvedImage"},J={kind:"variableAnchorOffsetCollection"};function W(t,e){return{kind:"array",itemType:t,N:e}}function K(t){if("array"===t.kind){const e=K(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Q=[D,L,$,O,R,N,G,j,W(U),X,Y,Z,H,J];function tt(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!tt(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Q)if(!tt(t,e))return null}return`Expected ${K(t)} but found ${K(e)} instead.`}function et(t,e){return e.some((e=>e.kind===t.kind))}function rt(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function nt(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const it=.96422,st=.82521,ot=4/29,at=6/29,lt=3*at*at,ut=at*at*at,ct=Math.PI/180,ht=180/Math.PI;function pt(t){return(t%=360)<0&&(t+=360),t}function ft([t,e,r,n]){let i,s;const o=yt((.2225045*(t=dt(t))+.7168786*(e=dt(e))+.0606169*(r=dt(r)))/1);t===e&&e===r?i=s=o:(i=yt((.4360747*t+.3850649*e+.1430804*r)/it),s=yt((.0139322*t+.0971045*e+.7141733*r)/st));const a=116*o-16;return[a<0?0:a,500*(i-o),200*(o-s),n]}function dt(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function yt(t){return t>ut?Math.pow(t,1/3):t/lt+ot}function mt([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,o=isNaN(r)?i:i-r/200;return i=1*xt(i),s=it*xt(s),o=st*xt(o),[gt(3.1338561*s-1.6168667*i-.4906146*o),gt(-.9787684*s+1.9161415*i+.033454*o),gt(.0719453*s-.2289914*i+1.4052427*o),n]}function gt(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function xt(t){return t>at?t*t*t:lt*(t-ot)}const vt=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function bt(t,e){return vt(t,e)?t[e]:void 0}function wt(t){return parseInt(t.padEnd(2,t),16)/255}function _t(t,e){return St(e?t/100:t,0,1)}function St(t,e,r){return Math.min(Math.max(e,t),r)}function kt(t){return!t.some(Number.isNaN)}const At={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function It(t,e,r){return t+r*(e-t)}function Mt(t,e,r){return t.map(((t,n)=>It(t,e[n],r)))}class zt{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]))}static parse(t){if(t instanceof zt)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=bt(At,t);if(e){const[t,r,n]=e;return[t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return[wt(t.slice(r,r+=e)),wt(t.slice(r,r+=e)),wt(t.slice(r,r+=e)),wt(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,o,a,l,u,c,h,p]=e,f=[i||" ",a||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,o,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[St(+r/e,0,1),St(+s/e,0,1),St(+l/e,0,1),h?_t(+h,p):1];if(kt(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,o,a,l,u]=r,c=[n||" ",s||" ",a].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,St(+i,0,100),St(+o,0,100),l?_t(+l,u):1];if(kt(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=pt(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new zt(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=ft(t),s=Math.sqrt(r*r+n*n);return[Math.round(1e4*s)?pt(Math.atan2(n,r)*ht):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",ft(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return`rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case"rgb":{const[n,i,s,o]=Mt(t.rgb,e.rgb,r);return new zt(n,i,s,o,!1)}case"hcl":{const[n,i,s,o]=t.hcl,[a,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(a))isNaN(n)?isNaN(a)?h=NaN:(h=a,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else{let t=a-n;a>n&&t>180?t-=360:a<n&&n-a>180&&(t+=360),h=n+r*t}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*ct,mt([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:It(i,l,r),It(s,u,r),It(o,c,r)]);return new zt(f,d,y,m,!1)}case"lab":{const[n,i,s,o]=mt(Mt(t.lab,e.lab,r));return new zt(n,i,s,o,!1)}}}}zt.black=new zt(0,0,0,1),zt.white=new zt(1,1,1,1),zt.transparent=new zt(0,0,0,0),zt.red=new zt(1,0,0,1);class Pt{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Tt=["bottom","center","top"];class Ct{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s}}class Bt{constructor(t){this.sections=t}static fromString(t){return new Bt([new Ct(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Bt?t:Bt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Et{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Et)return t;if("number"==typeof t)return new Et([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new Et(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Et(Mt(t.values,e.values,r))}}class Vt{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Vt)return t;if("number"==typeof t)return new Vt([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Vt(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Vt(Mt(t.values,e.values,r))}}class Ft{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ft)return t;if("string"==typeof t){const e=zt.parse(t);if(!e)return;return new Ft([e])}if(!Array.isArray(t))return;const e=[];for(const r of t){if("string"!=typeof r)return;const t=zt.parse(r);if(!t)return;e.push(t)}return new Ft(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r,n="rgb"){const i=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)i.push(zt.interpolate(t.values[s],e.values[s],r,n));return new Ft(i)}}class Dt extends Error{constructor(t){super(t),this.name="RuntimeError"}toJSON(){return this.message}}const Lt=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class $t{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof $t)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Lt.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new $t(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new Dt(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new Dt(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,o]=n[t+1],[a,l]=i[t+1];s.push([It(e,a,r),It(o,l,r)])}return new $t(s)}}class Ot{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new Ot({name:t,available:!1}):null}}class Rt{constructor(t,e,r){this.from=t,this.to=e,this.transition=r}static interpolate(t,e,r){return new Rt(t,e,r)}static parse(t){return t instanceof Rt?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Rt(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Rt(t.from,t.to,t.transition):"string"==typeof t?new Rt(t,t,1):void 0}}function Nt(t,e,r,n){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function jt(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Rt||t instanceof zt||t instanceof Pt||t instanceof Bt||t instanceof Et||t instanceof Vt||t instanceof Ft||t instanceof $t||t instanceof Ot)return!0;if(Array.isArray(t)){for(const e of t)if(!jt(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!jt(t[e]))return!1;return!0}return!1}function Ut(t){if(null===t)return D;if("string"==typeof t)return $;if("boolean"==typeof t)return O;if("number"==typeof t)return L;if(t instanceof zt)return R;if(t instanceof Rt)return N;if(t instanceof Pt)return q;if(t instanceof Bt)return G;if(t instanceof Et)return X;if(t instanceof Vt)return Y;if(t instanceof Ft)return Z;if(t instanceof $t)return J;if(t instanceof Ot)return H;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Ut(e);if(r){if(r===t)continue;r=U;break}r=t}return W(r||U,e)}return j}function qt(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof zt||t instanceof Rt||t instanceof Bt||t instanceof Et||t instanceof Vt||t instanceof Ft||t instanceof $t||t instanceof Ot?t.toString():JSON.stringify(t)}class Gt{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!jt(t[1]))return e.error("invalid value");const r=t[1];let n=Ut(r);const i=e.expectedType;return"array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Gt(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Xt={string:$,number:L,boolean:O,object:j};class Zt{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Xt)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Xt[r],n++}else i=U;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++}r=W(i,s)}else{if(!Xt[i])throw new Error(`Types doesn't contain name = ${i}`);r=Xt[i]}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,U);if(!r)return null;s.push(r)}return new Zt(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!tt(this.type,Ut(r)))return r;if(e===this.args.length-1)throw new Dt(`Expected value to be of type ${K(this.type)}, but found ${K(Ut(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Yt={"to-boolean":O,"to-color":R,"to-number":L,"to-string":$};class Ht{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Yt[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Yt[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,U);if(!n)return null;i.push(n)}return new Ht(n,i)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof zt)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Nt(e[0],e[1],e[2],e[3]),!r))return new zt(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Dt(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Et.parse(e);if(n)return n}throw new Dt(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"numberArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Vt.parse(e);if(n)return n}throw new Dt(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"colorArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Ft.parse(e);if(n)return n}throw new Dt(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=$t.parse(e);if(n)return n}throw new Dt(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Dt(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Bt.fromString(qt(this.args[0].evaluate(t)));case"resolvedImage":return Ot.fromString(qt(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return qt(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Jt=["Unknown","Point","LineString","Polygon"];class Wt{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Jt[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=zt.parse(t),this._parseColorCache.set(t,e)),e}}class Kt{constructor(t,e,r=[],n,i=new F,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return"assert"===r?new Zt(e,[t]):"coerce"===r?new Ht(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===t.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(i.kind))n=r(n,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"assert")}if(!(n instanceof Gt)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new Wt;try{n=new Gt(n.type,n.evaluate(t))}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Kt(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new V(r,t))}checkSubtype(t,e){const r=tt(t,e);return r&&this.error(r),r}}class Qt{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s])}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Qt(r,n):null}outputDefined(){return this.result.outputDefined()}}class te{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new te(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class ee{constructor(t,e,r){this.type=t,this.index=e,this.input=r}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,L),n=e.parse(t[2],2,W(e.expectedType||U));return r&&n?new ee(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Dt(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Dt(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Dt(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class re{constructor(t,e){this.type=O,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,U);return r&&n?et(r.type,[O,$,L,D,U])?new re(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${K(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return!1;if(!rt(e,["boolean","string","number","null"]))throw new Dt(`Expected first argument to be of type boolean, string, number or null, but found ${K(Ut(e))} instead.`);if(!rt(r,["string","array"]))throw new Dt(`Expected second argument to be of type array or string, but found ${K(Ut(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class ne{constructor(t,e,r){this.type=L,this.needle=t,this.haystack=e,this.fromIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,U);if(!r||!n)return null;if(!et(r.type,[O,$,L,D,U]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${K(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,L);return i?new ne(r,n,i):null}return new ne(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!rt(e,["boolean","string","number","null"]))throw new Dt(`Expected first argument to be of type boolean, string, number or null, but found ${K(Ut(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),rt(r,["string"])){const t=r.indexOf(e,n);return-1===t?-1:[...r.slice(0,t)].length}if(rt(r,["array"]))return r.indexOf(e,n);throw new Dt(`Expected second argument to be of type array or string, but found ${K(Ut(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class ie{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const u=e.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Ut(t)))return null}else r=Ut(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length}const c=e.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c)}const o=e.parse(t[1],1,U);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,n);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(r,o.type)?null:new ie(r,n,o,i,s,a):null}evaluate(t){const e=this.input.evaluate(t);return(Ut(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class se{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,O);if(!s)return null;const o=e.parse(t[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new se(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class oe{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,U),n=e.parse(t[2],2,L);if(!r||!n)return null;if(!et(r.type,[W(U),$,U]))return e.error(`Expected first argument to be of type array or string, but found ${K(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,L);return i?new oe(r.type,r,n,i):null}return new oe(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),rt(e,["string"]))return[...e].slice(r,n).join("");if(rt(e,["array"]))return e.slice(r,n);throw new Dt(`Expected first argument to be of type array or string, but found ${K(Ut(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function ae(t,e){const r=t.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=t[a],i=t[a+1],n<=e){if(a===r||e<i)return a;s=a+1}else{if(!(n>e))throw new Dt("Input is not a number.");o=a-1}return 0}class le{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,L);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],o=t[r+1],a=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=e.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u])}return new le(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[ae(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function ue(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var ce,he,pe=function(){if(he)return ce;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n}return he=1,ce=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s}var o=0,a=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},ce}(),fe=ue(pe);class de{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=ye(e,t.base,r,n);else if("linear"===t.name)i=ye(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new fe(s[0],s[1],s[2],s[3]).solve(ye(e,1,r,n))}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t}}else{if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,L),!i)return null;const o=[];let a=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||e.expectedType==Z?e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType):a=R;for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u])}return nt(a,L)||nt(a,N)||nt(a,R)||nt(a,X)||nt(a,Y)||nt(a,Z)||nt(a,J)||nt(a,W(L))?new de(a,r,n,i,o):e.error(`Type ${K(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=ae(e,n),o=de.interpolationFactor(this.interpolation,n,e[s],e[s+1]),a=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return It(a,l,o);case"color":return zt.interpolate(a,l,o);case"padding":return Et.interpolate(a,l,o);case"colorArray":return Ft.interpolate(a,l,o);case"numberArray":return Vt.interpolate(a,l,o);case"variableAnchorOffsetCollection":return $t.interpolate(a,l,o);case"array":return Mt(a,l,o);case"projectionDefinition":return Rt.interpolate(a,l,o)}case"interpolate-hcl":switch(this.type.kind){case"color":return zt.interpolate(a,l,o,"hcl");case"colorArray":return Ft.interpolate(a,l,o,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return zt.interpolate(a,l,o,"lab");case"colorArray":return Ft.interpolate(a,l,o,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function ye(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}const me={color:zt.interpolate,number:It,padding:Et.interpolate,numberArray:Vt.interpolate,colorArray:Ft.interpolate,variableAnchorOffsetCollection:$t.interpolate,array:Mt};class ge{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t)}if(!r)throw new Error("No output type");const s=n&&i.some((t=>tt(n,t.type)));return new ge(s?U:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof Ot&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function xe(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function ve(t,e,r,n){return 0===n.compare(e,r)}function be(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=O,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,U);if(!s)return null;if(!xe(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${K(s.type)}'.`);let o=e.parse(t[2],2,U);if(!o)return null;if(!xe(r,o.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${K(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${K(s.type)}' and '${K(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Zt(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Zt(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,q),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Ut(s),r=Ut(o);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Dt(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Ut(s),r=Ut(o);if("string"!==t.kind||"string"!==r.kind)return e(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):e(i,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const we=be("==",(function(t,e,r){return e===r}),ve),_e=be("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return!ve(0,e,r,n)})),Se=be("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),ke=be(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Ae=be("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Ie=be(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class Me{constructor(t,e,r){this.type=q,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,O);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,O);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,$),!s)?null:new Me(n,i,s)}evaluate(t){return new Pt(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class ze{constructor(t,e,r,n,i){this.type=$,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,L);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,$),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,$),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parse(n["min-fraction-digits"],1,L),!o))return null;let a=null;return n["max-fraction-digits"]&&(a=e.parse(n["max-fraction-digits"],1,L),!a)?null:new ze(r,i,s,o,a)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class Pe{constructor(t){this.type=G,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,L),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,W($)),!r))return null;let o=null;if(s["text-color"]&&(o=e.parse(s["text-color"],1,R),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Tt.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=e.parse(s["vertical-align"],1,$),!a)return null}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=o,l.verticalAlign=a}else{const s=e.parse(t[r],1,U);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Pe(n)}evaluate(t){return new Bt(this.sections.map((e=>{const r=e.content.evaluate(t);return Ut(r)===H?new Ct("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Ct(qt(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Te{constructor(t){this.type=H,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,$);return r?new Te(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Ot.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input)}outputDefined(){return!1}}class Ce{constructor(t){this.type=L,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${K(r.type)} instead.`):new Ce(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Dt(`Expected value to be of type string or array, but found ${K(Ut(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Be=8192;function Ee(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return[Math.round(r*i*Be),Math.round(n*i*Be)]}function Ve(t,e){const r=Math.pow(2,e.z);return[(i=(t[0]/Be+e.x)/r,360*i-180),(n=(t[1]/Be+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i}function Fe(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function De(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Le(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],o=t[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function $e(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!qe(t,e,r,n)||!qe(r,n,t,e));var i,s}function Oe(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if($e(t,e,n[r],n[r+1]))return!0;return!1}function Re(t,e,r=!1){let n=!1;for(const a of e)for(let e=0;e<a.length-1;e++){if(Le(t,a[e],a[e+1]))return r;(s=a[e])[1]>(i=t)[1]!=(o=a[e+1])[1]>i[1]&&i[0]<(o[0]-s[0])*(i[1]-s[1])/(o[1]-s[1])+s[0]&&(n=!n)}var i,s,o;return n}function Ne(t,e){for(const r of e)if(Re(t,r))return!0;return!1}function je(t,e){for(const r of t)if(!Re(r,e))return!1;for(let r=0;r<t.length-1;++r)if(Oe(t[r],t[r+1],e))return!1;return!0}function Ue(t,e){for(const r of e)if(je(t,r))return!0;return!1}function qe(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(t[0]-r[0])*s-i*(t[1]-r[1]),a=(e[0]-r[0])*s-i*(e[1]-r[1]);return o>0&&a<0||o<0&&a>0}function Ge(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const o=Ee(t[i][n],r);Fe(e,o),s.push(o)}n.push(s)}return n}function Xe(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Ge(t[i],e,r);n.push(s)}return n}function Ze(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i}Fe(e,t)}function Ye(t,e,r,n){const i=Math.pow(2,n.z)*Be,s=[n.x*Be,n.y*Be],o=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Ze(n,e,r,i),o.push(n)}return o}function He(t,e,r,n){const i=Math.pow(2,n.z)*Be,s=[n.x*Be,n.y*Be],o=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Fe(e,r),t.push(r)}o.push(t)}if(e[2]-e[0]<=i/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const n of t)Ze(n,e,r,i)}var a;return o}class Je{constructor(t,e){this.type=O,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(jt(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n)}if(t.length)return new Je(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Je(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Je(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Ge(e.coordinates,n,i),o=Ye(t.geometry(),r,n,i);if(!De(r,n))return!1;for(const t of o)if(!Re(t,s))return!1}if("MultiPolygon"===e.type){const s=Xe(e.coordinates,n,i),o=Ye(t.geometry(),r,n,i);if(!De(r,n))return!1;for(const t of o)if(!Ne(t,s))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Ge(e.coordinates,n,i),o=He(t.geometry(),r,n,i);if(!De(r,n))return!1;for(const t of o)if(!je(t,s))return!1}if("MultiPolygon"===e.type){const s=Xe(e.coordinates,n,i),o=He(t.geometry(),r,n,i);if(!De(r,n))return!1;for(const t of o)if(!Ue(t,s))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}let We=class{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n}e[t]=i}};function Ke(t,e,r=0,n=t.length-1,i=tr){for(;n>r;){if(n-r>600){const s=n-r+1,o=e-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);Ke(t,e,Math.max(r,Math.floor(e-o*l/s+u)),Math.min(n,Math.floor(e+(s-o)*l/s+u)),i)}const s=t[e];let o=r,a=n;for(Qe(t,r,e),i(t[n],s)>0&&Qe(t,r,n);o<a;){for(Qe(t,o,a),o++,a--;i(t[o],s)<0;)o++;for(;i(t[a],s)>0;)a--}0===i(t[r],s)?Qe(t,r,a):(a++,Qe(t,a,n)),a<=e&&(r=a+1),e<=a&&(n=a-1)}}function Qe(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function tr(t,e){return t<e?-1:t>e?1:0}function er(t,e){if(t.length<=1)return[t];const r=[];let n,i;for(const e of t){const t=nr(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e))}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Ke(r[t],e,1,r[t].length-1,rr),r[t]=r[t].slice(0,e));return r}function rr(t,e){return e.area-t.area}function nr(t){let e=0;for(let r,n,i=0,s=t.length,o=s-1;i<s;o=i++)r=t[i],n=t[o],e+=(n.x-r.x)*(r.y+n.y);return e}const ir=1/298.257223563,sr=ir*(2-ir),or=Math.PI/180;class ar{constructor(t){const e=6378.137*or*1e3,r=Math.cos(t*or),n=1/(1-sr*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-sr)}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,o=1/0;for(let a=0;a<t.length-1;a++){let l=t[a][0],u=t[a][1],c=this.wrap(t[a+1][0]-l)*this.kx,h=(t[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[a+1][0],u=t[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<o&&(o=f,r=l,n=u,i=a,s=p)}return{point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function lr(t,e){return e[0]-t[0]}function ur(t){return t[1]-t[0]+1}function cr(t,e){return t[1]>=t[0]&&t[1]<e}function hr(t,e){if(t[0]>t[1])return[null,null];const r=ur(t);if(e){if(2===r)return[t,null];const e=Math.floor(r/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return[t,null];const n=Math.floor(r/2)-1;return[[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function pr(t,e){if(!cr(e,t.length))return[1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Fe(r,t[n]);return r}function fr(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Fe(e,t);return e}function dr(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function yr(t,e,r){if(!dr(t)||!dr(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function mr(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function gr(t,e,r,n,i){const s=Math.min(mr(t,[r,n],i),mr(e,[r,n],i)),o=Math.min(mr(r,[t,e],i),mr(n,[t,e],i));return Math.min(s,o)}function xr(t,e,r,n,i){if(!cr(e,t.length)||!cr(n,r.length))return 1/0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(let t=n[0];t<n[1];++t){const n=r[t],o=r[t+1];if($e(e,a,n,o))return 0;s=Math.min(s,gr(e,a,n,o,i))}}return s}function vr(t,e,r,n,i){if(!cr(e,t.length)||!cr(n,r.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[o],r[e])),0===s)return s;return s}function br(t,e,r){if(Re(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,mr(t,[s,e],r)),0===n))return n;const o=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,o.point)),0===n)return n}return n}function wr(t,e,r,n){if(!cr(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Re(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(const t of r)for(let r=0,s=t.length,a=s-1;r<s;a=r++){const s=t[a],l=t[r];if($e(e,o,s,l))return 0;i=Math.min(i,gr(e,o,s,l,n))}}return i}function _r(t,e){for(const r of t)for(const t of r)if(Re(t,e,!0))return!0;return!1}function Sr(t,e,r,n=1/0){const i=fr(t),s=fr(e);if(n!==1/0&&yr(i,s,r)>=n)return n;if(De(i,s)){if(_r(t,e))return 0}else if(_r(e,t))return 0;let o=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],a=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if($e(i,a,n,l))return 0;o=Math.min(o,gr(i,a,n,l,r))}}return o}function kr(t,e,r,n,i,s){if(!s)return;const o=yr(pr(n,s),i,r);o<e&&t.push([o,s,[0,0]])}function Ar(t,e,r,n,i,s,o){if(!s||!o)return;const a=yr(pr(n,s),pr(i,o),r);a<e&&t.push([a,s,o])}function Ir(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const o=new We([[0,[0,t.length-1],[0,0]]],lr),a=fr(r);for(;o.length>0;){const i=o.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(ur(l)<=u){if(!cr(l,t.length))return NaN;if(e){const e=wr(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e)}else for(let e=l[0];e<=l[1];++e){const i=br(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else{const r=hr(l,e);kr(o,s,n,t,a,r[0]),kr(o,s,n,t,a,r[1])}}return s}function Mr(t,e,r,n,i,s=1/0){let o=Math.min(s,i.distance(t[0],r[0]));if(0===o)return o;const a=new We([[0,[0,t.length-1],[0,r.length-1]]],lr);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(ur(l)<=c&&ur(u)<=h){if(!cr(l,t.length)&&cr(u,r.length))return NaN;let s;if(e&&n)s=xr(t,l,r,u,i),o=Math.min(o,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=mr(r[t],e,i),o=Math.min(o,s),0===o)return o}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=mr(t[r],e,i),o=Math.min(o,s),0===o)return o}else s=vr(t,l,r,u,i),o=Math.min(o,s)}else{const s=hr(l,e),c=hr(u,n);Ar(a,o,i,t,r,s[0],c[0]),Ar(a,o,i,t,r,s[0],c[1]),Ar(a,o,i,t,r,s[1],c[0]),Ar(a,o,i,t,r,s[1],c[1])}}return o}function zr(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Pr{constructor(t,e){this.type=L,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(jt(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Pr(e,e.features.map((t=>zr(t.geometry))).flat());if("Feature"===e.type)return new Pr(e,zr(e.geometry));if("type"in e&&"coordinates"in e)return new Pr(e,zr(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ve([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new ar(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Mr(n,!1,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Mr(n,!1,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Ir(n,!1,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Ve([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new ar(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Mr(n,!0,[t.coordinates],!1,i,s));break;case"LineString":s=Math.min(s,Mr(n,!0,t.coordinates,!0,i,s));break;case"Polygon":s=Math.min(s,Ir(n,!0,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=er(r,0).map((e=>e.map((e=>e.map((e=>Ve([e.x,e.y],t.canonical))))))),i=new ar(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case"Point":s=Math.min(s,Ir([t.coordinates],!1,e,i,s));break;case"LineString":s=Math.min(s,Ir(t.coordinates,!0,e,i,s));break;case"Polygon":s=Math.min(s,Sr(e,t.coordinates,i,s))}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class Tr{constructor(t){this.type=U,this.key=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=t[1];return null==r?e.error("Global state property must be defined."):"string"!=typeof r?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Tr(r)}evaluate(t){var e;const r=null===(e=t.globals)||void 0===e?void 0:e.globalState;return r&&0!==Object.keys(r).length?bt(r,this.key):null}eachChild(){}outputDefined(){return!1}}const Cr={"==":we,"!=":_e,">":ke,"<":Se,">=":Ie,"<=":Ae,array:Zt,at:ee,boolean:Zt,case:se,coalesce:ge,collator:Me,format:Pe,image:Te,in:re,"index-of":ne,interpolate:de,"interpolate-hcl":de,"interpolate-lab":de,length:Ce,let:Qt,literal:Gt,match:ie,number:Zt,"number-format":ze,object:Zt,slice:oe,step:le,string:Zt,"to-boolean":Ht,"to-color":Ht,"to-number":Ht,"to-string":Ht,var:te,within:Je,distance:Pr,"global-state":Tr};class Br{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const r=t[0],n=Br.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let a=null;for(const[n,s]of o){a=new Kt(e.registry,Lr,e.path,null,e.scope);const o=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=a.parse(r,1+o.length,i);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(n)&&n.length!==o.length)a.error(`Expected ${n.length} arguments, but found ${o.length} instead.`);else{for(let t=0;t<o.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=o[t];a.concat(t+1).checkSubtype(e,r.type)}if(0===a.errors.length)return new Br(r,i,s,o)}}if(1===o.length)e.errors.push(...a.errors);else{const r=(o.length?o:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(K).join(", ")})`:`(${K(e.type)}...)`;var e})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(K(i.type))}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`)}return null}static register(t,e){Br.definitions=e;for(const r in e)t[r]=Br}}function Er(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,o=Nt(e,r,n,s);if(o)throw new Dt(o);return new zt(e/255,r/255,n/255,s,!1)}function Vr(t,e){return t in e}function Fr(t,e){const r=e[t];return void 0===r?null:r}function Dr(t){return{type:t}}function Lr(t){if(t instanceof te)return Lr(t.boundExpression);if(t instanceof Br&&"error"===t.name)return!1;if(t instanceof Me)return!1;if(t instanceof Je)return!1;if(t instanceof Pr)return!1;if(t instanceof Tr)return!1;const e=t instanceof Ht||t instanceof Zt;let r=!0;return t.eachChild((t=>{r=e?r&&Lr(t):r&&t instanceof Gt})),!!r&&$r(t)&&Rr(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function $r(t){if(t instanceof Br){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof Je)return!1;if(t instanceof Pr)return!1;let e=!0;return t.eachChild((t=>{e&&!$r(t)&&(e=!1)})),e}function Or(t){if(t instanceof Br&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!Or(t)&&(e=!1)})),e}function Rr(t,e){if(t instanceof Br&&e.indexOf(t.name)>=0)return!1;let r=!0;return t.eachChild((t=>{r&&!Rr(t,e)&&(r=!1)})),r}function Nr(t){return{result:"success",value:t}}function jr(t){return{result:"error",value:t}}function Ur(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function qr(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Gr(t){return!!t.expression&&t.expression.interpolated}function Xr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Zr(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Ut(t)===j}function Yr(t){return t}function Hr(t,e){const r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),i=t.type||(Gr(e)?"exponential":"interval"),s=function(t){switch(t.type){case"color":return zt.parse;case"padding":return Et.parse;case"numberArray":return Vt.parse;case"colorArray":return Ft.parse;default:return null}}(e);if(s&&((t=E({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(o=t.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${t.colorSpace}"`);var o;const a=function(t){switch(t){case"exponential":return Qr;case"interval":return Kr;case"categorical":return Wr;case"identity":return tn;default:throw new Error(`Unknown function type "${t}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0]}if(r){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]])}const i=[];for(const t of n)i.push([r[t].zoom,Hr(r[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:de.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Qr({stops:i,base:t.base},e,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:r,interpolationFactor:de.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,l,u)}}return{kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Jr(t.default,e.default):a(t,e,i,l,u)}}}function Jr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Wr(t,e,r,n,i){return Jr(typeof r===i?n[r]:void 0,t.default,e.default)}function Kr(t,e,r){if("number"!==Xr(r))return Jr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=ae(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Qr(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Xr(r))return Jr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=ae(t.stops.map((t=>t[0])),r),o=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1],u=me[e.type]||Yr;return"function"==typeof a.evaluate?{evaluate(...e){const r=a.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,o,t.colorSpace)}}:u(a,l,o,t.colorSpace)}function tn(t,e,r){switch(e.type){case"color":r=zt.parse(r);break;case"formatted":r=Bt.fromString(r.toString());break;case"resolvedImage":r=Ot.fromString(r.toString());break;case"padding":r=Et.parse(r);break;case"colorArray":r=Ft.parse(r);break;case"numberArray":r=Vt.parse(r);break;default:Xr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0)}return Jr(r,t.default,e.default)}Br.register(Cr,{error:[{kind:"error"},[$],(t,[e])=>{throw new Dt(e.evaluate(t))}],typeof:[$,[U],(t,[e])=>K(Ut(e.evaluate(t)))],"to-rgba":[W(L,4),[R],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return[255*r,255*n,255*i,s]}],rgb:[R,[L,L,L],Er],rgba:[R,[L,L,L,L],Er],has:{type:O,overloads:[[[$],(t,[e])=>Vr(e.evaluate(t),t.properties())],[[$,j],(t,[e,r])=>Vr(e.evaluate(t),r.evaluate(t))]]},get:{type:U,overloads:[[[$],(t,[e])=>Fr(e.evaluate(t),t.properties())],[[$,j],(t,[e,r])=>Fr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[U,[$],(t,[e])=>Fr(e.evaluate(t),t.featureState||{})],properties:[j,[],t=>t.properties()],"geometry-type":[$,[],t=>t.geometryType()],id:[U,[],t=>t.id()],zoom:[L,[],t=>t.globals.zoom],"heatmap-density":[L,[],t=>t.globals.heatmapDensity||0],elevation:[L,[],t=>t.globals.elevation||0],"line-progress":[L,[],t=>t.globals.lineProgress||0],accumulated:[U,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[L,Dr(L),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[L,Dr(L),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:L,overloads:[[[L,L],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[L],(t,[e])=>-e.evaluate(t)]]},"/":[L,[L,L],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[L,[L,L],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[L,[],()=>Math.LN2],pi:[L,[],()=>Math.PI],e:[L,[],()=>Math.E],"^":[L,[L,L],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[L,[L],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[L,[L],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[L,[L],(t,[e])=>Math.log(e.evaluate(t))],log2:[L,[L],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[L,[L],(t,[e])=>Math.sin(e.evaluate(t))],cos:[L,[L],(t,[e])=>Math.cos(e.evaluate(t))],tan:[L,[L],(t,[e])=>Math.tan(e.evaluate(t))],asin:[L,[L],(t,[e])=>Math.asin(e.evaluate(t))],acos:[L,[L],(t,[e])=>Math.acos(e.evaluate(t))],atan:[L,[L],(t,[e])=>Math.atan(e.evaluate(t))],min:[L,Dr(L),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[L,Dr(L),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[L,[L],(t,[e])=>Math.abs(e.evaluate(t))],round:[L,[L],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[L,[L],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[L,[L],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[O,[$,U],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[O,[U],(t,[e])=>t.id()===e.value],"filter-type-==":[O,[$],(t,[e])=>t.geometryType()===e.value],"filter-<":[O,[$,U],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[O,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[O,[$,U],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[O,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[O,[$,U],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[O,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[O,[$,U],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[O,[U],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[O,[U],(t,[e])=>e.value in t.properties()],"filter-has-id":[O,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[O,[W($)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[O,[W(U)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[O,[$,W(U)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[O,[$,W(U)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return!0;e[i]>t?n=i-1:r=i+1}return!1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:O,overloads:[[[O,O],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Dr(O),(t,e)=>{for(const r of e)if(!r.evaluate(t))return!1;return!0}]]},any:{type:O,overloads:[[[O,O],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Dr(O),(t,e)=>{for(const r of e)if(r.evaluate(t))return!0;return!1}]]},"!":[O,[O],(t,[e])=>!e.evaluate(t)],"is-supported-script":[O,[$],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return!r||r(e.evaluate(t))}],upcase:[$,[$],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[$,[$],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[$,Dr(U),(t,e)=>e.map((e=>qt(e.evaluate(t)))).join("")],"resolved-locale":[$,[q],(t,[e])=>e.evaluate(t).resolvedLocale()]});class en{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new Wt,this._defaultValue=e?function(t){if("color"===t.type&&Zr(t.default))return new zt(0,0,0,0);switch(t.type){case"color":return zt.parse(t.default)||null;case"padding":return Et.parse(t.default)||null;case"numberArray":return Vt.parse(t.default)||null;case"colorArray":return Ft.parse(t.default)||null;case"variableAnchorOffsetCollection":return $t.parse(t.default)||null;case"projectionDefinition":return Rt.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Dt(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function rn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Cr}function nn(t,e){const r=new Kt(Cr,Lr,[],e?function(t){const e={color:R,string:$,number:L,enum:$,boolean:O,formatted:G,padding:X,numberArray:Y,colorArray:Z,projectionDefinition:N,resolvedImage:H,variableAnchorOffsetCollection:J};return"array"===t.type?W(e[t.value]||U,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Nr(new en(n,e)):jr(r.errors)}class sn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Or(e.expression),this.globalStateRefs=cn(e.expression)}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class on{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Or(e.expression),this.globalStateRefs=cn(e.expression),this.interpolationType=n}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?de.interpolationFactor(this.interpolationType,t,e,r):0}}function an(t,e){const r=nn(t,e);if("error"===r.result)return r;const n=r.value.expression,i=$r(n);if(!i&&!Ur(e))return jr([new V("","data expressions not supported")]);const s=Rr(n,["zoom"]);if(!s&&!qr(e))return jr([new V("","zoom expressions not supported")]);const o=un(n);return o||s?o instanceof V?jr([o]):o instanceof de&&!Gr(e)?jr([new V("",'"interpolate" expressions cannot be used with this property')]):Nr(o?new on(i?"camera":"composite",r.value,o.labels,o instanceof de?o.interpolation:void 0):new sn(i?"constant":"source",r.value)):jr([new V("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class ln{constructor(t,e){this._parameters=t,this._specification=e,E(this,Hr(this._parameters,this._specification))}static deserialize(t){return new ln(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function un(t){let e=null;if(t instanceof Qt)e=un(t.result);else if(t instanceof ge){for(const r of t.args)if(e=un(r),e)break}else(t instanceof le||t instanceof de)&&t.input instanceof Br&&"zoom"===t.input.name&&(e=t);return e instanceof V||t.eachChild((t=>{const r=un(t);r instanceof V?e=r:!e&&r?e=new V("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new V("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function cn(t,e=new Set){return t instanceof Tr&&e.add(t.key),t.eachChild((t=>{cn(t,e)})),e}function hn(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!hn(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const pn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function fn(t){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};hn(t)||(t=mn(t));const e=nn(t,pn);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:yn(t),getGlobalStateRefs:()=>cn(e.value.expression)}}function dn(t,e){return t<e?-1:t>e?1:0}function yn(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(yn(t[e]))return!0;return!1}function mn(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?gn(t[1],t[2],"=="):"!="===e?bn(gn(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?gn(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(mn))):"all"===e?["all"].concat(t.slice(1).map(mn)):"none"===e?["all"].concat(t.slice(1).map(mn).map(bn)):"in"===e?xn(t[1],t.slice(2)):"!in"===e?bn(xn(t[1],t.slice(2))):"has"===e?vn(t[1]):"!has"!==e||bn(vn(t[1]));var r}function gn(t,e,r){switch(t){case"$type":return[`filter-type-${r}`,e];case"$id":return[`filter-id-${r}`,e];default:return[`filter-${r}`,t,e]}}function xn(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(dn)]]:["filter-in-small",t,["literal",e]]}}function vn(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function bn(t){return["!",t]}function wn(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${wn(r)},`;return`${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${wn(t[r[e]])},`;return`${n}}`}function _n(t){let e="";for(const r of C)e+=`/${wn(t[r])}`;return e}function Sn(t){const e=t.value;return e?[new B(t.key,e,"constants have been deprecated as of v8")]:[]}function kn(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function An(t){if(Array.isArray(t))return t.map(An);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=An(t[r]);return e}return kn(t)}function In(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,o=t.styleSpec,a=t.validateSpec;let l=[];const u=Xr(r);if("object"!==u)return[new B(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=bt(n,u)||n["*"];let h;if(bt(i,u))h=i[u];else if(bt(n,u))h=a;else if(i["*"])h=i["*"];else{if(!n["*"]){l.push(new B(e,r[t],`unknown property "${t}"`));continue}h=a}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:o,object:r,objectKey:t,validateSpec:a},r))}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new B(e,r,`missing required property "${t}"`));return l}function Mn(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,o=t.arrayElementValidator||t.validateSpec;if("array"!==Xr(e))return[new B(s,e,`array expected, ${Xr(e)} found`)];if(r.length&&e.length!==r.length)return[new B(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return[new B(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let a={type:r.value,values:r.values};i.$version<7&&(a.function=r.function),"object"===Xr(r.value)&&(a=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(o({array:e,arrayIndex:r,value:e[r],valueSpec:a,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function zn(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Xr(r);return"number"===i&&r!=r&&(i="NaN"),"number"!==i?[new B(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new B(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new B(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Pn(t){const e=t.valueSpec,r=kn(t.value.type);let n,i,s,o={};const a="categorical"!==r&&void 0===t.value.property,l=!a,u="array"===Xr(t.value.stops)&&"array"===Xr(t.value.stops[0])&&"object"===Xr(t.value.stops[0][0]),c=In({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return[new B(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Mn({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Xr(n)&&0===n.length&&e.push(new B(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===r&&a&&c.push(new B(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new B(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Gr(t.valueSpec)&&c.push(new B(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Ur(t.valueSpec)?c.push(new B(t.key,t.value,"property functions not supported")):a&&!qr(t.valueSpec)&&c.push(new B(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new B(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,a=t.key;if("array"!==Xr(n))return[new B(a,n,`array expected, ${Xr(n)} found`)];if(2!==n.length)return[new B(a,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Xr(n[0]))return[new B(a,n,`object expected, ${Xr(n[0])} found`)];if(void 0===n[0].zoom)return[new B(a,n,"object stop key must have zoom")];if(void 0===n[0].value)return[new B(a,n,"object stop key must have value")];if(s&&s>kn(n[0].zoom))return[new B(a,n[0].zoom,"stop zoom values must appear in ascending order")];kn(n[0].zoom)!==s&&(s=kn(n[0].zoom),i=void 0,o={}),r=r.concat(In({key:`${a}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:zn,value:p}}))}else r=r.concat(p({key:`${a}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return rn(An(n[1]))?r.concat([new B(`${a}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${a}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const a=Xr(t.value),l=kn(t.value),u=null!==t.value?t.value:s;if(n){if(a!==n)return[new B(t.key,u,`${a} stop domain type must match previous stop domain type ${n}`)]}else n=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new B(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==r){let n=`number expected, ${a} found`;return Ur(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new B(t.key,u,n)]}return"categorical"!==r||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===a&&void 0!==i&&l<i?[new B(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in o?[new B(t.key,u,"stop domain values must be unique")]:(o[l]=!0,[])):[new B(t.key,u,`integer expected, found ${l}`)]}}function Tn(t){const e=("property"===t.expressionContext?an:nn)(An(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new B(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return[new B(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Or(r))return[new B(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Or(r))return[new B(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Rr(r,["zoom","feature-state"]))return[new B(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!$r(r))return[new B(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Cn(t){const e=t.key,r=t.value,n=Xr(r);return"string"!==n?[new B(e,r,`color expected, ${n} found`)]:zt.parse(String(r))?[]:[new B(e,r,`color expected, "${r}" found`)]}function Bn(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(kn(r))&&i.push(new B(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(kn(r))&&i.push(new B(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function En(t){return hn(An(t.value))?Tn(E({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Vn(t)}function Vn(t){const e=t.value,r=t.key;if("array"!==Xr(e))return[new B(r,e,`array expected, ${Xr(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return[new B(r,e,"filter array must have at least 1 element")];switch(s=s.concat(Bn({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),kn(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===kn(e[1])&&s.push(new B(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new B(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Xr(e[1]),"string"!==i&&s.push(new B(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let o=2;o<e.length;o++)i=Xr(e[o]),"$type"===kn(e[1])?s=s.concat(Bn({key:`${r}[${o}]`,value:e[o],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new B(`${r}[${o}]`,e[o],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(Vn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Xr(e[1]),2!==e.length?s.push(new B(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new B(`${r}[1]`,e[1],`string expected, ${i} found`))}return s}function Fn(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,o=t.value,a=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const u=a.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:o,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[a];if(!c)return[new B(r,o,`unknown property "${a}"`)];let h;if("string"===Xr(o)&&Ur(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(o)))return[new B(r,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===a&&i&&!i.glyphs&&p.push(new B(r,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Zr(An(o))&&"identity"===kn(o.type)&&p.push(new B(r,o,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:o,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:a}))}function Dn(t){return Fn(t,"paint")}function Ln(t){return Fn(t,"layout")}function $n(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;if("object"!==Xr(r))return[new B(n,r,`object expected, ${Xr(r)} found`)];r.type||r.ref||e.push(new B(n,r,'either "type" or "ref" is required'));let o=kn(r.type);const a=kn(r.ref);if(r.id){const s=kn(r.id);for(let o=0;o<t.arrayIndex;o++){const t=i.layers[o];kn(t.id)===s&&e.push(new B(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`))}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new B(n,r[t],`"${t}" is prohibited for ref layers`))})),i.layers.forEach((e=>{kn(e.id)===a&&(t=e)})),t?t.ref?e.push(new B(n,r.ref,"ref cannot reference another ref layer")):o=kn(t.type):e.push(new B(n,r.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&kn(t.type);t?"vector"===s&&"raster"===o?e.push(new B(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?e.push(new B(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?e.push(new B(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?e.push(new B(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new B(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new B(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new B(n,r.source,`source "${r.source}" not found`))}else e.push(new B(n,r,'missing required property "source"'));return e=e.concat(In({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:En,layout:t=>In({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ln(E({layerType:o},t))}}),paint:t=>In({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Dn(E({layerType:o},t))}})}})),e}function On(t){const e=t.value,r=t.key,n=Xr(e);return"string"!==n?[new B(r,e,`string expected, ${n} found`)]:[]}const Rn={promoteId:function({key:t,value:e}){if("string"===Xr(e))return On({key:t,value:e});{const r=[];for(const n in e)r.push(...On({key:`${t}.${n}`,value:e[n]}));return r}}};function Nn(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return[new B(r,e,'"type" is required')];const o=kn(e.type);let a;switch(o){case"vector":case"raster":return a=In({key:r,value:e,valueSpec:n[`source_${o.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Rn,validateSpec:s}),a;case"raster-dem":return a=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,o=t.style;let a=[];const l=Xr(n);if(void 0===n)return a;if("object"!==l)return a.push(new B("source_raster_dem",n,`object expected, ${l} found`)),a;const u="custom"===kn(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?a.push(new B(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?a=a.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:o,styleSpec:i})):a.push(new B(e,n[e],`unknown property "${e}"`));return a}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),a;case"geojson":if(a=In({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Rn}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;a.push(...Tn({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),a.push(...Tn({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return In({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return In({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return[new B(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Bn({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function jn(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const o=Xr(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new B("light",e,`object expected, ${o} found`)]),s;for(const o in e){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?t.validateSpec({key:o,value:e[o],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new B(o,e[o],`unknown property "${o}"`)])}return s}function Un(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=Xr(e);if(void 0===e)return[];if("object"!==s)return[new B("sky",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new B(s,e[s],`unknown property "${s}"`)]);return o}function qn(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const o=Xr(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new B("terrain",e,`object expected, ${o} found`)]),s;for(const o in e)s=s.concat(n[o]?t.validateSpec({key:o,value:e[o],valueSpec:n[o],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new B(o,e[o],`unknown property "${o}"`)]);return s}function Gn(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const o in r)r[o].id&&i.includes(r[o].id)&&e.push(new B(n,r,`all the sprites' ids must be unique, but ${r[o].id} is duplicated`)),i.push(r[o].id),r[o].url&&s.includes(r[o].url)&&e.push(new B(n,r,`all the sprites' URLs must be unique, but ${r[o].url} is duplicated`)),s.push(r[o].url),e=e.concat(In({key:`${n}[${o}]`,value:r[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return On({key:n,value:r})}function Xn(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new B(t.key,t.value,`object expected, ${Xr(t.value)} found`)];var e}const Zn={"*":()=>[],array:Mn,boolean:function(t){const e=t.value,r=t.key,n=Xr(e);return"boolean"!==n?[new B(r,e,`boolean expected, ${n} found`)]:[]},number:zn,color:Cn,constants:Sn,enum:Bn,filter:En,function:Pn,layer:$n,object:In,source:Nn,light:jn,sky:Un,terrain:qn,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=Xr(e);if(void 0===e)return[];if("object"!==s)return[new B("projection",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new B(s,e[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Xr(r);return"array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new B(e,r,`projection expected, invalid type "${n}" found`)]:[new B(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:On,formatted:function(t){return 0===On(t).length?[]:Tn(t)},resolvedImage:function(t){return 0===On(t).length?[]:Tn(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Xr(r)){if(r.length<1||r.length>4)return[new B(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return zn({key:e,value:r,valueSpec:{}})},numberArray:function(t){const e=t.key,r=t.value;if("array"===Xr(r)){const n={type:"number"};if(r.length<1)return[new B(e,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return zn({key:e,value:r,valueSpec:{}})},colorArray:function(t){const e=t.key,r=t.value;if("array"===Xr(r)){if(r.length<1)return[new B(e,r,"array length at least 1 expected, length 0 found")];let t=[];for(let n=0;n<r.length;n++)t=t.concat(Cn({key:`${e}[${n}]`,value:r[n]}));return t}return Cn({key:e,value:r})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Xr(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return[new B(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Bn({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(Mn({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:Gn,state:Xn};function Yn(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Yn,r.expression&&Zr(kn(e))?Pn(t):r.expression&&rn(An(e))?Tn(t):r.type&&Zn[r.type]?Zn[r.type](t):In(E({},t,{valueSpec:r.type?n[r.type]:r}))}function Hn(t){const e=t.value,r=t.key,n=On(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new B(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new B(r,e,'"glyphs" url must include a "{range}" token'))),n}function Jn(t,e=T){let r=[];return r=r.concat(Yn({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Yn,objectElementValidators:{glyphs:Hn,"*":()=>[]}})),t.constants&&(r=r.concat(Sn({key:"constants",value:t.constants}))),Kn(r)}function Wn(t){return function(e){return t({...e,validateSpec:Yn})}}function Kn(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function Qn(t){return function(...e){return Kn(t.apply(this,e))}}Jn.source=Qn(Wn(Nn)),Jn.sprite=Qn(Wn(Gn)),Jn.glyphs=Qn(Wn(Hn)),Jn.light=Qn(Wn(jn)),Jn.sky=Qn(Wn(Un)),Jn.terrain=Qn(Wn(qn)),Jn.state=Qn(Wn(Xn)),Jn.layer=Qn(Wn($n)),Jn.filter=Qn(Wn(En)),Jn.paintProperty=Qn(Wn(Dn)),Jn.layoutProperty=Qn(Wn(Ln));const ti="AbortError";function ei(){return new Error(ti)}const ri={REGISTERED_PROTOCOLS:{}};function ni(t,e){ri.REGISTERED_PROTOCOLS[t]=e}function ii(t){delete ri.REGISTERED_PROTOCOLS[t]}const si="global-dispatcher";class oi extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n}}const ai=()=>S(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,li=function(e,r){if(/:\/\//.test(e.url)&&!/^https?:|^file:/.test(e.url)){const t=ri.REGISTERED_PROTOCOLS[(n=e.url).substring(0,n.indexOf("://"))];if(t)return t(e,r);if(S(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,targetMapId:si},r)}var n;if(!(t=>/^file:/.test(t)||/^file:/.test(ai())&&!/^\w+:/.test(t))(e.url)){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(e,r){return t(this,void 0,void 0,(function*(){const t=new Request(e.url,{method:e.method||"GET",body:e.body,credentials:e.credentials,headers:e.headers,cache:e.cache,referrer:ai(),signal:r.signal});let n,i;"json"!==e.type||t.headers.has("Accept")||t.headers.set("Accept","application/json");try{n=yield fetch(t)}catch(t){throw new oi(0,t.message,e.url,new Blob)}if(!n.ok){const t=yield n.blob();throw new oi(n.status,n.statusText,e.url,t)}i="arrayBuffer"===e.type||"image"===e.type?n.arrayBuffer():"json"===e.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw ei();return{data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(e,r);if(S(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,mustQueue:!0,targetMapId:si},r)}return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText))},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response)}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new oi(s.status,s.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{s.abort(),n(ei())})),s.send(t.body)}))}(e,r)},ui={};function ci(t,e,r={}){if(ui[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ui[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]}}ci("Object",Object),ci("Set",Set),ci("TransferableGridIndex",P),ci("Color",zt),ci("Error",Error),ci("AJAXError",oi),ci("ResolvedImage",Ot),ci("StylePropertyFunction",ln),ci("StyleExpression",en,{omit:["_evaluator"]}),ci("ZoomDependentExpression",on),ci("ZoomConstantExpression",sn),ci("CompoundExpression",Br,{omit:["_evaluate"]});for(const t in Cr)Cr[t]._classRegistryKey||ci(`Expression_${t}`,Cr[t]);function hi(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function pi(t){return t.$name||t.constructor._classRegistryKey}function fi(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=pi(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||hi(t)||k(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function di(t,e){if(fi(t))return(hi(t)||k(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(di(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=pi(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ui[r])throw new Error(`${r} is not registered.`);const{klass:n}=ui[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const n in t){if(!t.hasOwnProperty(n))continue;if(ui[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=ui[r].shallow.indexOf(n)>=0?s:di(s,e)}t instanceof Error&&(i.message=t.message)}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(i.$name=r),i}function yi(t){if(fi(t))return t;if(Array.isArray(t))return t.map(yi);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=pi(t)||"Object";if(!ui[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=ui[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=ui[e].shallow.indexOf(r)>=0?i:yi(i)}return n}class mi{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const gi={once:!0};class xi{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new mi((()=>this.process())),this.subscription=M(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=S(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?M(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),gi):null;this.resolveRejects[i]={resolve:t=>{null==s||s.unsubscribe(),r(t)},reject:t=>{null==s||s.unsubscribe(),n(t)}};const o=[],a=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:di(t.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(S(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(e,r){return t(this,void 0,void 0,(function*(){if("<response>"===r.type){const t=this.resolveRejects[e];if(delete this.resolveRejects[e],!t)return;return void(r.error?t.reject(yi(r.error)):t.resolve(yi(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(e,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const t=yi(r.data),n=new AbortController;this.abortControllers[e]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,t,n);this.completeTask(e,null,i)}catch(t){this.completeTask(e,t)}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?di(e):null,data:di(r,n)};this.target.postMessage(i,{transfer:n})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}function vi(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e))}function bi(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1)}}class wi{constructor(t,e={}){g(this,e),this.type=t}}class _i extends wi{constructor(t,e={}){super("error",g({error:t},e))}}class Si{on(t,e){return this._listeners=this._listeners||{},vi(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return bi(t,e,this._listeners),bi(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},vi(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new wi(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)bi(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(g(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t))}else t instanceof _i&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}const ki=Jn,Ai=ki.paintProperty,Ii=ki.layoutProperty;class Mi{constructor(){this.first=!0}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const zi=t=>t>=12272&&t<=12287,Pi=t=>t>=12288&&t<=12351,Ti=t=>t>=12448&&t<=12543,Ci=t=>t>=12736&&t<=12783,Bi=t=>t>=12800&&t<=13055,Ei=t=>t>=13056&&t<=13311,Vi=t=>t>=65040&&t<=65055,Fi=t=>t>=65072&&t<=65103,Di=t=>t>=65104&&t<=65135,Li=t=>t>=65280&&t<=65519;function $i(t){for(const e of t)if(qi(e.charCodeAt(0)))return!0;return!1}function Oi(t){for(const e of t)if(!ji(e.charCodeAt(0)))return!1;return!0}function Ri(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const Ni=Ri(["Arab","Dupl","Mong","Ougr","Syrc"]);function ji(t){return!Ni.test(String.fromCodePoint(t))}const Ui=Ri(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function qi(t){return!(746!==t&&747!==t&&(t<4352||!(Fi(t)&&!(t>=65097&&t<=65103)||Ei(t)||Ci(t)||!(!Pi(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Bi(t)||zi(t)||(t=>t>=12688&&t<=12703)(t)||Ti(t)&&12540!==t||!(!Li(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Di(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Vi(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||Ui.test(String.fromCodePoint(t)))))}function Gi(t){return!(qi(t)||function(t){return!!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Pi(t)||Ti(t)||(t=>t>=57344&&t<=63743)(t)||Fi(t)||Di(t)||Li(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const Xi=Ri(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Zi(t){return Xi.test(String.fromCodePoint(t))}function Yi(t,e){return!(!e&&Zi(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Hi(t){for(const e of t)if(Zi(e.charCodeAt(0)))return!0;return!1}const Ji=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Ji.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(e,r){return t(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==e.pluginStatus)return this.setState(e),e;const t=e.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t}));r(t);const i=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const e={pluginStatus:"loaded",pluginURL:t};return this.setState(e),e}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${t}`)}))}};class Wi{constructor(t,e){this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new Mi,this.transition=e.transition||{},this.globalState=e.globalState||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Mi,this.transition={},this.globalState={})}isSupportedScript(t){return function(t,e){for(const r of t)if(!Yi(r.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Ji.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class Ki{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Zr(t))return new ln(t,e);if(rn(t)){const r=an(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return"color"===e.type&&"string"==typeof t?r=zt.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=$t.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=Rt.parse(t)):r=Ft.parse(t):r=Vt.parse(t):r=Et.parse(t),{globalStateRefs:new Set,kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Qi{constructor(t){this.property=t,this.value=new Ki(t,void 0)}transitioned(t,e){return new es(this.property,this.value,e,g({},t.transition,this.transition),t.now)}untransitioned(){return new es(this.property,this.value,null,{},0)}}class ts{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues)}getValue(t){return v(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Qi(this._values[t].property)),this._values[t].value=new Ki(this._values[t].property,null===e?void 0:v(e))}getTransition(t){return v(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Qi(this._values[t].property)),this._values[t].transition=v(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n)}return t}transitioned(t,e){const r=new rs(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new rs(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class es{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r)}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(o))}}return i}}class rs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,r){const n=new ss(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class ns{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues)}hasValue(t){return void 0!==this._values[t].value}getValue(t){return v(this._values[t].value)}setValue(t,e){this._values[t]=new Ki(this._values[t].property,null===e?void 0:v(e))}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r)}return t}possiblyEvaluate(t,e,r){const n=new ss(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class is{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class ss{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class os{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=me[this.specification.type];return n?n(t,e,r):t}}class as{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,r,n){return new is(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new is(this,{kind:"constant",value:void 0},t.parameters);const n=me[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new is(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return"constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class ls extends as{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new is(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,o=this._calculate(s,s,s,e);return new is(this,{kind:"constant",value:o},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new is(this,{kind:"constant",value:r},e)}return new is(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const o=t.evaluate(e,r,n,i,s);return this._calculate(o,o,o,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class us{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Wi(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Wi(Math.floor(e.zoom),e)),t.expression.evaluate(new Wi(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class cs{constructor(t){this.specification=t}possiblyEvaluate(t,e,r,n){return!!t.expression.evaluate(e,null,{},r,n)}interpolate(){return!1}}class hs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Ki(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new Qi(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({})}}}ci("DataDrivenProperty",as),ci("DataConstantProperty",os),ci("CrossFadedDataDrivenProperty",ls),ci("CrossFadedProperty",us),ci("ColorRampProperty",cs);const ps="-transition";class fs extends Si{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=fn(t.filter)),e.layout&&(this._unevaluatedLayout=new ns(e.layout)),e.paint)){this._transitionablePaint=new ts(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new ss(e.paint)}}setFilter(t){this.filter=t,this._featureFilter=fn(t)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[e];for(const e of r.getGlobalStateRefs())t.add(e)}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Ii,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(ps)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Ai,`layers.${this.id}.paint.${t}`,t,e,r))return!1;if(t.endsWith(ps))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const o=this._transitionablePaint._values[t].value;return o.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,o)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),function(t,e){const r={};for(const n in t)e.call(this,t[n],n,t)&&(r[n]=t[n]);return r}(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return(!i||!1!==i.validate)&&function(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new _i(new Error(n.message))),r=!0;return r}(this,t.call(ki,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:T,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof is&&Ur(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const ds={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ys{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class ms{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function gs(t,e=1){let r=0,n=0;return{members:t.map((t=>{const i=ds[t.type].BYTES_PER_ELEMENT,s=r=xs(r,Math.max(e,i)),o=t.components||1;return n=Math.max(n,i),r+=i*o,{name:t.name,type:t.type,components:o,offset:s}})),size:xs(r,Math.max(n,e)),alignment:e}}function xs(t,e){return Math.ceil(t/e)*e}class vs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}vs.prototype.bytesPerElement=4,ci("StructArrayLayout2i4",vs);class bs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}bs.prototype.bytesPerElement=6,ci("StructArrayLayout3i6",bs);class ws extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}ws.prototype.bytesPerElement=8,ci("StructArrayLayout4i8",ws);class _s extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}_s.prototype.bytesPerElement=12,ci("StructArrayLayout2i4i12",_s);class Ss extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=4*t,l=8*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=o,t}}Ss.prototype.bytesPerElement=8,ci("StructArrayLayout2i4ub8",Ss);class ks extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}ks.prototype.bytesPerElement=8,ci("StructArrayLayout2f8",ks);class As extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,o,a,l,u)}emplace(t,e,r,n,i,s,o,a,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=o,this.uint16[h+6]=a,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}As.prototype.bytesPerElement=20,ci("StructArrayLayout10ui20",As);class Is extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,o,a,l,u,c,h)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=o,this.uint16[f+6]=a,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}Is.prototype.bytesPerElement=24,ci("StructArrayLayout4i4ui4i24",Is);class Ms extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ms.prototype.bytesPerElement=12,ci("StructArrayLayout3f12",Ms);class zs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}zs.prototype.bytesPerElement=4,ci("StructArrayLayout1ul4",zs);class Ps extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,o,a,l)}emplace(t,e,r,n,i,s,o,a,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=o,this.uint32[h+3]=a,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}Ps.prototype.bytesPerElement=20,ci("StructArrayLayout6i1ul2ui20",Ps);class Ts extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,t}}Ts.prototype.bytesPerElement=12,ci("StructArrayLayout2i2i2i12",Ts);class Cs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,t}}Cs.prototype.bytesPerElement=16,ci("StructArrayLayout2f1f2i16",Cs);class Bs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,o){const a=16*t,l=4*t,u=8*t;return this.uint8[a+0]=e,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=o,t}}Bs.prototype.bytesPerElement=16,ci("StructArrayLayout2ub2f2i16",Bs);class Es extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Es.prototype.bytesPerElement=6,ci("StructArrayLayout3ui6",Es);class Vs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=o,this.uint32[v+4]=a,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Vs.prototype.bytesPerElement=48,ci("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Vs);class Fs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M)}emplace(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,A,I,M,z){const P=32*t,T=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=o,this.int16[P+6]=a,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=S,this.uint32[T+12]=k,this.float32[T+13]=A,this.float32[T+14]=I,this.uint16[P+30]=M,this.uint16[P+31]=z,t}}Fs.prototype.bytesPerElement=64,ci("StructArrayLayout8i15ui1ul2f2ui64",Fs);class Ds extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Ds.prototype.bytesPerElement=4,ci("StructArrayLayout1f4",Ds);class Ls extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ls.prototype.bytesPerElement=12,ci("StructArrayLayout1ui2f12",Ls);class $s extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}$s.prototype.bytesPerElement=8,ci("StructArrayLayout1ul2ui8",$s);class Os extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Os.prototype.bytesPerElement=4,ci("StructArrayLayout2ui4",Os);class Rs extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Rs.prototype.bytesPerElement=2,ci("StructArrayLayout1ui2",Rs);class Ns extends ms{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Ns.prototype.bytesPerElement=16,ci("StructArrayLayout4f16",Ns);class js extends ys{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new a(this.anchorPointX,this.anchorPointY)}}js.prototype.size=20;class Us extends Ps{get(t){return new js(this,t)}}ci("CollisionBoxArray",Us);class qs extends ys{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}qs.prototype.size=48;class Gs extends Vs{get(t){return new qs(this,t)}}ci("PlacedSymbolArray",Gs);class Xs extends ys{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Xs.prototype.size=64;class Zs extends Fs{get(t){return new Xs(this,t)}}ci("SymbolInstanceArray",Zs);class Ys extends Ds{getoffsetX(t){return this.float32[1*t+0]}}ci("GlyphOffsetArray",Ys);class Hs extends bs{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}ci("SymbolLineVertexArray",Hs);class Js extends ys{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Js.prototype.size=12;class Ws extends Ls{get(t){return new Js(this,t)}}ci("TextAnchorOffsetArray",Ws);class Ks extends ys{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ks.prototype.size=8;class Qs extends $s{get(t){return new Ks(this,t)}}ci("FeatureIndexArray",Qs);class to extends vs{}class eo extends vs{}class ro extends vs{}class no extends _s{}class io extends Ss{}class so extends ks{}class oo extends As{}class ao extends Is{}class lo extends Ms{}class uo extends zs{}class co extends Ts{}class ho extends Bs{}class po extends Es{}class fo extends Os{}const yo=gs([{name:"a_pos",components:2,type:"Int16"}],4),{members:mo}=yo;class go{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>go.MAX_VERTEX_ARRAY_LENGTH&&w(`Max vertices per segment is ${go.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${go.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>go.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,r,n){return new go([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function xo(t,e){return 256*(t=m(Math.floor(t),0,255))+m(Math.floor(e),0,255)}go.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ci("SegmentVector",go);const vo=gs([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var bo,wo,_o,So={exports:{}},ko={exports:{}},Ao={exports:{}},Io=function(){if(_o)return So.exports;_o=1;var t=(bo||(bo=1,ko.exports=function(t,e){var r,n,i,s,o,a,l,u;for(n=t.length-(r=3&t.length),i=e,o=3432918353,a=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),ko.exports),e=(wo||(wo=1,Ao.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16)}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),Ao.exports);return So.exports=t,So.exports.murmur3=t,So.exports.murmur2=e,So.exports}(),Mo=e(Io);class zo{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,r,n){this.ids.push(Po(t)),this.positions.push(e,r,n)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=Po(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return To(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new zo;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Po(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:Mo(String(t))}function To(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++}while(t[s]<i);do{o--}while(t[o]>i);if(s>=o)break;Co(t,s,o),Co(e,3*s,3*o),Co(e,3*s+1,3*o+1),Co(e,3*s+2,3*o+2)}o-r<n-o?(To(t,e,r,o),r=o+1):(To(t,e,o+1,n),n=o)}}function Co(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}ci("FeaturePositionMap",zo);class Bo{constructor(t,e){this.gl=t.gl,this.location=e}}class Eo extends Bo{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class Vo extends Bo{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class Fo extends Bo{constructor(t,e){super(t,e),this.current=zt.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}function Do(t){return[xo(255*t.r,255*t.g),xo(255*t.b,255*t.a)]}class Lo{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r}setUniform(t,e,r){t.set(r.constantOr(this.value))}getBinding(t,e,r){return"color"===this.type?new Fo(t,e):new Eo(t,e)}}class $o{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i)}getBinding(t,e,r){return"u_pattern"===r.substr(0,9)?new Vo(t,e):new Eo(t,e)}}class Oo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n}populatePaintArray(t,e,r,n,i){const s=this.paintVertexArray.length,o=this.expression.evaluate(new Wi(0),e,{},n,[],i);this.paintVertexArray.resize(t),this._setPaintValue(s,t,o)}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i)}_setPaintValue(t,e,r){if("color"===this.type){const n=Do(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Ro{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Wi(this.zoom),e,{},n,[],i),o=this.expression.evaluate(new Wi(this.zoom+1),e,{},n,[],i),a=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(a,t,s,o)}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),s=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,s)}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Do(r),s=Do(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1])}else{for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=m(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n)}getBinding(t,e,r){return new Eo(t,e)}}class No{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r)}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i)}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:o}=r,a=n[i],l=n[s],u=n[o];if(a&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],a.tl[0],a.tl[1],a.br[0],a.br[1],l.pixelRatio,a.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,vo.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,vo.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class jo{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof is&&Ur(s.property.specification)))continue;const o=qo(i,t.type),a=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===a.kind)this.binders[i]=h?new $o(a.value,o):new Lo(a.value,o,l),n.push(`/u_${i}`);else if("source"===a.kind||h){const r=Go(i,l,"source");this.binders[i]=h?new No(a,l,u,e,r,t.id):new Oo(a,o,l,r),n.push(`/a_${i}`)}else{const t=Go(i,l,"composite");this.binders[i]=new Ro(a,o,l,u,e,t),n.push(`/z_${i}`)}}this.cacheKey=n.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof Oo||e instanceof Ro?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const s in this.binders){const o=this.binders[s];(o instanceof Oo||o instanceof Ro||o instanceof No)&&o.populatePaintArray(t,e,r,n,i)}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof $o&&n.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const o in t){const a=e.getPositions(o);for(const e of a){const a=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Oo||l instanceof Ro||l instanceof No)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,a,t[o],i),s=!0}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Lo||r instanceof $o)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Oo||r instanceof Ro)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof No)for(let e=0;e<vo.members.length;e++)t.push(vo.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Lo||r instanceof $o||r instanceof Ro)for(const e of r.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Lo||i instanceof $o||i instanceof Ro)for(const s of i.uniformNames)if(e[s]){const o=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:o})}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof No){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(r instanceof Oo||r instanceof Ro)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer)}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Oo||r instanceof Ro||r instanceof No)&&r.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Oo||e instanceof Ro||e instanceof No)&&e.destroy()}}}class Uo{constructor(t,e,r=()=>!0){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new jo(n,e,r);this.needsUpload=!1,this._featureMap=new zo,this._bufferOffset=0}populatePaintArrays(t,e,r,n,i,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function qo(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Go(t,e,r){const n={color:{source:ks,composite:Ns},number:{source:Ds,composite:ks}},i=function(t){return{"line-pattern":{source:oo,composite:oo},"fill-pattern":{source:oo,composite:oo},"fill-extrusion-pattern":{source:oo,composite:oo}}[t]}(t);return i&&i[r]||n[e][r]}ci("ConstantBinder",Lo),ci("CrossFadedConstantBinder",$o),ci("SourceExpressionBinder",Oo),ci("CrossFadedCompositeBinder",No),ci("CompositeExpressionBinder",Ro),ci("ProgramConfiguration",jo,{omit:["_buffers"]}),ci("ProgramConfigurationSet",Uo);const Xo=Math.pow(2,14)-1,Zo=-Xo-1;function Yo(t){const e=y/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=m(i,Zo,Xo),r.y=m(s,Zo,Xo),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&w("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return r}function Ho(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Yo(t):[]}}const Jo=-32768;function Wo(t,e,r,n,i){t.emplaceBack(Jo+8*e+n,Jo+8*r+i)}class Ko{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new eo,this.indexArray=new po,this.segments=new go,this.programConfigurations=new Uo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){const n=this.layers[0],i=[];let s=null,o=!1,a="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===t.paint.get("circle-pitch-alignment")}const l=a?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ho(e,t);if(!this.layers[0]._featureFilter.filter(new Wi(this.zoom,{globalState:this.globalState}),u,r))continue;const c=o?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:Yo(e),patterns:{},sortKey:c};i.push(h)}o&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n,a=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(a,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,mo),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=y||n<0||n>=y)continue;const i=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,t.sortKey),a=i.vertexLength;for(let t=0;t<o;t++)for(let e=0;e<o;e++)Wo(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<o-1;t++)for(let e=0;e<o-1;e++){const r=a+t*o+e,n=a+(t+1)*o+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1)}i.vertexLength+=o*o,i.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n)}}function Qo(t,e){for(let r=0;r<t.length;r++)if(la(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(la(t,e[r]))return!0;return!!na(t,e)}function ta(t,e,r){return!!la(t,e)||!!sa(e,t,r)}function ea(t,e){if(1===t.length)return aa(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(la(t,n[e]))return!0}for(let r=0;r<t.length;r++)if(aa(e,t[r]))return!0;for(let r=0;r<e.length;r++)if(na(t,e[r]))return!0;return!1}function ra(t,e,r){if(t.length>1){if(na(t,e))return!0;for(let n=0;n<e.length;n++)if(sa(e[n],t,r))return!0}for(let n=0;n<t.length;n++)if(sa(t[n],e,r))return!0;return!1}function na(t,e){if(0===t.length||0===e.length)return!1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(ia(n,i,e[t],e[t+1]))return!0}return!1}function ia(t,e,r,n){return _(t,r,n)!==_(e,r,n)&&_(t,e,r)!==_(t,e,n)}function sa(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(oa(t,e[r-1],e[r])<n)return!0;return!1}function oa(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function aa(t,e){let r,n,i,s=!1;for(let o=0;o<t.length;o++){r=t[o];for(let t=0,o=r.length-1;t<r.length;o=t++)n=r[t],i=r[o],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s)}return s}function la(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],o=t[i];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(r=!r)}return r}function ua(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return!1;const s=_(t,e,r[0]);return s!==_(t,e,r[1])||s!==_(t,e,r[2])||s!==_(t,e,r[3])}function ca(t,e,r){const n=e.paint.get(t).value;return"constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function ha(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function pa(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=a.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}let fa,da;ci("CircleBucket",Ko,{omit:["layers"]});var ya={get paint(){return da=da||new hs({"circle-radius":new as(T.paint_circle["circle-radius"]),"circle-color":new as(T.paint_circle["circle-color"]),"circle-blur":new as(T.paint_circle["circle-blur"]),"circle-opacity":new as(T.paint_circle["circle-opacity"]),"circle-translate":new os(T.paint_circle["circle-translate"]),"circle-translate-anchor":new os(T.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new os(T.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new os(T.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new as(T.paint_circle["circle-stroke-width"]),"circle-stroke-color":new as(T.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new as(T.paint_circle["circle-stroke-opacity"])})},get layout(){return fa=fa||new hs({"circle-sort-key":new as(T.layout_circle["circle-sort-key"])})}};class ma extends fs{constructor(t){super(t,ya)}createBucket(t){return new Ko(t)}queryRadius(t){const e=t;return ca("circle-radius",this,e)+ca("circle-stroke-width",this,e)+ha(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=pa(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c="map"===this.paint.get("circle-pitch-alignment"),h=c?l:function(t,e,r,n){return t.map((t=>ga(t,e,r,n)))}(l,i,o,a),p=c?u*s:u;for(const t of n)for(const e of t){const t=c?e:ga(e,i,o,a);let r=p;const n=i.projectTileCoordinates(e.x,e.y,o,a).signedDistanceFromCamera;if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n/i.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=i.cameraToCenterDistance/n),ta(h,t,r))return!0}return!1}}function ga(t,e,r,n){const i=e.projectTileCoordinates(t.x,t.y,r,n).point;return new a((.5*i.x+.5)*e.width,(.5*-i.y+.5)*e.height)}class xa extends Ko{}let va;ci("HeatmapBucket",xa,{omit:["layers"]});var ba={get paint(){return va=va||new hs({"heatmap-radius":new as(T.paint_heatmap["heatmap-radius"]),"heatmap-weight":new as(T.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new os(T.paint_heatmap["heatmap-intensity"]),"heatmap-color":new cs(T.paint_heatmap["heatmap-color"]),"heatmap-opacity":new os(T.paint_heatmap["heatmap-opacity"])})}};function wa(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function _a(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=wa({},{width:e,height:r},n);Sa(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data}function Sa(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,a=e.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)a[c+t]=o[u+t]}return e}class ka{constructor(t,e){wa(this,t,1,e)}resize(t){_a(this,t,1)}clone(){return new ka({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Sa(t,e,r,n,i,1)}}class Aa{constructor(t,e){wa(this,t,4,e)}resize(t){_a(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new Aa({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Sa(t,e,r,n,i,4)}setPixel(t,e,r){const n=4*(t*this.width+e);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a)}}ci("AlphaImage",ka),ci("RGBAImage",Aa);const Ia="big-fb";class Ma extends fs{createBucket(t){return new xa(t)}constructor(t){super(t,ba),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=function(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Aa({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,o)=>{e[t.evaluationKey]=o;const a=t.expression.evaluate(e);i.setPixel(n/4/r,s/4,a)};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=t.clips[e];s(i,o,l*(1-a)+u*a)}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Ia)&&this.heatmapFbos.delete(Ia)}queryRadius(){return 0}queryIntersectsFeature(){return!1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let za;var Pa={get paint(){return za=za||new hs({"hillshade-illumination-direction":new os(T.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new os(T.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new os(T.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new os(T.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new os(T.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new os(T.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new os(T.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new os(T.paint_hillshade["hillshade-method"])})}};class Ta extends fs{constructor(t){super(t,Pa),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(t.length,e.length,r.length,n.length);t=t.concat(Array(i-t.length).fill(t.at(-1))),e=e.concat(Array(i-e.length).fill(e.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=e.map(z);return{directionRadians:t.map(z),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Ca;var Ba={get paint(){return Ca=Ca||new hs({"color-relief-opacity":new os(T["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new cs(T["paint_color-relief"]["color-relief-color"])})}};class Ea{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n)}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(e&&e.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||k(t)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,n,i,0,this.format,a.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=r||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||k(t)?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,n,i,a.RGBA,a.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}class Va{constructor(t,e,r,n=1,i=1,s=1,o=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void w(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const a=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<a;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(a,t)]=this.data[this._idx(a-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,a)]=this.data[this._idx(t,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<a;t++)for(let e=0;e<a;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r)}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}pack(t){return Fa(t,this.getUnpackVector())}getPixels(){return new Aa({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1}switch(r){case-1:s=o-1;break;case 1:o=s+1}const a=-e*this.dim,l=-r*this.dim;for(let e=s;e<o;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+a,e+l)]}}function Fa(t,e){const r=e[0],n=e[1],i=e[2],s=e[3],o=Math.min(r,n,i),a=Math.round((t+s)/o);return{r:Math.floor(a*o/r)%256,g:Math.floor(a*o/n)%256,b:Math.floor(a*o/i)%256}}ci("DEMData",Va);class Da extends fs{constructor(t){super(t,Ba)}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof sn&&r._styleExpression.expression instanceof de){this.colorRampExpression=r;const t=r._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const r of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:r}}))}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[zt.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const n={elevationStops:[],colorStops:[]},i=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=i)n.elevationStops.push(e.elevationStops[Math.round(t)]),n.colorStops.push(e.colorStops[Math.round(t)]);return w(`Too many colors in specification of ${this.id} color-relief layer, may not render properly.`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(e),i=new Aa({width:n.colorStops.length,height:1}),s=new Aa({width:n.colorStops.length,height:1});for(let t=0;t<n.elevationStops.length;t++){const e=Fa(n.elevationStops[t],r);s.setPixel(0,t,new zt(e.r/255,e.g/255,e.b/255,1)),i.setPixel(0,t,n.colorStops[t])}return this.colorRampTextures={elevationTexture:new Ea(t,s,t.gl.RGBA),colorTexture:new Ea(t,i,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures}}const La=gs([{name:"a_pos",components:2,type:"Int16"}],4),{members:$a}=La;function Oa(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0)}return i}function Ra(t,e,r,n,i){const s=i.patternDependencies;for(const o of e){const e=o.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),a=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,s[t]=!0,s[a]=!0,s[l]=!0,r.patterns[o.id]={min:t,mid:a,max:l}}}return r}function Na(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,o=r-n;s<r;s+=n)i+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=ul(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=ul(i/n|0,t[i],t[i+1],s);return s&&nl(s,s.next)&&(cl(s),s=s.next),s}function ja(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!nl(n,n.next)&&0!==rl(n.prev,n,n.next))n=n.next;else{if(cl(n),n=e=n.prev,n===n.next)break;r=!0}}while(r||n!==e);return e}function Ua(t,e,r,n,i,s,o){if(!t)return;!o&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Wa(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let o=i,a=0;for(let t=0;t<r&&(a++,o=o.nextZ,o);t++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=o}s.nextZ=null,r*=2}while(e>1)}(i)}(t,n,i,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Ga(t,n,i,s):qa(t))e.push(l.i,t.i,u.i),cl(t),t=u.next,a=u.next;else if((t=u)===a){o?1===o?Ua(t=Xa(ja(t),e),e,r,n,i,s,2):2===o&&Za(t,e,r,n,i,s):Ua(ja(t),e,r,n,i,s,1);break}}}function qa(t){const e=t.prev,r=t,n=t.next;if(rl(e,r,n)>=0)return!1;const i=e.x,s=r.x,o=n.x,a=e.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),f=Math.max(a,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&tl(i,a,s,l,o,u,d.x,d.y)&&rl(d.prev,d,d.next)>=0)return!1;d=d.next}return!0}function Ga(t,e,r,n){const i=t.prev,s=t,o=t.next;if(rl(i,s,o)>=0)return!1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,f=Math.min(a,l,u),d=Math.min(c,h,p),y=Math.max(a,l,u),m=Math.max(c,h,p),g=Wa(f,d,e,r,n),x=Wa(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&tl(a,c,l,h,u,p,v.x,v.y)&&rl(v.prev,v,v.next)>=0)return!1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&tl(a,c,l,h,u,p,b.x,b.y)&&rl(b.prev,b,b.next)>=0)return!1;b=b.nextZ}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&tl(a,c,l,h,u,p,v.x,v.y)&&rl(v.prev,v,v.next)>=0)return!1;v=v.prevZ}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&tl(a,c,l,h,u,p,b.x,b.y)&&rl(b.prev,b,b.next)>=0)return!1;b=b.nextZ}return!0}function Xa(t,e){let r=t;do{const n=r.prev,i=r.next.next;!nl(n,i)&&il(n,r,r.next,i)&&al(n,i)&&al(i,n)&&(e.push(n.i,r.i,i.i),cl(r),cl(r.next),r=t=i),r=r.next}while(r!==t);return ja(r)}function Za(t,e,r,n,i,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&el(o,t)){let a=ll(o,t);return o=ja(o,o.next),a=ja(a,a.next),Ua(o,e,r,n,i,s,0),void Ua(a,e,r,n,i,s,0)}t=t.next}o=o.next}while(o!==t)}function Ya(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Ha(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,o=-1/0;if(nl(t,r))return r;do{if(nl(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>o&&(o=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next}while(r!==e);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Qa(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);al(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Ja(s,r)))&&(s=r,c=e)}r=r.next}while(r!==a);return s}(t,e);if(!r)return e;const n=ll(r,t);return ja(n,n.next),ja(r,r.next)}function Ja(t,e){return rl(t.prev,t,e.prev)<0&&rl(e.next,t,t.next)<0}function Wa(t,e,r,n,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Ka(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next}while(e!==t);return r}function Qa(t,e,r,n,i,s,o,a){return(i-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(n-a)>=(r-o)*(e-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function tl(t,e,r,n,i,s,o,a){return!(t===o&&e===a)&&Qa(t,e,r,n,i,s,o,a)}function el(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&il(r,r.next,t,e))return!0;r=r.next}while(r!==t);return!1}(t,e)&&(al(t,e)&&al(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==t);return n}(t,e)&&(rl(t.prev,t,e.prev)||rl(t,e.prev,e))||nl(t,e)&&rl(t.prev,t,t.next)>0&&rl(e.prev,e,e.next)>0)}function rl(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function nl(t,e){return t.x===e.x&&t.y===e.y}function il(t,e,r,n){const i=ol(rl(t,e,r)),s=ol(rl(t,e,n)),o=ol(rl(r,n,t)),a=ol(rl(r,n,e));return i!==s&&o!==a||!(0!==i||!sl(t,r,e))||!(0!==s||!sl(t,n,e))||!(0!==o||!sl(r,t,n))||!(0!==a||!sl(r,e,n))}function sl(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function ol(t){return t>0?1:t<0?-1:0}function al(t,e){return rl(t.prev,t,t.next)<0?rl(t,e,t.next)>=0&&rl(t,t.prev,e)>=0:rl(t,e,t.prev)<0||rl(t,t.next,e)<0}function ll(t,e){const r=hl(t.i,t.x,t.y),n=hl(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function ul(t,e,r,n){const i=hl(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function cl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function hl(t,e,r){return{i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class pl{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class fl{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}fl.noSubdivision=new fl({fill:new pl(0,0),line:new pl(0,0),tile:new pl(0,0),stencil:new pl(0,0),circle:1}),ci("SubdivisionGranularityExpression",pl),ci("SubdivisionGranularitySetting",fl);const dl=-32768,yl=32767;class ml{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=y/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],o=e[n+2],a=t[2*i],l=t[2*i+1];(t[2*s]-a)*(t[2*o+1]-l)-(t[2*s+1]-l)*(t[2*o]-a)>0?(r.push(i),r.push(o),r.push(s)):(r.push(i),r.push(s),r.push(o))}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),a=Math.max(a,e),o=Math.min(o,r),l=Math.max(l,r)}if(s===a||o===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(a/this._granularityCellSize),h=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);vl(this._vertexBuffer,n,e)}else e.push(...r)}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const o=e[2*t],a=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-o,f=u-a,d=0===p,y=0===f,m=(n-a)/f,g=(i-a)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(a<n||a>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(o+p*x,a+f*x));const b=o+p*Math.max(x,0),w=o+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,o,a,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(o+p*v,a+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,o,a,l,u,c,h,w,n,i)}return s}_generateIntraEdgeVertices(t,e,r,n,i,s,o){const a=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,o),h=u?Math.max(e,n):Math.max(s,o),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<o)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/a))}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/a))}}_generateInterEdgeVertices(t,e,r,n,i,s,o,a,l,u){const c=i-r,h=s-n,p=o-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,b=a<g;const w=0===p;if(w&&(o===l||o===u))return;if(w||y>=1||m<=0){const t=r-o,n=s+(e-s)*Math.min((l-o)/t,(u-o)/t);x=Math.floor(Math.min(n,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,a)/this._granularityCellSize)-1,b=a<n}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_))}_generateOutline(t){const e=[];for(const r of t){const t=xl(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i)}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===dl&&(t[e+1]=-32767),r===yl&&(t[e+1]=32766)}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===dl)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)))}_fillPoles(t,e,r){const n=this._vertexBuffer,i=y,s=t.length;for(let o=2;o<s;o+=3){const s=t[o-2],a=t[o-1],l=t[o],u=n[2*s],c=n[2*s+1],h=n[2*a],p=n[2*a+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,a,u,h,dl),0===p&&0===d&&this._generatePoleQuad(t,a,l,h,f,dl),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,dl)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,a,u,h,yl),p===i&&d===i&&this._generatePoleQuad(t,a,l,h,f,yl),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,yl))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y)}return{flattened:r,holeIndices:e}}(t);let i;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Na(t,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const o=Na(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);o===o.next&&(o.steiner=!0),i.push(Ka(o))}i.sort(Ya);for(let t=0;t<i.length;t++)r=Ha(i[t],r);return r}(t,e,s,r)),t.length>80*r){a=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<a&&(a=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i)}u=Math.max(e-a,n-l),u=0!==u?32767/u:0}return Ua(s,o,r,a,l,u,0),o}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y))}return e}}function gl(t,e,r,n=!0){return new ml(r,e).subdividePolygonInternal(t,n)}function xl(t,e,r=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const n=t[0],i=t[t.length-1],s=r&&(n.x!==i.x||n.y!==i.y);if(e<2)return s?[...t,t[0]]:[...t];const o=Math.floor(y/e),l=[];l.push(new a(t[0].x,t[0].y));const u=t.length,c=s?u:u-1;for(let e=0;e<c;e++){const r=t[e],n=e<u-1?t[e+1]:t[0],i=r.x,s=r.y,c=n.x,h=n.y,p=i!==c,f=s!==h;if(!p&&!f)continue;const d=c-i,y=h-s,m=Math.abs(d),g=Math.abs(y);let x=i,v=s;for(;;){const t=d>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,e=y>0?(Math.floor(v/o)+1)*o:(Math.ceil(v/o)-1)*o,r=Math.abs(x-t),n=Math.abs(v-e),i=Math.abs(x-c),s=Math.abs(v-h),u=p?r/m:Number.POSITIVE_INFINITY,b=f?n/g:Number.POSITIVE_INFINITY;if((i<=r||!p)&&(s<=n||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const e=new a(x,Math.round(v));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e)}else{x+=d*b,v=e;const t=new a(Math.round(x),v);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t)}}const b=new a(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b)}return l}function vl(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r)}const s=e.length;let o=n,a=(o+1)%s;for(;;){const n=o-1>=0?o-1:s-1,i=(a+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[o]],h=t[2*e[o]+1],p=t[2*e[a]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else{const r=p-h,s=-(t[2*e[a]]-c),o=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*o>((u-c)*r+(t[2*e[i]+1]-h)*s)*o&&(f=!0)}if(f){const t=e[n],i=e[o],l=e[a];t!==i&&t!==l&&i!==l&&r.push(l,i,t),o--,o<0&&(o=s-1)}else{const t=e[i],n=e[o],l=e[a];t!==n&&t!==l&&n!==l&&r.push(l,n,t),a++,a>=s&&(a=0)}if(n===i)break}}function bl(t,e,r,n,i,s,o,a,l){const u=i.length/2,c=o&&a&&l;if(u<go.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=o.prepareSegment(u,r,a),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)a.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2}}else!function(t,e,r,n,i,s){const o=[];for(let t=0;t<n.length/2;t++)o.push(-1);const a={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=o[p]<l,m=o[f]<l,g=o[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>go.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=a.count,y=!0,m=!0,g=!0,c=0);const x=wl(o,n,s,a,p,y,u),v=wl(o,n,s,a,f,m,u),b=wl(o,n,s,a,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const o=[];for(let t=0;t<n.length/2;t++)o.push(-1);const a={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=o[i]<l,y=o[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>go.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=a.count,d=!0,y=!0,c=0);const m=wl(o,n,s,a,i,d,u),g=wl(o,n,s,a,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++}}}(o,r,a,i,l,t),e.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function wl(t,e,r,n,i,s,o){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,o.vertexLength++,s}return t[i]}class _l{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ro,this.indexArray=new po,this.indexArray2=new fo,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new go,this.segments2=new go,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=Oa("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ho(o,t);if(!this.layers[0]._featureFilter.filter(new Wi(this.zoom,{globalState:this.globalState}),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Yo(o),patterns:{},sortKey:h};s.push(p)}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=Ra("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,$a),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,r,n,i,s){for(const t of er(e,500)){const e=gl(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;bl(((t,e)=>{r.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n)}}let Sl,kl;ci("FillBucket",_l,{omit:["layers","patternFeatures"]});var Al={get paint(){return kl=kl||new hs({"fill-antialias":new os(T.paint_fill["fill-antialias"]),"fill-opacity":new as(T.paint_fill["fill-opacity"]),"fill-color":new as(T.paint_fill["fill-color"]),"fill-outline-color":new as(T.paint_fill["fill-outline-color"]),"fill-translate":new os(T.paint_fill["fill-translate"]),"fill-translate-anchor":new os(T.paint_fill["fill-translate-anchor"]),"fill-pattern":new ls(T.paint_fill["fill-pattern"])})},get layout(){return Sl=Sl||new hs({"fill-sort-key":new as(T.layout_fill["fill-sort-key"])})}};class Il extends fs{constructor(t){super(t,Al)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new _l(t)}queryRadius(){return ha(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return ea(pa(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return!0}}const Ml=gs([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),zl=gs([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Pl}=Ml;var Tl,Cl,Bl,El,Vl,Fl,Dl,Ll={};function $l(){if(Cl)return Tl;Cl=1;var t=i();function e(t,e,n,i,s){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=s,t.readFields(r,this,e)}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos)}function n(t){for(var e,r,n=0,i=0,s=t.length,o=s-1;i<s;o=i++)n+=((r=t[o]).x-(e=t[i]).x)*(e.y+r.y);return n}return Tl=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,i=1,s=0,o=0,a=0,l=[];e.pos<n;){if(s<=0){var u=e.readVarint();i=7&u,s=u>>3}if(s--,1===i||2===i)o+=e.readSVarint(),a+=e.readSVarint(),1===i&&(r&&l.push(r),r=[]),r.push(new t(o,a));else{if(7!==i)throw new Error("unknown command "+i);r&&r.push(r[0].clone())}}return r&&l.push(r),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3}if(n--,1===r||2===r)(i+=t.readSVarint())<o&&(o=i),i>a&&(a=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return[o,l,a,u]},e.prototype.toGeoJSON=function(t,r,i){var s,o,a=this.extent*Math.pow(2,i),l=this.extent*t,u=this.extent*r,c=this.loadGeometry(),h=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+l)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+u)/a)*Math.PI/180))-90]}}switch(this.type){case 1:var f=[];for(s=0;s<c.length;s++)f[s]=c[s][0];p(c=f);break;case 2:for(s=0;s<c.length;s++)p(c[s]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return[t];for(var r,i,s=[],o=0;o<e;o++){var a=n(t[o]);0!==a&&(void 0===i&&(i=a<0),i===a<0?(r&&s.push(r),r=[t[o]]):r.push(t[o]))}return r&&s.push(r),s}(c),s=0;s<c.length;s++)for(o=0;o<c[s].length;o++)p(c[s][o])}1===c.length?c=c[0]:h="Multi"+h;var d={type:"Feature",geometry:{type:h,coordinates:c},properties:this.properties};return"id"in this&&(d.id=this.id),d},Tl}function Ol(){if(El)return Bl;El=1;var t=$l();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null}return e}(r))}return Bl=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},Bl}function Rl(){return Dl||(Dl=1,Ll.VectorTile=function(){if(Fl)return Vl;Fl=1;var t=Ol();function e(e,r,n){if(3===e){var i=new t(n,n.readVarint()+n.pos);i.length&&(r[i.name]=i)}}return Vl=function(t,r){this.layers=t.readFields(e,{},r)},Vl}(),Ll.VectorTileFeature=$l(),Ll.VectorTileLayer=Ol()),Ll}var Nl=e(Rl());const jl=Nl.VectorTileFeature.types,Ul=Math.pow(2,13);function ql(t,e,r,n,i,s,o,a){t.emplaceBack(e,r,2*Math.floor(n*Ul)+o,i*Ul*2,s*Ul*2,Math.round(a))}class Gl{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new no,this.centroidVertexArray=new to,this.indexArray=new po,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new go,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.features=[],this.hasPattern=Oa("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,a=Ho(n,t);if(!this.layers[0]._featureFilter.filter(new Wi(this.zoom,{globalState:this.globalState}),a,r))continue;const l={id:i,sourceLayerIndex:o,index:s,geometry:t?a.geometry:Yo(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(Ra("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,o,this.index,!0)}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Pl),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,zl.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,r,n,i,s){for(const r of er(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const o=this.layoutVertexArray.length-i,a=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<o;t++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n)}processPolygon(t,e,r,n,i){if(n.length<1)return;if(Yl(n[0]))return;for(const e of n)0!==e.length&&Xl(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=i.fill.getGranularityForZoomLevel(e.z),a="Polygon"===jl[r.type];for(const t of n){if(0===t.length)continue;if(Yl(t))continue;const e=xl(t,o,a);this._generateSideFaces(e,s)}if(!a)return;const l=gl(n,e,o,!1),u=this.layoutVertexArray;bl(((t,e)=>{ql(u,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if(Zl(i,s))continue;e.segment.vertexLength+4>go.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=i.sub(s)._perp()._unit(),a=s.dist(i);r+a>32768&&(r=0),ql(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,0,r),ql(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,1,r),r+=a,ql(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,r),ql(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function Xl(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++)}}function Zl(t,e){return t.x===e.x&&(t.x<0||t.x>y)||t.y===e.y&&(t.y<0||t.y>y)}function Yl(t){return t.every((t=>t.x<0))||t.every((t=>t.x>y))||t.every((t=>t.y<0))||t.every((t=>t.y>y))}let Hl;ci("FillExtrusionBucket",Gl,{omit:["layers","features"]});var Jl={get paint(){return Hl=Hl||new hs({"fill-extrusion-opacity":new os(T["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new as(T["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new os(T["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new os(T["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ls(T["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new as(T["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new as(T["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new os(T["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Wl extends fs{constructor(t){super(t,Jl)}createBucket(t){return new Gl(t)}queryRadius(){return ha(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,pixelPosMatrix:o}){const l=pa(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("fill-extrusion-height").evaluate(e,r),c=this.paint.get("fill-extrusion-base").evaluate(e,r),h=function(t,e){const r=[];for(const n of t){const t=[n.x,n.y,0,1];d(t,t,e),r.push(new a(t[0]/t[3],t[1]/t[3]))}return r}(l,o),p=function(t,e,r,n){const i=[],s=[],o=n[8]*e,l=n[9]*e,u=n[10]*e,c=n[11]*e,h=n[8]*r,p=n[9]*r,f=n[10]*r,d=n[11]*r;for(const e of t){const t=[],r=[];for(const i of e){const e=i.x,s=i.y,y=n[0]*e+n[4]*s+n[12],m=n[1]*e+n[5]*s+n[13],g=n[2]*e+n[6]*s+n[14],x=n[3]*e+n[7]*s+n[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,k=x+d,A=new a((y+o)/b,(m+l)/b);A.z=v/b,t.push(A);const I=new a(w/k,_/k);I.z=S/k,r.push(I)}i.push(t),s.push(r)}return[i,s]}(n,c,u,o);return function(t,e,r){let n=1/0;ea(r,e)&&(n=Ql(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],o=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],o[t+1],o[t],e];Qo(r,i)&&(n=Math.min(n,Ql(r,i)))}}return n!==1/0&&n}(p[0],p[1],h)}}function Kl(t,e){return t.x*e.x+t.y*e.y}function Ql(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],o=t[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=Kl(a,a),h=Kl(a,l),p=Kl(l,l),f=Kl(u,a),d=Kl(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const tu=gs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:eu}=tu,ru=gs([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:nu}=ru,iu=Nl.VectorTileFeature.types,su=Math.cos(Math.PI/180*37.5),ou=Math.pow(2,14)/.5;class au{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new io,this.layoutVertexArray2=new so,this.indexArray=new po,this.programConfigurations=new Uo(t.layers,t.zoom),this.segments=new go,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,r){this.hasPattern=Oa("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ho(e,t);if(!this.layers[0]._featureFilter.filter(new Wi(this.zoom,{globalState:this.globalState}),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:o,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?u.geometry:Yo(e),patterns:{},sortKey:c};s.push(h)}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasPattern){const t=Ra("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,o,this.index)}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r)}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,nu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,eu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const o=this.layers[0].layout,a=o.get("line-join").evaluate(t,{}),l=o.get("line-cap"),u=o.get("line-miter-limit"),c=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,l,u,c,n,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n)}addLine(t,e,r,n,i,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=xl(t,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===iu[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let o=m.add(g);0===o.x&&0===o.y||o._unit();const a=m.x*g.x+m.y*g.y,x=o.x*g.x+o.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<su&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e}}const S=d&&y;let k=S?r:l?"butt":n;if(S&&"round"===k&&(v<s?k="miter":v<=2&&(k="fakeround")),"miter"===k&&v>i&&(k="bevel"),"bevel"===k&&(v>2&&(k="flipbevel"),v<i&&(k="miter")),d&&this.updateDistance(d,f),"miter"===k)o._mult(v),this.addCurrentVertex(f,o,0,0,p);else if("flipbevel"===k){if(v>100)o=g.mult(-1);else{const t=v*m.add(g).mag()/m.sub(g).mag();o._perp()._mult(t*(_?-1:1))}this.addCurrentVertex(f,o,0,0,p),this.addCurrentVertex(f,o.mult(-1),0,0,p)}else if("bevel"===k||"fakeround"===k){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===k){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*t*t+(.848013+a*(.215638*a-1.06021)))}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p)}}y&&this.addCurrentVertex(f,g,-e,-r,p)}else if("butt"===k)this.addCurrentVertex(f,o,0,0,p);else if("square"===k){const t=d?1:-1;this.addCurrentVertex(f,o,t,t,p)}else"round"===k&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e}}}}addCurrentVertex(t,e,r,n,i,s=!1){const o=e.y*n-e.x,a=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,o,a,s,!0,-n,i),this.distance>ou/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s))}addHalfVertex({x:t,y:e},r,n,i,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(ou-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),a.primitiveLength++),s?this.e2=u:this.e1=u}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let lu,uu;ci("LineBucket",au,{omit:["layers","patternFeatures"]});var cu={get paint(){return uu=uu||new hs({"line-opacity":new as(T.paint_line["line-opacity"]),"line-color":new as(T.paint_line["line-color"]),"line-translate":new os(T.paint_line["line-translate"]),"line-translate-anchor":new os(T.paint_line["line-translate-anchor"]),"line-width":new as(T.paint_line["line-width"]),"line-gap-width":new as(T.paint_line["line-gap-width"]),"line-offset":new as(T.paint_line["line-offset"]),"line-blur":new as(T.paint_line["line-blur"]),"line-dasharray":new us(T.paint_line["line-dasharray"]),"line-pattern":new ls(T.paint_line["line-pattern"]),"line-gradient":new cs(T.paint_line["line-gradient"])})},get layout(){return lu=lu||new hs({"line-cap":new os(T.layout_line["line-cap"]),"line-join":new as(T.layout_line["line-join"]),"line-miter-limit":new os(T.layout_line["line-miter-limit"]),"line-round-limit":new os(T.layout_line["line-round-limit"]),"line-sort-key":new as(T.layout_line["line-sort-key"])})}};class hu extends as{possiblyEvaluate(t,e){return e=new Wi(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=g({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let pu;class fu extends fs{constructor(t){super(t,cu),this.gradientVersion=0,pu||(pu=new hu(cu.paint.properties["line-width"].specification),pu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof le,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=pu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new au(t)}queryRadius(t){const e=t,r=du(ca("line-width",this,e),ca("line-gap-width",this,e)),n=ca("line-offset",this,e);return r/2+Math.abs(n)+ha(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s}){const o=pa(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-i.bearingInRadians,s),l=s/2*du(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],s=[];for(let t=0;t<i.length;t++){const r=i[t-1],n=i[t],o=i[t+1],l=0===t?new a(0,0):n.sub(r)._unit()._perp(),u=t===i.length-1?new a(0,0):o.sub(n)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),s.push(c._mult(e)._add(n))}r.push(s)}return r}(n,u*s)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(la(t,i[e]))return!0;if(ra(t,i,r))return!0}return!1}(o,n,l)}isTileClipped(){return!0}}function du(t,e){return e>0?e+2*t:t}const yu=gs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),mu=gs([{name:"a_projected_pos",components:3,type:"Float32"}],4);gs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const gu=gs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);gs([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const xu=gs([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4);function vu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return"uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ji.applyArabicShaping&&(t=Ji.applyArabicShaping(t)),t}(t.text,e,r)})),t}gs([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4),gs([{name:"triangle",components:3,type:"Uint16"}]),gs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),gs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),gs([{type:"Float32",name:"offsetX"}]),gs([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),gs([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const bu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var wu,_u,Su,ku=24,Au={};function Iu(){return wu||(wu=1,Au.read=function(t,e,r,n,i){var s,o,a=8*i-n-1,l=(1<<a)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=a;c>0;s=256*s+t[e+h],h+=p,c-=8);for(o=s&(1<<-c)-1,s>>=-c,c+=n;c>0;o=256*o+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else{if(s===l)return o?NaN:1/0*(f?-1:1);o+=Math.pow(2,n),s-=u}return(f?-1:1)*o*Math.pow(2,s-n)},Au.write=function(t,e,r,n,i,s){var o,a,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,o=c):(o=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-o))<1&&(o--,l*=2),(e+=o+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(o++,l/=2),o+h>=c?(a=0,o=c):o+h>=1?(a=(e*l-1)*Math.pow(2,i),o+=h):(a=e*Math.pow(2,h-1)*Math.pow(2,i),o=0));i>=8;t[r+f]=255&a,f+=d,a/=256,i-=8);for(o=o<<i|a,u+=i;u>0;t[r+f]=255&o,f+=d,o/=256,u-=8);t[r+f-d]|=128*y}),Au}function Mu(){if(Su)return _u;Su=1,_u=e;var t=Iu();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,i="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function o(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function a(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i]}function l(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r])}function u(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r])}function c(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r])}function h(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r])}function p(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r])}function f(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r])}function d(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r])}function y(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r])}function m(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r])}function g(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function x(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24}function v(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return o(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return o(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return o(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&i?function(t,e,r){return i.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,o,a,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(o=t[i+2],128==(192&(s=t[i+1]))&&128==(192&o)&&((u=(15&l)<<12|(63&s)<<6|63&o)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(o=t[i+2],a=t[i+3],128==(192&(s=t[i+1]))&&128==(192&o)&&128==(192&a)&&((u=(15&l)<<18|(63&s)<<12|(63&o)<<6|63&a)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=s(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else{if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7)}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(n,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128)}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&a(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r]},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&a(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,c,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,h,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,f,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,d,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,y,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,m,e)},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r)},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r)},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r)},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r)},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r)},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r)},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r)},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r)},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r)},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}},_u}var zu,Pu=e(Mu());function Tu(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e)}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return{w:i,h:s,fill:e/(i*s)||0}}class Cu{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Bu{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:o}=Tu(i),a=new Aa({width:s||1,height:o||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Aa.copy(n.data,a,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data)}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,o=i.y+1,l=r.data.width,u=r.data.height;Aa.copy(r.data,a,{x:0,y:0},{x:s,y:o},r.data),Aa.copy(r.data,a,{x:0,y:u-1},{x:s,y:o-1},{width:l,height:1}),Aa.copy(r.data,a,{x:0,y:0},{x:s,y:o+u},{width:l,height:1}),Aa.copy(r.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:u}),Aa.copy(r.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:u})}this.image=a,this.iconPositions=r,this.patternPositions=n}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Cu(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e)}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i})}}ci("ImagePosition",Cu),ci("ImageAtlas",Bu),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(zu||(zu={}));class Eu{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom"}static forText(t,e,r){const n=new Eu;return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n}static forImage(t,e){const r=new Eu;return r.imageName=t,r.verticalAlign=e||"bottom",r}}class Vu{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null}static fromFeature(t,e){const r=new Vu;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e)}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&Gi(n)&&!bu[t[r+1]]||i&&Gi(i)&&!bu[t[r-1]]||!bu[t[r]]?t[r]:bu[t[r]]}return e}(this.text)}trim(){let t=0;for(let e=0;e<this.text.length&&Du[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Du[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e)}substring(t,e){const r=new Vu;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if(i.imageName){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1])}}return{maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push(Eu.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r)}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void w("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Eu.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):w("Reached maximum number of images 6401")}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Fu(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d){const y=Vu.fromFeature(t,i);let m;h===zu.vertical&&y.verticalizePunctuation();const{processBidirectionalText:g,processStyledBidirectionalText:x}=Ji;if(g&&1===y.sections.length){m=[];const t=g(y.toString(),qu(y,u,s,e,n,f));for(const e of t){const t=new Vu;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);m.push(t)}}else if(x){m=[];const t=x(y.text,y.sectionIndex,qu(y,u,s,e,n,f));for(const e of t){const t=new Vu;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,m.push(t)}}else m=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,qu(y,u,s,e,n,f));const v=[],b={positionedLines:v,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,o,a,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===a?1:"left"===a?0:.5,g=ku/h;let x=0;for(const o of i){o.trim();const i=o.getMaxScale(),a={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=a;const h=a.positionedGlyphs;let v=0;if(!o.length()){f+=s,++x;continue}const b=Xu(n,o,g);for(let s=0;s<o.length();s++){const a=o.getSection(s),d=o.getSectionIndex(s),y=o.getCharCode(s),m=Yu(l,c,y);let x;if(a.imageName){if(t.iconsInText=!0,a.scale=a.scale*g,x=Ju(a,m,i,b,n),!x)continue;v=Math.max(v,x.imageOffset)}else if(x=Hu(a,y,m,b,e,r),!x)continue;const{rect:w,metrics:_,baselineOffset:S}=x;h.push({glyph:y,imageName:a.imageName,x:p,y:f+S+-17,vertical:m,scale:a.scale,fontStack:a.fontStack,sectionIndex:d,metrics:_,rect:w}),m?(t.verticalizable=!0,p+=(a.imageName?_.advance:ku)*a.scale+u):p+=_.advance*a.scale+u}0!==h.length&&(d=Math.max(p-u,d),Wu(h,0,h.length-1,m)),p=0,a.lineOffset=Math.max(v,(i-1)*ku);const w=s*i+v;f+=w,y=Math.max(w,y),++x}const{horizontalAlign:v,verticalAlign:b}=Gu(o);(function(t,e,r,n,i,s,o,a,l){const u=(e-r)*i;let c=0;c=s!==o?-a*n- -17:-n*l*o+.5*o;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c})(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d}(b,e,r,n,m,o,a,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return!1;return!0}(v)&&b}const Du={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Lu={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},$u={40:!0};function Ou(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*ku/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function Ru(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Nu(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function ju(t,e,r,n,i,s){let o=null,a=Ru(e,r,i,s);for(const t of n){const n=Ru(e-t.x,r,i,s)+t.badness;n<=a&&(o=t,a=n)}return{index:t,x:e,priorBreak:o,badness:a}}function Uu(t){return t?Uu(t.priorBreak).concat(t.index):[]}function qu(t,e,r,n,i,s){if(!t)return[];const o=[],a=function(t,e,r,n,i,s){let o=0;for(let r=0;r<t.length();r++){const a=t.getSection(r);o+=Ou(t.getCharCode(r),a,n,i,e,s)}return o/Math.max(1,Math.ceil(o/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(Du[p]||(u+=Ou(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!Fi(c)||!!Ei(c)||!!Ci(c)||!!Pi(c)||!!Bi(c)||!!Li(c)||!!zi(c)||!!Vi(c)||Ui.test(String.fromCodePoint(c)));(Lu[p]||e||h.imageName||r!==t.length()-2&&$u[t.getCharCode(r+1)])&&o.push(ju(r+1,u,a,o,Nu(p,t.getCharCode(r+1),e&&l),!1))}}var c;return Uu(ju(t.length(),u,a,o,0,!0))}function Gu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0}return{horizontalAlign:e,verticalAlign:r}}function Xu(t,e,r){const n=e.getMaxScale()*ku,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),o=Math.max(n,s*r);return{verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:o}}function Zu(t){switch(t){case"top":return 0;case"center":return.5;default:return 1}}function Yu(t,e,r){return!(t===zu.horizontal||!e&&!qi(r)||e&&(Du[r]||(n=r,/\p{sc=Arab}/u.test(String.fromCodePoint(n)))));var n}function Hu(t,e,r,n,i,s){const o=s[t.fontStack],a=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(o&&o[e],i,t,e);if(null===a)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*ku;else{const e=Zu(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*ku)*e}return{rect:a.rect,metrics:a.metrics,baselineOffset:l}}function Ju(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const o=s.paddedRect,a=s.displaySize,l={width:a[0],height:a[1],left:1,top:-3,advance:e?a[1]:a[0]};let u;if(e)u=n.verticalLineContentWidth-a[1]*t.scale;else{const e=Zu(t.verticalAlign);u=(n.horizontalLineContentHeight-a[1]*t.scale)*e}return{rect:o,metrics:l,baselineOffset:u,imageOffset:(e?a[0]:a[1])*t.scale-ku*r}}function Wu(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s}function Ku(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Gu(r),s=e[0]-t.displaySize[0]*n,o=e[1]-t.displaySize[1]*i;return{image:t,top:o,bottom:o+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Qu(t){var e,r;let n=t.left,i=t.top,s=t.right-n,o=t.bottom-i;const a=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===a&&s/o<u||"proportional"===a){const t=Math.ceil(o*u);n*=t/s,s=t}}else if("proportional"===a&&"stretchOnly"===l&&0!==u&&s/o>u){const t=Math.ceil(s/u);i*=t/o,o=t}return{x1:n,y1:i,x2:n+s,y2:i+o}}function tc(t,e,r,n,i,s){const o=t.image;let a;if(o.content){const t=o.content,e=o.pixelRatio||1;a=[t[0]/e,t[1]/e,o.displaySize[0]-t[2]/e,o.displaySize[1]-t[3]/e]}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-o.displaySize[0])/2,h=f+o.displaySize[0]);const d=e.top*s,y=e.bottom*s;return"height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-o.displaySize[1])/2,p=c+o.displaySize[1]),{image:o,top:c,right:h,bottom:p,left:f,collisionPadding:a}}const ec=128,rc=32640;function nc(t,e){const{expression:r}=e;if("constant"===r.kind)return{kind:"constant",layoutSize:r.evaluate(new Wi(t+1))};if("source"===r.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const o=e[i],a=e[s];return"composite"===r.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:n}:{kind:"camera",minZoom:o,maxZoom:a,minSize:r.evaluate(new Wi(o)),maxSize:r.evaluate(new Wi(a)),interpolationType:n}}}function ic(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const sc=Nl.VectorTileFeature.types,oc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function ac(t,e,r,n,i,s,o,a,l,u,c,h,p){const f=a?Math.min(rc,Math.round(a[0])):0,d=a?Math.min(rc,Math.round(a[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,o,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p)}function lc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r)}function uc(t){for(const e of t.sections)if(Hi(e.text))return!0;return!1}class cc{constructor(t){this.layoutVertexArray=new ao,this.indexArray=new po,this.programConfigurations=t,this.segments=new go,this.dynamicLayoutVertexArray=new lo,this.opacityVertexArray=new uo,this.hasVisibleVertices=!1,this.placedSymbolArray=new Gs}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yu.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,mu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,oc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}ci("SymbolBuffers",cc);class hc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new go,this.collisionVertexArray=new ho}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,gu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}ci("CollisionBuffers",hc);class pc{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=nc(this.zoom,e["text-size"]),this.iconSizeData=nc(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap="never"!==ic(r,"text-overlap","text-allow-overlap")||"never"!==ic(r,"icon-overlap","icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&!n.isConstant(),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map((t=>zu[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new cc(new Uo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new cc(new Uo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Ys,this.lineVertexArray=new Hs,this.symbolInstances=new Zs,this.textAnchorOffsets=new Ws}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=bu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0)}}populate(t,e,r){const n=this.layers[0],i=n.layout,s=i.get("text-font"),o=i.get("text-field"),a=i.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Bt&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,c=i.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=e.iconDependencies,p=e.glyphDependencies,f=e.availableImages,d=new Wi(this.zoom,{globalState:this.globalState});for(const{feature:e,id:o,index:a,sourceLayerIndex:y}of t){const t=n._featureFilter.needGeometry,m=Ho(e,t);if(!n._featureFilter.filter(d,m,r))continue;let g,x;if(t||(m.geometry=Yo(e)),l){const t=n.getValueAndResolveTokens("text-field",m,r,f),e=Bt.factory(t),i=this.hasRTLText=this.hasRTLText||uc(e);(!i||"unavailable"===Ji.getRTLTextPluginStatus()||i&&Ji.isParsed())&&(g=vu(e,n,m))}if(u){const t=n.getValueAndResolveTokens("icon-image",m,r,f);x=t instanceof Ot?t:Ot.fromString(t)}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:o,text:g,icon:x,index:a,sourceLayerIndex:y,geometry:m.geometry,properties:e.properties,type:sc[e.type],sortKey:v}),x&&(h[x.name]=!0),g){const t=s.evaluate(m,{},r).join(","),e="viewport"!==i.get("text-rotation-alignment")&&"point"!==i.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(zu.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else{const n=$i(g.toString()),i=r.fontStack||t,s=p[i]=p[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n)}}}"line"===i.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++}function o(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return`${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=a(f,d,h),i=o(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null}else f in r?o(f,d,h):d in e?a(f,d,h):(s(u),e[f]=i-1,r[d]=i-1)}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,o,a,l,u,c,h){const p=t.indexArray,f=t.layoutVertexArray,d=t.segments.prepareSegment(4*e.length,f,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=d.vertexLength,g=this.allowVerticalPlacement&&o===zu.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:o,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=e[n],k=d.vertexLength,A=w[1];ac(f,a.x,a.y,i.x,A+i.y,c.x,c.y,r,_,y.x,y.y,v,b),ac(f,a.x,a.y,o.x,A+o.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),ac(f,a.x,a.y,l.x,A+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),ac(f,a.x,a.y,u.x,A+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),lc(t.dynamicLayoutVertexArray,a,g),p.emplaceBack(k,k+2,k+1),p.emplaceBack(k+1,k+2,k+3),d.vertexLength+=4,d.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),n!==e.length-1&&S===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(f.length,s,s.index,{},h,x&&x[S])}t.placedSymbolArray.emplaceBack(a.x,a.y,y,this.glyphOffsetArray.length-y,m,l,u,a.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],o,0,!1,0,c)}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,r,n,i,s,o){const l=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),u=l.vertexLength,c=i.layoutVertexArray,h=i.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,s,p,f,new a(t,e)),this._addCollisionDebugVertex(c,h,s,p,f,new a(r,e)),this._addCollisionDebugVertex(c,h,s,p,f,new a(r,n)),this._addCollisionDebugVertex(c,h,s,p,f,new a(t,n)),l.vertexLength+=4;const d=i.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new hc(co,xu.members,fo),this.iconCollisionBox=new hc(co,xu.members,fo);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,o,a,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<o;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=a;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);n.push(0|Math.round(e*o.anchorX+r*o.anchorY)),i.push(o.featureIndex)}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let fc,dc;ci("SymbolBucket",pc,{omit:["layers","collisionBoxArray","features","compareText"]}),pc.MAX_GLYPHS=65535,pc.addDynamicAttributes=lc;var yc={get paint(){return dc=dc||new hs({"icon-opacity":new as(T.paint_symbol["icon-opacity"]),"icon-color":new as(T.paint_symbol["icon-color"]),"icon-halo-color":new as(T.paint_symbol["icon-halo-color"]),"icon-halo-width":new as(T.paint_symbol["icon-halo-width"]),"icon-halo-blur":new as(T.paint_symbol["icon-halo-blur"]),"icon-translate":new os(T.paint_symbol["icon-translate"]),"icon-translate-anchor":new os(T.paint_symbol["icon-translate-anchor"]),"text-opacity":new as(T.paint_symbol["text-opacity"]),"text-color":new as(T.paint_symbol["text-color"],{runtimeType:R,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new as(T.paint_symbol["text-halo-color"]),"text-halo-width":new as(T.paint_symbol["text-halo-width"]),"text-halo-blur":new as(T.paint_symbol["text-halo-blur"]),"text-translate":new os(T.paint_symbol["text-translate"]),"text-translate-anchor":new os(T.paint_symbol["text-translate-anchor"])})},get layout(){return fc=fc||new hs({"symbol-placement":new os(T.layout_symbol["symbol-placement"]),"symbol-spacing":new os(T.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new os(T.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new as(T.layout_symbol["symbol-sort-key"]),"symbol-z-order":new os(T.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new os(T.layout_symbol["icon-allow-overlap"]),"icon-overlap":new os(T.layout_symbol["icon-overlap"]),"icon-ignore-placement":new os(T.layout_symbol["icon-ignore-placement"]),"icon-optional":new os(T.layout_symbol["icon-optional"]),"icon-rotation-alignment":new os(T.layout_symbol["icon-rotation-alignment"]),"icon-size":new as(T.layout_symbol["icon-size"]),"icon-text-fit":new os(T.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new os(T.layout_symbol["icon-text-fit-padding"]),"icon-image":new as(T.layout_symbol["icon-image"]),"icon-rotate":new as(T.layout_symbol["icon-rotate"]),"icon-padding":new as(T.layout_symbol["icon-padding"]),"icon-keep-upright":new os(T.layout_symbol["icon-keep-upright"]),"icon-offset":new as(T.layout_symbol["icon-offset"]),"icon-anchor":new as(T.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new os(T.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new os(T.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new os(T.layout_symbol["text-rotation-alignment"]),"text-field":new as(T.layout_symbol["text-field"]),"text-font":new as(T.layout_symbol["text-font"]),"text-size":new as(T.layout_symbol["text-size"]),"text-max-width":new as(T.layout_symbol["text-max-width"]),"text-line-height":new os(T.layout_symbol["text-line-height"]),"text-letter-spacing":new as(T.layout_symbol["text-letter-spacing"]),"text-justify":new as(T.layout_symbol["text-justify"]),"text-radial-offset":new as(T.layout_symbol["text-radial-offset"]),"text-variable-anchor":new os(T.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new as(T.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new as(T.layout_symbol["text-anchor"]),"text-max-angle":new os(T.layout_symbol["text-max-angle"]),"text-writing-mode":new os(T.layout_symbol["text-writing-mode"]),"text-rotate":new as(T.layout_symbol["text-rotate"]),"text-padding":new os(T.layout_symbol["text-padding"]),"text-keep-upright":new os(T.layout_symbol["text-keep-upright"]),"text-transform":new as(T.layout_symbol["text-transform"]),"text-offset":new as(T.layout_symbol["text-offset"]),"text-allow-overlap":new os(T.layout_symbol["text-allow-overlap"]),"text-overlap":new os(T.layout_symbol["text-overlap"]),"text-ignore-placement":new os(T.layout_symbol["text-ignore-placement"]),"text-optional":new os(T.layout_symbol["text-optional"])})}};class mc{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:D,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}ci("FormatSectionOverride",mc,{omit:["defaultValue"]});class gc extends fs{constructor(t){super(t,yc)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||rn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new pc(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of yc.paint.overridableProperties){if(!gc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new mc(e),n=new en(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new sn("source",n):new on("composite",n,e.value.zoomStops),this.paint._values[t]=new is(e.property,i,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,r){return!(!this.layout||e.isDataDriven()||r.isDataDriven())&&gc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=yc.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Bt)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof Gt&&Ut(e.value)===G?s(e.value.sections):e instanceof Pe?s(e.sections):e.eachChild(t))},e=r.value;e._styleExpression&&t(e._styleExpression.expression)}return i}}let xc;var vc={get paint(){return xc=xc||new hs({"background-color":new os(T.paint_background["background-color"]),"background-pattern":new us(T.paint_background["background-pattern"]),"background-opacity":new os(T.paint_background["background-opacity"])})}};class bc extends fs{constructor(t){super(t,vc)}}let wc;var _c,Sc={get paint(){return wc=wc||new hs({"raster-opacity":new os(T.paint_raster["raster-opacity"]),"raster-hue-rotate":new os(T.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new os(T.paint_raster["raster-brightness-min"]),"raster-brightness-max":new os(T.paint_raster["raster-brightness-max"]),"raster-saturation":new os(T.paint_raster["raster-saturation"]),"raster-contrast":new os(T.paint_raster["raster-contrast"]),"raster-resampling":new os(T.paint_raster["raster-resampling"]),"raster-fade-duration":new os(T.paint_raster["raster-fade-duration"])})}};class kc extends fs{constructor(t){super(t,Sc)}}class Ac extends fs{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Ic(t){if("custom"===t.type)return new Ac(t);switch(t.type){case"background":return new bc(t);case"circle":return new ma(t);case"color-relief":return new Da(t);case"fill":return new Il(t);case"fill-extrusion":return new Wl(t);case"heatmap":return new Ma(t);case"hillshade":return new Ta(t);case"line":return new fu(t);case"raster":return new kc(t);case"symbol":return new gc(t)}}class Mc{constructor(t){this.keyCache={},t&&this.replace(t)}replace(t){this._layerConfigs={},this._layers={},this.update(t,[])}update(t,e){for(const e of t){this._layerConfigs[e.id]=e;const t=this._layers[e.id]=Ic(e);t._featureFilter=fn(t.filter),this.keyCache[e.id]&&delete this.keyCache[e.id]}for(const t of e)delete this.keyCache[t],delete this._layerConfigs[t],delete this._layers[t];this.familiesBySource={};const r=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||_n(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n])}const n=[];for(const t in r)n.push(r[t]);return n}(Object.values(this._layerConfigs),this.keyCache);for(const t of r){const e=t.map((t=>this._layers[t.id])),r=e[0];if("none"===r.visibility)continue;const n=r.source||"";let i=this.familiesBySource[n];i||(i=this.familiesBySource[n]={});const s=r.sourceLayer||"_geojsonTileLayer";let o=i[s];o||(o=i[s]=[]),o.push(e)}}}class zc{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class Pc{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class Tc{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new Tc;return e.extend(t(new a(this.minX,this.minY))),e.extend(t(new a(this.maxX,this.minY))),e.extend(t(new a(this.minX,this.maxY))),e.extend(t(new a(this.maxX,this.maxY))),e}static fromPoints(t){const e=new Tc;for(const r of t)e.extend(r);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class Cc{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new P(y,16,0),this.grid3D=new P(y,16,0),this.featureIndexArray=new Qs,this.promoteId=e}insert(t,e,r,n,i,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const a=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y)}n[0]<y&&n[1]<y&&n[2]>=0&&n[3]>=0&&a.insert(o,n[0],n[1],n[2],n[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Nl.VectorTile(new Pu(this.rawTileData)).layers,this.sourceLayerCoder=new zc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params,s=y/t.tileSize/t.scale,o=fn(i.filter),l=t.queryGeometry,u=t.queryPadding*s,c=Tc.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=Tc.fromPoints(t.cameraQueryGeometry).expandBy(u),f=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((e,r,n,i)=>function(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return!0;const s=[new a(e,r),new a(e,i),new a(n,i),new a(n,r)];if(t.length>2)for(const e of s)if(la(t,e))return!0;for(let e=0;e<t.length-1;e++)if(ua(t[e],t[e+1],s))return!0;return!1}(t.cameraQueryGeometry,e-u,r-u,n+u,i+u)));for(const t of f)h.push(t);h.sort(Ec);const d={};let m;for(let a=0;a<h.length;a++){const u=h[a];if(u===m)continue;m=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,i.layers,i.availableImages,e,r,n,((e,r,n)=>(p||(p=Yo(e)),r.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:s,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return d}loadMatchingFeature(t,e,r,n,i,s,o,a,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=Ho(f,!0);if(!i.filter(new Wi(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Wi(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=a[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=g({},l[r]);y.paint=Bc(y.paint,i.paint,f,p,o),y.layout=Bc(y.layout,i.layout,f,p,o);const m=!c||c(f,i,p);if(!m)continue;const x=new Pc(f,this.z,this.x,this.y,d);x.layer=y;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:n,feature:x,intersectionZ:m})}}lookupSymbolFeatures(t,e,r,n,i,s,o,a){const l={};this.loadVTLayers();const u=fn(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,o,a,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return!0;return!1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function Bc(t,e,r,n,i){return x(t,((t,s)=>{const o=e instanceof ss?e.get(s):null;return o&&o.evaluate?o.evaluate(r,n,i):o}))}function Ec(t,e){return e-t}ci("FeatureIndex",Cc,{omit:["rawTileData","sourceLayerCoder"]});class Vc extends a{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n)}clone(){return new Vc(this.x,this.y,this.angle,this.segment)}}function Fc(t,e,r,n,i){if(void 0===e.segment||0===r)return!0;let s=e,o=e.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return!1;a-=t[o].dist(s),s=t[o]}a+=t[o].dist(t[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const e=t[o],r=t[o+1];if(!r)return!1;let s=t[o-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return!1;o++,a+=e.dist(r)}return!0}function Dc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Lc(t,e,r){return t?.6*e*r:0}function $c(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function Oc(t,e,r,n,i,s){const o=Lc(r,i,s),a=$c(r,n)*s;let l=0;const u=Dc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=me.number(n.x,i.x,c),p=me.number(n.y,i.y,c),f=new Vc(h,p,i.angleTo(n),r);return f._round(),!o||Fc(t,f,a,o,e)?f:void 0}l+=s}}function Rc(t,e,r,n,i,s,o,a,l){const u=Lc(n,s,o),c=$c(n,i),h=c*o,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),Nc(t,p?e/2*a%e:(c/2+2*s)*o*a%e,e,u,r,h,p,!1,l)}function Nc(t,e,r,n,i,s,o,a,l){const u=s/2,c=Dc(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const o=t[e],a=t[e+1],d=o.dist(a),y=a.angleTo(o);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=me.number(o.x,a.x,m),x=me.number(o.y,a.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Vc(g,x,y,e);r._round(),n&&!Fc(t,r,s,n,i)||f.push(r)}}h+=d}return a||f.length||o||(f=Nc(t,h/2,r,n,i,s,o,!0,l)),f}function jc(t,e,r,n){const i=[],s=t.image,o=s.pixelRatio,l=s.paddedRect.w-2,u=s.paddedRect.h-2;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=s.stretchX||[[0,l]],p=s.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,k=0,A=g;if(s.content&&n){const e=s.content,r=e[2]-e[0],n=e[3]-e[1];(s.textFitWidth||s.textFitHeight)&&(c=Qu(t)),x=Uc(h,0,e[0]),b=Uc(p,0,e[1]),v=Uc(h,e[0],e[2]),w=Uc(p,e[1],e[3]),_=e[0]-x,k=e[1]-b,S=r-v,A=n-w}const I=c.x1,M=c.y1,z=c.x2-I,P=c.y2-M,T=(t,n,i,l)=>{const u=Gc(t.stretch-x,v,z,I),c=Xc(t.fixed-_,S,t.stretch,d),h=Gc(n.stretch-b,w,P,M),p=Xc(n.fixed-k,A,n.stretch,y),f=Gc(i.stretch-x,v,z,I),m=Xc(i.fixed-_,S,i.stretch,d),g=Gc(l.stretch-b,w,P,M),T=Xc(l.fixed-k,A,l.stretch,y),C=new a(u,h),B=new a(f,h),E=new a(f,g),V=new a(u,g),F=new a(c/o,p/o),D=new a(m/o,T/o),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];C._matMult(r),B._matMult(r),V._matMult(r),E._matMult(r)}const $=t.stretch+t.fixed,O=n.stretch+n.fixed;return{tl:C,tr:B,bl:V,br:E,tex:{x:s.paddedRect.x+1+$,y:s.paddedRect.y+1+O,w:i.stretch+i.fixed-$,h:l.stretch+l.fixed-O},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:D,minFontScaleX:S/o/z,minFontScaleY:A/o/P,isSDF:r}};if(n&&(s.stretchX||s.stretchY)){const t=qc(h,m,d),e=qc(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(T(n,e[t],s,e[t+1]))}}else i.push(T({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return i}function Uc(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function qc(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)})}return n.push({fixed:e+1,stretch:r}),n}function Gc(t,e,r,n){return t/e*r+n}function Xc(t,e,r,n){return t-e*r/n}ci("Anchor",Vc);class Zc{constructor(t,e,r,n,i,s,o,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=s.top,e=s.bottom;const r=s.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n)}else{const u=(null===(h=s.image)||void 0===h?void 0:h.content)&&(s.image.textFitWidth||s.image.textFitHeight)?Qu(s):{x1:s.left,y1:s.top,x2:s.right,y2:s.bottom};u.y1=u.y1*o-l[0],u.y2=u.y2*o+l[2],u.x1=u.x1*o-l[3],u.x2=u.x2*o+l[1];const p=s.collisionPadding;if(p&&(u.x1-=p[0]*o,u.y1-=p[1]*o,u.x2+=p[2]*o,u.y2+=p[3]*o),c){const t=new a(u.x1,u.y1),e=new a(u.x2,u.y1),r=new a(u.x1,u.y2),n=new a(u.x2,u.y2),i=c*Math.PI/180;t._rotate(i),e._rotate(i),r._rotate(i),n._rotate(i),u.x1=Math.min(t.x,e.x,r.x,n.x),u.x2=Math.max(t.x,e.x,r.x,n.x),u.y1=Math.min(t.y,e.y,r.y,n.y),u.y2=Math.max(t.y,e.y,r.y,n.y)}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,r,n,i)}this.boxEndIndex=t.length}}class Yc{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i}e[t]=n}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n}e[t]=i}}function Hc(t,e=1,r=!1){const n=Tc.fromPoints(t[0]),i=Math.min(n.width(),n.height());let s=i/2;const o=new Yc([],Jc),{minX:l,minY:u,maxX:c,maxY:h}=n;if(0===i)return new a(l,u);for(let e=l;e<c;e+=i)for(let r=u;r<h;r+=i)o.push(new Wc(e+s,r+s,s,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,o=s-1;t<s;o=t++){const s=i[t],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,e+=3*l}return new Wc(r/e,n/e,0,t)}(t),f=o.length;for(;o.length;){const n=o.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,f)),n.max-p.d<=e||(s=n.h/2,o.push(new Wc(n.p.x-s,n.p.y-s,s,t)),o.push(new Wc(n.p.x+s,n.p.y-s,s,t)),o.push(new Wc(n.p.x-s,n.p.y+s,s,t)),o.push(new Wc(n.p.x+s,n.p.y+s,s,t)),f+=4)}return r&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Jc(t,e){return e.max-t.max}function Wc(t,e,r,n){this.p=new a(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,o=i-1;e<i;o=e++){const i=s[e],a=s[o];i.y>t.y!=a.y>t.y&&t.x<(a.x-i.x)*(t.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,oa(t,i,a))}}return(r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2}!function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(_c||(_c={}));const Kc=Number.POSITIVE_INFINITY;function Qc(t,e){return e[1]!==Kc?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e}return[n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e}return[r,n]}(t,e[0])}function th(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*ku));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),e[r+1]=i}return new $t(e)}const o=i.get("text-variable-anchor");if(o){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*ku,Kc]:i.get("text-offset").evaluate(e,{},r).map((t=>t*ku));const s=[];for(const t of o)s.push(t,Qc(t,n));return new $t(s)}return null}function eh(t){t.bucket.createArrays(),t.bucket.tilePixelRatio=y/(512*t.bucket.overscaling),t.bucket.compareText={},t.bucket.iconsNeedLinear=!1;const e=t.bucket.layers[0],r=e.layout,n=e._unevaluatedLayout._values,i={layoutIconSize:n["icon-size"].possiblyEvaluate(new Wi(t.bucket.zoom+1),t.canonical),layoutTextSize:n["text-size"].possiblyEvaluate(new Wi(t.bucket.zoom+1),t.canonical),textMaxSize:n["text-size"].possiblyEvaluate(new Wi(18))};if("composite"===t.bucket.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.textSizeData;i.compositeTextSizes=[n["text-size"].possiblyEvaluate(new Wi(e),t.canonical),n["text-size"].possiblyEvaluate(new Wi(r),t.canonical)]}if("composite"===t.bucket.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.iconSizeData;i.compositeIconSizes=[n["icon-size"].possiblyEvaluate(new Wi(e),t.canonical),n["icon-size"].possiblyEvaluate(new Wi(r),t.canonical)]}const s=r.get("text-line-height")*ku,o="viewport"!==r.get("text-rotation-alignment")&&"point"!==r.get("symbol-placement"),a=r.get("text-keep-upright"),l=r.get("text-size");for(const n of t.bucket.features){const u=r.get("text-font").evaluate(n,{},t.canonical).join(","),c=l.evaluate(n,{},t.canonical),h=i.layoutTextSize.evaluate(n,{},t.canonical),p=i.layoutIconSize.evaluate(n,{},t.canonical),f={horizontal:{},vertical:void 0},d=n.text;let y,m=[0,0];if(d){const i=d.toString(),l=r.get("text-letter-spacing").evaluate(n,{},t.canonical)*ku,p=Oi(i)?l:0,y=r.get("text-anchor").evaluate(n,{},t.canonical),g=th(e,n,t.canonical);if(!g){const e=r.get("text-radial-offset").evaluate(n,{},t.canonical);m=e?Qc(y,[e*ku,Kc]):r.get("text-offset").evaluate(n,{},t.canonical).map((t=>t*ku))}let x=o?"center":r.get("text-justify").evaluate(n,{},t.canonical);const v="point"===r.get("symbol-placement")?r.get("text-max-width").evaluate(n,{},t.canonical)*ku:1/0,b=()=>{t.bucket.allowVerticalPlacement&&$i(i)&&(f.vertical=Fu(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,"left",p,m,zu.vertical,!0,h,c))};if(!o&&g){const e=new Set;if("auto"===x)for(let t=0;t<g.values.length;t+=2)e.add(rh(g.values[t]));else e.add(x);let r=!1;for(const n of e)if(!f.horizontal[n])if(r)f.horizontal[n]=f.horizontal[0];else{const e=Fu(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,"center",n,p,m,zu.horizontal,!1,h,c);e&&(f.horizontal[n]=e,r=1===e.positionedLines.length)}b()}else{"auto"===x&&(x=rh(y));const e=Fu(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,x,p,m,zu.horizontal,!1,h,c);e&&(f.horizontal[x]=e),b(),$i(i)&&o&&a&&(f.vertical=Fu(d,t.glyphMap,t.glyphPositions,t.imagePositions,u,v,s,y,x,p,m,zu.vertical,!1,h,c))}}let g=!1;if(n.icon&&n.icon.name){const e=t.imageMap[n.icon.name];e&&(y=Ku(t.imagePositions[n.icon.name],r.get("icon-offset").evaluate(n,{},t.canonical),r.get("icon-anchor").evaluate(n,{},t.canonical)),g=!!e.sdf,void 0===t.bucket.sdfIcons?t.bucket.sdfIcons=g:t.bucket.sdfIcons!==g&&w("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.bucket.pixelRatio||0!==r.get("icon-rotate").constantOr(1))&&(t.bucket.iconsNeedLinear=!0))}const x=sh(f.horizontal)||f.vertical;t.bucket.iconsInText=!!x&&x.iconsInText,(x||y)&&nh(t.bucket,n,f,y,t.imageMap,i,h,p,m,g,t.canonical,t.subdivisionGranularity)}t.showCollisionBoxes&&t.bucket.generateCollisionDebugBuffers()}function rh(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}function nh(t,e,r,n,i,s,o,l,u,c,h,p){let f=s.textMaxSize.evaluate(e,{});void 0===f&&(f=o);const d=t.layers[0].layout,m=d.get("icon-offset").evaluate(e,{},h),g=sh(r.horizontal),x=o/24,v=t.tilePixelRatio*x,b=t.tilePixelRatio*f/24,_=t.tilePixelRatio*l,S=t.tilePixelRatio*d.get("symbol-spacing"),k=d.get("text-padding")*t.tilePixelRatio,A=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return[s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(d,e,h,t.tilePixelRatio),I=d.get("text-max-angle")/180*Math.PI,M="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),z="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),P=d.get("symbol-placement"),T=S/2,C=d.get("icon-text-fit");let B;n&&"none"!==C&&(t.allowVerticalPlacement&&r.vertical&&(B=tc(n,r.vertical,C,d.get("icon-text-fit-padding"),m,x)),g&&(n=tc(n,g,C,d.get("icon-text-fit-padding"),m,x)));const E=h?p.line.getGranularityForZoomLevel(h.z):1,V=(a,l)=>{l.x<0||l.x>=y||l.y<0||l.y>=y||function(t,e,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,_,S,k,A){const I=t.addToLineVertexArray(e,r);let M,z,P,T,C=0,B=0,E=0,V=0,F=-1,D=-1;const L={};let $=Mo("");if(t.allowVerticalPlacement&&n.vertical){const t=a.layout.get("text-rotate").evaluate(b,{},k)+90;P=new Zc(l,e,u,c,h,n.vertical,p,f,d,t),o&&(T=new Zc(l,e,u,c,h,o,m,g,d,t))}if(i){const r=a.layout.get("icon-rotate").evaluate(b,{}),n="none"!==a.layout.get("icon-text-fit"),s=jc(i,r,S,n),p=o?jc(o,r,S,n):void 0;z=new Zc(l,e,u,c,h,i,m,g,!1,r),C=4*s.length;const f=t.iconSizeData;let d=null;"source"===f.kind?(d=[ec*a.layout.get("icon-size").evaluate(b,{})],d[0]>rc&&w(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===f.kind&&(d=[ec*_.compositeIconSizes[0].evaluate(b,{},k),ec*_.compositeIconSizes[1].evaluate(b,{},k)],(d[0]>rc||d[1]>rc)&&w(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,d,v,x,b,zu.none,e,I.lineStartIndex,I.lineLength,-1,k),F=t.icon.placedSymbolArray.length-1,p&&(B=4*p.length,t.addSymbols(t.icon,p,d,v,x,b,zu.vertical,e,I.lineStartIndex,I.lineLength,-1,k),D=t.icon.placedSymbolArray.length-1)}const O=Object.keys(n.horizontal);for(const r of O){const i=n.horizontal[r];if(!M){$=Mo(i.text);const t=a.layout.get("text-rotate").evaluate(b,{},k);M=new Zc(l,e,u,c,h,i,p,f,d,t)}const o=1===i.positionedLines.length;if(E+=ih(t,e,i,s,a,d,b,y,I,n.vertical?zu.horizontal:zu.horizontalOnly,o?O:[r],L,F,_,k),o)break}n.vertical&&(V+=ih(t,e,n.vertical,s,a,d,b,y,I,zu.vertical,["vertical"],L,D,_,k));const R=M?M.boxStartIndex:t.collisionBoxArray.length,N=M?M.boxEndIndex:t.collisionBoxArray.length,j=P?P.boxStartIndex:t.collisionBoxArray.length,U=P?P.boxEndIndex:t.collisionBoxArray.length,q=z?z.boxStartIndex:t.collisionBoxArray.length,G=z?z.boxEndIndex:t.collisionBoxArray.length,X=T?T.boxStartIndex:t.collisionBoxArray.length,Z=T?T.boxEndIndex:t.collisionBoxArray.length;let Y=-1;const H=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;Y=H(M,Y),Y=H(P,Y),Y=H(z,Y),Y=H(T,Y);const J=Y>-1?1:0;J&&(Y*=A/ku),t.glyphOffsetArray.length>=pc.MAX_GLYPHS&&w("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey);const W=th(a,b,k),[K,Q]=function(t,e){const r=t.length,n=null==e?void 0:e.values;if((null==n?void 0:n.length)>0)for(let e=0;e<n.length;e+=2){const r=n[e+1];t.emplaceBack(_c[n[e]],r[0],r[1])}return[r,t.length]}(t.textAnchorOffsets,W);t.symbolInstances.emplaceBack(e.x,e.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,F,D,$,R,N,j,U,q,G,X,Z,u,E,V,C,B,J,0,p,Y,K,Q)}(t,l,a,r,n,i,B,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,v,[k,k,k,k],M,u,_,A,z,m,e,s,c,h,o)};if("line"===P)for(const i of function(t,e,r,n,i){const s=[];for(let e=0;e<t.length;e++){const r=t[e];let o;for(let t=0;t<r.length-1;t++){let e=r[t],l=r[t+1];e.x<0&&l.x<0||(e.x<0?e=new a(0,e.y+(0-e.x)/(l.x-e.x)*(l.y-e.y))._round():l.x<0&&(l=new a(0,e.y+(0-e.x)/(l.x-e.x)*(l.y-e.y))._round()),e.y<0&&l.y<0||(e.y<0?e=new a(e.x+(0-e.y)/(l.y-e.y)*(l.x-e.x),0)._round():l.y<0&&(l=new a(e.x+(0-e.y)/(l.y-e.y)*(l.x-e.x),0)._round()),e.x>=n&&l.x>=n||(e.x>=n?e=new a(n,e.y+(n-e.x)/(l.x-e.x)*(l.y-e.y))._round():l.x>=n&&(l=new a(n,e.y+(n-e.x)/(l.x-e.x)*(l.y-e.y))._round()),e.y>=i&&l.y>=i||(e.y>=i?e=new a(e.x+(i-e.y)/(l.y-e.y)*(l.x-e.x),i)._round():l.y>=i&&(l=new a(e.x+(i-e.y)/(l.y-e.y)*(l.x-e.x),i)._round()),o&&e.equals(o[o.length-1])||(o=[e],s.push(o)),o.push(l)))))}}return s}(e.geometry,0,0,y,y)){const e=xl(i,E),s=Rc(e,S,I,r.vertical||g,n,24,b,t.overscaling,y);for(const r of s)g&&oh(t,g.text,T,r)||V(e,r)}else if("line-center"===P){for(const t of e.geometry)if(t.length>1){const e=xl(t,E),i=Oc(e,I,r.vertical||g,n,24,b);i&&V(e,i)}}else if("Polygon"===e.type)for(const t of er(e.geometry,0)){const e=Hc(t,16);V(xl(t[0],E,!0),new Vc(e.x,e.y,0))}else if("LineString"===e.type)for(const t of e.geometry){const e=xl(t,E);V(e,new Vc(e[0].x,e[0].y,0))}else if("Point"===e.type)for(const t of e.geometry)for(const e of t)V([e],new Vc(e.x,e.y,0))}function ih(t,e,r,n,i,s,o,l,u,c,h,p,f,d,y){const m=function(t,e,r,n,i,s,o,l){const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const s=n.rect||{};let h=4,p=!0,f=1,d=0;const y=(i||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(n.imageName?-(ku-n.metrics.width*n.scale)/2:(n.scale-1)*ku)),n.imageName){const t=o[n.imageName];p=t.sdf,f=t.pixelRatio,h=1/f}const g=i?[n.x+m,n.y]:[0,0];let x=i?[0,0]:[n.x+m+r[0],n.y+r[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=n.metrics.isDoubleResolution?2:1,w=(n.metrics.left-h)*n.scale-m+x[0],_=(-n.metrics.top-h)*n.scale+x[1],S=w+s.w/b*n.scale/f,k=_+s.h/b*n.scale/f,A=new a(w,_),I=new a(S,_),M=new a(w,k),z=new a(S,k);if(y){const t=new a(-m,m- -17),e=-Math.PI/2,r=12-m,i=new a(22-r,-(n.imageName?r:0)),s=new a(...v);A._rotateAround(e,t)._add(i)._add(s),I._rotateAround(e,t)._add(i)._add(s),M._rotateAround(e,t)._add(i)._add(s),z._rotateAround(e,t)._add(i)._add(s)}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];A._matMult(r),I._matMult(r),M._matMult(r),z._matMult(r)}const P=new a(0,0),T=new a(0,0);c.push({tl:A,tr:I,bl:M,br:z,tex:s,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:T,minFontScaleX:0,minFontScaleY:0})}return c}(0,r,l,i,s,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[ec*i.layout.get("text-size").evaluate(o,{})],x[0]>rc&&w(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[ec*d.compositeTextSizes[0].evaluate(o,{},y),ec*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>rc||x[1]>rc)&&w(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,s,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function sh(t){for(const e in t)return t[e];return null}function oh(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return!0}else i[e]=[];return i[e].push(n),!1}class ah{constructor(t){const e={},r=[];for(const n in t){const i=t[n],s=e[n]={};for(const t in i){const e=i[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n={x:0,y:0,w:e.bitmap.width+2,h:e.bitmap.height+2};r.push(n),s[t]={rect:n,metrics:e.metrics}}}const{w:n,h:i}=Tu(r),s=new ka({width:n||1,height:i||1});for(const r in t){const n=t[r];for(const t in n){const i=n[+t];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const o=e[r][t].rect;ka.copy(i.bitmap,s,{x:0,y:0},{x:o.x+1,y:o.y+1},i.bitmap)}}this.image=s,this.positions=e}}function lh(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return[t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}ci("GlyphAtlas",ah);const uh=6371008.8;class ch{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new ch(function(t,e){const r=((t-e)%360+360)%360+e;return r===e?180:r}(this.lng,-180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return uh*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof ch)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new ch(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new ch(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const hh=2*Math.PI*uh;function ph(t){return hh*Math.cos(t*Math.PI/180)}function fh(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class dh{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r}static fromLngLat(t,e=0){const r=ch.convert(t);return new dh((180+r.lng)/360,(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+r.lat*Math.PI/360)))/360,function(t,e){return t/ph(e)}(e,r.lat))}toLngLat(){return new ch(360*this.x-180,fh(this.y))}toAltitude(){return this.z*ph(fh(this.y))}meterInMercatorCoordinateUnits(){return 1/hh*(t=fh(this.y),1/Math.cos(t*Math.PI/180));var t}}class yh{constructor(t,e,r){if(!function(t,e,r){return!(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=xh(0,t,t,e,r)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(s=this.y,o=this.z,a=lh(256*(i=this.x),256*(s=Math.pow(2,o)-s-1),o),l=lh(256*(i+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var i,s,o,a,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new a((t.x*e-this.x)*y,(t.y*e-this.y)*y)}toString(){return`${this.z}/${this.x}/${this.y}`}}class mh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=xh(t,e.z,e.z,e.x,e.y)}}class gh{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new yh(r,+n,+i),this.key=xh(e,t,r,n,i)}clone(){return new gh(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new gh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new gh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?xh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):xh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new gh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return[new gh(e,this.wrap,e,r,n),new gh(e,this.wrap,e,r+1,n),new gh(e,this.wrap,e,r,n+1),new gh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new gh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new gh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new mh(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new dh(t.x-this.wrap,t.y))}}function xh(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return(s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}ci("CanonicalTileID",yh),ci("OverscaledTileID",gh,{omit:["terrainRttPosMatrix32f"]});class vh{constructor(t){this.tileID=new gh(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[],this.globalState=t.globalState}parse(e,r,n,i,s){return t(this,void 0,void 0,(function*(){this.status="parsing",this.data=e,this.collisionBoxArray=new Us;const t=new zc(Object.keys(e.layers).sort()),o=new Cc(this.tileID,this.promoteId);o.bucketLayerIDs=[];const a={},l={featureIndex:o,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:n,subdivisionGranularity:s},u=r.familiesBySource[this.source];for(const r in u){const i=e.layers[r];if(!i)continue;1===i.version&&w(`Vector tile source "${this.source}" layer "${r}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const s=t.encode(r),c=[];for(let t=0;t<i.length;t++){const e=i.feature(t),n=o.getId(e,r);c.push({feature:e,id:n,index:t,sourceLayerIndex:s})}for(const t of u[r]){const e=t[0];e.source!==this.source&&w(`layer.source = ${e.source} does not equal this.source = ${this.source}`),e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(bh(t,this.zoom,n),(a[e.id]=e.createBucket({index:o.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:s,sourceID:this.source,globalState:this.globalState})).populate(c,l,this.tileID.canonical),o.bucketLayerIDs.push(t.map((t=>t.id))))}}const c=x(l.glyphDependencies,(t=>Object.keys(t).map(Number)));this.inFlightDependencies.forEach((t=>null==t?void 0:t.abort())),this.inFlightDependencies=[];let h=Promise.resolve({});if(Object.keys(c).length){const t=new AbortController;this.inFlightDependencies.push(t),h=i.sendAsync({type:"GG",data:{stacks:c,source:this.source,tileID:this.tileID,type:"glyphs"}},t)}const p=Object.keys(l.iconDependencies);let f=Promise.resolve({});if(p.length){const t=new AbortController;this.inFlightDependencies.push(t),f=i.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},t)}const d=Object.keys(l.patternDependencies);let y=Promise.resolve({});if(d.length){const t=new AbortController;this.inFlightDependencies.push(t),y=i.sendAsync({type:"GI",data:{icons:d,source:this.source,tileID:this.tileID,type:"patterns"}},t)}const[m,g,v]=yield Promise.all([h,f,y]),b=new ah(m),_=new Bu(g,v);for(const t in a){const e=a[t];e instanceof pc?(bh(e.layers,this.zoom,n),eh({bucket:e,glyphMap:m,glyphPositions:b.positions,imageMap:g,imagePositions:_.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:l.subdivisionGranularity})):e.hasPattern&&(e instanceof au||e instanceof _l||e instanceof Gl)&&(bh(e.layers,this.zoom,n),e.addFeatures(l,this.tileID.canonical,_.patternPositions))}return this.status="done",{buckets:Object.values(a).filter((t=>!t.isEmpty())),featureIndex:o,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:b.image,imageAtlas:_,glyphMap:this.returnDependencies?m:null,iconMap:this.returnDependencies?g:null,glyphPositions:this.returnDependencies?b.positions:null}}))}}function bh(t,e,r){const n=new Wi(e);for(const e of t)e.recalculate(n,r)}var wh,_h,Sh;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(wh||(wh={}));class kh{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start)}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}}class Ah{constructor(t,e,r){this.actor=t,this.layerIndex=e,this.availableImages=r,this.fetching={},this.loading={},this.loaded={}}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=yield((t,e)=>li(g(t,{type:"arrayBuffer"}),e))(e.request,r);try{return{vectorTile:new Nl.VectorTile(new Pu(t.data)),rawData:t.data,cacheControl:t.cacheControl,expires:t.expires}}catch(r){const n=new Uint8Array(t.data);let i=`Unable to parse the tile at ${e.request.url}, `;throw i+=31===n[0]&&139===n[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${r.message}`,new Error(i)}}))}loadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid,r=!!(e&&e.request&&e.request.collectResourceTiming)&&new kh(e.request),n=new vh(e);this.loading[t]=n;const i=new AbortController;n.abort=i;try{const s=yield this.loadVectorTile(e,i);if(delete this.loading[t],!s)return null;const o=s.rawData,a={};s.expires&&(a.expires=s.expires),s.cacheControl&&(a.cacheControl=s.cacheControl);const l={};if(r){const t=r.finish();t&&(l.resourceTiming=JSON.parse(JSON.stringify(t)))}n.vectorTile=s.vectorTile;const u=n.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);this.loaded[t]=n,this.fetching[t]={rawTileData:o,cacheControl:a,resourceTiming:l};try{const t=yield u;return g({rawTileData:o.slice(0)},t,a,l)}finally{delete this.fetching[t]}}catch(e){throw delete this.loading[t],n.status="done",this.loaded[t]=n,e}}))}reloadTile(e){return t(this,void 0,void 0,(function*(){const t=e.uid;if(!this.loaded||!this.loaded[t])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const r=this.loaded[t];if(r.showCollisionBoxes=e.showCollisionBoxes,r.globalState=e.globalState,"parsing"===r.status){const n=yield r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity);let i;if(this.fetching[t]){const{rawTileData:e,cacheControl:r,resourceTiming:s}=this.fetching[t];delete this.fetching[t],i=g({rawTileData:e.slice(0)},n,r,s)}else i=n;return i}if("done"===r.status&&r.vectorTile)return r.parse(r.vectorTile,this.layerIndex,this.availableImages,this.actor,e.subdivisionGranularity)}))}abortTile(e){return t(this,void 0,void 0,(function*(){const t=this.loading,r=e.uid;t&&t[r]&&t[r].abort&&(t[r].abort.abort(),delete t[r])}))}removeTile(e){return t(this,void 0,void 0,(function*(){this.loaded&&this.loaded[e.uid]&&delete this.loaded[e.uid]}))}}class Ih{constructor(){this.loaded={}}loadTile(e){return t(this,void 0,void 0,(function*(){const{uid:r,encoding:n,rawImageData:i,redFactor:s,greenFactor:o,blueFactor:a,baseShift:l}=e,u=i.width+2,p=i.height+2,f=k(i)?new Aa({width:u,height:p},yield function(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if(function(){if(null==h&&(h=!1,null==c&&(c="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),c)){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1)}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){h=!0;break}}}return h||!1}())try{return yield function(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const t=new VideoFrame(e,{timestamp:0});try{const o=null==t?void 0:t.format;if(!o||!o.startsWith("BGR")&&!o.startsWith("RGB"))throw new Error(`Unrecognized format ${o}`);const a=o.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield t.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),o=(Math.max(0,r)-r)*n*4+s,a=4*n,l=Math.max(0,e),u=Math.max(0,r);return{rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:o,stride:a}]}}(e,r,n,i,s)),a)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e}return l}finally{t.close()}}))}(e,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,o=t.height;A&&I||(A=new OffscreenCanvas(s,o),I=A.getContext("2d",{willReadFrequently:!0})),A.width=s,A.height=o,I.drawImage(t,0,0,s,o);const a=I.getImageData(e,r,n,i);return I.clearRect(0,0,s,o),a.data}(e,r,n,i,s)}))}(i,-1,-1,u,p)):i,d=new Va(r,f,n,s,o,a,l);return this.loaded=this.loaded||{},this.loaded[r]=d,d}))}removeTile(t){const e=this.loaded,r=t.uid;e&&e[r]&&delete e[r]}}var Mh=function(){if(Sh)return _h;function t(t,r){if(0!==t.length){e(t[0],r);for(var n=1;n<t.length;n++)e(t[n],!r)}}function e(t,e){for(var r=0,n=0,i=0,s=t.length,o=s-1;i<s;o=i++){var a=(t[i][0]-t[o][0])*(t[o][1]+t[i][1]),l=r+a;n+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l}r+n>=0!=!!e&&t.reverse()}return Sh=1,_h=function e(r,n){var i,s=r&&r.type;if("FeatureCollection"===s)for(i=0;i<r.features.length;i++)e(r.features[i],n);else if("GeometryCollection"===s)for(i=0;i<r.geometries.length;i++)e(r.geometries[i],n);else if("Feature"===s)e(r.geometry,n);else if("Polygon"===s)t(r.coordinates,n);else if("MultiPolygon"===s)for(i=0;i<r.coordinates.length;i++)t(r.coordinates[i],n);return r}}(),zh=e(Mh);const Ph=Nl.VectorTileFeature.prototype.toGeoJSON;class Th{constructor(t){this._feature=t,this.extent=y,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10))}loadGeometry(){if(1===this._feature.type){const t=[];for(const e of this._feature.geometry)t.push([new a(e[0],e[1])]);return t}{const t=[];for(const e of this._feature.geometry){const r=[];for(const t of e)r.push(new a(t[0],t[1]));t.push(r)}return t}}toGeoJSON(t,e,r){return Ph.call(this,t,e,r)}}class Ch{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=y,this.length=t.length,this._features=t}feature(t){return new Th(this._features[t])}}var Bh,Eh,Vh,Fh={exports:{}},Dh=function(){if(Vh)return Fh.exports;Vh=1;var t=Mu(),e=function(){if(Eh)return Bh;Eh=1;var t=i(),e=Rl().VectorTileFeature;function r(t,e){this.options=e||{},this.features=t,this.length=t.length}function n(t,e){this.id="number"==typeof t.id?t.id:void 0,this.type=t.type,this.rawGeometry=1===t.type?[t.geometry]:t.geometry,this.properties=t.tags,this.extent=e||4096}return Bh=r,r.prototype.feature=function(t){return new n(this.features[t],this.options.extent)},n.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var r=0;r<e.length;r++){for(var n=e[r],i=[],s=0;s<n.length;s++)i.push(new t(n[s][0],n[s][1]));this.geometry.push(i)}return this.geometry},n.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var t=this.geometry,e=1/0,r=-1/0,n=1/0,i=-1/0,s=0;s<t.length;s++)for(var o=t[s],a=0;a<o.length;a++){var l=o[a];e=Math.min(e,l.x),r=Math.max(r,l.x),n=Math.min(n,l.y),i=Math.max(i,l.y)}return[e,n,r,i]},n.prototype.toGeoJSON=e.prototype.toGeoJSON,Bh}();function r(e){var r=new t;return function(t,e){for(var r in t.layers)e.writeMessage(3,n,t.layers[r])}(e,r),r.finish()}function n(t,e){var r;e.writeVarintField(15,t.version||1),e.writeStringField(1,t.name||""),e.writeVarintField(5,t.extent||4096);var n={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<t.length;r++)n.feature=t.feature(r),e.writeMessage(2,s,n);var i=n.keys;for(r=0;r<i.length;r++)e.writeStringField(3,i[r]);var o=n.values;for(r=0;r<o.length;r++)e.writeMessage(4,c,o[r])}function s(t,e){var r=t.feature;void 0!==r.id&&e.writeVarintField(1,r.id),e.writeMessage(2,o,t),e.writeVarintField(3,r.type),e.writeMessage(4,u,r)}function o(t,e){var r=t.feature,n=t.keys,i=t.values,s=t.keycache,o=t.valuecache;for(var a in r.properties){var l=r.properties[a],u=s[a];if(null!==l){void 0===u&&(n.push(a),s[a]=u=n.length-1),e.writeVarint(u);var c=typeof l;"string"!==c&&"boolean"!==c&&"number"!==c&&(l=JSON.stringify(l));var h=c+":"+l,p=o[h];void 0===p&&(i.push(l),o[h]=p=i.length-1),e.writeVarint(p)}}}function a(t,e){return(e<<3)+(7&t)}function l(t){return t<<1^t>>31}function u(t,e){for(var r=t.loadGeometry(),n=t.type,i=0,s=0,o=r.length,u=0;u<o;u++){var c=r[u],h=1;1===n&&(h=c.length),e.writeVarint(a(1,h));for(var p=3===n?c.length-1:c.length,f=0;f<p;f++){1===f&&1!==n&&e.writeVarint(a(2,p-1));var d=c[f].x-i,y=c[f].y-s;e.writeVarint(l(d)),e.writeVarint(l(y)),i+=d,s+=y}3===n&&e.writeVarint(a(7,1))}}function c(t,e){var r=typeof t;"string"===r?e.writeStringField(1,t):"boolean"===r?e.writeBooleanField(7,t):"number"===r&&(t%1!=0?e.writeDoubleField(3,t):t<0?e.writeSVarintField(6,t):e.writeVarintField(5,t))}return Fh.exports=r,Fh.exports.fromVectorTileJs=r,Fh.exports.fromGeojsonVt=function(t,n){n=n||{};var i={};for(var s in t)i[s]=new e(t[s].features,n),i[s].name=s,i[s].version=n.version,i[s].extent=n.extent;return r({layers:i})},Fh.exports.GeoJSONWrapper=e,Fh.exports}(),Lh=e(Dh);const $h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Oh{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=$h[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new Oh(o,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=$h.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Rh(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=t&&a<=r&&u>=e&&u<=n&&l.push(i[o])}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=f:n>=d)&&(a.push(p+1),a.push(c),a.push(1-u))}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)qh(i[2*r],i[2*r+1],t,e)<=l&&a.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];qh(f,d,t,e)<=l&&a.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(o.push(p+1),o.push(c),o.push(1-u))}return a}}function Rh(t,e,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;Nh(t,e,o,n,i,s),Rh(t,e,r,n,o-1,1-s),Rh(t,e,r,o+1,i,1-s)}function Nh(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);Nh(t,e,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s)}const o=e[2*r+s];let a=n,l=i;for(jh(t,e,n,r),e[2*i+s]>o&&jh(t,e,n,i);a<l;){for(jh(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--}e[2*n+s]===o?jh(t,e,n,l):(l++,jh(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1)}}function jh(t,e,r,n){Uh(t,r,n),Uh(e,2*r,2*n),Uh(e,2*r+1,2*n+1)}function Uh(t,e,r){const n=t[e];t[e]=t[r],t[r]=n}function qh(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}const Gh={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:t=>t},Xh=Math.fround||(Zh=new Float32Array(1),t=>(Zh[0]=+t,Zh[0]));var Zh;class Yh{constructor(t){this.options=Object.assign(Object.create(Gh),t),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[]}load(t){const{log:e,minZoom:r,maxZoom:n}=this.options;e&&console.time("total time");const i=`prepare ${t.length} points`;e&&console.time(i),this.points=t;const s=[];for(let e=0;e<t.length;e++){const r=t[e];if(!r.geometry)continue;const[n,i]=r.geometry.coordinates,o=Xh(Wh(n)),a=Xh(Kh(i));s.push(o,a,1/0,e,-1,1),this.options.reduce&&s.push(0)}let o=this.trees[n+1]=this._createTree(s);e&&console.timeEnd(i);for(let t=n;t>=r;t--){const r=+Date.now();o=this.trees[t]=this._createTree(this._cluster(o,t)),e&&console.log("z%d: %d clusters in %dms",t,o.numItems,+Date.now()-r)}return e&&console.timeEnd("total time"),this}getClusters(t,e){let r=((t[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,t[1]));let i=180===t[2]?180:((t[2]+180)%360+360)%360-180;const s=Math.max(-90,Math.min(90,t[3]));if(t[2]-t[0]>=360)r=-180,i=180;else if(r>i){const t=this.getClusters([r,n,180,s],e),o=this.getClusters([-180,n,i,s],e);return t.concat(o)}const o=this.trees[this._limitZoom(e)],a=o.range(Wh(r),Kh(s),Wh(i),Kh(n)),l=o.data,u=[];for(const t of a){const e=this.stride*t;u.push(l[e+5]>1?Hh(l,e,this.clusterProps):this.points[l[e+3]])}return u}getChildren(t){const e=this._getOriginId(t),r=this._getOriginZoom(t),n="No cluster with the specified id.",i=this.trees[r];if(!i)throw new Error(n);const s=i.data;if(e*this.stride>=s.length)throw new Error(n);const o=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=i.within(s[e*this.stride],s[e*this.stride+1],o),l=[];for(const e of a){const r=e*this.stride;s[r+4]===t&&l.push(s[r+5]>1?Hh(s,r,this.clusterProps):this.points[s[r+3]])}if(0===l.length)throw new Error(n);return l}getLeaves(t,e,r){const n=[];return this._appendLeaves(n,t,e=e||10,r=r||0,0),n}getTile(t,e,r){const n=this.trees[this._limitZoom(t)],i=Math.pow(2,t),{extent:s,radius:o}=this.options,a=o/s,l=(r-a)/i,u=(r+1+a)/i,c={features:[]};return this._addTileFeatures(n.range((e-a)/i,l,(e+1+a)/i,u),n.data,e,r,i,c),0===e&&this._addTileFeatures(n.range(1-a/i,l,1,u),n.data,i,r,i,c),e===i-1&&this._addTileFeatures(n.range(0,l,a/i,u),n.data,-1,r,i,c),c.features.length?c:null}getClusterExpansionZoom(t){let e=this._getOriginZoom(t)-1;for(;e<=this.options.maxZoom;){const r=this.getChildren(t);if(e++,1!==r.length)break;t=r[0].properties.cluster_id}return e}_appendLeaves(t,e,r,n,i){const s=this.getChildren(e);for(const e of s){const s=e.properties;if(s&&s.cluster?i+s.point_count<=n?i+=s.point_count:i=this._appendLeaves(t,s.cluster_id,r,n,i):i<n?i++:t.push(e),t.length===r)break}return i}_createTree(t){const e=new Oh(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let r=0;r<t.length;r+=this.stride)e.add(t[r],t[r+1]);return e.finish(),e.data=t,e}_addTileFeatures(t,e,r,n,i,s){for(const o of t){const t=o*this.stride,a=e[t+5]>1;let l,u,c;if(a)l=Jh(e,t,this.clusterProps),u=e[t],c=e[t+1];else{const r=this.points[e[t+3]];l=r.properties;const[n,i]=r.geometry.coordinates;u=Wh(n),c=Kh(i)}const h={type:1,geometry:[[Math.round(this.options.extent*(u*i-r)),Math.round(this.options.extent*(c*i-n))]],tags:l};let p;p=a||this.options.generateId?e[t+3]:this.points[e[t+3]].id,void 0!==p&&(h.id=p),s.features.push(h)}}_limitZoom(t){return Math.max(this.options.minZoom,Math.min(Math.floor(+t),this.options.maxZoom+1))}_cluster(t,e){const{radius:r,extent:n,reduce:i,minPoints:s}=this.options,o=r/(n*Math.pow(2,e)),a=t.data,l=[],u=this.stride;for(let r=0;r<a.length;r+=u){if(a[r+2]<=e)continue;a[r+2]=e;const n=a[r],c=a[r+1],h=t.within(a[r],a[r+1],o),p=a[r+5];let f=p;for(const t of h){const r=t*u;a[r+2]>e&&(f+=a[r+5])}if(f>p&&f>=s){let t,s=n*p,o=c*p,d=-1;const y=(r/u<<5)+(e+1)+this.points.length;for(const n of h){const l=n*u;if(a[l+2]<=e)continue;a[l+2]=e;const c=a[l+5];s+=a[l]*c,o+=a[l+1]*c,a[l+4]=y,i&&(t||(t=this._map(a,r,!0),d=this.clusterProps.length,this.clusterProps.push(t)),i(t,this._map(a,l)))}a[r+4]=y,l.push(s/f,o/f,1/0,y,-1,f),i&&l.push(d)}else{for(let t=0;t<u;t++)l.push(a[r+t]);if(f>1)for(const t of h){const r=t*u;if(!(a[r+2]<=e)){a[r+2]=e;for(let t=0;t<u;t++)l.push(a[r+t])}}}}return l}_getOriginId(t){return t-this.points.length>>5}_getOriginZoom(t){return(t-this.points.length)%32}_map(t,e,r){if(t[e+5]>1){const n=this.clusterProps[t[e+6]];return r?Object.assign({},n):n}const n=this.points[t[e+3]].properties,i=this.options.map(n);return r&&i===n?Object.assign({},i):i}}function Hh(t,e,r){return{type:"Feature",id:t[e+3],properties:Jh(t,e,r),geometry:{type:"Point",coordinates:[(n=t[e],360*(n-.5)),Qh(t[e+1])]}};var n}function Jh(t,e,r){const n=t[e+5],i=n>=1e4?`${Math.round(n/1e3)}k`:n>=1e3?Math.round(n/100)/10+"k":n,s=t[e+6],o=-1===s?{}:Object.assign({},r[s]);return Object.assign(o,{cluster:!0,cluster_id:t[e+3],point_count:n,point_count_abbreviated:i})}function Wh(t){return t/360+.5}function Kh(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function Qh(t){const e=(180-360*t)*Math.PI/180;return 360*Math.atan(Math.exp(e))/Math.PI-90}function tp(t,e,r,n){let i=n;const s=e+(r-e>>1);let o,a=r-e;const l=t[e],u=t[e+1],c=t[r],h=t[r+1];for(let n=e+3;n<r;n+=3){const e=ep(t[n],t[n+1],l,u,c,h);if(e>i)o=n,i=e;else if(e===i){const t=Math.abs(n-s);t<a&&(o=n,a=t)}}i>n&&(o-e>3&&tp(t,e,o,n),t[o+2]=i,r-o>3&&tp(t,o,r,n))}function ep(t,e,r,n,i,s){let o=i-r,a=s-n;if(0!==o||0!==a){const l=((t-r)*o+(e-n)*a)/(o*o+a*a);l>1?(r=i,n=s):l>0&&(r+=o*l,n+=a*l)}return o=t-r,a=e-n,o*o+a*a}function rp(t,e,r,n){const i={id:null==t?null:t,type:e,geometry:r,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===e||"MultiPoint"===e||"LineString"===e)np(i,r);else if("Polygon"===e)np(i,r[0]);else if("MultiLineString"===e)for(const t of r)np(i,t);else if("MultiPolygon"===e)for(const t of r)np(i,t[0]);return i}function np(t,e){for(let r=0;r<e.length;r+=3)t.minX=Math.min(t.minX,e[r]),t.minY=Math.min(t.minY,e[r+1]),t.maxX=Math.max(t.maxX,e[r]),t.maxY=Math.max(t.maxY,e[r+1])}function ip(t,e,r,n){if(!e.geometry)return;const i=e.geometry.coordinates;if(i&&0===i.length)return;const s=e.geometry.type,o=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2);let a=[],l=e.id;if(r.promoteId?l=e.properties[r.promoteId]:r.generateId&&(l=n||0),"Point"===s)sp(i,a);else if("MultiPoint"===s)for(const t of i)sp(t,a);else if("LineString"===s)op(i,a,o,!1);else if("MultiLineString"===s){if(r.lineMetrics){for(const r of i)a=[],op(r,a,o,!1),t.push(rp(l,"LineString",a,e.properties));return}ap(i,a,o,!1)}else if("Polygon"===s)ap(i,a,o,!0);else{if("MultiPolygon"!==s){if("GeometryCollection"===s){for(const i of e.geometry.geometries)ip(t,{id:l,geometry:i,properties:e.properties},r,n);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const t of i){const e=[];ap(t,e,o,!0),a.push(e)}}t.push(rp(l,s,a,e.properties))}function sp(t,e){e.push(lp(t[0]),up(t[1]),0)}function op(t,e,r,n){let i,s,o=0;for(let r=0;r<t.length;r++){const a=lp(t[r][0]),l=up(t[r][1]);e.push(a,l,0),r>0&&(o+=n?(i*l-a*s)/2:Math.sqrt(Math.pow(a-i,2)+Math.pow(l-s,2))),i=a,s=l}const a=e.length-3;e[2]=1,tp(e,0,a,r),e[a+2]=1,e.size=Math.abs(o),e.start=0,e.end=e.size}function ap(t,e,r,n){for(let i=0;i<t.length;i++){const s=[];op(t[i],s,r,n),e.push(s)}}function lp(t){return t/360+.5}function up(t){const e=Math.sin(t*Math.PI/180),r=.5-.25*Math.log((1+e)/(1-e))/Math.PI;return r<0?0:r>1?1:r}function cp(t,e,r,n,i,s,o,a){if(n/=e,s>=(r/=e)&&o<n)return t;if(o<r||s>=n)return null;const l=[];for(const e of t){const t=e.geometry;let s=e.type;const o=0===i?e.minX:e.minY,u=0===i?e.maxX:e.maxY;if(o>=r&&u<n){l.push(e);continue}if(u<r||o>=n)continue;let c=[];if("Point"===s||"MultiPoint"===s)hp(t,c,r,n,i);else if("LineString"===s)pp(t,c,r,n,i,!1,a.lineMetrics);else if("MultiLineString"===s)dp(t,c,r,n,i,!1);else if("Polygon"===s)dp(t,c,r,n,i,!0);else if("MultiPolygon"===s)for(const e of t){const t=[];dp(e,t,r,n,i,!0),t.length&&c.push(t)}if(c.length){if(a.lineMetrics&&"LineString"===s){for(const t of c)l.push(rp(e.id,s,t,e.tags));continue}"LineString"!==s&&"MultiLineString"!==s||(1===c.length?(s="LineString",c=c[0]):s="MultiLineString"),"Point"!==s&&"MultiPoint"!==s||(s=3===c.length?"Point":"MultiPoint"),l.push(rp(e.id,s,c,e.tags))}}return l.length?l:null}function hp(t,e,r,n,i){for(let s=0;s<t.length;s+=3){const o=t[s+i];o>=r&&o<=n&&yp(e,t[s],t[s+1],t[s+2])}}function pp(t,e,r,n,i,s,o){let a=fp(t);const l=0===i?mp:gp;let u,c,h=t.start;for(let p=0;p<t.length-3;p+=3){const f=t[p],d=t[p+1],y=t[p+2],m=t[p+3],g=t[p+4],x=0===i?f:d,v=0===i?m:g;let b=!1;o&&(u=Math.sqrt(Math.pow(f-m,2)+Math.pow(d-g,2))),x<r?v>r&&(c=l(a,f,d,m,g,r),o&&(a.start=h+u*c)):x>n?v<n&&(c=l(a,f,d,m,g,n),o&&(a.start=h+u*c)):yp(a,f,d,y),v<r&&x>=r&&(c=l(a,f,d,m,g,r),b=!0),v>n&&x<=n&&(c=l(a,f,d,m,g,n),b=!0),!s&&b&&(o&&(a.end=h+u*c),e.push(a),a=fp(t)),o&&(h+=u)}let p=t.length-3;const f=t[p],d=t[p+1],y=0===i?f:d;y>=r&&y<=n&&yp(a,f,d,t[p+2]),p=a.length-3,s&&p>=3&&(a[p]!==a[0]||a[p+1]!==a[1])&&yp(a,a[0],a[1],a[2]),a.length&&e.push(a)}function fp(t){const e=[];return e.size=t.size,e.start=t.start,e.end=t.end,e}function dp(t,e,r,n,i,s){for(const o of t)pp(o,e,r,n,i,s,!1)}function yp(t,e,r,n){t.push(e,r,n)}function mp(t,e,r,n,i,s){const o=(s-e)/(n-e);return yp(t,s,r+(i-r)*o,1),o}function gp(t,e,r,n,i,s){const o=(s-r)/(i-r);return yp(t,e+(n-e)*o,s,1),o}function xp(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],s=i.type;let o;if("Point"===s||"MultiPoint"===s||"LineString"===s)o=vp(i.geometry,e);else if("MultiLineString"===s||"Polygon"===s){o=[];for(const t of i.geometry)o.push(vp(t,e))}else if("MultiPolygon"===s){o=[];for(const t of i.geometry){const r=[];for(const n of t)r.push(vp(n,e));o.push(r)}}r.push(rp(i.id,s,o,i.tags))}return r}function vp(t,e){const r=[];r.size=t.size,void 0!==t.start&&(r.start=t.start,r.end=t.end);for(let n=0;n<t.length;n+=3)r.push(t[n]+e,t[n+1],t[n+2]);return r}function bp(t,e){if(t.transformed)return t;const r=1<<t.z,n=t.x,i=t.y;for(const s of t.features){const t=s.geometry,o=s.type;if(s.geometry=[],1===o)for(let o=0;o<t.length;o+=2)s.geometry.push(wp(t[o],t[o+1],e,r,n,i));else for(let o=0;o<t.length;o++){const a=[];for(let s=0;s<t[o].length;s+=2)a.push(wp(t[o][s],t[o][s+1],e,r,n,i));s.geometry.push(a)}}return t.transformed=!0,t}function wp(t,e,r,n,i,s){return[Math.round(r*(t*n-i)),Math.round(r*(e*n-s))]}function _p(t,e,r,n,i){const s=e===i.maxZoom?0:i.tolerance/((1<<e)*i.extent),o={features:[],numPoints:0,numSimplified:0,numFeatures:t.length,source:null,x:r,y:n,z:e,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const e of t)Sp(o,e,s,i);return o}function Sp(t,e,r,n){const i=e.geometry,s=e.type,o=[];if(t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),"Point"===s||"MultiPoint"===s)for(let e=0;e<i.length;e+=3)o.push(i[e],i[e+1]),t.numPoints++,t.numSimplified++;else if("LineString"===s)kp(o,i,t,r,!1,!1);else if("MultiLineString"===s||"Polygon"===s)for(let e=0;e<i.length;e++)kp(o,i[e],t,r,"Polygon"===s,0===e);else if("MultiPolygon"===s)for(let e=0;e<i.length;e++){const n=i[e];for(let e=0;e<n.length;e++)kp(o,n[e],t,r,!0,0===e)}if(o.length){let r=e.tags||null;if("LineString"===s&&n.lineMetrics){r={};for(const t in e.tags)r[t]=e.tags[t];r.mapbox_clip_start=i.start/i.size,r.mapbox_clip_end=i.end/i.size}const a={geometry:o,type:"Polygon"===s||"MultiPolygon"===s?3:"LineString"===s||"MultiLineString"===s?2:1,tags:r};null!==e.id&&(a.id=e.id),t.features.push(a)}}function kp(t,e,r,n,i,s){const o=n*n;if(n>0&&e.size<(i?o:n))return void(r.numPoints+=e.length/3);const a=[];for(let t=0;t<e.length;t+=3)(0===n||e[t+2]>o)&&(r.numSimplified++,a.push(e[t],e[t+1])),r.numPoints++;i&&function(t,e){let r=0;for(let e=0,n=t.length,i=n-2;e<n;i=e,e+=2)r+=(t[e]-t[i])*(t[e+1]+t[i+1]);if(r>0===e)for(let e=0,r=t.length;e<r/2;e+=2){const n=t[e],i=t[e+1];t[e]=t[r-2-e],t[e+1]=t[r-1-e],t[r-2-e]=n,t[r-1-e]=i}}(a,s),t.push(a)}const Ap={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class Ip{constructor(t,e){const r=(e=this.options=function(t,e){for(const r in e)t[r]=e[r];return t}(Object.create(Ap),e)).debug;if(r&&console.time("preprocess data"),e.maxZoom<0||e.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(e.promoteId&&e.generateId)throw new Error("promoteId and generateId cannot be used together.");let n=function(t,e){const r=[];if("FeatureCollection"===t.type)for(let n=0;n<t.features.length;n++)ip(r,t.features[n],e,n);else ip(r,"Feature"===t.type?t:{geometry:t},e);return r}(t,e);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",e.indexMaxZoom,e.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),n=function(t,e){const r=e.buffer/e.extent;let n=t;const i=cp(t,1,-1-r,r,0,-1,2,e),s=cp(t,1,1-r,2+r,0,-1,2,e);return(i||s)&&(n=cp(t,1,-r,1+r,0,-1,2,e)||[],i&&(n=xp(i,1).concat(n)),s&&(n=n.concat(xp(s,-1)))),n}(n,e),n.length&&this.splitTile(n,0,0,0),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)))}splitTile(t,e,r,n,i,s,o){const a=[t,e,r,n],l=this.options,u=l.debug;for(;a.length;){n=a.pop(),r=a.pop(),e=a.pop(),t=a.pop();const c=1<<e,h=Mp(e,r,n);let p=this.tiles[h];if(!p&&(u>1&&console.time("creation"),p=this.tiles[h]=_p(t,e,r,n,l),this.tileCoords.push({z:e,x:r,y:n}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",e,r,n,p.numFeatures,p.numPoints,p.numSimplified),console.timeEnd("creation"));const t=`z${e}`;this.stats[t]=(this.stats[t]||0)+1,this.total++}if(p.source=t,null==i){if(e===l.indexMaxZoom||p.numPoints<=l.indexMaxPoints)continue}else{if(e===l.maxZoom||e===i)continue;if(null!=i){const t=i-e;if(r!==s>>t||n!==o>>t)continue}}if(p.source=null,0===t.length)continue;u>1&&console.time("clipping");const f=.5*l.buffer/l.extent,d=.5-f,y=.5+f,m=1+f;let g=null,x=null,v=null,b=null,w=cp(t,c,r-f,r+y,0,p.minX,p.maxX,l),_=cp(t,c,r+d,r+m,0,p.minX,p.maxX,l);t=null,w&&(g=cp(w,c,n-f,n+y,1,p.minY,p.maxY,l),x=cp(w,c,n+d,n+m,1,p.minY,p.maxY,l),w=null),_&&(v=cp(_,c,n-f,n+y,1,p.minY,p.maxY,l),b=cp(_,c,n+d,n+m,1,p.minY,p.maxY,l),_=null),u>1&&console.timeEnd("clipping"),a.push(g||[],e+1,2*r,2*n),a.push(x||[],e+1,2*r,2*n+1),a.push(v||[],e+1,2*r+1,2*n),a.push(b||[],e+1,2*r+1,2*n+1)}}getTile(t,e,r){t=+t,e=+e,r=+r;const n=this.options,{extent:i,debug:s}=n;if(t<0||t>24)return null;const o=1<<t,a=Mp(t,e=e+o&o-1,r);if(this.tiles[a])return bp(this.tiles[a],i);s>1&&console.log("drilling down to z%d-%d-%d",t,e,r);let l,u=t,c=e,h=r;for(;!l&&u>0;)u--,c>>=1,h>>=1,l=this.tiles[Mp(u,c,h)];return l&&l.source?(s>1&&(console.log("found parent tile z%d-%d-%d",u,c,h),console.time("drilling down")),this.splitTile(l.source,u,c,h,t,e,r),s>1&&console.timeEnd("drilling down"),this.tiles[a]?bp(this.tiles[a],i):null):null}}function Mp(t,e,r){return 32*((1<<t)*r+e)+t}function zp(t,e){return e?t.properties[e]:t.id}function Pp(t,e){if(null==t)return!0;if("Feature"===t.type)return null!=zp(t,e);if("FeatureCollection"===t.type){const r=new Set;for(const n of t.features){const t=zp(n,e);if(null==t)return!1;if(r.has(t))return!1;r.add(t)}return!0}return!1}function Tp(t,e){const r=new Map;if(null==t);else if("Feature"===t.type)r.set(zp(t,e),t);else for(const n of t.features)r.set(zp(n,e),n);return r}class Cp extends Ah{constructor(){super(...arguments),this._dataUpdateable=new Map}loadVectorTile(e,r){return t(this,void 0,void 0,(function*(){const t=e.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const r=this._geoJSONIndex.getTile(t.z,t.x,t.y);if(!r)return null;const n=new Ch(r.features);let i=Lh(n);return 0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),{vectorTile:n,rawData:i.buffer}}))}loadData(e){return t(this,void 0,void 0,(function*(){var t;null===(t=this._pendingRequest)||void 0===t||t.abort();const r=!!(e&&e.request&&e.request.collectResourceTiming)&&new kh(e.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(e,this._pendingRequest),this._geoJSONIndex=e.cluster?new Yh(function({superclusterOptions:t,clusterProperties:e}){if(!e||!t)return t;const r={},n={},i={accumulated:null,zoom:0},s={properties:null},o=Object.keys(e);for(const t of o){const[i,s]=e[t],o=nn(s),a=nn("string"==typeof i?[i,["accumulated"],["get",t]]:i);r[t]=o.value,n[t]=a.value}return t.map=t=>{s.properties=t;const e={};for(const t of o)e[t]=r[t].evaluate(i,s);return e},t.reduce=(t,e)=>{s.properties=e;for(const e of o)i.accumulated=t[e],t[e]=n[e].evaluate(i,s)},t}(e)).load((yield this._pendingData).features):(n=yield this._pendingData,new Ip(n,e.geojsonVtOptions)),this.loaded={};const t={};if(r){const n=r.finish();n&&(t.resourceTiming={},t.resourceTiming[e.source]=JSON.parse(JSON.stringify(n)))}return t}catch(t){if(delete this._pendingRequest,function(t){return t.message===ti}(t))return{abandoned:!0};throw t}var n}))}getData(){return t(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(t){const e=this.loaded;return e&&e[t.uid]?super.reloadTile(t):this.loadTile(t)}loadAndProcessGeoJSON(e,r){return t(this,void 0,void 0,(function*(){let t=yield this.loadGeoJSON(e,r);if(delete this._pendingRequest,"object"!=typeof t)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(zh(t,!0),e.filter){const r=nn(e.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));const n=t.features.filter((t=>r.value.evaluate({zoom:0},t)));t={type:"FeatureCollection",features:n}}return t}))}loadGeoJSON(e,r){return t(this,void 0,void 0,(function*(){const{promoteId:t}=e;if(e.request){const n=yield((t,e)=>li(g(t,{type:"json"}),e))(e.request,r);return this._dataUpdateable=Pp(n.data,t)?Tp(n.data,t):void 0,n.data}if("string"==typeof e.data)try{const r=JSON.parse(e.data);return this._dataUpdateable=Pp(r,t)?Tp(r,t):void 0,r}catch(t){throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`)}if(!e.dataDiff)throw new Error(`Input data given to '${e.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${e.source}`);return function(t,e,r){var n,i,s,o;if(e.removeAll&&t.clear(),e.remove)for(const r of e.remove)t.delete(r);if(e.add)for(const n of e.add){const e=zp(n,r);null!=e&&t.set(e,n)}if(e.update)for(const r of e.update){let e=t.get(r.id);if(null==e)continue;const a=!r.removeAllProperties&&((null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0);if((r.newGeometry||r.removeAllProperties||a)&&(e=Object.assign({},e),t.set(r.id,e),a&&(e.properties=Object.assign({},e.properties))),r.newGeometry&&(e.geometry=r.newGeometry),r.removeAllProperties)e.properties={};else if((null===(s=r.removeProperties)||void 0===s?void 0:s.length)>0)for(const t of r.removeProperties)Object.prototype.hasOwnProperty.call(e.properties,t)&&delete e.properties[t];if((null===(o=r.addOrUpdateProperties)||void 0===o?void 0:o.length)>0)for(const{key:t,value:n}of r.addOrUpdateProperties)e.properties[t]=n}}(this._dataUpdateable,e.dataDiff,t),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(e){return t(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort()}))}getClusterExpansionZoom(t){return this._geoJSONIndex.getClusterExpansionZoom(t.clusterId)}getClusterChildren(t){return this._geoJSONIndex.getChildren(t.clusterId)}getClusterLeaves(t){return this._geoJSONIndex.getLeaves(t.clusterId,t.limit,t.offset)}}class Bp{constructor(e){this.self=e,this.actor=new xi(e),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(t,e)=>{if(this.externalWorkerSourceTypes[t])throw new Error(`Worker source with name "${t}" already registered.`);this.externalWorkerSourceTypes[t]=e},this.self.addProtocol=ni,this.self.removeProtocol=ii,this.self.registerRTLTextPlugin=t=>{Ji.setMethods(t)},this.actor.registerMessageHandler("LDT",((t,e)=>this._getDEMWorkerSource(t,e.source).loadTile(e))),this.actor.registerMessageHandler("RDT",((e,r)=>t(this,void 0,void 0,(function*(){this._getDEMWorkerSource(e,r.source).removeTile(r)})))),this.actor.registerMessageHandler("GCEZ",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterExpansionZoom(r)})))),this.actor.registerMessageHandler("GCC",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterChildren(r)})))),this.actor.registerMessageHandler("GCL",((e,r)=>t(this,void 0,void 0,(function*(){return this._getWorkerSource(e,r.type,r.source).getClusterLeaves(r)})))),this.actor.registerMessageHandler("LD",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadData(e))),this.actor.registerMessageHandler("GD",((t,e)=>this._getWorkerSource(t,e.type,e.source).getData())),this.actor.registerMessageHandler("LT",((t,e)=>this._getWorkerSource(t,e.type,e.source).loadTile(e))),this.actor.registerMessageHandler("RT",((t,e)=>this._getWorkerSource(t,e.type,e.source).reloadTile(e))),this.actor.registerMessageHandler("AT",((t,e)=>this._getWorkerSource(t,e.type,e.source).abortTile(e))),this.actor.registerMessageHandler("RMT",((t,e)=>this._getWorkerSource(t,e.type,e.source).removeTile(e))),this.actor.registerMessageHandler("RS",((e,r)=>t(this,void 0,void 0,(function*(){if(!this.workerSources[e]||!this.workerSources[e][r.type]||!this.workerSources[e][r.type][r.source])return;const t=this.workerSources[e][r.type][r.source];delete this.workerSources[e][r.type][r.source],void 0!==t.removeSource&&t.removeSource(r)})))),this.actor.registerMessageHandler("RM",(e=>t(this,void 0,void 0,(function*(){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e]})))),this.actor.registerMessageHandler("SR",((e,r)=>t(this,void 0,void 0,(function*(){this.referrer=r})))),this.actor.registerMessageHandler("SRPS",((t,e)=>this._syncRTLPluginState(t,e))),this.actor.registerMessageHandler("IS",((e,r)=>t(this,void 0,void 0,(function*(){this.self.importScripts(r)})))),this.actor.registerMessageHandler("SI",((t,e)=>this._setImages(t,e))),this.actor.registerMessageHandler("UL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).update(r.layers,r.removedIds)})))),this.actor.registerMessageHandler("SL",((e,r)=>t(this,void 0,void 0,(function*(){this._getLayerIndex(e).replace(r)}))))}_setImages(e,r){return t(this,void 0,void 0,(function*(){this.availableImages[e]=r;for(const t in this.workerSources[e]){const n=this.workerSources[e][t];for(const t in n)n[t].availableImages=r}}))}_syncRTLPluginState(e,r){return t(this,void 0,void 0,(function*(){return yield Ji.syncState(r,this.self.importScripts)}))}_getAvailableImages(t){let e=this.availableImages[t];return e||(e=[]),e}_getLayerIndex(t){let e=this.layerIndexes[t];return e||(e=this.layerIndexes[t]=new Mc),e}_getWorkerSource(t,e,r){if(this.workerSources[t]||(this.workerSources[t]={}),this.workerSources[t][e]||(this.workerSources[t][e]={}),!this.workerSources[t][e][r]){const n={sendAsync:(e,r)=>(e.targetMapId=t,this.actor.sendAsync(e,r))};switch(e){case"vector":this.workerSources[t][e][r]=new Ah(n,this._getLayerIndex(t),this._getAvailableImages(t));break;case"geojson":this.workerSources[t][e][r]=new Cp(n,this._getLayerIndex(t),this._getAvailableImages(t));break;default:this.workerSources[t][e][r]=new this.externalWorkerSourceTypes[e](n,this._getLayerIndex(t),this._getAvailableImages(t))}}return this.workerSources[t][e][r]}_getDEMWorkerSource(t,e){return this.demWorkerSources[t]||(this.demWorkerSources[t]={}),this.demWorkerSources[t][e]||(this.demWorkerSources[t][e]=new Ih),this.demWorkerSources[t][e]}}return S(self)&&(self.worker=new Bp(self)),Bp}();
//# sourceMappingURL=maplibre-gl-csp-worker.js.map
