/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.6.1/LICENSE.txt
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).maplibregl={})}(this,(function(t){"use strict";var e,i,r="5.6.1";function n(t,e,i,r){return new(i||(i=Promise))((function(n,s){function o(t){try{l(r.next(t))}catch(t){s(t)}}function a(t){try{l(r.throw(t))}catch(t){s(t)}}function l(t){var e;t.done?n(t.value):(e=t.value,e instanceof i?e:new i((function(t){t(e)}))).then(o,a)}l((r=r.apply(t,e||[])).next())}))}function s(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function o(){if(i)return e;function t(t,e){this.x=t,this.y=e}return i=1,e=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),i=Math.sin(t),r=i*this.x+e*this.y;return this.x=e*this.x-i*this.y,this.y=r,this},_rotateAround:function(t,e){var i=Math.cos(t),r=Math.sin(t),n=e.y+r*(this.x-e.x)+i*(this.y-e.y);return this.x=e.x+i*(this.x-e.x)-r*(this.y-e.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},e}"function"==typeof SuppressedError&&SuppressedError;var a,l,c=s(o()),h=function(){if(l)return a;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return l=1,a=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},a}(),u=s(h);let p,d;function f(){return null==p&&(p="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),p}var m=1e-6,_="undefined"!=typeof Float32Array?Float32Array:Array;function g(){var t=new _(4);return _!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}function y(){var t=new _(9);return _!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function x(){var t=new _(16);return _!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function v(t){var e=new _(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function b(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function w(t,e){var i=e[0],r=e[1],n=e[2],s=e[3],o=e[4],a=e[5],l=e[6],c=e[7],h=e[8],u=e[9],p=e[10],d=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=i*a-r*o,x=i*l-n*o,v=i*c-s*o,b=r*l-n*a,w=r*c-s*a,T=n*c-s*l,P=h*m-u*f,S=h*_-p*f,M=h*g-d*f,I=u*_-p*m,C=u*g-d*m,A=p*g-d*_,E=y*A-x*C+v*I+b*M-w*S+T*P;return E?(t[0]=(a*A-l*C+c*I)*(E=1/E),t[1]=(n*C-r*A-s*I)*E,t[2]=(m*T-_*w+g*b)*E,t[3]=(p*w-u*T-d*b)*E,t[4]=(l*M-o*A-c*S)*E,t[5]=(i*A-n*M+s*S)*E,t[6]=(_*v-f*T-g*x)*E,t[7]=(h*T-p*v+d*x)*E,t[8]=(o*C-a*M+c*P)*E,t[9]=(r*M-i*C-s*P)*E,t[10]=(f*w-m*v+g*y)*E,t[11]=(u*v-h*w-d*y)*E,t[12]=(a*S-o*I-l*P)*E,t[13]=(i*I-r*S+n*P)*E,t[14]=(m*x-f*b-_*y)*E,t[15]=(h*b-u*x+p*y)*E,t):null}function T(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=i[0],v=i[1],b=i[2],w=i[3];return t[0]=x*r+v*a+b*u+w*m,t[1]=x*n+v*l+b*p+w*_,t[2]=x*s+v*c+b*d+w*g,t[3]=x*o+v*h+b*f+w*y,t[4]=(x=i[4])*r+(v=i[5])*a+(b=i[6])*u+(w=i[7])*m,t[5]=x*n+v*l+b*p+w*_,t[6]=x*s+v*c+b*d+w*g,t[7]=x*o+v*h+b*f+w*y,t[8]=(x=i[8])*r+(v=i[9])*a+(b=i[10])*u+(w=i[11])*m,t[9]=x*n+v*l+b*p+w*_,t[10]=x*s+v*c+b*d+w*g,t[11]=x*o+v*h+b*f+w*y,t[12]=(x=i[12])*r+(v=i[13])*a+(b=i[14])*u+(w=i[15])*m,t[13]=x*n+v*l+b*p+w*_,t[14]=x*s+v*c+b*d+w*g,t[15]=x*o+v*h+b*f+w*y,t}function P(t,e,i){var r,n,s,o,a,l,c,h,u,p,d,f,m=i[0],_=i[1],g=i[2];return e===t?(t[12]=e[0]*m+e[4]*_+e[8]*g+e[12],t[13]=e[1]*m+e[5]*_+e[9]*g+e[13],t[14]=e[2]*m+e[6]*_+e[10]*g+e[14],t[15]=e[3]*m+e[7]*_+e[11]*g+e[15]):(n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],t[0]=r=e[0],t[1]=n,t[2]=s,t[3]=o,t[4]=a,t[5]=l,t[6]=c,t[7]=h,t[8]=u,t[9]=p,t[10]=d,t[11]=f,t[12]=r*m+a*_+u*g+e[12],t[13]=n*m+l*_+p*g+e[13],t[14]=s*m+c*_+d*g+e[14],t[15]=o*m+h*_+f*g+e[15]),t}function S(t,e,i){var r=i[0],n=i[1],s=i[2];return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function M(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[4],o=e[5],a=e[6],l=e[7],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*n+c*r,t[5]=o*n+h*r,t[6]=a*n+u*r,t[7]=l*n+p*r,t[8]=c*n-s*r,t[9]=h*n-o*r,t[10]=u*n-a*r,t[11]=p*n-l*r,t}function I(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n-c*r,t[1]=o*n-h*r,t[2]=a*n-u*r,t[3]=l*n-p*r,t[8]=s*r+c*n,t[9]=o*r+h*n,t[10]=a*r+u*n,t[11]=l*r+p*n,t}function C(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[4],h=e[5],u=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n+c*r,t[1]=o*n+h*r,t[2]=a*n+u*r,t[3]=l*n+p*r,t[4]=c*n-s*r,t[5]=h*n-o*r,t[6]=u*n-a*r,t[7]=p*n-l*r,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var A=function(t,e,i,r,n){var s,o=1/Math.tan(e/2);return t[0]=o/i,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=o,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0?(t[10]=(n+r)*(s=1/(r-n)),t[14]=2*n*r*s):(t[10]=-1,t[14]=-2*r),t},E=function(t,e,i,r,n,s,o){var a=1/(e-i),l=1/(r-n),c=1/(s-o);return t[0]=-2*a,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*c,t[11]=0,t[12]=(e+i)*a,t[13]=(n+r)*l,t[14]=(o+s)*c,t[15]=1,t};function z(){var t=new _(3);return _!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function k(t){var e=new _(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function R(t){return Math.hypot(t[0],t[1],t[2])}function D(t,e,i){var r=new _(3);return r[0]=t,r[1]=e,r[2]=i,r}function L(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}function B(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t}function F(t,e){var i=e[0],r=e[1],n=e[2],s=i*i+r*r+n*n;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function O(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function j(t,e,i){var r=e[0],n=e[1],s=e[2],o=i[0],a=i[1],l=i[2];return t[0]=n*l-s*a,t[1]=s*o-r*l,t[2]=r*a-n*o,t}function V(t,e,i){var r=i[0],n=i[1],s=i[2],o=e[0],a=e[1],l=e[2],c=n*l-s*a,h=s*o-r*l,u=r*a-n*o,p=n*u-s*h,d=s*c-r*u,f=r*h-n*c,m=2*i[3];return h*=m,u*=m,d*=2,f*=2,t[0]=o+(c*=m)+(p*=2),t[1]=a+h+d,t[2]=l+u+f,t}function N(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0],s[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),s[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function U(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),s[1]=n[1],s[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function Z(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),s[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),s[2]=n[2],t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}var G,$=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t},q=R;function W(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3];return t[0]=i[0]*r+i[4]*n+i[8]*s+i[12]*o,t[1]=i[1]*r+i[5]*n+i[9]*s+i[13]*o,t[2]=i[2]*r+i[6]*n+i[10]*s+i[14]*o,t[3]=i[3]*r+i[7]*n+i[11]*s+i[15]*o,t}function H(){var t=new _(4);return _!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function X(t,e,i,r){var n=.5*Math.PI/180;e*=n,i*=n,r*=n;var s=Math.sin(e),o=Math.cos(e),a=Math.sin(i),l=Math.cos(i),c=Math.sin(r),h=Math.cos(r);return t[0]=s*l*h-o*a*c,t[1]=o*a*h+s*l*c,t[2]=o*l*c-s*a*h,t[3]=o*l*h+s*a*c,t}function Y(){var t=new _(2);return _!=Float32Array&&(t[0]=0,t[1]=0),t}function K(t,e){var i=new _(2);return i[0]=t,i[1]=e,i}function J(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t}function Q(t){return Math.hypot(t[0],t[1])}function tt(t){return t[0]=0,t[1]=0,t}z(),G=new _(4),_!=Float32Array&&(G[0]=0,G[1]=0,G[2]=0,G[3]=0),z(),D(1,0,0),D(0,1,0),H(),H(),y();var et=function(t){var e=t[0],i=t[1];return e*e+i*i};Y();const it=8192;function rt(t,e,i){return e*(it/(t.tileSize*Math.pow(2,i-t.tileID.overscaledZ)))}function nt(){return new Float64Array(4)}function st(){return new Float64Array(3)}function ot(){return new Float64Array(16)}function at(){const t=new Float64Array(16);return b(t),t}function lt(){const t=new Float32Array(16);return b(t),t}function ct(t,e,i,r,n=!1){if(!i[0]&&!i[1])return[0,0];const s=n?"map"===r?-t.bearingInRadians:0:"viewport"===r?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}return[n?i[0]:rt(e,i[0],t.zoom),n?i[1]:rt(e,i[1],t.zoom)]}function ht(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]}function ut(t,e,i){const r=(n=[t[0],t[1],t[2],e[0],e[1],e[2],i[0],i[1],i[2]])[0]*((h=n[8])*(o=n[4])-(a=n[5])*(c=n[7]))+n[1]*(-h*(s=n[3])+a*(l=n[6]))+n[2]*(c*s-o*l);var n,s,o,a,l,c,h;if(0===r)return null;const u=j([],[e[0],e[1],e[2]],[i[0],i[1],i[2]]),p=j([],[i[0],i[1],i[2]],[t[0],t[1],t[2]]),d=j([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),f=B([],u,-t[3]);return L(f,f,B([],p,-e[3])),L(f,f,B([],d,-i[3])),B(f,f,1/r),f}function pt(t,e,i){const r=e[0]*i[0]+e[1]*i[1]+e[2]*i[2];return 0===r?null:(-(t[0]*i[0]+t[1]*i[1]+t[2]*i[2])-i[3])/r}function dt(t,e,i,r){const n=Math.sqrt(t*t+e*e),s=Math.sqrt(i*i+r*r);t/=n,e/=n,i/=s,r/=s;const o=Math.acos(t*i+e*r);return-e*i+t*r>0?o:-o}function ft(t,e){const i=_t(t,360),r=_t(e,360),n=r-i,s=r>i?n-360:n+360;return Math.abs(n)<Math.abs(s)?n:s}function mt(t,e){const i=_t(t,2*Math.PI),r=_t(e,2*Math.PI);return Math.min(Math.abs(i-r),Math.abs(i-r+2*Math.PI),Math.abs(i-r-2*Math.PI))}function _t(t,e){return(t%e+e)%e}function gt(t,e,i,r,n){return yt(r,n,Tt((t-e)/(i-e),0,1))}function yt(t,e,i){return t*(1-i)+e*i}function xt(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of t)e=Math.min(e,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);return[e,i,r,n]}function vt(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)}function bt(t,e,i,r){const n=new u(t,e,i,r);return t=>n.solve(t)}const wt=bt(.25,.1,.25,1);function Tt(t,e,i){return Math.min(i,Math.max(e,t))}function Pt(t,e,i){const r=i-e,n=((t-e)%r+r)%r+e;return n===e?i:n}function St(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}function Mt(t,e){const i={};for(let r=0;r<e.length;r++){const n=e[r];n in t&&(i[n]=t[n])}return i}let It=1;function Ct(){return It++}function At(t){return Math.pow(2,t)}function Et(t){return Math.log(t)/Math.LN2}function zt(t,e,i){const r={};for(const i in t)r[i]=e.call(this,t[i],i,t);return r}function kt(t,e,i){const r={};for(const i in t)e.call(this,t[i],i,t)&&(r[i]=t[i]);return r}function Rt(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!Rt(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!Rt(t[i],e[i]))return!1;return!0}return t===e}function Dt(t){return Array.isArray(t)?t.map(Dt):"object"==typeof t&&t?zt(t,Dt):t}const Lt={};function Bt(t){Lt[t]||("undefined"!=typeof console&&console.warn(t),Lt[t]=!0)}function Ft(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}function Ot(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let jt=null;function Vt(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const Nt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function Ut(t,e,i,r){return t.addEventListener(e,i,r),{unsubscribe:()=>{t.removeEventListener(e,i,r)}}}function Zt(t){return t*Math.PI/180}function Gt(t){return t/Math.PI*180}function $t(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing}function qt(t,e,i){const r=K(e.x-i.x,e.y-i.y),n=K(t.x-i.x,t.y-i.y);var s,o;return Gt(Math.atan2(r[0]*n[1]-r[1]*n[0],(s=r)[0]*(o=n)[0]+s[1]*o[1]))}function Wt(t,e,i){const r=new Float64Array(4);return X(r,t,e-90,i),r}const Ht=85.051129,Xt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},Yt={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0};function Kt(t,e){return Xt[e]&&"touches"in t}const Jt="AbortError";function Qt(){return new Error(Jt)}let te,ee;const ie={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(t,e,i){const r=requestAnimationFrame((t=>{n(),e(t)})),{unsubscribe:n}=Ut(t.signal,"abort",(()=>{n(),cancelAnimationFrame(r),i(Qt())}),!1)},frameAsync(t){return new Promise(((e,i)=>{this.frame(t,e,i)}))},getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(te||(te=document.createElement("a")),te.href=t,te.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==ee&&(ee=matchMedia("(prefers-reduced-motion: reduce)")),ee.matches)}};class re{static testProp(t){if(!re.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in re.docStyle)return t[e];return t[0]}static create(t,e,i){const r=window.document.createElement(t);return void 0!==e&&(r.className=e),i&&i.appendChild(r),r}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){re.docStyle&&re.selectProp&&(re.userSelect=re.docStyle[re.selectProp],re.docStyle[re.selectProp]="none")}static enableDrag(){re.docStyle&&re.selectProp&&(re.docStyle[re.selectProp]=re.userSelect)}static setTransform(t,e){t.style[re.transformProp]=e}static addEventListener(t,e,i,r={}){t.addEventListener(e,i,"passive"in r?r:r.capture)}static removeEventListener(t,e,i,r={}){t.removeEventListener(e,i,"passive"in r?r:r.capture)}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",re.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",re.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",re.suppressClickInternal,!0)}),0)}static getScale(t){const e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,e,i){const r=e.boundingClientRect;return new c((i.clientX-r.left)/e.x-t.clientLeft,(i.clientY-r.top)/e.y-t.clientTop)}static mousePos(t,e){const i=re.getScale(t);return re.getPoint(t,i,e)}static touchPos(t,e){const i=[],r=re.getScale(t);for(let n=0;n<e.length;n++)i.push(re.getPoint(t,r,e[n]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t)}static sanitize(t){const e=(new DOMParser).parseFromString(t,"text/html").body||document.createElement("body"),i=e.querySelectorAll("script");for(const t of i)t.remove();return re.clean(e),e.innerHTML}static isPossiblyDangerous(t,e){const i=e.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(t)||!i.includes("javascript:")&&!i.includes("data:"))||!!t.startsWith("on")||void 0}static clean(t){const e=t.children;for(const t of e)re.removeAttributes(t),re.clean(t)}static removeAttributes(t){for(const{name:e,value:i}of t.attributes)re.isPossiblyDangerous(e,i)&&t.removeAttribute(e)}}re.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,re.selectProp=re.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),re.transformProp=re.testProp(["transform","WebkitTransform"]);const ne={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function se(t){return ne.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const oe="global-dispatcher";class ae extends Error{constructor(t,e,i,r){super(`AJAXError: ${e} (${t}): ${i}`),this.status=t,this.statusText=e,this.url=i,this.body=r}}const le=()=>Ot(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,ce=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const i=se(t.url);if(i)return i(t,e);if(Ot(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:oe},e)}if(!(/^file:/.test(i=t.url)||/^file:/.test(le())&&!/^\w+:/.test(i))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,e){return n(this,void 0,void 0,(function*(){const i=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:le(),signal:e.signal});let r,n;"json"!==t.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");try{r=yield fetch(i)}catch(e){throw new ae(0,e.message,t.url,new Blob)}if(!r.ok){const e=yield r.blob();throw new ae(r.status,r.statusText,t.url,e)}n="arrayBuffer"===t.type||"image"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text();const s=yield n;if(e.signal.aborted)throw Qt();return{data:s,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(t,e);if(Ot(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:oe},e)}var i;return function(t,e){return new Promise(((i,r)=>{var n;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(n=t.headers)||void 0===n?void 0:n.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{r(new Error(s.statusText))},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response)}catch(t){return void r(t)}i({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});r(new ae(s.status,s.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{s.abort(),r(Qt())})),s.send(t.body)}))}(t,e)},he=(t,e)=>ce(St(t,{type:"json"}),e);function ue(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),i=window.location;return e.protocol===i.protocol&&e.host===i.host}const pe={supported:!1,testSupport:function(t){!me&&fe&&(_e?ge(t):de=t)}};let de,fe,me=!1,_e=!1;function ge(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,fe),t.isContextLost())return;pe.supported=!0}catch(t){}t.deleteTexture(e),me=!0}var ye;"undefined"!=typeof document&&(fe=document.createElement("img"),fe.onload=()=>{de&&ge(de),de=null,_e=!0},fe.onerror=()=>{me=!0,de=null},fe.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let e,i,r,s;t.resetRequestQueue=()=>{e=[],i=0,r=0,s={}},t.addThrottleControl=t=>{const e=r++;return s[e]=t,e},t.removeThrottleControl=t=>{delete s[t],a()},t.getImage=(t,i,r=!0)=>new Promise(((n,s)=>{pe.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),St(t,{type:"image"});const o={abortController:i,requestParameters:t,supportImageRefresh:r,state:"queued",onError:t=>{s(t)},onSuccess:t=>{n(t)}};e.push(o),a()}));const o=t=>n(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:e,supportImageRefresh:r,onError:s,onSuccess:o,abortController:c}=t,h=!1===r&&!Ot(self)&&!se(e.url)&&(!e.headers||Object.keys(e.headers).reduce(((t,e)=>t&&"accept"===e),!0));i++;const u=h?l(e,c):ce(e,c);try{const e=yield u;delete t.abortController,t.state="completed",e.data instanceof HTMLImageElement||Vt(e.data)?o(e):e.data&&o({data:yield(p=e.data,"function"==typeof createImageBitmap?(t=>n(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(p):(t=>new Promise(((e,i)=>{const r=new Image;r.onload=()=>{e(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=Nt}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):Nt})))(p)),cacheControl:e.cacheControl,expires:e.expires})}catch(e){delete t.abortController,s(e)}finally{i--,a()}var p})),a=()=>{const t=(()=>{for(const t of Object.keys(s))if(s[t]())return!0;return!1})()?ne.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:ne.MAX_PARALLEL_IMAGE_REQUESTS;for(let r=i;r<t&&e.length>0;r++){const t=e.shift();t.abortController.signal.aborted?r--:o(t)}},l=(t,e)=>new Promise(((i,r)=>{const n=new Image,s=t.url,o=t.credentials;o&&"include"===o?n.crossOrigin="use-credentials":(o&&"same-origin"===o||!ue(s))&&(n.crossOrigin="anonymous"),e.signal.addEventListener("abort",(()=>{n.src="",r(Qt())})),n.fetchPriority="high",n.onload=()=>{n.onerror=n.onload=null,i({data:n})},n.onerror=()=>{n.onerror=n.onload=null,e.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},n.src=s}))}(ye||(ye={})),ye.resetRequestQueue();class xe{constructor(t){this._transformRequestFn=t}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t}}function ve(t,e,i){i[t]&&-1!==i[t].indexOf(e)||(i[t]=i[t]||[],i[t].push(e))}function be(t,e,i){if(i&&i[t]){const r=i[t].indexOf(e);-1!==r&&i[t].splice(r,1)}}class we{constructor(t,e={}){St(this,e),this.type=t}}class Te extends we{constructor(t,e={}){super("error",St({error:t},e))}}class Pe{on(t,e){return this._listeners=this._listeners||{},ve(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return be(t,e,this._listeners),be(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ve(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new we(t,e||{}));const i=t.type;if(this.listens(i)){t.target=this;const e=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of e)i.call(this,t);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const e of r)be(i,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(St(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t))}else t instanceof Te&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Se={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const Me=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Ie(t,e){const i={};for(const e in t)"ref"!==e&&(i[e]=t[e]);return Me.forEach((t=>{t in e&&(i[t]=e[t])})),i}function Ce(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=Ie(t[i],e[t[i].ref]));return t}function Ae(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!Ae(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!Ae(t[i],e[i]))return!1;return!0}return t===e}function Ee(t,e){t.push(e)}function ze(t,e,i){Ee(i,{command:"addSource",args:[t,e[t]]})}function ke(t,e,i){Ee(e,{command:"removeSource",args:[t]}),i[t]=!0}function Re(t,e,i,r){ke(t,i,r),ze(t,e,i)}function De(t,e,i){let r;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!Ae(t[i][r],e[i][r]))return!1;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!Ae(t[i][r],e[i][r]))return!1;return!0}function Le(t,e,i,r,n,s){t=t||{},e=e||{};for(const o in t)Object.prototype.hasOwnProperty.call(t,o)&&(Ae(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}));for(const o in e)Object.prototype.hasOwnProperty.call(e,o)&&!Object.prototype.hasOwnProperty.call(t,o)&&(Ae(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}))}function Be(t){return t.id}function Fe(t,e){return t[e.id]=e,t}class Oe{constructor(t,e,i,r){this.message=(t?`${t}: `:"")+i,r&&(this.identifier=r),null!=e&&e.__line__&&(this.line=e.__line__)}}function je(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}class Ve extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class Ne{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,i]of e)this.bindings[t]=i}concat(t){return new Ne(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Ue={kind:"null"},Ze={kind:"number"},Ge={kind:"string"},$e={kind:"boolean"},qe={kind:"color"},We={kind:"projectionDefinition"},He={kind:"object"},Xe={kind:"value"},Ye={kind:"collator"},Ke={kind:"formatted"},Je={kind:"padding"},Qe={kind:"colorArray"},ti={kind:"numberArray"},ei={kind:"resolvedImage"},ii={kind:"variableAnchorOffsetCollection"};function ri(t,e){return{kind:"array",itemType:t,N:e}}function ni(t){if("array"===t.kind){const e=ni(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const si=[Ue,Ze,Ge,$e,qe,We,Ke,He,ri(Xe),Je,ti,Qe,ei,ii];function oi(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!oi(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of si)if(!oi(t,e))return null}return`Expected ${ni(t)} but found ${ni(e)} instead.`}function ai(t,e){return e.some((e=>e.kind===t.kind))}function li(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function ci(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const hi=.96422,ui=.82521,pi=4/29,di=6/29,fi=3*di*di,mi=di*di*di,_i=Math.PI/180,gi=180/Math.PI;function yi(t){return(t%=360)<0&&(t+=360),t}function xi([t,e,i,r]){let n,s;const o=bi((.2225045*(t=vi(t))+.7168786*(e=vi(e))+.0606169*(i=vi(i)))/1);t===e&&e===i?n=s=o:(n=bi((.4360747*t+.3850649*e+.1430804*i)/hi),s=bi((.0139322*t+.0971045*e+.7141733*i)/ui));const a=116*o-16;return[a<0?0:a,500*(n-o),200*(o-s),r]}function vi(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function bi(t){return t>mi?Math.pow(t,1/3):t/fi+pi}function wi([t,e,i,r]){let n=(t+16)/116,s=isNaN(e)?n:n+e/500,o=isNaN(i)?n:n-i/200;return n=1*Pi(n),s=hi*Pi(s),o=ui*Pi(o),[Ti(3.1338561*s-1.6168667*n-.4906146*o),Ti(-.9787684*s+1.9161415*n+.033454*o),Ti(.0719453*s-.2289914*n+1.4052427*o),r]}function Ti(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function Pi(t){return t>di?t*t*t:fi*(t-pi)}const Si=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function Mi(t,e){return Si(t,e)?t[e]:void 0}function Ii(t){return parseInt(t.padEnd(2,t),16)/255}function Ci(t,e){return Ai(e?t/100:t,0,1)}function Ai(t,e,i){return Math.min(Math.max(e,t),i)}function Ei(t){return!t.some(Number.isNaN)}const zi={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function ki(t,e,i){return t+i*(e-t)}function Ri(t,e,i){return t.map(((t,r)=>ki(t,e[r],i)))}class Di{constructor(t,e,i,r=1,n=!0){this.r=t,this.g=e,this.b=i,this.a=r,n||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[t,e,i,r]))}static parse(t){if(t instanceof Di)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=Mi(zi,t);if(e){const[t,i,r]=e;return[t/255,i/255,r/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let i=1;return[Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,i,r,n,s,o,a,l,c,h,u,p]=e,d=[n||" ",a||" ",h].join("");if("  "===d||"  /"===d||",,"===d||",,,"===d){const t=[r,o,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[Ai(+i/e,0,1),Ai(+s/e,0,1),Ai(+l/e,0,1),u?Ci(+u,p):1];if(Ei(t))return t}}return}}const i=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[t,e,r,n,s,o,a,l,c]=i,h=[r||" ",s||" ",a].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,Ai(+n,0,100),Ai(+o,0,100),l?Ci(+l,c):1];if(Ei(t))return function([t,e,i,r]){function n(r){const n=(r+t/30)%12,s=e*Math.min(i,1-i);return i-s*Math.max(-1,Math.min(n-3,9-n,1))}return t=yi(t),e/=100,i/=100,[n(0),n(8),n(4),r]}(t)}}}(t);return e?new Di(...e,!1):void 0}get rgb(){const{r:t,g:e,b:i,a:r}=this,n=r||1/0;return this.overwriteGetter("rgb",[t/n,e/n,i/n,r])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,i,r,n]=xi(t),s=Math.sqrt(i*i+r*r);return[Math.round(1e4*s)?yi(Math.atan2(r,i)*gi):NaN,s,e,n]}(this.rgb))}get lab(){return this.overwriteGetter("lab",xi(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,i,r]=this.rgb;return`rgba(${[t,e,i].map((t=>Math.round(255*t))).join(",")},${r})`}static interpolate(t,e,i,r="rgb"){switch(r){case"rgb":{const[r,n,s,o]=Ri(t.rgb,e.rgb,i);return new Di(r,n,s,o,!1)}case"hcl":{const[r,n,s,o]=t.hcl,[a,l,c,h]=e.hcl;let u,p;if(isNaN(r)||isNaN(a))isNaN(r)?isNaN(a)?u=NaN:(u=a,1!==s&&0!==s||(p=l)):(u=r,1!==c&&0!==c||(p=n));else{let t=a-r;a>r&&t>180?t-=360:a<r&&r-a>180&&(t+=360),u=r+i*t}const[d,f,m,_]=function([t,e,i,r]){return t=isNaN(t)?0:t*_i,wi([i,Math.cos(t)*e,Math.sin(t)*e,r])}([u,null!=p?p:ki(n,l,i),ki(s,c,i),ki(o,h,i)]);return new Di(d,f,m,_,!1)}case"lab":{const[r,n,s,o]=wi(Ri(t.lab,e.lab,i));return new Di(r,n,s,o,!1)}}}}Di.black=new Di(0,0,0,1),Di.white=new Di(1,1,1,1),Di.transparent=new Di(0,0,0,0),Di.red=new Di(1,0,0,1);class Li{constructor(t,e,i){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Bi=["bottom","center","top"];class Fi{constructor(t,e,i,r,n,s){this.text=t,this.image=e,this.scale=i,this.fontStack=r,this.textColor=n,this.verticalAlign=s}}class Oi{constructor(t){this.sections=t}static fromString(t){return new Oi([new Fi(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Oi?t:Oi.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class ji{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof ji)return t;if("number"==typeof t)return new ji([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new ji(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new ji(Ri(t.values,e.values,i))}}class Vi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Vi)return t;if("number"==typeof t)return new Vi([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Vi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new Vi(Ri(t.values,e.values,i))}}class Ni{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ni)return t;if("string"==typeof t){const e=Di.parse(t);if(!e)return;return new Ni([e])}if(!Array.isArray(t))return;const e=[];for(const i of t){if("string"!=typeof i)return;const t=Di.parse(i);if(!t)return;e.push(t)}return new Ni(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i,r="rgb"){const n=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)n.push(Di.interpolate(t.values[s],e.values[s],i,r));return new Ni(n)}}class Ui extends Error{constructor(t){super(t),this.name="RuntimeError"}toJSON(){return this.message}}const Zi=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Gi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Gi)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const i=t[e],r=t[e+1];if("string"!=typeof i||!Zi.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new Gi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){const r=t.values,n=e.values;if(r.length!==n.length)throw new Ui(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<r.length;t+=2){if(r[t]!==n[t])throw new Ui(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${r[t]}, to[${t}]: ${n[t]}`);s.push(r[t]);const[e,o]=r[t+1],[a,l]=n[t+1];s.push([ki(e,a,i),ki(o,l,i)])}return new Gi(s)}}class $i{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new $i({name:t,available:!1}):null}}class qi{constructor(t,e,i){this.from=t,this.to=e,this.transition=i}static interpolate(t,e,i){return new qi(t,e,i)}static parse(t){return t instanceof qi?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new qi(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new qi(t.from,t.to,t.transition):"string"==typeof t?new qi(t,t,1):void 0}}function Wi(t,e,i,r){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[t,e,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[t,e,i,r]:[t,e,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Hi(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof qi||t instanceof Di||t instanceof Li||t instanceof Oi||t instanceof ji||t instanceof Vi||t instanceof Ni||t instanceof Gi||t instanceof $i)return!0;if(Array.isArray(t)){for(const e of t)if(!Hi(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!Hi(t[e]))return!1;return!0}return!1}function Xi(t){if(null===t)return Ue;if("string"==typeof t)return Ge;if("boolean"==typeof t)return $e;if("number"==typeof t)return Ze;if(t instanceof Di)return qe;if(t instanceof qi)return We;if(t instanceof Li)return Ye;if(t instanceof Oi)return Ke;if(t instanceof ji)return Je;if(t instanceof Vi)return ti;if(t instanceof Ni)return Qe;if(t instanceof Gi)return ii;if(t instanceof $i)return ei;if(Array.isArray(t)){const e=t.length;let i;for(const e of t){const t=Xi(e);if(i){if(i===t)continue;i=Xe;break}i=t}return ri(i||Xe,e)}return He}function Yi(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Di||t instanceof qi||t instanceof Oi||t instanceof ji||t instanceof Vi||t instanceof Ni||t instanceof Gi||t instanceof $i?t.toString():JSON.stringify(t)}class Ki{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Hi(t[1]))return e.error("invalid value");const i=t[1];let r=Xi(i);const n=e.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Ki(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Ji={string:Ge,number:Ze,boolean:$e,object:He};class Qi{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i,r=1;const n=t[0];if("array"===n){let n,s;if(t.length>2){const i=t[1];if("string"!=typeof i||!(i in Ji)||"object"===i)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=Ji[i],r++}else n=Xe;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],r++}i=ri(n,s)}else{if(!Ji[n])throw new Error(`Types doesn't contain name = ${n}`);i=Ji[n]}const s=[];for(;r<t.length;r++){const i=e.parse(t[r],r,Xe);if(!i)return null;s.push(i)}return new Qi(i,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const i=this.args[e].evaluate(t);if(!oi(this.type,Xi(i)))return i;if(e===this.args.length-1)throw new Ui(`Expected value to be of type ${ni(this.type)}, but found ${ni(Xi(i))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const tr={"to-boolean":$e,"to-color":qe,"to-number":Ze,"to-string":Ge};class er{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[0];if(!tr[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==t.length)return e.error("Expected one argument.");const r=tr[i],n=[];for(let i=1;i<t.length;i++){const r=e.parse(t[i],i,Xe);if(!r)return null;n.push(r)}return new er(r,n)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,i;for(const r of this.args){if(e=r.evaluate(t),i=null,e instanceof Di)return e;if("string"==typeof e){const i=t.parseColor(e);if(i)return i}else if(Array.isArray(e)&&(i=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Wi(e[0],e[1],e[2],e[3]),!i))return new Di(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Ui(i||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const i of this.args){e=i.evaluate(t);const r=ji.parse(e);if(r)return r}throw new Ui(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"numberArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Vi.parse(e);if(r)return r}throw new Ui(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"colorArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Ni.parse(e);if(r)return r}throw new Ui(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const i of this.args){e=i.evaluate(t);const r=Gi.parse(e);if(r)return r}throw new Ui(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const i of this.args){if(e=i.evaluate(t),null===e)return 0;const r=Number(e);if(!isNaN(r))return r}throw new Ui(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Oi.fromString(Yi(this.args[0].evaluate(t)));case"resolvedImage":return $i.fromString(Yi(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Yi(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const ir=["Unknown","Point","LineString","Polygon"];class rr{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ir[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=Di.parse(t),this._parseColorCache.set(t,e)),e}}class nr{constructor(t,e,i=[],r,n=new Ne,s=[]){this.registry=t,this.path=i,this.key=i.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=s,this.expectedType=r,this._isConstant=e}parse(t,e,i,r,n={}){return e?this.concat(e,i,r)._parse(t,n):this._parse(t,n)}_parse(t,e){function i(t,e,i){return"assert"===i?new Qi(e,[t]):"coerce"===i?new er(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=t[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(t,this);if(!r)return null;if(this.expectedType){const t=this.expectedType,n=r.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(n.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(n.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(n.kind)||"colorArray"===t.kind&&["value","string","array"].includes(n.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(n.kind))r=i(r,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,n))return null}else r=i(r,t,e.typeAnnotation||"assert")}if(!(r instanceof Ki)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const t=new rr;try{r=new Ki(r.type,r.evaluate(t))}catch(t){return this.error(t.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,i){const r="number"==typeof t?this.path.concat(t):this.path,n=i?this.scope.concat(i):this.scope;return new nr(this.registry,this._isConstant,r,e||null,n,this.errors)}error(t,...e){const i=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Ve(i,t))}checkSubtype(t,e){const i=oi(t,e);return i&&this.error(i),i}}class sr{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const i=[];for(let r=1;r<t.length-1;r+=2){const n=t[r];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",r);const s=e.parse(t[r+1],r+1);if(!s)return null;i.push([n,s])}const r=e.parse(t[t.length-1],t.length-1,e.expectedType,i);return r?new sr(i,r):null}outputDefined(){return this.result.outputDefined()}}class or{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const i=t[1];return e.scope.has(i)?new or(i,e.scope.get(i)):e.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class ar{constructor(t,e,i){this.type=t,this.index=e,this.input=i}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ze),r=e.parse(t[2],2,ri(e.expectedType||Xe));return i&&r?new ar(r.type.itemType,i,r):null}evaluate(t){const e=this.index.evaluate(t),i=this.input.evaluate(t);if(e<0)throw new Ui(`Array index out of bounds: ${e} < 0.`);if(e>=i.length)throw new Ui(`Array index out of bounds: ${e} > ${i.length-1}.`);if(e!==Math.floor(e))throw new Ui(`Array index must be an integer, but found ${e} instead.`);return i[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class lr{constructor(t,e){this.type=$e,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Xe);return i&&r?ai(i.type,[$e,Ge,Ze,Ue,Xe])?new lr(i,r):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ni(i.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!i)return!1;if(!li(e,["boolean","string","number","null"]))throw new Ui(`Expected first argument to be of type boolean, string, number or null, but found ${ni(Xi(e))} instead.`);if(!li(i,["string","array"]))throw new Ui(`Expected second argument to be of type array or string, but found ${ni(Xi(i))} instead.`);return i.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class cr{constructor(t,e,i){this.type=Ze,this.needle=t,this.haystack=e,this.fromIndex=i}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Xe);if(!i||!r)return null;if(!ai(i.type,[$e,Ge,Ze,Ue,Xe]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ni(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ze);return n?new cr(i,r,n):null}return new cr(i,r)}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!li(e,["boolean","string","number","null"]))throw new Ui(`Expected first argument to be of type boolean, string, number or null, but found ${ni(Xi(e))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(t)),li(i,["string"])){const t=i.indexOf(e,r);return-1===t?-1:[...i.slice(0,t)].length}if(li(i,["array"]))return i.indexOf(e,r);throw new Ui(`Expected second argument to be of type array or string, but found ${ni(Xi(i))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class hr{constructor(t,e,i,r,n,s){this.inputType=t,this.type=e,this.input=i,this.cases=r,this.outputs=n,this.otherwise=s}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let i,r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const c=e.concat(o);if(0===a.length)return c.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Xi(t)))return null}else i=Xi(t);if(void 0!==n[String(t)])return c.error("Branch labels must be unique.");n[String(t)]=s.length}const h=e.parse(l,o,r);if(!h)return null;r=r||h.type,s.push(h)}const o=e.parse(t[1],1,Xe);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,r);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(i,o.type)?null:new hr(i,r,o,n,s,a):null}evaluate(t){const e=this.input.evaluate(t);return(Xi(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class ur{constructor(t,e,i){this.type=t,this.branches=e,this.otherwise=i}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const r=[];for(let n=1;n<t.length-1;n+=2){const s=e.parse(t[n],n,$e);if(!s)return null;const o=e.parse(t[n+1],n+1,i);if(!o)return null;r.push([s,o]),i=i||o.type}const n=e.parse(t[t.length-1],t.length-1,i);if(!n)return null;if(!i)throw new Error("Can't infer output type");return new ur(i,r,n)}evaluate(t){for(const[e,i]of this.branches)if(e.evaluate(t))return i.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,i]of this.branches)t(e),t(i);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class pr{constructor(t,e,i,r){this.type=t,this.input=e,this.beginIndex=i,this.endIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Ze);if(!i||!r)return null;if(!ai(i.type,[ri(Xe),Ge,Xe]))return e.error(`Expected first argument to be of type array or string, but found ${ni(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ze);return n?new pr(i.type,i,r,n):null}return new pr(i.type,i,r)}evaluate(t){const e=this.input.evaluate(t),i=this.beginIndex.evaluate(t);let r;if(this.endIndex&&(r=this.endIndex.evaluate(t)),li(e,["string"]))return[...e].slice(i,r).join("");if(li(e,["array"]))return e.slice(i,r);throw new Ui(`Expected first argument to be of type array or string, but found ${ni(Xi(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function dr(t,e){const i=t.length-1;let r,n,s=0,o=i,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),r=t[a],n=t[a+1],r<=e){if(a===i||e<n)return a;s=a+1}else{if(!(r>e))throw new Ui("Input is not a number.");o=a-1}return 0}class fr{constructor(t,e,i){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const i=e.parse(t[1],1,Ze);if(!i)return null;const r=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let i=1;i<t.length;i+=2){const s=1===i?-1/0:t[i],o=t[i+1],a=i,l=i+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(r.length&&r[r.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const c=e.parse(o,l,n);if(!c)return null;n=n||c.type,r.push([s,c])}return new fr(n,i,r)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;return r>=e[n-1]?i[n-1].evaluate(t):i[dr(e,r)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function mr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var _r,gr,yr=function(){if(gr)return _r;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return gr=1,_r=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},_r}(),xr=mr(yr);class vr{constructor(t,e,i,r,n){this.type=t,this.operator=e,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,i,r){let n=0;if("exponential"===t.name)n=br(e,t.base,i,r);else if("linear"===t.name)n=br(e,1,i,r);else if("cubic-bezier"===t.name){const s=t.controlPoints;n=new xr(s[0],s[1],s[2],s[3]).solve(br(e,1,i,r))}return n}static parse(t,e){let[i,r,n,...s]=t;if(!Array.isArray(r)||0===r.length)return e.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const t=r[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:t}}else{if("cubic-bezier"!==r[0])return e.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const t=r.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,Ze),!n)return null;const o=[];let a=null;"interpolate-hcl"!==i&&"interpolate-lab"!==i||e.expectedType==Qe?e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType):a=qe;for(let t=0;t<s.length;t+=2){const i=s[t],r=s[t+1],n=t+3,l=t+4;if("number"!=typeof i)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(o.length&&o[o.length-1][0]>=i)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=e.parse(r,l,a);if(!c)return null;a=a||c.type,o.push([i,c])}return ci(a,Ze)||ci(a,We)||ci(a,qe)||ci(a,Je)||ci(a,ti)||ci(a,Qe)||ci(a,ii)||ci(a,ri(Ze))?new vr(a,i,r,n,o):e.error(`Type ${ni(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;if(r>=e[n-1])return i[n-1].evaluate(t);const s=dr(e,r),o=vr.interpolationFactor(this.interpolation,r,e[s],e[s+1]),a=i[s].evaluate(t),l=i[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return ki(a,l,o);case"color":return Di.interpolate(a,l,o);case"padding":return ji.interpolate(a,l,o);case"colorArray":return Ni.interpolate(a,l,o);case"numberArray":return Vi.interpolate(a,l,o);case"variableAnchorOffsetCollection":return Gi.interpolate(a,l,o);case"array":return Ri(a,l,o);case"projectionDefinition":return qi.interpolate(a,l,o)}case"interpolate-hcl":switch(this.type.kind){case"color":return Di.interpolate(a,l,o,"hcl");case"colorArray":return Ni.interpolate(a,l,o,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return Di.interpolate(a,l,o,"lab");case"colorArray":return Ni.interpolate(a,l,o,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function br(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}const wr={color:Di.interpolate,number:ki,padding:ji.interpolate,numberArray:Vi.interpolate,colorArray:Ni.interpolate,variableAnchorOffsetCollection:Gi.interpolate,array:Ri};class Tr{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i=null;const r=e.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of t.slice(1)){const t=e.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!t)return null;i=i||t.type,n.push(t)}if(!i)throw new Error("No output type");const s=r&&n.some((t=>oi(r,t.type)));return new Tr(s?Xe:i,n)}evaluate(t){let e,i=null,r=0;for(const n of this.args)if(r++,i=n.evaluate(t),i&&i instanceof $i&&!i.available&&(e||(e=i.name),i=null,r===this.args.length&&(i=e)),null!==i)break;return i}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function Pr(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Sr(t,e,i,r){return 0===r.compare(e,i)}function Mr(t,e,i){const r="=="!==t&&"!="!==t;return class n{constructor(t,e,i){this.type=$e,this.lhs=t,this.rhs=e,this.collator=i,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const i=t[0];let s=e.parse(t[1],1,Xe);if(!s)return null;if(!Pr(i,s.type))return e.concat(1).error(`"${i}" comparisons are not supported for type '${ni(s.type)}'.`);let o=e.parse(t[2],2,Xe);if(!o)return null;if(!Pr(i,o.type))return e.concat(2).error(`"${i}" comparisons are not supported for type '${ni(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${ni(s.type)}' and '${ni(o.type)}'.`);r&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Qi(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Qi(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,Ye),!a)return null}return new n(s,o,a)}evaluate(n){const s=this.lhs.evaluate(n),o=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const e=Xi(s),i=Xi(o);if(e.kind!==i.kind||"string"!==e.kind&&"number"!==e.kind)throw new Ui(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const t=Xi(s),i=Xi(o);if("string"!==t.kind||"string"!==i.kind)return e(n,s,o)}return this.collator?i(n,s,o,this.collator.evaluate(n)):e(n,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const Ir=Mr("==",(function(t,e,i){return e===i}),Sr),Cr=Mr("!=",(function(t,e,i){return e!==i}),(function(t,e,i,r){return!Sr(0,e,i,r)})),Ar=Mr("<",(function(t,e,i){return e<i}),(function(t,e,i,r){return r.compare(e,i)<0})),Er=Mr(">",(function(t,e,i){return e>i}),(function(t,e,i,r){return r.compare(e,i)>0})),zr=Mr("<=",(function(t,e,i){return e<=i}),(function(t,e,i,r){return r.compare(e,i)<=0})),kr=Mr(">=",(function(t,e,i){return e>=i}),(function(t,e,i,r){return r.compare(e,i)>=0}));class Rr{constructor(t,e,i){this.type=Ye,this.locale=i,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const i=t[1];if("object"!=typeof i||Array.isArray(i))return e.error("Collator options argument must be an object.");const r=e.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,$e);if(!r)return null;const n=e.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,$e);if(!n)return null;let s=null;return i.locale&&(s=e.parse(i.locale,1,Ge),!s)?null:new Rr(r,n,s)}evaluate(t){return new Li(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class Dr{constructor(t,e,i,r,n){this.type=Ge,this.number=t,this.locale=e,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=n}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ze);if(!i)return null;const r=t[2];if("object"!=typeof r||Array.isArray(r))return e.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=e.parse(r.locale,1,Ge),!n))return null;let s=null;if(r.currency&&(s=e.parse(r.currency,1,Ge),!s))return null;let o=null;if(r["min-fraction-digits"]&&(o=e.parse(r["min-fraction-digits"],1,Ze),!o))return null;let a=null;return r["max-fraction-digits"]&&(a=e.parse(r["max-fraction-digits"],1,Ze),!a)?null:new Dr(i,n,s,o,a)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class Lr{constructor(t){this.type=Ke,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[1];if(!Array.isArray(i)&&"object"==typeof i)return e.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=t.length-1;++i){const s=t[i];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Ze),!t))return null;let i=null;if(s["text-font"]&&(i=e.parse(s["text-font"],1,ri(Ge)),!i))return null;let o=null;if(s["text-color"]&&(o=e.parse(s["text-color"],1,qe),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Bi.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=e.parse(s["vertical-align"],1,Ge),!a)return null}const l=r[r.length-1];l.scale=t,l.font=i,l.textColor=o,l.verticalAlign=a}else{const s=e.parse(t[i],1,Xe);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Lr(r)}evaluate(t){return new Oi(this.sections.map((e=>{const i=e.content.evaluate(t);return Xi(i)===ei?new Fi("",i,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Fi(Yi(i),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Br{constructor(t){this.type=ei,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ge);return i?new Br(i):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),i=$i.fromString(e);return i&&t.availableImages&&(i.available=t.availableImages.indexOf(e)>-1),i}eachChild(t){t(this.input)}outputDefined(){return!1}}class Fr{constructor(t){this.type=Ze,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=e.parse(t[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?e.error(`Expected argument of type string or array, but found ${ni(i.type)} instead.`):new Fr(i):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Ui(`Expected value to be of type string or array, but found ${ni(Xi(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Or=8192;function jr(t,e){const i=(180+t[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return[Math.round(i*n*Or),Math.round(r*n*Or)]}function Vr(t,e){const i=Math.pow(2,e.z);return[(n=(t[0]/Or+e.x)/i,360*n-180),(r=(t[1]/Or+e.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function Nr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function Ur(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Zr(t,e,i){const r=t[0]-e[0],n=t[1]-e[1],s=t[0]-i[0],o=t[1]-i[1];return r*o-s*n==0&&r*s<=0&&n*o<=0}function Gr(t,e,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-n[1]*s[0]&&!(!Yr(t,e,i,r)||!Yr(i,r,t,e));var n,s}function $r(t,e,i){for(const r of i)for(let i=0;i<r.length-1;++i)if(Gr(t,e,r[i],r[i+1]))return!0;return!1}function qr(t,e,i=!1){let r=!1;for(const a of e)for(let e=0;e<a.length-1;e++){if(Zr(t,a[e],a[e+1]))return i;(s=a[e])[1]>(n=t)[1]!=(o=a[e+1])[1]>n[1]&&n[0]<(o[0]-s[0])*(n[1]-s[1])/(o[1]-s[1])+s[0]&&(r=!r)}var n,s,o;return r}function Wr(t,e){for(const i of e)if(qr(t,i))return!0;return!1}function Hr(t,e){for(const i of t)if(!qr(i,e))return!1;for(let i=0;i<t.length-1;++i)if($r(t[i],t[i+1],e))return!1;return!0}function Xr(t,e){for(const i of e)if(Hr(t,i))return!0;return!1}function Yr(t,e,i,r){const n=r[0]-i[0],s=r[1]-i[1],o=(t[0]-i[0])*s-n*(t[1]-i[1]),a=(e[0]-i[0])*s-n*(e[1]-i[1]);return o>0&&a<0||o<0&&a>0}function Kr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=[];for(let r=0;r<t[n].length;r++){const o=jr(t[n][r],i);Nr(e,o),s.push(o)}r.push(s)}return r}function Jr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=Kr(t[n],e,i);r.push(s)}return r}function Qr(t,e,i,r){if(t[0]<i[0]||t[0]>i[2]){const e=.5*r;let n=t[0]-i[0]>e?-r:i[0]-t[0]>e?r:0;0===n&&(n=t[0]-i[2]>e?-r:i[2]-t[0]>e?r:0),t[0]+=n}Nr(e,t)}function tn(t,e,i,r){const n=Math.pow(2,r.z)*Or,s=[r.x*Or,r.y*Or],o=[];for(const r of t)for(const t of r){const r=[t.x+s[0],t.y+s[1]];Qr(r,e,i,n),o.push(r)}return o}function en(t,e,i,r){const n=Math.pow(2,r.z)*Or,s=[r.x*Or,r.y*Or],o=[];for(const i of t){const t=[];for(const r of i){const i=[r.x+s[0],r.y+s[1]];Nr(e,i),t.push(i)}o.push(t)}if(e[2]-e[0]<=n/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const r of t)Qr(r,e,i,n)}var a;return o}class rn{constructor(t,e){this.type=$e,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Hi(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const i of e.features){const{type:e,coordinates:r}=i.geometry;"Polygon"===e&&t.push(r),"MultiPolygon"===e&&t.push(...r)}if(t.length)return new rn(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new rn(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new rn(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Kr(e.coordinates,r,n),o=tn(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of o)if(!qr(t,s))return!1}if("MultiPolygon"===e.type){const s=Jr(e.coordinates,r,n),o=tn(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of o)if(!Wr(t,s))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Kr(e.coordinates,r,n),o=en(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of o)if(!Hr(t,s))return!1}if("MultiPolygon"===e.type){const s=Jr(e.coordinates,r,n),o=en(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of o)if(!Xr(t,s))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class nn{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:i}=this,r=e[t];for(;t>0;){const n=t-1>>1,s=e[n];if(i(r,s)>=0)break;e[t]=s,t=n}e[t]=r}_down(t){const{data:e,compare:i}=this,r=this.length>>1,n=e[t];for(;t<r;){let r=1+(t<<1);const s=r+1;if(s<this.length&&i(e[s],e[r])<0&&(r=s),i(e[r],n)>=0)break;e[t]=e[r],t=r}e[t]=n}}function sn(t,e,i=0,r=t.length-1,n=an){for(;r>i;){if(r-i>600){const s=r-i+1,o=e-i+1,a=Math.log(s),l=.5*Math.exp(2*a/3),c=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);sn(t,e,Math.max(i,Math.floor(e-o*l/s+c)),Math.min(r,Math.floor(e+(s-o)*l/s+c)),n)}const s=t[e];let o=i,a=r;for(on(t,i,e),n(t[r],s)>0&&on(t,i,r);o<a;){for(on(t,o,a),o++,a--;n(t[o],s)<0;)o++;for(;n(t[a],s)>0;)a--}0===n(t[i],s)?on(t,i,a):(a++,on(t,a,r)),a<=e&&(i=a+1),e<=a&&(r=a-1)}}function on(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function an(t,e){return t<e?-1:t>e?1:0}function ln(t,e){if(t.length<=1)return[t];const i=[];let r,n;for(const e of t){const t=hn(e);0!==t&&(e.area=Math.abs(t),void 0===n&&(n=t<0),n===t<0?(r&&i.push(r),r=[e]):r.push(e))}if(r&&i.push(r),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(sn(i[t],e,1,i[t].length-1,cn),i[t]=i[t].slice(0,e));return i}function cn(t,e){return e.area-t.area}function hn(t){let e=0;for(let i,r,n=0,s=t.length,o=s-1;n<s;o=n++)i=t[n],r=t[o],e+=(r.x-i.x)*(i.y+r.y);return e}const un=1/298.257223563,pn=un*(2-un),dn=Math.PI/180;class fn{constructor(t){const e=6378.137*dn*1e3,i=Math.cos(t*dn),r=1/(1-pn*(1-i*i)),n=Math.sqrt(r);this.kx=e*n*i,this.ky=e*n*r*(1-pn)}distance(t,e){const i=this.wrap(t[0]-e[0])*this.kx,r=(t[1]-e[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(t,e){let i,r,n,s,o=1/0;for(let a=0;a<t.length-1;a++){let l=t[a][0],c=t[a][1],h=this.wrap(t[a+1][0]-l)*this.kx,u=(t[a+1][1]-c)*this.ky,p=0;0===h&&0===u||(p=(this.wrap(e[0]-l)*this.kx*h+(e[1]-c)*this.ky*u)/(h*h+u*u),p>1?(l=t[a+1][0],c=t[a+1][1]):p>0&&(l+=h/this.kx*p,c+=u/this.ky*p)),h=this.wrap(e[0]-l)*this.kx,u=(e[1]-c)*this.ky;const d=h*h+u*u;d<o&&(o=d,i=l,r=c,n=a,s=p)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function mn(t,e){return e[0]-t[0]}function _n(t){return t[1]-t[0]+1}function gn(t,e){return t[1]>=t[0]&&t[1]<e}function yn(t,e){if(t[0]>t[1])return[null,null];const i=_n(t);if(e){if(2===i)return[t,null];const e=Math.floor(i/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===i)return[t,null];const r=Math.floor(i/2)-1;return[[t[0],t[0]+r],[t[0]+r+1,t[1]]]}function xn(t,e){if(!gn(e,t.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=e[0];r<=e[1];++r)Nr(i,t[r]);return i}function vn(t){const e=[1/0,1/0,-1/0,-1/0];for(const i of t)for(const t of i)Nr(e,t);return e}function bn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function wn(t,e,i){if(!bn(t)||!bn(e))return NaN;let r=0,n=0;return t[2]<e[0]&&(r=e[0]-t[2]),t[0]>e[2]&&(r=t[0]-e[2]),t[1]>e[3]&&(n=t[1]-e[3]),t[3]<e[1]&&(n=e[1]-t[3]),i.distance([0,0],[r,n])}function Tn(t,e,i){const r=i.pointOnLine(e,t);return i.distance(t,r.point)}function Pn(t,e,i,r,n){const s=Math.min(Tn(t,[i,r],n),Tn(e,[i,r],n)),o=Math.min(Tn(i,[t,e],n),Tn(r,[t,e],n));return Math.min(s,o)}function Sn(t,e,i,r,n){if(!gn(e,t.length)||!gn(r,i.length))return 1/0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(let t=r[0];t<r[1];++t){const r=i[t],o=i[t+1];if(Gr(e,a,r,o))return 0;s=Math.min(s,Pn(e,a,r,o,n))}}return s}function Mn(t,e,i,r,n){if(!gn(e,t.length)||!gn(r,i.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=r[0];e<=r[1];++e)if(s=Math.min(s,n.distance(t[o],i[e])),0===s)return s;return s}function In(t,e,i){if(qr(t,e,!0))return 0;let r=1/0;for(const n of e){const e=n[0],s=n[n.length-1];if(e!==s&&(r=Math.min(r,Tn(t,[s,e],i)),0===r))return r;const o=i.pointOnLine(n,t);if(r=Math.min(r,i.distance(t,o.point)),0===r)return r}return r}function Cn(t,e,i,r){if(!gn(e,t.length))return NaN;for(let r=e[0];r<=e[1];++r)if(qr(t[r],i,!0))return 0;let n=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(const t of i)for(let i=0,s=t.length,a=s-1;i<s;a=i++){const s=t[a],l=t[i];if(Gr(e,o,s,l))return 0;n=Math.min(n,Pn(e,o,s,l,r))}}return n}function An(t,e){for(const i of t)for(const t of i)if(qr(t,e,!0))return!0;return!1}function En(t,e,i,r=1/0){const n=vn(t),s=vn(e);if(r!==1/0&&wn(n,s,i)>=r)return r;if(Ur(n,s)){if(An(t,e))return 0}else if(An(e,t))return 0;let o=1/0;for(const r of t)for(let t=0,n=r.length,s=n-1;t<n;s=t++){const n=r[s],a=r[t];for(const t of e)for(let e=0,r=t.length,s=r-1;e<r;s=e++){const r=t[s],l=t[e];if(Gr(n,a,r,l))return 0;o=Math.min(o,Pn(n,a,r,l,i))}}return o}function zn(t,e,i,r,n,s){if(!s)return;const o=wn(xn(r,s),n,i);o<e&&t.push([o,s,[0,0]])}function kn(t,e,i,r,n,s,o){if(!s||!o)return;const a=wn(xn(r,s),xn(n,o),i);a<e&&t.push([a,s,o])}function Rn(t,e,i,r,n=1/0){let s=Math.min(r.distance(t[0],i[0][0]),n);if(0===s)return s;const o=new nn([[0,[0,t.length-1],[0,0]]],mn),a=vn(i);for(;o.length>0;){const n=o.pop();if(n[0]>=s)continue;const l=n[1],c=e?50:100;if(_n(l)<=c){if(!gn(l,t.length))return NaN;if(e){const e=Cn(t,l,i,r);if(isNaN(e)||0===e)return e;s=Math.min(s,e)}else for(let e=l[0];e<=l[1];++e){const n=In(t[e],i,r);if(s=Math.min(s,n),0===s)return 0}}else{const i=yn(l,e);zn(o,s,r,t,a,i[0]),zn(o,s,r,t,a,i[1])}}return s}function Dn(t,e,i,r,n,s=1/0){let o=Math.min(s,n.distance(t[0],i[0]));if(0===o)return o;const a=new nn([[0,[0,t.length-1],[0,i.length-1]]],mn);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],c=s[2],h=e?50:100,u=r?50:100;if(_n(l)<=h&&_n(c)<=u){if(!gn(l,t.length)&&gn(c,i.length))return NaN;let s;if(e&&r)s=Sn(t,l,i,c,n),o=Math.min(o,s);else if(e&&!r){const e=t.slice(l[0],l[1]+1);for(let t=c[0];t<=c[1];++t)if(s=Tn(i[t],e,n),o=Math.min(o,s),0===o)return o}else if(!e&&r){const e=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(s=Tn(t[i],e,n),o=Math.min(o,s),0===o)return o}else s=Mn(t,l,i,c,n),o=Math.min(o,s)}else{const s=yn(l,e),h=yn(c,r);kn(a,o,n,t,i,s[0],h[0]),kn(a,o,n,t,i,s[0],h[1]),kn(a,o,n,t,i,s[1],h[0]),kn(a,o,n,t,i,s[1],h[1])}}return o}function Ln(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Bn{constructor(t,e){this.type=Ze,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Hi(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Bn(e,e.features.map((t=>Ln(t.geometry))).flat());if("Feature"===e.type)return new Bn(e,Ln(e.geometry));if("type"in e&&"coordinates"in e)return new Bn(e,Ln(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Vr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new fn(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Dn(r,!1,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,Dn(r,!1,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,Rn(r,!1,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Vr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new fn(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,Dn(r,!0,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,Dn(r,!0,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,Rn(r,!0,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const i=t.geometry();if(0===i.length||0===i[0].length)return NaN;const r=ln(i,0).map((e=>e.map((e=>e.map((e=>Vr([e.x,e.y],t.canonical))))))),n=new fn(r[0][0][0][1]);let s=1/0;for(const t of e)for(const e of r){switch(t.type){case"Point":s=Math.min(s,Rn([t.coordinates],!1,e,n,s));break;case"LineString":s=Math.min(s,Rn(t.coordinates,!0,e,n,s));break;case"Polygon":s=Math.min(s,En(e,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class Fn{constructor(t){this.type=Xe,this.key=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=t[1];return null==i?e.error("Global state property must be defined."):"string"!=typeof i?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Fn(i)}evaluate(t){var e;const i=null===(e=t.globals)||void 0===e?void 0:e.globalState;return i&&0!==Object.keys(i).length?Mi(i,this.key):null}eachChild(){}outputDefined(){return!1}}const On={"==":Ir,"!=":Cr,">":Er,"<":Ar,">=":kr,"<=":zr,array:Qi,at:ar,boolean:Qi,case:ur,coalesce:Tr,collator:Rr,format:Lr,image:Br,in:lr,"index-of":cr,interpolate:vr,"interpolate-hcl":vr,"interpolate-lab":vr,length:Fr,let:sr,literal:Ki,match:hr,number:Qi,"number-format":Dr,object:Qi,slice:pr,step:fr,string:Qi,"to-boolean":er,"to-color":er,"to-number":er,"to-string":er,var:or,within:rn,distance:Bn,"global-state":Fn};class jn{constructor(t,e,i,r){this.name=t,this.type=e,this._evaluate=i,this.args=r}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const i=t[0],r=jn.definitions[i];if(!r)return e.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,s=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,o=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let a=null;for(const[r,s]of o){a=new nr(e.registry,Gn,e.path,null,e.scope);const o=[];let l=!1;for(let e=1;e<t.length;e++){const i=t[e],n=Array.isArray(r)?r[e-1]:r.type,s=a.parse(i,1+o.length,n);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(r)&&r.length!==o.length)a.error(`Expected ${r.length} arguments, but found ${o.length} instead.`);else{for(let t=0;t<o.length;t++){const e=Array.isArray(r)?r[t]:r.type,i=o[t];a.concat(t+1).checkSubtype(e,i.type)}if(0===a.errors.length)return new jn(i,n,s,o)}}if(1===o.length)e.errors.push(...a.errors);else{const i=(o.length?o:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(ni).join(", ")})`:`(${ni(e.type)}...)`;var e})).join(" | "),r=[];for(let i=1;i<t.length;i++){const n=e.parse(t[i],1+r.length);if(!n)return null;r.push(ni(n.type))}e.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(t,e){jn.definitions=e;for(const i in e)t[i]=jn}}function Vn(t,[e,i,r,n]){e=e.evaluate(t),i=i.evaluate(t),r=r.evaluate(t);const s=n?n.evaluate(t):1,o=Wi(e,i,r,s);if(o)throw new Ui(o);return new Di(e/255,i/255,r/255,s,!1)}function Nn(t,e){return t in e}function Un(t,e){const i=e[t];return void 0===i?null:i}function Zn(t){return{type:t}}function Gn(t){if(t instanceof or)return Gn(t.boundExpression);if(t instanceof jn&&"error"===t.name)return!1;if(t instanceof Rr)return!1;if(t instanceof rn)return!1;if(t instanceof Bn)return!1;if(t instanceof Fn)return!1;const e=t instanceof er||t instanceof Qi;let i=!0;return t.eachChild((t=>{i=e?i&&Gn(t):i&&t instanceof Ki})),!!i&&$n(t)&&Wn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function $n(t){if(t instanceof jn){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof rn)return!1;if(t instanceof Bn)return!1;let e=!0;return t.eachChild((t=>{e&&!$n(t)&&(e=!1)})),e}function qn(t){if(t instanceof jn&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!qn(t)&&(e=!1)})),e}function Wn(t,e){if(t instanceof jn&&e.indexOf(t.name)>=0)return!1;let i=!0;return t.eachChild((t=>{i&&!Wn(t,e)&&(i=!1)})),i}function Hn(t){return{result:"success",value:t}}function Xn(t){return{result:"error",value:t}}function Yn(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Kn(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Jn(t){return!!t.expression&&t.expression.interpolated}function Qn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function ts(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Xi(t)===He}function es(t){return t}function is(t,e){const i=t.stops&&"object"==typeof t.stops[0][0],r=i||!(i||void 0!==t.property),n=t.type||(Jn(e)?"exponential":"interval"),s=function(t){switch(t.type){case"color":return Di.parse;case"padding":return ji.parse;case"numberArray":return Vi.parse;case"colorArray":return Ni.parse;default:return null}}(e);if(s&&((t=je({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(o=t.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${t.colorSpace}"`);var o;const a=function(t){switch(t){case"exponential":return os;case"interval":return ss;case"categorical":return ns;case"identity":return as;default:throw new Error(`Unknown function type "${t}"`)}}(n);let l,c;if("categorical"===n){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];c=typeof t.stops[0][0]}if(i){const i={},r=[];for(let e=0;e<t.stops.length;e++){const n=t.stops[e],s=n[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},r.push(s)),i[s].stops.push([n[0].value,n[1]])}const n=[];for(const t of r)n.push([i[t].zoom,is(i[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:vr.interpolationFactor.bind(void 0,s),zoomStops:n.map((t=>t[0])),evaluate:({zoom:i},r)=>os({stops:n,base:t.base},e,i).evaluate(i,r)}}if(r){const i="exponential"===n?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:vr.interpolationFactor.bind(void 0,i),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:i})=>a(t,e,i,l,c)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[t.property]:void 0;return void 0===n?rs(t.default,e.default):a(t,e,n,l,c)}}}function rs(t,e,i){return void 0!==t?t:void 0!==e?e:void 0!==i?i:void 0}function ns(t,e,i,r,n){return rs(typeof i===n?r[i]:void 0,t.default,e.default)}function ss(t,e,i){if("number"!==Qn(i))return rs(t.default,e.default);const r=t.stops.length;if(1===r)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[r-1][0])return t.stops[r-1][1];const n=dr(t.stops.map((t=>t[0])),i);return t.stops[n][1]}function os(t,e,i){const r=void 0!==t.base?t.base:1;if("number"!==Qn(i))return rs(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[n-1][0])return t.stops[n-1][1];const s=dr(t.stops.map((t=>t[0])),i),o=function(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}(i,r,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1],c=wr[e.type]||es;return"function"==typeof a.evaluate?{evaluate(...e){const i=a.evaluate.apply(void 0,e),r=l.evaluate.apply(void 0,e);if(void 0!==i&&void 0!==r)return c(i,r,o,t.colorSpace)}}:c(a,l,o,t.colorSpace)}function as(t,e,i){switch(e.type){case"color":i=Di.parse(i);break;case"formatted":i=Oi.fromString(i.toString());break;case"resolvedImage":i=$i.fromString(i.toString());break;case"padding":i=ji.parse(i);break;case"colorArray":i=Ni.parse(i);break;case"numberArray":i=Vi.parse(i);break;default:Qn(i)===e.type||"enum"===e.type&&e.values[i]||(i=void 0)}return rs(i,t.default,e.default)}jn.register(On,{error:[{kind:"error"},[Ge],(t,[e])=>{throw new Ui(e.evaluate(t))}],typeof:[Ge,[Xe],(t,[e])=>ni(Xi(e.evaluate(t)))],"to-rgba":[ri(Ze,4),[qe],(t,[e])=>{const[i,r,n,s]=e.evaluate(t).rgb;return[255*i,255*r,255*n,s]}],rgb:[qe,[Ze,Ze,Ze],Vn],rgba:[qe,[Ze,Ze,Ze,Ze],Vn],has:{type:$e,overloads:[[[Ge],(t,[e])=>Nn(e.evaluate(t),t.properties())],[[Ge,He],(t,[e,i])=>Nn(e.evaluate(t),i.evaluate(t))]]},get:{type:Xe,overloads:[[[Ge],(t,[e])=>Un(e.evaluate(t),t.properties())],[[Ge,He],(t,[e,i])=>Un(e.evaluate(t),i.evaluate(t))]]},"feature-state":[Xe,[Ge],(t,[e])=>Un(e.evaluate(t),t.featureState||{})],properties:[He,[],t=>t.properties()],"geometry-type":[Ge,[],t=>t.geometryType()],id:[Xe,[],t=>t.id()],zoom:[Ze,[],t=>t.globals.zoom],"heatmap-density":[Ze,[],t=>t.globals.heatmapDensity||0],elevation:[Ze,[],t=>t.globals.elevation||0],"line-progress":[Ze,[],t=>t.globals.lineProgress||0],accumulated:[Xe,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Ze,Zn(Ze),(t,e)=>{let i=0;for(const r of e)i+=r.evaluate(t);return i}],"*":[Ze,Zn(Ze),(t,e)=>{let i=1;for(const r of e)i*=r.evaluate(t);return i}],"-":{type:Ze,overloads:[[[Ze,Ze],(t,[e,i])=>e.evaluate(t)-i.evaluate(t)],[[Ze],(t,[e])=>-e.evaluate(t)]]},"/":[Ze,[Ze,Ze],(t,[e,i])=>e.evaluate(t)/i.evaluate(t)],"%":[Ze,[Ze,Ze],(t,[e,i])=>e.evaluate(t)%i.evaluate(t)],ln2:[Ze,[],()=>Math.LN2],pi:[Ze,[],()=>Math.PI],e:[Ze,[],()=>Math.E],"^":[Ze,[Ze,Ze],(t,[e,i])=>Math.pow(e.evaluate(t),i.evaluate(t))],sqrt:[Ze,[Ze],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))],log2:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Ze,[Ze],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Ze,[Ze],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Ze,[Ze],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Ze,[Ze],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Ze,[Ze],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Ze,[Ze],(t,[e])=>Math.atan(e.evaluate(t))],min:[Ze,Zn(Ze),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Ze,Zn(Ze),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Ze,[Ze],(t,[e])=>Math.abs(e.evaluate(t))],round:[Ze,[Ze],(t,[e])=>{const i=e.evaluate(t);return i<0?-Math.round(-i):Math.round(i)}],floor:[Ze,[Ze],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Ze,[Ze],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[$e,[Ge,Xe],(t,[e,i])=>t.properties()[e.value]===i.value],"filter-id-==":[$e,[Xe],(t,[e])=>t.id()===e.value],"filter-type-==":[$e,[Ge],(t,[e])=>t.geometryType()===e.value],"filter-<":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<r}],"filter->":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>r}],"filter-<=":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<=r}],"filter->=":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>=r}],"filter-has":[$e,[Xe],(t,[e])=>e.value in t.properties()],"filter-has-id":[$e,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[$e,[ri(Ge)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[$e,[ri(Xe)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[$e,[Ge,ri(Xe)],(t,[e,i])=>i.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[$e,[Ge,ri(Xe)],(t,[e,i])=>function(t,e,i,r){for(;i<=r;){const n=i+r>>1;if(e[n]===t)return!0;e[n]>t?r=n-1:i=n+1}return!1}(t.properties()[e.value],i.value,0,i.value.length-1)],all:{type:$e,overloads:[[[$e,$e],(t,[e,i])=>e.evaluate(t)&&i.evaluate(t)],[Zn($e),(t,e)=>{for(const i of e)if(!i.evaluate(t))return!1;return!0}]]},any:{type:$e,overloads:[[[$e,$e],(t,[e,i])=>e.evaluate(t)||i.evaluate(t)],[Zn($e),(t,e)=>{for(const i of e)if(i.evaluate(t))return!0;return!1}]]},"!":[$e,[$e],(t,[e])=>!e.evaluate(t)],"is-supported-script":[$e,[Ge],(t,[e])=>{const i=t.globals&&t.globals.isSupportedScript;return!i||i(e.evaluate(t))}],upcase:[Ge,[Ge],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Ge,[Ge],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Ge,Zn(Xe),(t,e)=>e.map((e=>Yi(e.evaluate(t)))).join("")],"resolved-locale":[Ge,[Ye],(t,[e])=>e.evaluate(t).resolvedLocale()]});class ls{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new rr,this._defaultValue=e?function(t){if("color"===t.type&&ts(t.default))return new Di(0,0,0,0);switch(t.type){case"color":return Di.parse(t.default)||null;case"padding":return ji.parse(t.default)||null;case"numberArray":return Vi.parse(t.default)||null;case"colorArray":return Ni.parse(t.default)||null;case"variableAnchorOffsetCollection":return Gi.parse(t.default)||null;case"projectionDefinition":return qi.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,i,r,n,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Ui(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function cs(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in On}function hs(t,e){const i=new nr(On,Gn,[],e?function(t){const e={color:qe,string:Ge,number:Ze,enum:Ge,boolean:$e,formatted:Ke,padding:Je,numberArray:ti,colorArray:Qe,projectionDefinition:We,resolvedImage:ei,variableAnchorOffsetCollection:ii};return"array"===t.type?ri(e[t.value]||Xe,t.length):e[t.type]}(e):void 0),r=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return r?Hn(new ls(r,e)):Xn(i.errors)}class us{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!qn(e.expression),this.globalStateRefs=_s(e.expression)}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._styleExpression.evaluate(t,e,i,r,n,s)}}class ps{constructor(t,e,i,r){this.kind=t,this.zoomStops=i,this._styleExpression=e,this.isStateDependent="camera"!==t&&!qn(e.expression),this.globalStateRefs=_s(e.expression),this.interpolationType=r}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._styleExpression.evaluate(t,e,i,r,n,s)}interpolationFactor(t,e,i){return this.interpolationType?vr.interpolationFactor(this.interpolationType,t,e,i):0}}function ds(t,e){const i=hs(t,e);if("error"===i.result)return i;const r=i.value.expression,n=$n(r);if(!n&&!Yn(e))return Xn([new Ve("","data expressions not supported")]);const s=Wn(r,["zoom"]);if(!s&&!Kn(e))return Xn([new Ve("","zoom expressions not supported")]);const o=ms(r);return o||s?o instanceof Ve?Xn([o]):o instanceof vr&&!Jn(e)?Xn([new Ve("",'"interpolate" expressions cannot be used with this property')]):Hn(o?new ps(n?"camera":"composite",i.value,o.labels,o instanceof vr?o.interpolation:void 0):new us(n?"constant":"source",i.value)):Xn([new Ve("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class fs{constructor(t,e){this._parameters=t,this._specification=e,je(this,is(this._parameters,this._specification))}static deserialize(t){return new fs(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function ms(t){let e=null;if(t instanceof sr)e=ms(t.result);else if(t instanceof Tr){for(const i of t.args)if(e=ms(i),e)break}else(t instanceof fr||t instanceof vr)&&t.input instanceof jn&&"zoom"===t.input.name&&(e=t);return e instanceof Ve||t.eachChild((t=>{const i=ms(t);i instanceof Ve?e=i:!e&&i?e=new Ve("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&i&&e!==i&&(e=new Ve("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function _s(t,e=new Set){return t instanceof Fn&&e.add(t.key),t.eachChild((t=>{_s(t,e)})),e}function gs(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!gs(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const ys={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function xs(t){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};gs(t)||(t=ws(t));const e=hs(t,ys);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,i,r)=>e.value.evaluate(t,i,{},r),needGeometry:bs(t),getGlobalStateRefs:()=>_s(e.value.expression)}}function vs(t,e){return t<e?-1:t>e?1:0}function bs(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(bs(t[e]))return!0;return!1}function ws(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Ts(t[1],t[2],"=="):"!="===e?Ms(Ts(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Ts(t[1],t[2],e):"any"===e?(i=t.slice(1),["any"].concat(i.map(ws))):"all"===e?["all"].concat(t.slice(1).map(ws)):"none"===e?["all"].concat(t.slice(1).map(ws).map(Ms)):"in"===e?Ps(t[1],t.slice(2)):"!in"===e?Ms(Ps(t[1],t.slice(2))):"has"===e?Ss(t[1]):"!has"!==e||Ms(Ss(t[1]));var i}function Ts(t,e,i){switch(t){case"$type":return[`filter-type-${i}`,e];case"$id":return[`filter-id-${i}`,e];default:return[`filter-${i}`,t,e]}}function Ps(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(vs)]]:["filter-in-small",t,["literal",e]]}}function Ss(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function Ms(t){return["!",t]}function Is(t){const e=t.value;return e?[new Oe(t.key,e,"constants have been deprecated as of v8")]:[]}function Cs(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function As(t){if(Array.isArray(t))return t.map(As);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const i in t)e[i]=As(t[i]);return e}return Cs(t)}function Es(t){const e=t.key,i=t.value,r=t.valueSpec||{},n=t.objectElementValidators||{},s=t.style,o=t.styleSpec,a=t.validateSpec;let l=[];const c=Qn(i);if("object"!==c)return[new Oe(e,i,`object expected, ${c} found`)];for(const t in i){const c=t.split(".")[0],h=Mi(r,c)||r["*"];let u;if(Mi(n,c))u=n[c];else if(Mi(r,c))u=a;else if(n["*"])u=n["*"];else{if(!r["*"]){l.push(new Oe(e,i[t],`unknown property "${t}"`));continue}u=a}l=l.concat(u({key:(e?`${e}.`:e)+t,value:i[t],valueSpec:h,style:s,styleSpec:o,object:i,objectKey:t,validateSpec:a},i))}for(const t in r)n[t]||r[t].required&&void 0===r[t].default&&void 0===i[t]&&l.push(new Oe(e,i,`missing required property "${t}"`));return l}function zs(t){const e=t.value,i=t.valueSpec,r=t.style,n=t.styleSpec,s=t.key,o=t.arrayElementValidator||t.validateSpec;if("array"!==Qn(e))return[new Oe(s,e,`array expected, ${Qn(e)} found`)];if(i.length&&e.length!==i.length)return[new Oe(s,e,`array length ${i.length} expected, length ${e.length} found`)];if(i["min-length"]&&e.length<i["min-length"])return[new Oe(s,e,`array length at least ${i["min-length"]} expected, length ${e.length} found`)];let a={type:i.value,values:i.values};n.$version<7&&(a.function=i.function),"object"===Qn(i.value)&&(a=i.value);let l=[];for(let i=0;i<e.length;i++)l=l.concat(o({array:e,arrayIndex:i,value:e[i],valueSpec:a,validateSpec:t.validateSpec,style:r,styleSpec:n,key:`${s}[${i}]`}));return l}function ks(t){const e=t.key,i=t.value,r=t.valueSpec;let n=Qn(i);return"number"===n&&i!=i&&(n="NaN"),"number"!==n?[new Oe(e,i,`number expected, ${n} found`)]:"minimum"in r&&i<r.minimum?[new Oe(e,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new Oe(e,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function Rs(t){const e=t.valueSpec,i=Cs(t.value.type);let r,n,s,o={};const a="categorical"!==i&&void 0===t.value.property,l=!a,c="array"===Qn(t.value.stops)&&"array"===Qn(t.value.stops[0])&&"object"===Qn(t.value.stops[0][0]),h=Es({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===i)return[new Oe(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const r=t.value;return e=e.concat(zs({key:t.key,value:r,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===Qn(r)&&0===r.length&&e.push(new Oe(t.key,r,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===i&&a&&h.push(new Oe(t.key,t.value,'missing required property "property"')),"identity"===i||t.value.stops||h.push(new Oe(t.key,t.value,'missing required property "stops"')),"exponential"===i&&t.valueSpec.expression&&!Jn(t.valueSpec)&&h.push(new Oe(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Yn(t.valueSpec)?h.push(new Oe(t.key,t.value,"property functions not supported")):a&&!Kn(t.valueSpec)&&h.push(new Oe(t.key,t.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==t.value.property||h.push(new Oe(t.key,t.value,'"property" property is required')),h;function u(t){let i=[];const r=t.value,a=t.key;if("array"!==Qn(r))return[new Oe(a,r,`array expected, ${Qn(r)} found`)];if(2!==r.length)return[new Oe(a,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Qn(r[0]))return[new Oe(a,r,`object expected, ${Qn(r[0])} found`)];if(void 0===r[0].zoom)return[new Oe(a,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new Oe(a,r,"object stop key must have value")];if(s&&s>Cs(r[0].zoom))return[new Oe(a,r[0].zoom,"stop zoom values must appear in ascending order")];Cs(r[0].zoom)!==s&&(s=Cs(r[0].zoom),n=void 0,o={}),i=i.concat(Es({key:`${a}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ks,value:p}}))}else i=i.concat(p({key:`${a}[0]`,value:r[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},r));return cs(As(r[1]))?i.concat([new Oe(`${a}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(t.validateSpec({key:`${a}[1]`,value:r[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const a=Qn(t.value),l=Cs(t.value),c=null!==t.value?t.value:s;if(r){if(a!==r)return[new Oe(t.key,c,`${a} stop domain type must match previous stop domain type ${r}`)]}else r=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new Oe(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==i){let r=`number expected, ${a} found`;return Yn(e)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Oe(t.key,c,r)]}return"categorical"!==i||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===a&&void 0!==n&&l<n?[new Oe(t.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in o?[new Oe(t.key,c,"stop domain values must be unique")]:(o[l]=!0,[])):[new Oe(t.key,c,`integer expected, found ${l}`)]}}function Ds(t){const e=("property"===t.expressionContext?ds:hs)(As(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Oe(`${t.key}${e.key}`,t.value,e.message)));const i=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!i.outputDefined())return[new Oe(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!qn(i))return[new Oe(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!qn(i))return[new Oe(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Wn(i,["zoom","feature-state"]))return[new Oe(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!$n(i))return[new Oe(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Ls(t){const e=t.key,i=t.value,r=Qn(i);return"string"!==r?[new Oe(e,i,`color expected, ${r} found`)]:Di.parse(String(i))?[]:[new Oe(e,i,`color expected, "${i}" found`)]}function Bs(t){const e=t.key,i=t.value,r=t.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(Cs(i))&&n.push(new Oe(e,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(Cs(i))&&n.push(new Oe(e,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Fs(t){return gs(As(t.value))?Ds(je({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Os(t)}function Os(t){const e=t.value,i=t.key;if("array"!==Qn(e))return[new Oe(i,e,`array expected, ${Qn(e)} found`)];const r=t.styleSpec;let n,s=[];if(e.length<1)return[new Oe(i,e,"filter array must have at least 1 element")];switch(s=s.concat(Bs({key:`${i}[0]`,value:e[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),Cs(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Cs(e[1])&&s.push(new Oe(i,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Oe(i,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(n=Qn(e[1]),"string"!==n&&s.push(new Oe(`${i}[1]`,e[1],`string expected, ${n} found`)));for(let o=2;o<e.length;o++)n=Qn(e[o]),"$type"===Cs(e[1])?s=s.concat(Bs({key:`${i}[${o}]`,value:e[o],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&s.push(new Oe(`${i}[${o}]`,e[o],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<e.length;r++)s=s.concat(Os({key:`${i}[${r}]`,value:e[r],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":n=Qn(e[1]),2!==e.length?s.push(new Oe(i,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==n&&s.push(new Oe(`${i}[1]`,e[1],`string expected, ${n} found`))}return s}function js(t,e){const i=t.key,r=t.validateSpec,n=t.style,s=t.styleSpec,o=t.value,a=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const c=a.match(/^(.*)-transition$/);if("paint"===e&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:o,valueSpec:s.transition,style:n,styleSpec:s});const h=t.valueSpec||l[a];if(!h)return[new Oe(i,o,`unknown property "${a}"`)];let u;if("string"===Qn(o)&&Yn(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(o)))return[new Oe(i,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&p.push(new Oe(i,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&ts(As(o))&&"identity"===Cs(o.type)&&p.push(new Oe(i,o,'"text-font" does not support identity functions'))),p.concat(r({key:t.key,value:o,valueSpec:h,style:n,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:a}))}function Vs(t){return js(t,"paint")}function Ns(t){return js(t,"layout")}function Us(t){let e=[];const i=t.value,r=t.key,n=t.style,s=t.styleSpec;if("object"!==Qn(i))return[new Oe(r,i,`object expected, ${Qn(i)} found`)];i.type||i.ref||e.push(new Oe(r,i,'either "type" or "ref" is required'));let o=Cs(i.type);const a=Cs(i.ref);if(i.id){const s=Cs(i.id);for(let o=0;o<t.arrayIndex;o++){const t=n.layers[o];Cs(t.id)===s&&e.push(new Oe(r,i.id,`duplicate layer id "${i.id}", previously used at line ${t.id.__line__}`))}}if("ref"in i){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in i&&e.push(new Oe(r,i[t],`"${t}" is prohibited for ref layers`))})),n.layers.forEach((e=>{Cs(e.id)===a&&(t=e)})),t?t.ref?e.push(new Oe(r,i.ref,"ref cannot reference another ref layer")):o=Cs(t.type):e.push(new Oe(r,i.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(i.source){const t=n.sources&&n.sources[i.source],s=t&&Cs(t.type);t?"vector"===s&&"raster"===o?e.push(new Oe(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?e.push(new Oe(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?e.push(new Oe(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==s||i["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?e.push(new Oe(r,i.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!i.paint||!i.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Oe(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Oe(r,i,`layer "${i.id}" must specify a "source-layer"`)):e.push(new Oe(r,i.source,`source "${i.source}" not found`))}else e.push(new Oe(r,i,'missing required property "source"'));return e=e.concat(Es({key:r,value:i,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${r}.type`,value:i.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:i,objectKey:"type"}),filter:Fs,layout:t=>Es({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ns(je({layerType:o},t))}}),paint:t=>Es({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Vs(je({layerType:o},t))}})}})),e}function Zs(t){const e=t.value,i=t.key,r=Qn(e);return"string"!==r?[new Oe(i,e,`string expected, ${r} found`)]:[]}const Gs={promoteId:function({key:t,value:e}){if("string"===Qn(e))return Zs({key:t,value:e});{const i=[];for(const r in e)i.push(...Zs({key:`${t}.${r}`,value:e[r]}));return i}}};function $s(t){const e=t.value,i=t.key,r=t.styleSpec,n=t.style,s=t.validateSpec;if(!e.type)return[new Oe(i,e,'"type" is required')];const o=Cs(e.type);let a;switch(o){case"vector":case"raster":return a=Es({key:i,value:e,valueSpec:r[`source_${o.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:Gs,validateSpec:s}),a;case"raster-dem":return a=function(t){var e;const i=null!==(e=t.sourceName)&&void 0!==e?e:"",r=t.value,n=t.styleSpec,s=n.source_raster_dem,o=t.style;let a=[];const l=Qn(r);if(void 0===r)return a;if("object"!==l)return a.push(new Oe("source_raster_dem",r,`object expected, ${l} found`)),a;const c="custom"===Cs(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in r)!c&&h.includes(e)?a.push(new Oe(e,r[e],`In "${i}": "${e}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):s[e]?a=a.concat(t.validateSpec({key:e,value:r[e],valueSpec:s[e],validateSpec:t.validateSpec,style:o,styleSpec:n})):a.push(new Oe(e,r[e],`unknown property "${e}"`));return a}({sourceName:i,value:e,style:t.style,styleSpec:r,validateSpec:s}),a;case"geojson":if(a=Es({key:i,value:e,valueSpec:r.source_geojson,style:n,styleSpec:r,validateSpec:s,objectElementValidators:Gs}),e.cluster)for(const t in e.clusterProperties){const[r,n]=e.clusterProperties[t],s="string"==typeof r?[r,["accumulated"],["get",t]]:r;a.push(...Ds({key:`${i}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...Ds({key:`${i}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return Es({key:i,value:e,valueSpec:r.source_video,style:n,validateSpec:s,styleSpec:r});case"image":return Es({key:i,value:e,valueSpec:r.source_image,style:n,validateSpec:s,styleSpec:r});case"canvas":return[new Oe(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Bs({key:`${i}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function qs(t){const e=t.value,i=t.styleSpec,r=i.light,n=t.style;let s=[];const o=Qn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Oe("light",e,`object expected, ${o} found`)]),s;for(const o in e){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&r[a[1]]&&r[a[1]].transition?t.validateSpec({key:o,value:e[o],valueSpec:i.transition,validateSpec:t.validateSpec,style:n,styleSpec:i}):r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Oe(o,e[o],`unknown property "${o}"`)])}return s}function Ws(t){const e=t.value,i=t.styleSpec,r=i.sky,n=t.style,s=Qn(e);if(void 0===e)return[];if("object"!==s)return[new Oe("sky",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Oe(s,e[s],`unknown property "${s}"`)]);return o}function Hs(t){const e=t.value,i=t.styleSpec,r=i.terrain,n=t.style;let s=[];const o=Qn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Oe("terrain",e,`object expected, ${o} found`)]),s;for(const o in e)s=s.concat(r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Oe(o,e[o],`unknown property "${o}"`)]);return s}function Xs(t){let e=[];const i=t.value,r=t.key;if(Array.isArray(i)){const n=[],s=[];for(const o in i)i[o].id&&n.includes(i[o].id)&&e.push(new Oe(r,i,`all the sprites' ids must be unique, but ${i[o].id} is duplicated`)),n.push(i[o].id),i[o].url&&s.includes(i[o].url)&&e.push(new Oe(r,i,`all the sprites' URLs must be unique, but ${i[o].url} is duplicated`)),s.push(i[o].url),e=e.concat(Es({key:`${r}[${o}]`,value:i[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Zs({key:r,value:i})}function Ys(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new Oe(t.key,t.value,`object expected, ${Qn(t.value)} found`)];var e}const Ks={"*":()=>[],array:zs,boolean:function(t){const e=t.value,i=t.key,r=Qn(e);return"boolean"!==r?[new Oe(i,e,`boolean expected, ${r} found`)]:[]},number:ks,color:Ls,constants:Is,enum:Bs,filter:Fs,function:Rs,layer:Us,object:Es,source:$s,light:qs,sky:Ws,terrain:Hs,projection:function(t){const e=t.value,i=t.styleSpec,r=i.projection,n=t.style,s=Qn(e);if(void 0===e)return[];if("object"!==s)return[new Oe("projection",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Oe(s,e[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(t){const e=t.key;let i=t.value;i=i instanceof String?i.valueOf():i;const r=Qn(i);return"array"!==r||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(i)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(i)?["array","string"].includes(r)?[]:[new Oe(e,i,`projection expected, invalid type "${r}" found`)]:[new Oe(e,i,`projection expected, invalid array ${JSON.stringify(i)} found`)]},string:Zs,formatted:function(t){return 0===Zs(t).length?[]:Ds(t)},resolvedImage:function(t){return 0===Zs(t).length?[]:Ds(t)},padding:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){if(i.length<1||i.length>4)return[new Oe(e,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let n=[];for(let s=0;s<i.length;s++)n=n.concat(t.validateSpec({key:`${e}[${s}]`,value:i[s],validateSpec:t.validateSpec,valueSpec:r}));return n}return ks({key:e,value:i,valueSpec:{}})},numberArray:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){const r={type:"number"};if(i.length<1)return[new Oe(e,i,"array length at least 1 expected, length 0 found")];let n=[];for(let s=0;s<i.length;s++)n=n.concat(t.validateSpec({key:`${e}[${s}]`,value:i[s],validateSpec:t.validateSpec,valueSpec:r}));return n}return ks({key:e,value:i,valueSpec:{}})},colorArray:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){if(i.length<1)return[new Oe(e,i,"array length at least 1 expected, length 0 found")];let t=[];for(let r=0;r<i.length;r++)t=t.concat(Ls({key:`${e}[${r}]`,value:i[r]}));return t}return Ls({key:e,value:i})},variableAnchorOffsetCollection:function(t){const e=t.key,i=t.value,r=Qn(i),n=t.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new Oe(e,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let r=0;r<i.length;r+=2)s=s.concat(Bs({key:`${e}[${r}]`,value:i[r],valueSpec:n.layout_symbol["text-anchor"]})),s=s.concat(zs({key:`${e}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:n}));return s},sprite:Xs,state:Ys};function Js(t){const e=t.value,i=t.valueSpec,r=t.styleSpec;return t.validateSpec=Js,i.expression&&ts(Cs(e))?Rs(t):i.expression&&cs(As(e))?Ds(t):i.type&&Ks[i.type]?Ks[i.type](t):Es(je({},t,{valueSpec:i.type?r[i.type]:i}))}function Qs(t){const e=t.value,i=t.key,r=Zs(t);return r.length||(-1===e.indexOf("{fontstack}")&&r.push(new Oe(i,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&r.push(new Oe(i,e,'"glyphs" url must include a "{range}" token'))),r}function to(t,e=Se){let i=[];return i=i.concat(Js({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Js,objectElementValidators:{glyphs:Qs,"*":()=>[]}})),t.constants&&(i=i.concat(Is({key:"constants",value:t.constants}))),io(i)}function eo(t){return function(e){return t({...e,validateSpec:Js})}}function io(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function ro(t){return function(...e){return io(t.apply(this,e))}}to.source=ro(eo($s)),to.sprite=ro(eo(Xs)),to.glyphs=ro(eo(Qs)),to.light=ro(eo(qs)),to.sky=ro(eo(Ws)),to.terrain=ro(eo(Hs)),to.state=ro(eo(Ys)),to.layer=ro(eo(Us)),to.filter=ro(eo(Fs)),to.paintProperty=ro(eo(Vs)),to.layoutProperty=ro(eo(Ns));const no=to,so=no.light,oo=no.sky,ao=no.paintProperty,lo=no.layoutProperty;function co(t,e){let i=!1;if(e&&e.length)for(const r of e)t.fire(new Te(new Error(r.message))),i=!0;return i}class ho{constructor(t,e,i){const r=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(i=n[2]);for(let t=0;t<this.d*this.d;t++){const e=n[3+t],i=n[3+t+1];r.push(e===i?null:n.subarray(e,i))}const s=n[3+r.length+1];this.keys=n.subarray(n[3+r.length],s),this.bboxes=n.subarray(s),this.insert=this._insertReadonly}else{this.d=e+2*i;for(let t=0;t<this.d*this.d;t++)r.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=i,this.scale=e/t,this.uid=0;const n=i/e*t;this.min=-n,this.max=t+n}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,i,r,n,s){this.cells[n].push(s)}query(t,e,i,r,n){const s=this.min,o=this.max;if(t<=s&&e<=s&&o<=i&&o<=r&&!n)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,i,r,this._queryCell,s,{},n),s}}_queryCell(t,e,i,r,n,s,o,a){const l=this.cells[n];if(null!==l){const n=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===o[u]){const l=4*u;(a?a(c[l+0],c[l+1],c[l+2],c[l+3]):t<=c[l+2]&&e<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(o[u]=!0,s.push(n[u])):o[u]=!1}}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++){const c=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&n.call(this,t,e,i,r,c,s,o,a))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let i=0;for(let t=0;t<this.cells.length;t++)i+=this.cells[t].length;const r=new Int32Array(e+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let n=e;for(let e=0;e<t.length;e++){const i=t[e];r[3+e]=n,r.set(i,n),n+=i.length}return r[3+t.length]=n,r.set(this.keys,n),n+=this.keys.length,r[3+t.length+1]=n,r.set(this.bboxes,n),n+=this.bboxes.length,r.buffer}static serialize(t,e){const i=t.toArrayBuffer();return e&&e.push(i),{buffer:i}}static deserialize(t){return new ho(t.buffer)}}const uo={};function po(t,e,i={}){if(uo[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),uo[t]={klass:e,omit:i.omit||[],shallow:i.shallow||[]}}po("Object",Object),po("Set",Set),po("TransferableGridIndex",ho),po("Color",Di),po("Error",Error),po("AJAXError",ae),po("ResolvedImage",$i),po("StylePropertyFunction",fs),po("StyleExpression",ls,{omit:["_evaluator"]}),po("ZoomDependentExpression",ps),po("ZoomConstantExpression",us),po("CompoundExpression",jn,{omit:["_evaluate"]});for(const t in On)On[t]._classRegistryKey||po(`Expression_${t}`,On[t]);function fo(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function mo(t){return t.$name||t.constructor._classRegistryKey}function _o(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=mo(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||fo(t)||Vt(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function go(t,e){if(_o(t))return(fo(t)||Vt(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const i=[];for(const r of t)i.push(go(r,e));return i}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const i=mo(t);if(!i)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!uo[i])throw new Error(`${i} is not registered.`);const{klass:r}=uo[i],n=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&n===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in t){if(!t.hasOwnProperty(r))continue;if(uo[i].omit.indexOf(r)>=0)continue;const s=t[r];n[r]=uo[i].shallow.indexOf(r)>=0?s:go(s,e)}t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(n.$name=i),n}function yo(t){if(_o(t))return t;if(Array.isArray(t))return t.map(yo);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=mo(t)||"Object";if(!uo[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:i}=uo[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const i of Object.keys(t)){if("$name"===i)continue;const n=t[i];r[i]=uo[e].shallow.indexOf(i)>=0?n:yo(n)}return r}class xo{constructor(){this.first=!0}update(t,e){const i=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=i,!0))}}const vo=t=>t>=12288&&t<=12351,bo=t=>t>=12448&&t<=12543,wo=t=>t>=65280&&t<=65519;function To(t){for(const e of t)if(Mo(e.charCodeAt(0)))return!0;return!1}function Po(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}Po(["Arab","Dupl","Mong","Ougr","Syrc"]);const So=Po(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Mo(t){return!(746!==t&&747!==t&&(t<4352||!((t=>t>=65072&&t<=65103)(t)&&!(t>=65097&&t<=65103)||(t=>t>=13056&&t<=13311)(t)||(t=>t>=12736&&t<=12783)(t)||!(!vo(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||(t=>t>=12800&&t<=13055)(t)||(t=>t>=12272&&t<=12287)(t)||(t=>t>=12688&&t<=12703)(t)||bo(t)&&12540!==t||!(!wo(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!(t=>t>=65104&&t<=65135)(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=65040&&t<=65055)(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||So.test(String.fromCodePoint(t)))))}const Io=Po(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Co(t){return Io.test(String.fromCodePoint(t))}function Ao(t,e){return!(!e&&Co(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Eo(t){for(const e of t)if(Co(e.charCodeAt(0)))return!0;return!1}const zo=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(zo.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,e){return n(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const i=t.pluginURL,r=new Promise((t=>{this.loadScriptResolve=t}));e(i);const n=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([r,n]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:i};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${i}`)}))}};class ko{constructor(t,e){this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new xo,this.transition=e.transition||{},this.globalState=e.globalState||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new xo,this.transition={},this.globalState={})}isSupportedScript(t){return function(t,e){for(const i of t)if(!Ao(i.charCodeAt(0),e))return!1;return!0}(t,"loaded"===zo.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),i=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*e}}}class Ro{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(ts(t))return new fs(t,e);if(cs(t)){const i=ds(t,e);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let i=t;return"color"===e.type&&"string"==typeof t?i=Di.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?i=Gi.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(i=qi.parse(t)):i=Ni.parse(t):i=Vi.parse(t):i=ji.parse(t),{globalStateRefs:new Set,kind:"constant",evaluate:()=>i}}}(void 0===e?t.specification.default:e,t.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,i){return this.property.possiblyEvaluate(this,t,e,i)}}class Do{constructor(t){this.property=t,this.value=new Ro(t,void 0)}transitioned(t,e){return new Bo(this.property,this.value,e,St({},t.transition,this.transition),t.now)}untransitioned(){return new Bo(this.property,this.value,null,{},0)}}class Lo{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues)}getValue(t){return Dt(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Do(this._values[t].property)),this._values[t].value=new Ro(this._values[t].property,null===e?void 0:Dt(e))}getTransition(t){return Dt(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Do(this._values[t].property)),this._values[t].transition=Dt(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i);const r=this.getTransition(e);void 0!==r&&(t[`${e}-transition`]=r)}return t}transitioned(t,e){const i=new Fo(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(t,e._values[r]);return i}untransitioned(){const t=new Fo(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Bo{constructor(t,e,i,r,n){this.property=t,this.value=e,this.begin=n+r.delay||0,this.end=this.begin+r.duration||0,t.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(t,e,i){const r=t.now||0,n=this.value.possiblyEvaluate(t,e,i),s=this.prior;if(s){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return s.possiblyEvaluate(t,e,i);{const o=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,i),n,vt(o))}}return n}}class Fo{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,i){const r=new Vo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class Oo{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues)}hasValue(t){return void 0!==this._values[t].value}getValue(t){return Dt(this._values[t].value)}setValue(t,e){this._values[t]=new Ro(this._values[t].property,null===e?void 0:Dt(e))}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i)}return t}possiblyEvaluate(t,e,i){const r=new Vo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}}class jo{constructor(t,e,i){this.property=t,this.value=e,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,i,r){return this.property.evaluate(this.value,this.parameters,t,e,i,r)}}class Vo{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class No{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,i){const r=wr[this.specification.type];return r?r(t,e,i):t}}class Uo{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,i,r){return new jo(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},i,r)}:t.expression,e)}interpolate(t,e,i){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new jo(this,{kind:"constant",value:void 0},t.parameters);const r=wr[this.specification.type];if(r){const n=r(t.value.value,e.value.value,i);return new jo(this,{kind:"constant",value:n},t.parameters)}return t}evaluate(t,e,i,r,n,s){return"constant"===t.kind?t.value:t.evaluate(e,i,r,n,s)}}class Zo extends Uo{possiblyEvaluate(t,e,i,r){if(void 0===t.value)return new jo(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r),s="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,o=this._calculate(s,s,s,e);return new jo(this,{kind:"constant",value:o},e)}if("camera"===t.expression.kind){const i=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new jo(this,{kind:"constant",value:i},e)}return new jo(this,t.expression,e)}evaluate(t,e,i,r,n,s){if("source"===t.kind){const o=t.evaluate(e,i,r,n,s);return this._calculate(o,o,o,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},i,r),t.evaluate({zoom:Math.floor(e.zoom)},i,r),t.evaluate({zoom:Math.floor(e.zoom)+1},i,r),e):t.value}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class Go{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new ko(Math.floor(e.zoom-1),e)),t.expression.evaluate(new ko(Math.floor(e.zoom),e)),t.expression.evaluate(new ko(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class $o{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){return!!t.expression.evaluate(e,null,{},i,r)}interpolate(){return!1}}class qo{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const i=t[e];i.specification.overridable&&this.overridableProperties.push(e);const r=this.defaultPropertyValues[e]=new Ro(i,void 0),n=this.defaultTransitionablePropertyValues[e]=new Do(i);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=r.possiblyEvaluate({})}}}po("DataDrivenProperty",Uo),po("DataConstantProperty",No),po("CrossFadedDataDrivenProperty",Zo),po("CrossFadedProperty",Go),po("ColorRampProperty",$o);const Wo="-transition";class Ho extends Pe{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=xs(t.filter)),e.layout&&(this._unevaluatedLayout=new Oo(e.layout)),e.paint)){this._transitionablePaint=new Lo(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Vo(e.paint)}}setFilter(t){this.filter=t,this._featureFilter=xs(t)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const i=this._unevaluatedLayout._values[e];for(const e of i.getGlobalStateRefs())t.add(e)}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}setLayoutProperty(t,e,i={}){null!=e&&this._validate(lo,`layers.${this.id}.layout.${t}`,t,e,i)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(Wo)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,i={}){if(null!=e&&this._validate(ao,`layers.${this.id}.paint.${t}`,t,e,i))return!1;if(t.endsWith(Wo))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const i=this._transitionablePaint._values[t],r="cross-faded-data-driven"===i.property.specification["property-type"],n=i.value.isDataDriven(),s=i.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const o=this._transitionablePaint._values[t].value;return o.isDataDriven()||n||r||this._handleOverridablePaintPropertyUpdate(t,s,o)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,i){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),kt(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&co(this,t.call(no,{key:e,layerType:this.type,objectKey:i,value:r,styleSpec:Se,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof jo&&Yn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const Xo={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Yo{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class Ko{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Jo(t,e=1){let i=0,r=0;return{members:t.map((t=>{const n=Xo[t.type].BYTES_PER_ELEMENT,s=i=Qo(i,Math.max(e,n)),o=t.components||1;return r=Math.max(r,n),i+=n*o,{name:t.name,type:t.type,components:o,offset:s}})),size:Qo(i,Math.max(r,e)),alignment:e}}function Qo(t,e){return Math.ceil(t/e)*e}class ta extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.int16[r+0]=e,this.int16[r+1]=i,t}}ta.prototype.bytesPerElement=4,po("StructArrayLayout2i4",ta);class ea extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=i,this.int16[n+2]=r,t}}ea.prototype.bytesPerElement=6,po("StructArrayLayout3i6",ea);class ia extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=i,this.int16[s+2]=r,this.int16[s+3]=n,t}}ia.prototype.bytesPerElement=8,po("StructArrayLayout4i8",ia);class ra extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}ra.prototype.bytesPerElement=12,po("StructArrayLayout2i4i12",ra);class na extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=4*t,l=8*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=n,this.uint8[l+6]=s,this.uint8[l+7]=o,t}}na.prototype.bytesPerElement=8,po("StructArrayLayout2i4ub8",na);class sa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.float32[r+0]=e,this.float32[r+1]=i,t}}sa.prototype.bytesPerElement=8,po("StructArrayLayout2f8",sa);class oa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,i,r,n,s,o,a,l,c)}emplace(t,e,i,r,n,s,o,a,l,c,h){const u=10*t;return this.uint16[u+0]=e,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=n,this.uint16[u+4]=s,this.uint16[u+5]=o,this.uint16[u+6]=a,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,t}}oa.prototype.bytesPerElement=20,po("StructArrayLayout10ui20",oa);class aa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,i,r,n,s,o,a,l,c,h,u)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=i,this.int16[d+2]=r,this.int16[d+3]=n,this.uint16[d+4]=s,this.uint16[d+5]=o,this.uint16[d+6]=a,this.uint16[d+7]=l,this.int16[d+8]=c,this.int16[d+9]=h,this.int16[d+10]=u,this.int16[d+11]=p,t}}aa.prototype.bytesPerElement=24,po("StructArrayLayout4i4ui4i24",aa);class la extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}la.prototype.bytesPerElement=12,po("StructArrayLayout3f12",la);class ca extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ca.prototype.bytesPerElement=4,po("StructArrayLayout1ul4",ca);class ha extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,i,r,n,s,o,a,l)}emplace(t,e,i,r,n,s,o,a,l,c){const h=10*t,u=5*t;return this.int16[h+0]=e,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=n,this.int16[h+4]=s,this.int16[h+5]=o,this.uint32[u+3]=a,this.uint16[h+8]=l,this.uint16[h+9]=c,t}}ha.prototype.bytesPerElement=20,po("StructArrayLayout6i1ul2ui20",ha);class ua extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}ua.prototype.bytesPerElement=12,po("StructArrayLayout2i2i2i12",ua);class pa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n)}emplace(t,e,i,r,n,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=i,this.float32[o+2]=r,this.int16[a+6]=n,this.int16[a+7]=s,t}}pa.prototype.bytesPerElement=16,po("StructArrayLayout2f1f2i16",pa);class da extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=16*t,l=4*t,c=8*t;return this.uint8[a+0]=e,this.uint8[a+1]=i,this.float32[l+1]=r,this.float32[l+2]=n,this.int16[c+6]=s,this.int16[c+7]=o,t}}da.prototype.bytesPerElement=16,po("StructArrayLayout2ub2f2i16",da);class fa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=i,this.uint16[n+2]=r,t}}fa.prototype.bytesPerElement=6,po("StructArrayLayout3ui6",fa);class ma extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g){const y=24*t,x=12*t,v=48*t;return this.int16[y+0]=e,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=n,this.uint32[x+2]=s,this.uint32[x+3]=o,this.uint32[x+4]=a,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=p,this.uint8[v+36]=d,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,t}}ma.prototype.bytesPerElement=48,po("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",ma);class _a extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I){const C=this.length;return this.resize(C+1),this.emplace(C,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,S,M,I,C){const A=32*t,E=16*t;return this.int16[A+0]=e,this.int16[A+1]=i,this.int16[A+2]=r,this.int16[A+3]=n,this.int16[A+4]=s,this.int16[A+5]=o,this.int16[A+6]=a,this.int16[A+7]=l,this.uint16[A+8]=c,this.uint16[A+9]=h,this.uint16[A+10]=u,this.uint16[A+11]=p,this.uint16[A+12]=d,this.uint16[A+13]=f,this.uint16[A+14]=m,this.uint16[A+15]=_,this.uint16[A+16]=g,this.uint16[A+17]=y,this.uint16[A+18]=x,this.uint16[A+19]=v,this.uint16[A+20]=b,this.uint16[A+21]=w,this.uint16[A+22]=T,this.uint32[E+12]=P,this.float32[E+13]=S,this.float32[E+14]=M,this.uint16[A+30]=I,this.uint16[A+31]=C,t}}_a.prototype.bytesPerElement=64,po("StructArrayLayout8i15ui1ul2f2ui64",_a);class ga extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}ga.prototype.bytesPerElement=4,po("StructArrayLayout1f4",ga);class ya extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[6*t+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}ya.prototype.bytesPerElement=12,po("StructArrayLayout1ui2f12",ya);class xa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=4*t;return this.uint32[2*t+0]=e,this.uint16[n+2]=i,this.uint16[n+3]=r,t}}xa.prototype.bytesPerElement=8,po("StructArrayLayout1ul2ui8",xa);class va extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.uint16[r+0]=e,this.uint16[r+1]=i,t}}va.prototype.bytesPerElement=4,po("StructArrayLayout2ui4",va);class ba extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}ba.prototype.bytesPerElement=2,po("StructArrayLayout1ui2",ba);class wa extends Ko{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,this.float32[s+3]=n,t}}wa.prototype.bytesPerElement=16,po("StructArrayLayout4f16",wa);class Ta extends Yo{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new c(this.anchorPointX,this.anchorPointY)}}Ta.prototype.size=20;class Pa extends ha{get(t){return new Ta(this,t)}}po("CollisionBoxArray",Pa);class Sa extends Yo{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Sa.prototype.size=48;class Ma extends ma{get(t){return new Sa(this,t)}}po("PlacedSymbolArray",Ma);class Ia extends Yo{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Ia.prototype.size=64;class Ca extends _a{get(t){return new Ia(this,t)}}po("SymbolInstanceArray",Ca);class Aa extends ga{getoffsetX(t){return this.float32[1*t+0]}}po("GlyphOffsetArray",Aa);class Ea extends ea{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}po("SymbolLineVertexArray",Ea);class za extends Yo{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}za.prototype.size=12;class ka extends ya{get(t){return new za(this,t)}}po("TextAnchorOffsetArray",ka);class Ra extends Yo{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ra.prototype.size=8;class Da extends xa{get(t){return new Ra(this,t)}}po("FeatureIndexArray",Da);class La extends ta{}class Ba extends ea{}class Fa extends ia{}class Oa extends ta{}class ja extends ta{}class Va extends ra{}class Na extends na{}class Ua extends sa{}class Za extends oa{}class Ga extends aa{}class $a extends la{}class qa extends ca{}class Wa extends ua{}class Ha extends pa{}class Xa extends da{}class Ya extends fa{}class Ka extends fa{}class Ja extends va{}class Qa extends ba{}const tl=Jo([{name:"a_pos",components:2,type:"Int16"}],4),{members:el}=tl;class il{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,i,r){const n=this.segments[this.segments.length-1];return t>il.MAX_VERTEX_ARRAY_LENGTH&&Bt(`Max vertices per segment is ${il.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${il.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!n||n.vertexLength+t>il.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r?this.createNewSegment(e,i,r):n}createNewSegment(t,e,i){const r={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==i&&(r.sortKey=i),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(r),r}getOrCreateLatestSegment(t,e,i){return this.prepareSegment(0,t,e,i)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,i,r){return new il([{vertexOffset:t,primitiveOffset:e,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function rl(t,e){return 256*(t=Tt(Math.floor(t),0,255))+Tt(Math.floor(e),0,255)}il.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,po("SegmentVector",il);const nl=Jo([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var sl,ol,al,ll={exports:{}},cl={exports:{}},hl={exports:{}},ul=function(){if(al)return ll.exports;al=1;var t=(sl||(sl=1,function(t){t.exports=function(t,e){var i,r,n,s,o,a,l,c;for(r=t.length-(i=3&t.length),n=e,o=3432918353,a=461845907,c=0;c<r;)l=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&t.charCodeAt(c+2))<<16;case 2:l^=(255&t.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(c)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(cl)),cl.exports),e=(ol||(ol=1,function(t){t.exports=function(t,e){for(var i,r=t.length,n=e^r,s=0;r>=4;)i=1540483477*(65535&(i=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++s;switch(r){case 3:n^=(255&t.charCodeAt(s+2))<<16;case 2:n^=(255&t.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(hl)),hl.exports);return ll.exports=t,ll.exports.murmur3=t,ll.exports.murmur2=e,ll.exports}(),pl=s(ul);class dl{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,i,r){this.ids.push(fl(t)),this.positions.push(e,i,r)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=fl(t);let i=0,r=this.ids.length-1;for(;i<r;){const t=i+r>>1;this.ids[t]>=e?r=t:i=t+1}const n=[];for(;this.ids[i]===e;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(t,e){const i=new Float64Array(t.ids),r=new Uint32Array(t.positions);return ml(i,r,0,i.length-1),e&&e.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(t){const e=new dl;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function fl(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:pl(String(t))}function ml(t,e,i,r){for(;i<r;){const n=t[i+r>>1];let s=i-1,o=r+1;for(;;){do{s++}while(t[s]<n);do{o--}while(t[o]>n);if(s>=o)break;_l(t,s,o),_l(e,3*s,3*o),_l(e,3*s+1,3*o+1),_l(e,3*s+2,3*o+2)}o-i<r-o?(ml(t,e,i,o),i=o+1):(ml(t,e,o+1,r),r=o)}}function _l(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}po("FeaturePositionMap",dl);class gl{constructor(t,e){this.gl=t.gl,this.location=e}}class yl extends gl{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t))}}class xl extends gl{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class vl extends gl{constructor(t,e){super(t,e),this.current=[0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]))}}class bl extends gl{constructor(t,e){super(t,e),this.current=[0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]))}}class wl extends gl{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class Tl extends gl{constructor(t,e){super(t,e),this.current=Di.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}class Pl extends gl{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let i=0;i<t.length;i++)e[4*i]=t[i].r,e[4*i+1]=t[i].g,e[4*i+2]=t[i].b,e[4*i+3]=t[i].a;this.gl.uniform4fv(this.location,e)}}}class Sl extends gl{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e)}}}const Ml=new Float32Array(16);class Il extends gl{constructor(t,e){super(t,e),this.current=Ml}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}}function Cl(t){return[rl(255*t.r,255*t.g),rl(255*t.b,255*t.a)]}class Al{constructor(t,e,i){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=i}setUniform(t,e,i){t.set(i.constantOr(this.value))}getBinding(t,e,i){return"color"===this.type?new Tl(t,e):new xl(t,e)}}class El{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,i,r){const n="u_pattern_to"===r?this.patternTo:"u_pattern_from"===r?this.patternFrom:"u_pixel_ratio_to"===r?this.pixelRatioTo:"u_pixel_ratio_from"===r?this.pixelRatioFrom:null;n&&t.set(n)}getBinding(t,e,i){return"u_pattern"===i.substr(0,9)?new wl(t,e):new xl(t,e)}}class zl{constructor(t,e,i,r){this.expression=t,this.type=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(t,e,i,r,n){const s=this.paintVertexArray.length,o=this.expression.evaluate(new ko(0),e,{},r,[],n);this.paintVertexArray.resize(t),this._setPaintValue(s,t,o)}updatePaintArray(t,e,i,r){const n=this.expression.evaluate({zoom:0},i,r);this._setPaintValue(t,e,n)}_setPaintValue(t,e,i){if("color"===this.type){const r=Cl(i);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class kl{constructor(t,e,i,r,n,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(t,e,i,r,n){const s=this.expression.evaluate(new ko(this.zoom),e,{},r,[],n),o=this.expression.evaluate(new ko(this.zoom+1),e,{},r,[],n),a=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(a,t,s,o)}updatePaintArray(t,e,i,r){const n=this.expression.evaluate({zoom:this.zoom},i,r),s=this.expression.evaluate({zoom:this.zoom+1},i,r);this._setPaintValue(t,e,n,s)}_setPaintValue(t,e,i,r){if("color"===this.type){const n=Cl(i),s=Cl(r);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,n[0],n[1],s[0],s[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const i=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,r=Tt(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);t.set(r)}getBinding(t,e,i){return new xl(t,e)}}class Rl{constructor(t,e,i,r,n,s){this.expression=t,this.type=e,this.useIntegerZoom=i,this.zoom=r,this.layerId=s,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n}populatePaintArray(t,e,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(r,t,e.patterns&&e.patterns[this.layerId],i)}updatePaintArray(t,e,i,r,n){this._setPaintValues(t,e,i.patterns&&i.patterns[this.layerId],n)}_setPaintValues(t,e,i,r){if(!r||!i)return;const{min:n,mid:s,max:o}=i,a=r[n],l=r[s],c=r[o];if(a&&l&&c)for(let i=t;i<e;i++)this.zoomInPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],a.tl[0],a.tl[1],a.br[0],a.br[1],l.pixelRatio,a.pixelRatio),this.zoomOutPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],c.tl[0],c.tl[1],c.br[0],c.br[1],l.pixelRatio,c.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,nl.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,nl.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class Dl{constructor(t,e,i){this.binders={},this._buffers=[];const r=[];for(const n in t.paint._values){if(!i(n))continue;const s=t.paint.get(n);if(!(s instanceof jo&&Yn(s.property.specification)))continue;const o=Bl(n,t.type),a=s.value,l=s.property.specification.type,c=s.property.useIntegerZoom,h=s.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===a.kind)this.binders[n]=u?new El(a.value,o):new Al(a.value,o,l),r.push(`/u_${n}`);else if("source"===a.kind||u){const i=Fl(n,l,"source");this.binders[n]=u?new Rl(a,l,c,e,i,t.id):new zl(a,o,l,i),r.push(`/a_${n}`)}else{const t=Fl(n,l,"composite");this.binders[n]=new kl(a,o,l,c,e,t),r.push(`/z_${n}`)}}this.cacheKey=r.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof zl||e instanceof kl?e.maxValue:0}populatePaintArrays(t,e,i,r,n){for(const s in this.binders){const o=this.binders[s];(o instanceof zl||o instanceof kl||o instanceof Rl)&&o.populatePaintArray(t,e,i,r,n)}}setConstantPatternPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof El&&r.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,i,r,n){let s=!1;for(const o in t){const a=e.getPositions(o);for(const e of a){const a=i.feature(e.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof zl||l instanceof kl||l instanceof Rl)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(e.start,e.end,a,t[o],n),s=!0}}}}return s}defines(){const t=[];for(const e in this.binders){const i=this.binders[e];(i instanceof Al||i instanceof El)&&t.push(...i.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof zl||i instanceof kl)for(let e=0;e<i.paintVertexAttributes.length;e++)t.push(i.paintVertexAttributes[e].name);else if(i instanceof Rl)for(let e=0;e<nl.members.length;e++)t.push(nl.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof Al||i instanceof El||i instanceof kl)for(const e of i.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const i=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Al||n instanceof El||n instanceof kl)for(const s of n.uniformNames)if(e[s]){const o=n.getBinding(t,e[s],s);i.push({name:s,property:r,binding:o})}}return i}setUniforms(t,e,i,r){for(const{name:t,property:n,binding:s}of e)this.binders[n].setUniform(s,r,i.get(n),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const i=this.binders[e];if(t&&i instanceof Rl){const e=2===t.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(i instanceof zl||i instanceof kl)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(t){for(const e in this.binders){const i=this.binders[e];(i instanceof zl||i instanceof kl||i instanceof Rl)&&i.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof zl||e instanceof kl||e instanceof Rl)&&e.destroy()}}}class Ll{constructor(t,e,i=()=>!0){this.programConfigurations={};for(const r of t)this.programConfigurations[r.id]=new Dl(r,e,i);this.needsUpload=!1,this._featureMap=new dl,this._bufferOffset=0}populatePaintArrays(t,e,i,r,n,s){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(t,e,r,n,s);void 0!==e.id&&this._featureMap.add(e.id,i,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,i,r){for(const n of i)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,r)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function Bl(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Fl(t,e,i){const r={color:{source:sa,composite:wa},number:{source:ga,composite:sa}},n=function(t){return{"line-pattern":{source:Za,composite:Za},"fill-pattern":{source:Za,composite:Za},"fill-extrusion-pattern":{source:Za,composite:Za}}[t]}(t);return n&&n[i]||r[e][i]}po("ConstantBinder",Al),po("CrossFadedConstantBinder",El),po("SourceExpressionBinder",zl),po("CrossFadedCompositeBinder",Rl),po("CompositeExpressionBinder",kl),po("ProgramConfiguration",Dl,{omit:["_buffers"]}),po("ProgramConfigurationSet",Ll);const Ol=Math.pow(2,14)-1,jl=-Ol-1;function Vl(t){const e=it/t.extent,i=t.loadGeometry();for(let t=0;t<i.length;t++){const r=i[t];for(let t=0;t<r.length;t++){const i=r[t],n=Math.round(i.x*e),s=Math.round(i.y*e);i.x=Tt(n,jl,Ol),i.y=Tt(s,jl,Ol),(n<i.x||n>i.x+1||s<i.y||s>i.y+1)&&Bt("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function Nl(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Vl(t):[]}}const Ul=-32768;function Zl(t,e,i,r,n){t.emplaceBack(Ul+8*e+r,Ul+8*i+n)}class Gl{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Oa,this.indexArray=new Ka,this.segments=new il,this.programConfigurations=new Ll(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){const r=this.layers[0],n=[];let s=null,o=!1,a="heatmap"===r.type;if("circle"===r.type){const t=r;s=t.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===t.paint.get("circle-pitch-alignment")}const l=a?e.subdivisionGranularity.circle:1;for(const{feature:e,id:r,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Nl(e,t);if(!this.layers[0]._featureFilter.filter(new ko(this.zoom,{globalState:this.globalState}),c,i))continue;const h=o?s.evaluate(c,{},i):void 0,u={id:r,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:Vl(e),patterns:{},sortKey:h};n.push(u)}o&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:n,index:s,sourceLayerIndex:o}=r,a=t[s].feature;this.addFeature(r,n,s,i,l),e.featureIndex.insert(a,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,el),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,i,r,n=1){let s;switch(n){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${n}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const i of e)for(const e of i){const i=e.x,r=e.y;if(i<0||i>=it||r<0||r>=it)continue;const n=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,t.sortKey),a=n.vertexLength;for(let t=0;t<o;t++)for(let e=0;e<o;e++)Zl(this.layoutVertexArray,i,r,s[e],s[t]);for(let t=0;t<o-1;t++)for(let e=0;e<o-1;e++){const i=a+t*o+e,r=a+(t+1)*o+e;this.indexArray.emplaceBack(i,r+1,i+1),this.indexArray.emplaceBack(i,r,r+1)}n.vertexLength+=o*o,n.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{},r)}}function $l(t,e){for(let i=0;i<t.length;i++)if(tc(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(tc(t,e[i]))return!0;return!!Xl(t,e)}function ql(t,e,i){return!!tc(t,e)||!!Kl(e,t,i)}function Wl(t,e){if(1===t.length)return Ql(e,t[0]);for(let i=0;i<e.length;i++){const r=e[i];for(let e=0;e<r.length;e++)if(tc(t,r[e]))return!0}for(let i=0;i<t.length;i++)if(Ql(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(Xl(t,e[i]))return!0;return!1}function Hl(t,e,i){if(t.length>1){if(Xl(t,e))return!0;for(let r=0;r<e.length;r++)if(Kl(e[r],t,i))return!0}for(let r=0;r<t.length;r++)if(Kl(t[r],e,i))return!0;return!1}function Xl(t,e){if(0===t.length||0===e.length)return!1;for(let i=0;i<t.length-1;i++){const r=t[i],n=t[i+1];for(let t=0;t<e.length-1;t++)if(Yl(r,n,e[t],e[t+1]))return!0}return!1}function Yl(t,e,i,r){return Ft(t,i,r)!==Ft(e,i,r)&&Ft(t,e,i)!==Ft(t,e,r)}function Kl(t,e,i){const r=i*i;if(1===e.length)return t.distSqr(e[0])<r;for(let i=1;i<e.length;i++)if(Jl(t,e[i-1],e[i])<r)return!0;return!1}function Jl(t,e,i){const r=e.distSqr(i);if(0===r)return t.distSqr(e);const n=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/r;return t.distSqr(n<0?e:n>1?i:i.sub(e)._mult(n)._add(e))}function Ql(t,e){let i,r,n,s=!1;for(let o=0;o<t.length;o++){i=t[o];for(let t=0,o=i.length-1;t<i.length;o=t++)r=i[t],n=i[o],r.y>e.y!=n.y>e.y&&e.x<(n.x-r.x)*(e.y-r.y)/(n.y-r.y)+r.x&&(s=!s)}return s}function tc(t,e){let i=!1;for(let r=0,n=t.length-1;r<t.length;n=r++){const s=t[r],o=t[n];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(i=!i)}return i}function ec(t,e,i){const r=i[0],n=i[2];if(t.x<r.x&&e.x<r.x||t.x>n.x&&e.x>n.x||t.y<r.y&&e.y<r.y||t.y>n.y&&e.y>n.y)return!1;const s=Ft(t,e,i[0]);return s!==Ft(t,e,i[1])||s!==Ft(t,e,i[2])||s!==Ft(t,e,i[3])}function ic(t,e,i){const r=e.paint.get(t).value;return"constant"===r.kind?r.value:i.programConfigurations.get(e.id).getMaxValue(t)}function rc(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function nc(t,e,i,r,n){if(!e[0]&&!e[1])return t;const s=c.convert(e)._mult(n);"viewport"===i&&s._rotate(-r);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}let sc,oc;po("CircleBucket",Gl,{omit:["layers"]});var ac={get paint(){return oc=oc||new qo({"circle-radius":new Uo(Se.paint_circle["circle-radius"]),"circle-color":new Uo(Se.paint_circle["circle-color"]),"circle-blur":new Uo(Se.paint_circle["circle-blur"]),"circle-opacity":new Uo(Se.paint_circle["circle-opacity"]),"circle-translate":new No(Se.paint_circle["circle-translate"]),"circle-translate-anchor":new No(Se.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new No(Se.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new No(Se.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Uo(Se.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Uo(Se.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Uo(Se.paint_circle["circle-stroke-opacity"])})},get layout(){return sc=sc||new qo({"circle-sort-key":new Uo(Se.layout_circle["circle-sort-key"])})}};class lc extends Ho{constructor(t){super(t,ac)}createBucket(t){return new Gl(t)}queryRadius(t){const e=t;return ic("circle-radius",this,e)+ic("circle-stroke-width",this,e)+rc(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=nc(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-n.bearingInRadians,s),c=this.paint.get("circle-radius").evaluate(e,i)+this.paint.get("circle-stroke-width").evaluate(e,i),h="map"===this.paint.get("circle-pitch-alignment"),u=h?l:function(t,e,i,r){return t.map((t=>cc(t,e,i,r)))}(l,n,o,a),p=h?c*s:c;for(const t of r)for(const e of t){const t=h?e:cc(e,n,o,a);let i=p;const r=n.projectTileCoordinates(e.x,e.y,o,a).signedDistanceFromCamera;if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?i*=r/n.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(i*=n.cameraToCenterDistance/r),ql(u,t,i))return!0}return!1}}function cc(t,e,i,r){const n=e.projectTileCoordinates(t.x,t.y,i,r).point;return new c((.5*n.x+.5)*e.width,(.5*-n.y+.5)*e.height)}class hc extends Gl{}let uc;po("HeatmapBucket",hc,{omit:["layers"]});var pc={get paint(){return uc=uc||new qo({"heatmap-radius":new Uo(Se.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Uo(Se.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new No(Se.paint_heatmap["heatmap-intensity"]),"heatmap-color":new $o(Se.paint_heatmap["heatmap-color"]),"heatmap-opacity":new No(Se.paint_heatmap["heatmap-opacity"])})}};function dc(t,{width:e,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*i*r)throw new RangeError(`mismatched image size. expected: ${n.length} but got: ${e*i*r}`)}else n=new Uint8Array(e*i*r);return t.width=e,t.height=i,t.data=n,t}function fc(t,{width:e,height:i},r){if(e===t.width&&i===t.height)return;const n=dc({},{width:e,height:i},r);mc(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,i)},r),t.width=e,t.height=i,t.data=n.data}function mc(t,e,i,r,n,s){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||i.x>t.width-n.width||i.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||r.x>e.width-n.width||r.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,a=e.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<n.height;l++){const c=((i.y+l)*t.width+i.x)*s,h=((r.y+l)*e.width+r.x)*s;for(let t=0;t<n.width*s;t++)a[h+t]=o[c+t]}return e}class _c{constructor(t,e){dc(this,t,1,e)}resize(t){fc(this,t,1)}clone(){return new _c({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){mc(t,e,i,r,n,1)}}class gc{constructor(t,e){dc(this,t,4,e)}resize(t){fc(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new gc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){mc(t,e,i,r,n,4)}setPixel(t,e,i){const r=4*(t*this.width+e);this.data[r+0]=Math.round(255*i.r/i.a),this.data[r+1]=Math.round(255*i.g/i.a),this.data[r+2]=Math.round(255*i.b/i.a),this.data[r+3]=Math.round(255*i.a)}}function yc(t){const e={},i=t.resolution||256,r=t.clips?t.clips.length:1,n=t.image||new gc({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const s=(r,s,o)=>{e[t.evaluationKey]=o;const a=t.expression.evaluate(e);n.setPixel(r/4/i,s/4,a)};if(t.clips)for(let e=0,n=0;e<r;++e,n+=4*i)for(let r=0,o=0;r<i;r++,o+=4){const a=r/(i-1),{start:l,end:c}=t.clips[e];s(n,o,l*(1-a)+c*a)}else for(let t=0,e=0;t<i;t++,e+=4)s(0,e,t/(i-1));return n}po("AlphaImage",_c),po("RGBAImage",gc);const xc="big-fb";class vc extends Ho{createBucket(t){return new hc(t)}constructor(t){super(t,pc),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=yc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(xc)&&this.heatmapFbos.delete(xc)}queryRadius(){return 0}queryIntersectsFeature(){return!1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let bc;var wc={get paint(){return bc=bc||new qo({"hillshade-illumination-direction":new No(Se.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new No(Se.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new No(Se.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new No(Se.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new No(Se.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new No(Se.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new No(Se.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new No(Se.paint_hillshade["hillshade-method"])})}};class Tc extends Ho{constructor(t){super(t,wc),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,i=this.paint.get("hillshade-highlight-color").values,r=this.paint.get("hillshade-shadow-color").values;const n=Math.max(t.length,e.length,i.length,r.length);t=t.concat(Array(n-t.length).fill(t.at(-1))),e=e.concat(Array(n-e.length).fill(e.at(-1))),i=i.concat(Array(n-i.length).fill(i.at(-1))),r=r.concat(Array(n-r.length).fill(r.at(-1)));const s=e.map(Zt);return{directionRadians:t.map(Zt),altitudeRadians:s,shadowColor:r,highlightColor:i}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Pc;var Sc={get paint(){return Pc=Pc||new qo({"color-relief-opacity":new No(Se["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new $o(Se["paint_color-relief"]["color-relief-color"])})}};class Mc{constructor(t,e,i,r){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,r)}update(t,e,i){const{width:r,height:n}=t,s=!(this.size&&this.size[0]===r&&this.size[1]===n||i),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(e&&e.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[r,n],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Vt(t)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,r,n,0,this.format,a.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=i||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Vt(t)?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,r,n,a.RGBA,a.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(t,e,i){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),i!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}function Ic(t,e){const i=e[0],r=e[1],n=e[2],s=e[3],o=Math.min(i,r,n),a=Math.round((t+s)/o);return{r:Math.floor(a*o/i)%256,g:Math.floor(a*o/r)%256,b:Math.floor(a*o/n)%256}}po("DEMData",class{constructor(t,e,i,r=1,n=1,s=1,o=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void Bt(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const a=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=n,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<a;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(a,t)]=this.data[this._idx(a-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,a)]=this.data[this._idx(t,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<a;t++)for(let e=0;e<a;e++){const i=this.get(t,e);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(t,e){const i=new Uint8Array(this.data.buffer),r=4*this._idx(t,e);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,i){return t*this.redFactor+e*this.greenFactor+i*this.blueFactor-this.baseShift}pack(t){return Ic(t,this.getUnpackVector())}getPixels(){return new gc({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,i){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let r=e*this.dim,n=e*this.dim+this.dim,s=i*this.dim,o=i*this.dim+this.dim;switch(e){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:s=o-1;break;case 1:o=s+1}const a=-e*this.dim,l=-i*this.dim;for(let e=s;e<o;e++)for(let i=r;i<n;i++)this.data[this._idx(i,e)]=t.data[this._idx(i+a,e+l)]}});class Cc extends Ho{constructor(t){super(t,Sc)}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},i=this._transitionablePaint._values["color-relief-color"].value.expression;if(i instanceof us&&i._styleExpression.expression instanceof vr){this.colorRampExpression=i;const t=i._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const i of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:i}}))}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[Di.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const r={elevationStops:[],colorStops:[]},n=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=n)r.elevationStops.push(e.elevationStops[Math.round(t)]),r.colorStops.push(e.colorStops[Math.round(t)]);return Bt(`Too many colors in specification of ${this.id} color-relief layer, may not render properly.`),r}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,i){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const r=this._createColorRamp(e),n=new gc({width:r.colorStops.length,height:1}),s=new gc({width:r.colorStops.length,height:1});for(let t=0;t<r.elevationStops.length;t++){const e=Ic(r.elevationStops[t],i);s.setPixel(0,t,new Di(e.r/255,e.g/255,e.b/255,1)),n.setPixel(0,t,r.colorStops[t])}return this.colorRampTextures={elevationTexture:new Mc(t,s,t.gl.RGBA),colorTexture:new Mc(t,n,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures}}const Ac=Jo([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ec}=Ac;function zc(t,e,i){const r=i.patternDependencies;let n=!1;for(const i of e){const e=i.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const s=e.constantOr(null);s&&(n=!0,r[s.to]=!0,r[s.from]=!0)}return n}function kc(t,e,i,r,n){const s=n.patternDependencies;for(const o of e){const e=o.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:r-1},i,{},n.availableImages),a=e.evaluate({zoom:r},i,{},n.availableImages),l=e.evaluate({zoom:r+1},i,{},n.availableImages);t=t&&t.name?t.name:t,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,s[t]=!0,s[a]=!0,s[l]=!0,i.patterns[o.id]={min:t,mid:a,max:l}}}return i}function Rc(t,e,i,r,n){let s;if(n===function(t,e,i,r){let n=0;for(let s=e,o=i-r;s<i;s+=r)n+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return n}(t,e,i,r)>0)for(let n=e;n<i;n+=r)s=eh(n/r|0,t[n],t[n+1],s);else for(let n=i-r;n>=e;n-=r)s=eh(n/r|0,t[n],t[n+1],s);return s&&Xc(s,s.next)&&(ih(s),s=s.next),s}function Dc(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!Xc(r,r.next)&&0!==Hc(r.prev,r,r.next))r=r.next;else{if(ih(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function Lc(t,e,i,r,n,s,o){if(!t)return;!o&&s&&function(t,e,i,r){let n=t;do{0===n.z&&(n.z=Zc(n.x,n.y,e,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){let e,i=1;do{let r,n=t;t=null;let s=null;for(e=0;n;){e++;let o=n,a=0;for(let t=0;t<i&&(a++,o=o.nextZ,o);t++);let l=i;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||n.z<=o.z)?(r=n,n=n.nextZ,a--):(r=o,o=o.nextZ,l--),s?s.nextZ=r:t=r,r.prevZ=s,s=r;n=o}s.nextZ=null,i*=2}while(e>1)}(n)}(t,r,n,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,c=t.next;if(s?Fc(t,r,n,s):Bc(t))e.push(l.i,t.i,c.i),ih(t),t=c.next,a=c.next;else if((t=c)===a){o?1===o?Lc(t=Oc(Dc(t),e),e,i,r,n,s,2):2===o&&jc(t,e,i,r,n,s):Lc(Dc(t),e,i,r,n,s,1);break}}}function Bc(t){const e=t.prev,i=t,r=t.next;if(Hc(e,i,r)>=0)return!1;const n=e.x,s=i.x,o=r.x,a=e.y,l=i.y,c=r.y,h=Math.min(n,s,o),u=Math.min(a,l,c),p=Math.max(n,s,o),d=Math.max(a,l,c);let f=r.next;for(;f!==e;){if(f.x>=h&&f.x<=p&&f.y>=u&&f.y<=d&&qc(n,a,s,l,o,c,f.x,f.y)&&Hc(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function Fc(t,e,i,r){const n=t.prev,s=t,o=t.next;if(Hc(n,s,o)>=0)return!1;const a=n.x,l=s.x,c=o.x,h=n.y,u=s.y,p=o.y,d=Math.min(a,l,c),f=Math.min(h,u,p),m=Math.max(a,l,c),_=Math.max(h,u,p),g=Zc(d,f,e,i,r),y=Zc(m,_,e,i,r);let x=t.prevZ,v=t.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&qc(a,h,l,u,c,p,x.x,x.y)&&Hc(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&qc(a,h,l,u,c,p,v.x,v.y)&&Hc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&qc(a,h,l,u,c,p,x.x,x.y)&&Hc(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&qc(a,h,l,u,c,p,v.x,v.y)&&Hc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function Oc(t,e){let i=t;do{const r=i.prev,n=i.next.next;!Xc(r,n)&&Yc(r,i,i.next,n)&&Qc(r,n)&&Qc(n,r)&&(e.push(r.i,i.i,n.i),ih(i),ih(i.next),i=t=n),i=i.next}while(i!==t);return Dc(i)}function jc(t,e,i,r,n,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&Wc(o,t)){let a=th(o,t);return o=Dc(o,o.next),a=Dc(a,a.next),Lc(o,e,i,r,n,s,0),void Lc(a,e,i,r,n,s,0)}t=t.next}o=o.next}while(o!==t)}function Vc(t,e){let i=t.x-e.x;return 0===i&&(i=t.y-e.y,0===i)&&(i=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),i}function Nc(t,e){const i=function(t,e){let i=e;const r=t.x,n=t.y;let s,o=-1/0;if(Xc(t,i))return i;do{if(Xc(t,i.next))return i.next;if(n<=i.y&&n>=i.next.y&&i.next.y!==i.y){const t=i.x+(n-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>o&&(o=t,s=i.x<i.next.x?i:i.next,t===r))return s}i=i.next}while(i!==e);if(!s)return null;const a=s,l=s.x,c=s.y;let h=1/0;i=s;do{if(r>=i.x&&i.x>=l&&r!==i.x&&$c(n<c?r:o,n,l,c,n<c?o:r,n,i.x,i.y)){const e=Math.abs(n-i.y)/(r-i.x);Qc(i,t)&&(e<h||e===h&&(i.x>s.x||i.x===s.x&&Uc(s,i)))&&(s=i,h=e)}i=i.next}while(i!==a);return s}(t,e);if(!i)return e;const r=th(i,t);return Dc(r,r.next),Dc(i,i.next)}function Uc(t,e){return Hc(t.prev,t,e.prev)<0&&Hc(e.next,t,t.next)<0}function Zc(t,e,i,r,n){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Gc(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function $c(t,e,i,r,n,s,o,a){return(n-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(r-a)>=(i-o)*(e-a)&&(i-o)*(s-a)>=(n-o)*(r-a)}function qc(t,e,i,r,n,s,o,a){return!(t===o&&e===a)&&$c(t,e,i,r,n,s,o,a)}function Wc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&Yc(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(t,e)&&(Qc(t,e)&&Qc(e,t)&&function(t,e){let i=t,r=!1;const n=(t.x+e.x)/2,s=(t.y+e.y)/2;do{i.y>s!=i.next.y>s&&i.next.y!==i.y&&n<(i.next.x-i.x)*(s-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(t,e)&&(Hc(t.prev,t,e.prev)||Hc(t,e.prev,e))||Xc(t,e)&&Hc(t.prev,t,t.next)>0&&Hc(e.prev,e,e.next)>0)}function Hc(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function Xc(t,e){return t.x===e.x&&t.y===e.y}function Yc(t,e,i,r){const n=Jc(Hc(t,e,i)),s=Jc(Hc(t,e,r)),o=Jc(Hc(i,r,t)),a=Jc(Hc(i,r,e));return n!==s&&o!==a||!(0!==n||!Kc(t,i,e))||!(0!==s||!Kc(t,r,e))||!(0!==o||!Kc(i,t,r))||!(0!==a||!Kc(i,e,r))}function Kc(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function Jc(t){return t>0?1:t<0?-1:0}function Qc(t,e){return Hc(t.prev,t,t.next)<0?Hc(t,e,t.next)>=0&&Hc(t,t.prev,e)>=0:Hc(t,e,t.prev)<0||Hc(t,t.next,e)<0}function th(t,e){const i=rh(t.i,t.x,t.y),r=rh(e.i,e.x,e.y),n=t.next,s=e.prev;return t.next=e,e.prev=t,i.next=n,n.prev=i,r.next=i,i.prev=r,s.next=r,r.prev=s,r}function eh(t,e,i,r){const n=rh(t,e,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function ih(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function rh(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class nh{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class sh{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}sh.noSubdivision=new sh({fill:new nh(0,0),line:new nh(0,0),tile:new nh(0,0),stencil:new nh(0,0),circle:1}),po("SubdivisionGranularityExpression",nh),po("SubdivisionGranularitySetting",sh);const oh=-32768,ah=32767;class lh{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=it/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const i=0|Math.round(t),r=0|Math.round(e),n=this._getKey(i,r);if(this._vertexDictionary.has(n))return this._vertexDictionary.get(n);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(n,s),this._vertexBuffer.push(i,r),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const i=[];for(let r=0;r<e.length;r+=3){const n=e[r],s=e[r+1],o=e[r+2],a=t[2*n],l=t[2*n+1];(t[2*s]-a)*(t[2*o+1]-l)-(t[2*s+1]-l)*(t[2*o]-a)>0?(i.push(n),i.push(o),i.push(s)):(i.push(n),i.push(s),i.push(o))}return i}(this._vertexBuffer,t);const e=[],i=t.length;for(let r=0;r<i;r+=3){const i=[t[r+0],t[r+1],t[r+2]],n=[this._vertexBuffer[2*t[r+0]+0],this._vertexBuffer[2*t[r+0]+1],this._vertexBuffer[2*t[r+1]+0],this._vertexBuffer[2*t[r+1]+1],this._vertexBuffer[2*t[r+2]+0],this._vertexBuffer[2*t[r+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=n[2*t],i=n[2*t+1];s=Math.min(s,e),a=Math.max(a,e),o=Math.min(o,i),l=Math.max(l,i)}if(s===a||o===l)continue;const c=Math.floor(s/this._granularityCellSize),h=Math.ceil(a/this._granularityCellSize),u=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(c!==h||u!==p)for(let t=u;t<p;t++){const r=this._scanlineGenerateVertexRingForCellRow(t,n,i);uh(this._vertexBuffer,r,e)}else e.push(...i)}return e}_scanlineGenerateVertexRingForCellRow(t,e,i){const r=t*this._granularityCellSize,n=r+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const o=e[2*t],a=e[2*t+1],l=e[2*(t+1)%6],c=e[(2*(t+1)+1)%6],h=e[2*(t+2)%6],u=e[(2*(t+2)+1)%6],p=l-o,d=c-a,f=0===p,m=0===d,_=(r-a)/d,g=(n-a)/d,y=Math.min(_,g),x=Math.max(_,g);if(!m&&(y>=1||x<=0)||m&&(a<r||a>n)){c>=r&&c<=n&&s.push(i[(t+1)%3]);continue}!m&&y>0&&s.push(this._vertexToIndex(o+p*y,a+d*y));const v=o+p*Math.max(y,0),b=o+p*Math.min(x,1);f||this._generateIntraEdgeVertices(s,o,a,l,c,v,b),!m&&x<1&&s.push(this._vertexToIndex(o+p*x,a+d*x)),(m||c>=r&&c<=n)&&s.push(i[(t+1)%3]),!m&&(c<=r||c>=n)&&this._generateInterEdgeVertices(s,o,a,l,c,h,u,b,r,n)}return s}_generateIntraEdgeVertices(t,e,i,r,n,s,o){const a=r-e,l=n-i,c=0===l,h=c?Math.min(e,r):Math.min(s,o),u=c?Math.max(e,r):Math.max(s,o),p=Math.floor(h/this._granularityCellSize)+1,d=Math.ceil(u/this._granularityCellSize)-1;if(c?e<r:s<o)for(let r=p;r<=d;r++){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}else for(let r=d;r>=p;r--){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}}_generateInterEdgeVertices(t,e,i,r,n,s,o,a,l,c){const h=n-i,u=s-r,p=o-n,d=(l-n)/p,f=(c-n)/p,m=Math.min(d,f),_=Math.max(d,f),g=r+u*m;let y=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,v=a<g;const b=0===p;if(b&&(o===l||o===c))return;if(b||m>=1||_<=0){const t=i-o,r=s+(e-s)*Math.min((l-o)/t,(c-o)/t);y=Math.floor(Math.min(r,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(r,a)/this._granularityCellSize)-1,v=a<r}const w=h>0?c:l;if(v)for(let e=y;e<=x;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,w));else for(let e=x;e>=y;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,w))}_generateOutline(t){const e=[];for(const i of t){const t=hh(i,this._granularity,!0),r=this._pointArrayToIndices(t),n=[];for(let t=1;t<r.length;t++)n.push(r[t-1]),n.push(r[t]);e.push(n)}return e}_handlePoles(t){let e=!1,i=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(i=!0)),(e||i)&&this._fillPoles(t,e,i)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const i=t[e+1];i===oh&&(t[e+1]=-32767),i===ah&&(t[e+1]=32766)}}_generatePoleQuad(t,e,i,r,n,s){r>n!=(s===oh)?(t.push(e),t.push(i),t.push(this._vertexToIndex(r,s)),t.push(i),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(r,s))):(t.push(i),t.push(e),t.push(this._vertexToIndex(r,s)),t.push(this._vertexToIndex(n,s)),t.push(i),t.push(this._vertexToIndex(r,s)))}_fillPoles(t,e,i){const r=this._vertexBuffer,n=it,s=t.length;for(let o=2;o<s;o+=3){const s=t[o-2],a=t[o-1],l=t[o],c=r[2*s],h=r[2*s+1],u=r[2*a],p=r[2*a+1],d=r[2*l],f=r[2*l+1];e&&(0===h&&0===p&&this._generatePoleQuad(t,s,a,c,u,oh),0===p&&0===f&&this._generatePoleQuad(t,a,l,u,d,oh),0===f&&0===h&&this._generatePoleQuad(t,l,s,d,c,oh)),i&&(h===n&&p===n&&this._generatePoleQuad(t,s,a,c,u,ah),p===n&&f===n&&this._generatePoleQuad(t,a,l,u,d,ah),f===n&&h===n&&this._generatePoleQuad(t,l,s,d,c,ah))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:i,holeIndices:r}=function(t){const e=[],i=[];for(const r of t)if(0!==r.length){r!==t[0]&&e.push(i.length/2);for(let t=0;t<r.length;t++)i.push(r[t].x),i.push(r[t].y)}return{flattened:i,holeIndices:e}}(t);let n;this._initializeVertices(i);try{const t=function(t,e,i=2){const r=e&&e.length,n=r?e[0]*i:t.length;let s=Rc(t,0,n,i,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,c;if(r&&(s=function(t,e,i,r){const n=[];for(let i=0,s=e.length;i<s;i++){const o=Rc(t,e[i]*r,i<s-1?e[i+1]*r:t.length,r,!1);o===o.next&&(o.steiner=!0),n.push(Gc(o))}n.sort(Vc);for(let t=0;t<n.length;t++)i=Nc(n[t],i);return i}(t,e,s,i)),t.length>80*i){a=1/0,l=1/0;let e=-1/0,r=-1/0;for(let s=i;s<n;s+=i){const i=t[s],n=t[s+1];i<a&&(a=i),n<l&&(l=n),i>e&&(e=i),n>r&&(r=n)}c=Math.max(e-a,r-l),c=0!==c?32767/c:0}return Lc(s,o,i,a,l,c,0),o}(i,r),e=this._convertIndices(i,t);n=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(n),{verticesFlattened:this._vertexBuffer,indicesTriangles:n,indicesLineList:s}}_convertIndices(t,e){const i=[];for(let r=0;r<e.length;r++)i.push(this._vertexToIndex(t[2*e[r]],t[2*e[r]+1]));return i}_pointArrayToIndices(t){const e=[];for(let i=0;i<t.length;i++){const r=t[i];e.push(this._vertexToIndex(r.x,r.y))}return e}}function ch(t,e,i,r=!0){return new lh(i,e).subdividePolygonInternal(t,r)}function hh(t,e,i=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const r=t[0],n=t[t.length-1],s=i&&(r.x!==n.x||r.y!==n.y);if(e<2)return s?[...t,t[0]]:[...t];const o=Math.floor(it/e),a=[];a.push(new c(t[0].x,t[0].y));const l=t.length,h=s?l:l-1;for(let e=0;e<h;e++){const i=t[e],r=e<l-1?t[e+1]:t[0],n=i.x,s=i.y,h=r.x,u=r.y,p=n!==h,d=s!==u;if(!p&&!d)continue;const f=h-n,m=u-s,_=Math.abs(f),g=Math.abs(m);let y=n,x=s;for(;;){const t=f>0?(Math.floor(y/o)+1)*o:(Math.ceil(y/o)-1)*o,e=m>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,i=Math.abs(y-t),r=Math.abs(x-e),n=Math.abs(y-h),s=Math.abs(x-u),l=p?i/_:Number.POSITIVE_INFINITY,v=d?r/g:Number.POSITIVE_INFINITY;if((n<=i||!p)&&(s<=r||!d))break;if(l<v&&p||!d){y=t,x+=m*l;const e=new c(y,Math.round(x));a[a.length-1].x===e.x&&a[a.length-1].y===e.y||a.push(e)}else{y+=f*v,x=e;const t=new c(Math.round(y),x);a[a.length-1].x===t.x&&a[a.length-1].y===t.y||a.push(t)}}const v=new c(h,u);a[a.length-1].x===v.x&&a[a.length-1].y===v.y||a.push(v)}return a}function uh(t,e,i){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let r=0,n=t[2*e[0]];for(let i=1;i<e.length;i++){const s=t[2*e[i]];s<n&&(n=s,r=i)}const s=e.length;let o=r,a=(o+1)%s;for(;;){const r=o-1>=0?o-1:s-1,n=(a+1)%s,l=t[2*e[r]],c=t[2*e[n]],h=t[2*e[o]],u=t[2*e[o]+1],p=t[2*e[a]+1];let d=!1;if(l<c)d=!0;else if(l>c)d=!1;else{const i=p-u,s=-(t[2*e[a]]-h),o=u<p?1:-1;((l-h)*i+(t[2*e[r]+1]-u)*s)*o>((c-h)*i+(t[2*e[n]+1]-u)*s)*o&&(d=!0)}if(d){const t=e[r],n=e[o],l=e[a];t!==n&&t!==l&&n!==l&&i.push(l,n,t),o--,o<0&&(o=s-1)}else{const t=e[n],r=e[o],l=e[a];t!==r&&t!==l&&r!==l&&i.push(l,r,t),a++,a>=s&&(a=0)}if(r===n)break}}function ph(t,e,i,r,n,s,o,a,l){const c=n.length/2,h=o&&a&&l;if(c<il.MAX_VERTEX_ARRAY_LENGTH){const u=e.prepareSegment(c,i,r),p=u.vertexLength;for(let t=0;t<s.length;t+=3)r.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let d,f;u.vertexLength+=c,u.primitiveLength+=s.length/3,h&&(f=o.prepareSegment(c,i,a),d=f.vertexLength,f.vertexLength+=c);for(let e=0;e<n.length;e+=2)t(n[e],n[e+1]);if(h)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)a.emplaceBack(d+e[t-1],d+e[t]);f.primitiveLength+=e.length/2}}else!function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=2;u<n.length;u+=3){const p=n[u-2],d=n[u-1],f=n[u];let m=o[p]<l,_=o[d]<l,g=o[f]<l;c.vertexLength+((m?1:0)+(_?1:0)+(g?1:0))>il.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,m=!0,_=!0,g=!0,h=0);const y=dh(o,r,s,a,p,m,c),x=dh(o,r,s,a,d,_,c),v=dh(o,r,s,a,f,g,c);i.emplaceBack(h+y-l,h+x-l,h+v-l),c.primitiveLength++}}(e,i,r,n,s,t),h&&function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=0;u<n.length;u++){const p=n[u];for(let d=1;d<n[u].length;d+=2){const n=p[d-1],u=p[d];let f=o[n]<l,m=o[u]<l;c.vertexLength+((f?1:0)+(m?1:0))>il.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,f=!0,m=!0,h=0);const _=dh(o,r,s,a,n,f,c),g=dh(o,r,s,a,u,m,c);i.emplaceBack(h+_-l,h+g-l),c.primitiveLength++}}}(o,i,a,n,l,t),e.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function dh(t,e,i,r,n,s,o){if(s){const s=r.count;return i(e[2*n],e[2*n+1]),t[n]=r.count,r.count++,o.vertexLength++,s}return t[n]}class fh{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ja,this.indexArray=new Ka,this.indexArray2=new Ja,this.programConfigurations=new Ll(t.layers,t.zoom),this.segments=new il,this.segments2=new il,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=zc("fill",this.layers,e);const r=this.layers[0].layout.get("fill-sort-key"),n=!r.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=Nl(o,t);if(!this.layers[0]._featureFilter.filter(new ko(this.zoom,{globalState:this.globalState}),h,i))continue;const u=n?r.evaluate(h,{},i,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:c,index:l,geometry:t?h.geometry:Vl(o),patterns:{},sortKey:u};s.push(p)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=kc("fill",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ec),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,i,r,n,s){for(const t of ln(e,500)){const e=ch(t,r,s.fill.getGranularityForZoomLevel(r.z)),i=this.layoutVertexArray;ph(((t,e)=>{i.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}}let mh,_h;po("FillBucket",fh,{omit:["layers","patternFeatures"]});var gh={get paint(){return _h=_h||new qo({"fill-antialias":new No(Se.paint_fill["fill-antialias"]),"fill-opacity":new Uo(Se.paint_fill["fill-opacity"]),"fill-color":new Uo(Se.paint_fill["fill-color"]),"fill-outline-color":new Uo(Se.paint_fill["fill-outline-color"]),"fill-translate":new No(Se.paint_fill["fill-translate"]),"fill-translate-anchor":new No(Se.paint_fill["fill-translate-anchor"]),"fill-pattern":new Zo(Se.paint_fill["fill-pattern"])})},get layout(){return mh=mh||new qo({"fill-sort-key":new Uo(Se.layout_fill["fill-sort-key"])})}};class yh extends Ho{constructor(t){super(t,gh)}recalculate(t,e){super.recalculate(t,e);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new fh(t)}queryRadius(){return rc(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:i,pixelsToTileUnits:r}){return Wl(nc(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-i.bearingInRadians,r),e)}isTileClipped(){return!0}}const xh=Jo([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),vh=Jo([{name:"a_centroid",components:2,type:"Int16"}],4),{members:bh}=xh;var wh,Th,Ph,Sh,Mh,Ih,Ch,Ah={};function Eh(){if(Th)return wh;Th=1;var t=o();function e(t,e,r,n,s){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=s,t.readFields(i,this,e)}function i(t,e,i){1==t?e.id=i.readVarint():2==t?function(t,e){for(var i=t.readVarint()+t.pos;t.pos<i;){var r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n}}(i,e):3==t?e.type=i.readVarint():4==t&&(e._geometry=i.pos)}function r(t){for(var e,i,r=0,n=0,s=t.length,o=s-1;n<s;o=n++)r+=((i=t[o]).x-(e=t[n]).x)*(e.y+i.y);return r}return wh=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var i,r=e.readVarint()+e.pos,n=1,s=0,o=0,a=0,l=[];e.pos<r;){if(s<=0){var c=e.readVarint();n=7&c,s=c>>3}if(s--,1===n||2===n)o+=e.readSVarint(),a+=e.readSVarint(),1===n&&(i&&l.push(i),i=[]),i.push(new t(o,a));else{if(7!==n)throw new Error("unknown command "+n);i&&i.push(i[0].clone())}}return i&&l.push(i),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,i=1,r=0,n=0,s=0,o=1/0,a=-1/0,l=1/0,c=-1/0;t.pos<e;){if(r<=0){var h=t.readVarint();i=7&h,r=h>>3}if(r--,1===i||2===i)(n+=t.readSVarint())<o&&(o=n),n>a&&(a=n),(s+=t.readSVarint())<l&&(l=s),s>c&&(c=s);else if(7!==i)throw new Error("unknown command "+i)}return[o,l,a,c]},e.prototype.toGeoJSON=function(t,i,n){var s,o,a=this.extent*Math.pow(2,n),l=this.extent*t,c=this.extent*i,h=this.loadGeometry(),u=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var i=t[e];t[e]=[360*(i.x+l)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(i.y+c)/a)*Math.PI/180))-90]}}switch(this.type){case 1:var d=[];for(s=0;s<h.length;s++)d[s]=h[s][0];p(h=d);break;case 2:for(s=0;s<h.length;s++)p(h[s]);break;case 3:for(h=function(t){var e=t.length;if(e<=1)return[t];for(var i,n,s=[],o=0;o<e;o++){var a=r(t[o]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(i&&s.push(i),i=[t[o]]):i.push(t[o]))}return i&&s.push(i),s}(h),s=0;s<h.length;s++)for(o=0;o<h[s].length;o++)p(h[s][o])}1===h.length?h=h[0]:u="Multi"+u;var f={type:"Feature",geometry:{type:u,coordinates:h},properties:this.properties};return"id"in this&&(f.id=this.id),f},wh}function zh(){if(Sh)return Ph;Sh=1;var t=Eh();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(i,this,e),this.length=this._features.length}function i(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){for(var e=null,i=t.readVarint()+t.pos;t.pos<i;){var r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null}return e}(i))}return Ph=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var i=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,i,this.extent,this._keys,this._values)},Ph}var kh=(Ch||(Ch=1,Ah.VectorTile=function(){if(Ih)return Mh;Ih=1;var t=zh();function e(e,i,r){if(3===e){var n=new t(r,r.readVarint()+r.pos);n.length&&(i[n.name]=n)}}return Mh=function(t,i){this.layers=t.readFields(e,{},i)},Mh}(),Ah.VectorTileFeature=Eh(),Ah.VectorTileLayer=zh()),Ah),Rh=s(kh);const Dh=Rh.VectorTileFeature.types,Lh=Math.pow(2,13);function Bh(t,e,i,r,n,s,o,a){t.emplaceBack(e,i,2*Math.floor(r*Lh)+o,n*Lh*2,s*Lh*2,Math.round(a))}class Fh{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Va,this.centroidVertexArray=new La,this.indexArray=new Ka,this.programConfigurations=new Ll(t.layers,t.zoom),this.segments=new il,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.features=[],this.hasPattern=zc("fill-extrusion",this.layers,e);for(const{feature:r,id:n,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,a=Nl(r,t);if(!this.layers[0]._featureFilter.filter(new ko(this.zoom,{globalState:this.globalState}),a,i))continue;const l={id:n,sourceLayerIndex:o,index:s,geometry:t?a.geometry:Vl(r),properties:r.properties,type:r.type,patterns:{}};this.hasPattern?this.features.push(kc("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,i,{},e.subdivisionGranularity),e.featureIndex.insert(r,l.geometry,s,o,this.index,!0)}}addFeatures(t,e,i){for(const r of this.features){const{geometry:n}=r;this.addFeature(r,n,r.index,e,i,t.subdivisionGranularity)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,bh),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,vh.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,i,r,n,s){for(const i of ln(e,500)){const e={x:0,y:0,sampleCount:0},n=this.layoutVertexArray.length;this.processPolygon(e,r,t,i,s);const o=this.layoutVertexArray.length-n,a=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<o;t++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}processPolygon(t,e,i,r,n){if(r.length<1)return;if(Vh(r[0]))return;for(const e of r)0!==e.length&&Oh(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=n.fill.getGranularityForZoomLevel(e.z),a="Polygon"===Dh[i.type];for(const t of r){if(0===t.length)continue;if(Vh(t))continue;const e=hh(t,o,a);this._generateSideFaces(e,s)}if(!a)return;const l=ch(r,e,o,!1),c=this.layoutVertexArray;ph(((t,e)=>{Bh(c,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let i=0;for(let r=1;r<t.length;r++){const n=t[r],s=t[r-1];if(jh(n,s))continue;e.segment.vertexLength+4>il.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=n.sub(s)._perp()._unit(),a=s.dist(n);i+a>32768&&(i=0),Bh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,0,i),Bh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,1,i),i+=a,Bh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,i),Bh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,i);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function Oh(t,e){for(let i=0;i<e.length;i++){const r=e[i];i===e.length-1&&e[0].x===r.x&&e[0].y===r.y||(t.x+=r.x,t.y+=r.y,t.sampleCount++)}}function jh(t,e){return t.x===e.x&&(t.x<0||t.x>it)||t.y===e.y&&(t.y<0||t.y>it)}function Vh(t){return t.every((t=>t.x<0))||t.every((t=>t.x>it))||t.every((t=>t.y<0))||t.every((t=>t.y>it))}let Nh;po("FillExtrusionBucket",Fh,{omit:["layers","features"]});var Uh={get paint(){return Nh=Nh||new qo({"fill-extrusion-opacity":new No(Se["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Uo(Se["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new No(Se["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new No(Se["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Zo(Se["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Uo(Se["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Uo(Se["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new No(Se["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Zh extends Ho{constructor(t){super(t,Uh)}createBucket(t){return new Fh(t)}queryRadius(){return rc(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,pixelPosMatrix:o}){const a=nc(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-n.bearingInRadians,s),l=this.paint.get("fill-extrusion-height").evaluate(e,i),h=this.paint.get("fill-extrusion-base").evaluate(e,i),u=function(t,e){const i=[];for(const r of t){const t=[r.x,r.y,0,1];W(t,t,e),i.push(new c(t[0]/t[3],t[1]/t[3]))}return i}(a,o),p=function(t,e,i,r){const n=[],s=[],o=r[8]*e,a=r[9]*e,l=r[10]*e,h=r[11]*e,u=r[8]*i,p=r[9]*i,d=r[10]*i,f=r[11]*i;for(const e of t){const t=[],i=[];for(const n of e){const e=n.x,s=n.y,m=r[0]*e+r[4]*s+r[12],_=r[1]*e+r[5]*s+r[13],g=r[2]*e+r[6]*s+r[14],y=r[3]*e+r[7]*s+r[15],x=g+l,v=y+h,b=m+u,w=_+p,T=g+d,P=y+f,S=new c((m+o)/v,(_+a)/v);S.z=x/v,t.push(S);const M=new c(b/P,w/P);M.z=T/P,i.push(M)}n.push(t),s.push(i)}return[n,s]}(r,h,l,o);return function(t,e,i){let r=1/0;Wl(i,e)&&(r=$h(i,e[0]));for(let n=0;n<e.length;n++){const s=e[n],o=t[n];for(let t=0;t<s.length-1;t++){const e=s[t],n=[e,s[t+1],o[t+1],o[t],e];$l(i,n)&&(r=Math.min(r,$h(i,n)))}}return r!==1/0&&r}(p[0],p[1],u)}}function Gh(t,e){return t.x*e.x+t.y*e.y}function $h(t,e){if(1===t.length){let i=0;const r=e[i++];let n;for(;!n||r.equals(n);)if(n=e[i++],!n)return 1/0;for(;i<e.length;i++){const s=e[i],o=t[0],a=n.sub(r),l=s.sub(r),c=o.sub(r),h=Gh(a,a),u=Gh(a,l),p=Gh(l,l),d=Gh(c,a),f=Gh(c,l),m=h*p-u*u,_=(p*d-u*f)/m,g=(h*f-u*d)/m,y=r.z*(1-_-g)+n.z*_+s.z*g;if(isFinite(y))return y}return 1/0}{let t=1/0;for(const i of e)t=Math.min(t,i.z);return t}}const qh=Jo([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Wh}=qh,Hh=Jo([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Xh}=Hh,Yh=Rh.VectorTileFeature.types,Kh=Math.cos(Math.PI/180*37.5),Jh=Math.pow(2,14)/.5;class Qh{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new Na,this.layoutVertexArray2=new Ua,this.indexArray=new Ka,this.programConfigurations=new Ll(t.layers,t.zoom),this.segments=new il,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=zc("line",this.layers,e);const r=this.layers[0].layout.get("line-sort-key"),n=!r.isConstant(),s=[];for(const{feature:e,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Nl(e,t);if(!this.layers[0]._featureFilter.filter(new ko(this.zoom,{globalState:this.globalState}),c,i))continue;const h=n?r.evaluate(c,{},i):void 0,u={id:o,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:Vl(e),patterns:{},sortKey:h};s.push(u)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=kc("line",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Xh)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Wh),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,i,r,n,s){const o=this.layers[0].layout,a=o.get("line-join").evaluate(t,{}),l=o.get("line-cap"),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const i of e)this.addLine(i,t,a,l,c,h,r,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}addLine(t,e,i,r,n,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=hh(t,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===Yh[e.type];let c=t.length;for(;c>=2&&t[c-1].equals(t[c-2]);)c--;let h=0;for(;h<c-1&&t[h].equals(t[h+1]);)h++;if(c<(l?3:2))return;"bevel"===i&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let d,f,m,_,g;this.e1=this.e2=-1,l&&(d=t[c-2],g=t[h].sub(d)._unit()._perp());for(let e=h;e<c;e++){if(m=e===c-1?l?t[h+1]:void 0:t[e+1],m&&t[e].equals(m))continue;g&&(_=g),d&&(f=d),d=t[e],g=m?m.sub(d)._unit()._perp():_,_=_||g;let o=_.add(g);0===o.x&&0===o.y||o._unit();const a=_.x*g.x+_.y*g.y,y=o.x*g.x+o.y*g.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<Kh&&f&&m,w=_.x*g.y-_.y*g.x>0;if(b&&e>h){const t=d.dist(f);if(t>2*u){const e=d.sub(d.sub(f)._mult(u/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,_,0,0,p),f=e}}const T=f&&m;let P=T?i:l?"butt":r;if(T&&"round"===P&&(x<s?P="miter":x<=2&&(P="fakeround")),"miter"===P&&x>n&&(P="bevel"),"bevel"===P&&(x>2&&(P="flipbevel"),x<n&&(P="miter")),f&&this.updateDistance(f,d),"miter"===P)o._mult(x),this.addCurrentVertex(d,o,0,0,p);else if("flipbevel"===P){if(x>100)o=g.mult(-1);else{const t=x*_.add(g).mag()/_.sub(g).mag();o._perp()._mult(t*(w?-1:1))}this.addCurrentVertex(d,o,0,0,p),this.addCurrentVertex(d,o.mult(-1),0,0,p)}else if("bevel"===P||"fakeround"===P){const t=-Math.sqrt(x*x-1),e=w?t:0,i=w?0:t;if(f&&this.addCurrentVertex(d,_,e,i,p),"fakeround"===P){const t=Math.round(180*v/Math.PI/20);for(let e=1;e<t;e++){let i=e/t;if(.5!==i){const t=i-.5;i+=i*t*(i-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*t*t+(.848013+a*(.215638*a-1.06021)))}const r=g.sub(_)._mult(i)._add(_)._unit()._mult(w?-1:1);this.addHalfVertex(d,r.x,r.y,!1,w,0,p)}}m&&this.addCurrentVertex(d,g,-e,-i,p)}else if("butt"===P)this.addCurrentVertex(d,o,0,0,p);else if("square"===P){const t=f?1:-1;this.addCurrentVertex(d,o,t,t,p)}else"round"===P&&(f&&(this.addCurrentVertex(d,_,0,0,p),this.addCurrentVertex(d,_,1,1,p,!0)),m&&(this.addCurrentVertex(d,g,-1,-1,p,!0),this.addCurrentVertex(d,g,0,0,p)));if(b&&e<c-1){const t=d.dist(m);if(t>2*u){const e=d.add(m.sub(d)._mult(u/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,g,0,0,p),d=e}}}}addCurrentVertex(t,e,i,r,n,s=!1){const o=e.y*r-e.x,a=-e.y-e.x*r;this.addHalfVertex(t,e.x+e.y*i,e.y-e.x*i,s,!1,i,n),this.addHalfVertex(t,o,a,s,!0,-r,n),this.distance>Jh/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,i,r,n,s))}addHalfVertex({x:t,y:e},i,r,n,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(Jh-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(s?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),a.primitiveLength++),s?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let tu,eu;po("LineBucket",Qh,{omit:["layers","patternFeatures"]});var iu={get paint(){return eu=eu||new qo({"line-opacity":new Uo(Se.paint_line["line-opacity"]),"line-color":new Uo(Se.paint_line["line-color"]),"line-translate":new No(Se.paint_line["line-translate"]),"line-translate-anchor":new No(Se.paint_line["line-translate-anchor"]),"line-width":new Uo(Se.paint_line["line-width"]),"line-gap-width":new Uo(Se.paint_line["line-gap-width"]),"line-offset":new Uo(Se.paint_line["line-offset"]),"line-blur":new Uo(Se.paint_line["line-blur"]),"line-dasharray":new Go(Se.paint_line["line-dasharray"]),"line-pattern":new Zo(Se.paint_line["line-pattern"]),"line-gradient":new $o(Se.paint_line["line-gradient"])})},get layout(){return tu=tu||new qo({"line-cap":new No(Se.layout_line["line-cap"]),"line-join":new Uo(Se.layout_line["line-join"]),"line-miter-limit":new No(Se.layout_line["line-miter-limit"]),"line-round-limit":new No(Se.layout_line["line-round-limit"]),"line-sort-key":new Uo(Se.layout_line["line-sort-key"])})}};class ru extends Uo{possiblyEvaluate(t,e){return e=new ko(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,i,r){return e=St({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,i,r)}}let nu;class su extends Ho{constructor(t){super(t,iu),this.gradientVersion=0,nu||(nu=new ru(iu.paint.properties["line-width"].specification),nu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof fr,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=nu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new Qh(t)}queryRadius(t){const e=t,i=ou(ic("line-width",this,e),ic("line-gap-width",this,e)),r=ic("line-offset",this,e);return i/2+Math.abs(r)+rc(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s}){const o=nc(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-n.bearingInRadians,s),a=s/2*ou(this.paint.get("line-width").evaluate(e,i),this.paint.get("line-gap-width").evaluate(e,i)),l=this.paint.get("line-offset").evaluate(e,i);return l&&(r=function(t,e){const i=[];for(let r=0;r<t.length;r++){const n=t[r],s=[];for(let t=0;t<n.length;t++){const i=n[t-1],r=n[t],o=n[t+1],a=0===t?new c(0,0):r.sub(i)._unit()._perp(),l=t===n.length-1?new c(0,0):o.sub(r)._unit()._perp(),h=a._add(l)._unit(),u=h.x*l.x+h.y*l.y;0!==u&&h._mult(1/u),s.push(h._mult(e)._add(r))}i.push(s)}return i}(r,l*s)),function(t,e,i){for(let r=0;r<e.length;r++){const n=e[r];if(t.length>=3)for(let e=0;e<n.length;e++)if(tc(t,n[e]))return!0;if(Hl(t,n,i))return!0}return!1}(o,r,a)}isTileClipped(){return!0}}function ou(t,e){return e>0?e+2*t:t}const au=Jo([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),lu=Jo([{name:"a_projected_pos",components:3,type:"Float32"}],4);Jo([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const cu=Jo([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);Jo([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const hu=Jo([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),uu=Jo([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function pu(t,e,i){return t.sections.forEach((t=>{t.text=function(t,e,i){const r=e.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?t=t.toLocaleUpperCase():"lowercase"===r&&(t=t.toLocaleLowerCase()),zo.applyArabicShaping&&(t=zo.applyArabicShaping(t)),t}(t.text,e,i)})),t}Jo([{name:"triangle",components:3,type:"Uint16"}]),Jo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Jo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),Jo([{type:"Float32",name:"offsetX"}]),Jo([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),Jo([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const du={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var fu,mu,_u,gu={};function yu(){return fu||(fu=1,gu.read=function(t,e,i,r,n){var s,o,a=8*n-r-1,l=(1<<a)-1,c=l>>1,h=-7,u=i?n-1:0,p=i?-1:1,d=t[e+u];for(u+=p,s=d&(1<<-h)-1,d>>=-h,h+=a;h>0;s=256*s+t[e+u],u+=p,h-=8);for(o=s&(1<<-h)-1,s>>=-h,h+=r;h>0;o=256*o+t[e+u],u+=p,h-=8);if(0===s)s=1-c;else{if(s===l)return o?NaN:1/0*(d?-1:1);o+=Math.pow(2,r),s-=c}return(d?-1:1)*o*Math.pow(2,s-r)},gu.write=function(t,e,i,r,n,s){var o,a,l,c=8*s-n-1,h=(1<<c)-1,u=h>>1,p=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,d=r?0:s-1,f=r?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,o=h):(o=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-o))<1&&(o--,l*=2),(e+=o+u>=1?p/l:p*Math.pow(2,1-u))*l>=2&&(o++,l/=2),o+u>=h?(a=0,o=h):o+u>=1?(a=(e*l-1)*Math.pow(2,n),o+=u):(a=e*Math.pow(2,u-1)*Math.pow(2,n),o=0));n>=8;t[i+d]=255&a,d+=f,a/=256,n-=8);for(o=o<<n|a,c+=n;c>0;t[i+d]=255&o,d+=f,o/=256,c-=8);t[i+d-f]|=128*m}),gu}var xu,vu=function(){if(_u)return mu;_u=1,mu=e;var t=yu();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var i=4294967296,r=1/i,n="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function o(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function a(t,e,i){var r=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(r);for(var n=i.pos-1;n>=t;n--)i.buf[n+r]=i.buf[n]}function l(t,e){for(var i=0;i<t.length;i++)e.writeVarint(t[i])}function c(t,e){for(var i=0;i<t.length;i++)e.writeSVarint(t[i])}function h(t,e){for(var i=0;i<t.length;i++)e.writeFloat(t[i])}function u(t,e){for(var i=0;i<t.length;i++)e.writeDouble(t[i])}function p(t,e){for(var i=0;i<t.length;i++)e.writeBoolean(t[i])}function d(t,e){for(var i=0;i<t.length;i++)e.writeFixed32(t[i])}function f(t,e){for(var i=0;i<t.length;i++)e.writeSFixed32(t[i])}function m(t,e){for(var i=0;i<t.length;i++)e.writeFixed64(t[i])}function _(t,e){for(var i=0;i<t.length;i++)e.writeSFixed64(t[i])}function g(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function y(t,e,i){t[i]=e,t[i+1]=e>>>8,t[i+2]=e>>>16,t[i+3]=e>>>24}function x(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null},readFields:function(t,e,i){for(i=i||this.length;this.pos<i;){var r=this.readVarint(),n=r>>3,s=this.pos;this.type=7&r,t(n,e,this),this.pos===s&&this.skip(r)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=x(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*i;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+x(this.buf,this.pos+4)*i;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,i,r=this.buf;return e=127&(i=r[this.pos++]),i<128?e:(e|=(127&(i=r[this.pos++]))<<7,i<128?e:(e|=(127&(i=r[this.pos++]))<<14,i<128?e:(e|=(127&(i=r[this.pos++]))<<21,i<128?e:function(t,e,i){var r,n,s=i.buf;if(r=(112&(n=s[i.pos++]))>>4,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<3,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<10,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<17,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<24,n<128)return o(t,r,e);if(r|=(1&(n=s[i.pos++]))<<31,n<128)return o(t,r,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(i=r[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&n?function(t,e,i){return n.decode(t.subarray(e,i))}(this.buf,e,t):function(t,e,i){for(var r="",n=e;n<i;){var s,o,a,l=t[n],c=null,h=l>239?4:l>223?3:l>191?2:1;if(n+h>i)break;1===h?l<128&&(c=l):2===h?128==(192&(s=t[n+1]))&&(c=(31&l)<<6|63&s)<=127&&(c=null):3===h?(o=t[n+2],128==(192&(s=t[n+1]))&&128==(192&o)&&((c=(15&l)<<12|(63&s)<<6|63&o)<=2047||c>=55296&&c<=57343)&&(c=null)):4===h&&(o=t[n+2],a=t[n+3],128==(192&(s=t[n+1]))&&128==(192&o)&&128==(192&a)&&((c=(15&l)<<18|(63&s)<<12|(63&o)<<6|63&a)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,h=1):c>65535&&(c-=65536,r+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),r+=String.fromCharCode(c),n+=h}return r}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,i){if(this.type!==e.Bytes)return t.push(this.readVarint(i));var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(i));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed64());return t},skip:function(t){var i=7&t;if(i===e.Varint)for(;this.buf[this.pos++]>127;);else if(i===e.Bytes)this.pos=this.readVarint()+this.pos;else if(i===e.Fixed32)this.pos+=4;else{if(i!==e.Fixed64)throw new Error("Unimplemented type: "+i);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var i=new Uint8Array(e);i.set(this.buf),this.buf=i,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),y(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),y(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),y(this.buf,-1&t,this.pos),y(this.buf,Math.floor(t*r),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),y(this.buf,-1&t,this.pos),y(this.buf,Math.floor(t*r),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var i,r;if(t>=0?(i=t%4294967296|0,r=t/4294967296|0):(r=~(-t/4294967296),4294967295^(i=~(-t%4294967296))?i=i+1|0:(i=0,r=r+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,i.buf[i.pos]=127&(t>>>=7)}(i,0,e),function(t,e){var i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(r,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,i){for(var r,n,s=0;s<e.length;s++){if((r=e.charCodeAt(s))>55295&&r<57344){if(!n){r>56319||s+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):n=r;continue}if(r<56320){t[i++]=239,t[i++]=191,t[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(t[i++]=239,t[i++]=191,t[i++]=189,n=null);r<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(r<65536?t[i++]=r>>12|224:(t[i++]=r>>18|240,t[i++]=r>>12&63|128),t[i++]=r>>6&63|128),t[i++]=63&r|128)}return i}(this.buf,t,this.pos);var i=this.pos-e;i>=128&&a(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var i=0;i<e;i++)this.buf[this.pos++]=t[i]},writeRawMessage:function(t,e){this.pos++;var i=this.pos;t(e,this);var r=this.pos-i;r>=128&&a(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(t,i,r){this.writeTag(t,e.Bytes),this.writeRawMessage(i,r)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,c,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,h,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,u,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,d,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,f,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,_,e)},writeBytesField:function(t,i){this.writeTag(t,e.Bytes),this.writeBytes(i)},writeFixed32Field:function(t,i){this.writeTag(t,e.Fixed32),this.writeFixed32(i)},writeSFixed32Field:function(t,i){this.writeTag(t,e.Fixed32),this.writeSFixed32(i)},writeFixed64Field:function(t,i){this.writeTag(t,e.Fixed64),this.writeFixed64(i)},writeSFixed64Field:function(t,i){this.writeTag(t,e.Fixed64),this.writeSFixed64(i)},writeVarintField:function(t,i){this.writeTag(t,e.Varint),this.writeVarint(i)},writeSVarintField:function(t,i){this.writeTag(t,e.Varint),this.writeSVarint(i)},writeStringField:function(t,i){this.writeTag(t,e.Bytes),this.writeString(i)},writeFloatField:function(t,i){this.writeTag(t,e.Fixed32),this.writeFloat(i)},writeDoubleField:function(t,i){this.writeTag(t,e.Fixed64),this.writeDouble(i)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}},mu}(),bu=s(vu);function wu(t,e,i){1===t&&i.readMessage(Tu,e)}function Tu(t,e,i){if(3===t){const{id:t,bitmap:r,width:n,height:s,left:o,top:a,advance:l}=i.readMessage(Pu,{});e.push({id:t,bitmap:new _c({width:n+6,height:s+6},r),metrics:{width:n,height:s,left:o,top:a,advance:l}})}}function Pu(t,e,i){1===t?e.id=i.readVarint():2===t?e.bitmap=i.readBytes():3===t?e.width=i.readVarint():4===t?e.height=i.readVarint():5===t?e.left=i.readSVarint():6===t?e.top=i.readSVarint():7===t&&(e.advance=i.readVarint())}function Su(t){let e=0,i=0;for(const r of t)e+=r.w*r.h,i=Math.max(i,r.w);t.sort(((t,e)=>e.h-t.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),i),h:1/0}];let n=0,s=0;for(const e of t)for(let t=r.length-1;t>=0;t--){const i=r[t];if(!(e.w>i.w||e.h>i.h)){if(e.x=i.x,e.y=i.y,s=Math.max(s,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===i.w&&e.h===i.h){const e=r.pop();t<r.length&&(r[t]=e)}else e.h===i.h?(i.x+=e.w,i.w-=e.w):e.w===i.w?(i.y+=e.h,i.h-=e.h):(r.push({x:i.x+e.w,y:i.y,w:i.w-e.w,h:e.h}),i.y+=e.h,i.h-=e.h);break}}return{w:n,h:s,fill:e/(n*s)||0}}class Mu{constructor(t,{pixelRatio:e,version:i,stretchX:r,stretchY:n,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=r,this.stretchY=n,this.content=s,this.version=i,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}function Iu(t){let e=.5,i=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:e,verticalAlign:i}}function Cu(t,e){const{expression:i}=e;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new ko(t+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:r}=i;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let s=n;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const o=e[n],a=e[s];return"composite"===i.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:r}:{kind:"camera",minZoom:o,maxZoom:a,minSize:i.evaluate(new ko(o)),maxSize:i.evaluate(new ko(a)),interpolationType:r}}}function Au(t,{uSize:e,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===t.kind?r/128:"composite"===t.kind?wr.number(r/128,n/128,i):e}function Eu(t,e){let i=0,r=0;if("constant"===t.kind)r=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:s,maxZoom:o}=t,a=n?Tt(vr.interpolationFactor(n,e,s,o),0,1):0;"camera"===t.kind?r=wr.number(t.minSize,t.maxSize,a):i=a}return{uSizeT:i,uSize:r}}function zu(t,e,i){let r="never";const n=t.get(e);return n?r=n:t.get(i)&&(r="always"),r}po("ImagePosition",Mu),po("ImageAtlas",class{constructor(t,e){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,i,n),this.addImages(e,r,n);const{w:s,h:o}=Su(n),a=new gc({width:s||1,height:o||1});for(const e in t){const r=t[e],n=i[e].paddedRect;gc.copy(r.data,a,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const t in e){const i=e[t],n=r[t].paddedRect,s=n.x+1,o=n.y+1,l=i.data.width,c=i.data.height;gc.copy(i.data,a,{x:0,y:0},{x:s,y:o},i.data),gc.copy(i.data,a,{x:0,y:c-1},{x:s,y:o-1},{width:l,height:1}),gc.copy(i.data,a,{x:0,y:0},{x:s,y:o+c},{width:l,height:1}),gc.copy(i.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:c}),gc.copy(i.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:c})}this.image=a,this.iconPositions=i,this.patternPositions=r}addImages(t,e,i){for(const r in t){const n=t[r],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(s),e[r]=new Mu(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in t.updatedImages)this.patchUpdatedImage(this.iconPositions[i],t.getImage(i),e),this.patchUpdatedImage(this.patternPositions[i],t.getImage(i),e)}patchUpdatedImage(t,e,i){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[r,n]=t.tl;i.update(e.data,void 0,{x:r,y:n})}}),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(xu||(xu={}));const ku=Rh.VectorTileFeature.types,Ru=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Du(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=a?Math.min(32640,Math.round(a[0])):0,f=a?Math.min(32640,Math.round(a[1])):0;t.emplaceBack(e,i,Math.round(32*r),Math.round(32*n),s,o,(d<<1)+(l?1:0),f,16*c,16*h,256*u,256*p)}function Lu(t,e,i){t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i)}function Bu(t){for(const e of t.sections)if(Eo(e.text))return!0;return!1}class Fu{constructor(t){this.layoutVertexArray=new Ga,this.indexArray=new Ka,this.programConfigurations=t,this.segments=new il,this.dynamicLayoutVertexArray=new $a,this.opacityVertexArray=new qa,this.hasVisibleVertices=!1,this.placedSymbolArray=new Ma}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,au.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,lu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Ru,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}po("SymbolBuffers",Fu);class Ou{constructor(t,e,i){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new i,this.segments=new il,this.collisionVertexArray=new Xa}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,cu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}po("CollisionBuffers",Ou);class ju{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Cu(this.zoom,e["text-size"]),this.iconSizeData=Cu(this.zoom,e["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap="never"!==zu(i,"text-overlap","text-allow-overlap")||"never"!==zu(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((t=>xu[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new Fu(new Ll(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Fu(new Ll(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Aa,this.lineVertexArray=new Ea,this.symbolInstances=new Ca,this.textAnchorOffsets=new ka}calculateGlyphDependencies(t,e,i,r,n){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(i||r)&&n){const i=du[t.charAt(s)];i&&(e[i.charCodeAt(0)]=!0)}}populate(t,e,i){const r=this.layers[0],n=r.layout,s=n.get("text-font"),o=n.get("text-field"),a=n.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Oi&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),c="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,h=n.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new ko(this.zoom,{globalState:this.globalState});for(const{feature:e,id:o,index:a,sourceLayerIndex:m}of t){const t=r._featureFilter.needGeometry,_=Nl(e,t);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(t||(_.geometry=Vl(e)),l){const t=r.getValueAndResolveTokens("text-field",_,i,d),e=Oi.factory(t),n=this.hasRTLText=this.hasRTLText||Bu(e);(!n||"unavailable"===zo.getRTLTextPluginStatus()||n&&zo.isParsed())&&(g=pu(e,r,_))}if(c){const t=r.getValueAndResolveTokens("icon-image",_,i,d);y=t instanceof $i?t:$i.fromString(t)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:o,text:g,icon:y,index:a,sourceLayerIndex:m,geometry:_.geometry,properties:e.properties,type:ku[e.type],sortKey:x}),y&&(u[y.name]=!0),g){const t=s.evaluate(_,{},i).join(","),e="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(xu.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=To(g.toString()),n=i.fontStack||t,s=p[n]=p[n]||{};this.calculateGlyphDependencies(i.text,s,e,this.allowVerticalPlacement,r)}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},i={},r=[];let n=0;function s(e){r.push(t[e]),n++}function o(t,e,n){const s=i[t];return delete i[t],i[e]=s,r[s].geometry[0].pop(),r[s].geometry[0]=r[s].geometry[0].concat(n[0]),s}function a(t,i,n){const s=e[i];return delete e[i],e[t]=s,r[s].geometry[0].shift(),r[s].geometry[0]=n[0].concat(r[s].geometry[0]),s}function l(t,e,i){const r=i?e[0][e[0].length-1]:e[0][0];return`${t}:${r.x}:${r.y}`}for(let c=0;c<t.length;c++){const h=t[c],u=h.geometry,p=h.text?h.text.toString():null;if(!p){s(c);continue}const d=l(p,u),f=l(p,u,!0);if(d in i&&f in e&&i[d]!==e[f]){const t=a(d,f,u),n=o(d,f,r[t].geometry);delete e[d],delete i[f],i[l(p,r[n].geometry,!0)]=n,r[t].geometry=null}else d in i?o(d,f,u):f in e?a(d,f,u):(s(c),e[d]=n-1,i[f]=n-1)}return r.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,i),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,i))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const i=this.lineVertexArray.length;if(void 0!==t.segment){let i=t.dist(e[t.segment+1]),r=t.dist(e[t.segment]);const n={};for(let r=t.segment+1;r<e.length;r++)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r<e.length-1&&(i+=e[r+1].dist(e[r]));for(let i=t.segment||0;i>=0;i--)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=e[i-1].dist(e[i]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(t,e,i,r,n,s,o,a,l,c,h,u){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&o===xu.vertical?Math.PI/2:0,y=s.text&&s.text.sections;for(let r=0;r<e.length;r++){const{tl:n,tr:o,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=e[r],P=f.vertexLength,S=b[1];Du(d,a.x,a.y,n.x,S+n.y,h.x,h.y,i,w,m.x,m.y,x,v),Du(d,a.x,a.y,o.x,S+o.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),Du(d,a.x,a.y,l.x,S+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),Du(d,a.x,a.y,c.x,S+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),Lu(t.dynamicLayoutVertexArray,a,g),p.emplaceBack(P,P+2,P+1),p.emplaceBack(P+1,P+2,P+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==e.length-1&&T===e[r+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{},u,y&&y[T])}t.placedSymbolArray.emplaceBack(a.x,a.y,m,this.glyphOffsetArray.length-m,_,l,c,a.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],o,0,!1,0,h)}_addCollisionDebugVertex(t,e,i,r,n,s){return e.emplaceBack(0,0),t.emplaceBack(i.x,i.y,r,n,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,i,r,n,s,o){const a=n.segments.prepareSegment(4,n.layoutVertexArray,n.indexArray),l=a.vertexLength,h=n.layoutVertexArray,u=n.collisionVertexArray,p=o.anchorX,d=o.anchorY;this._addCollisionDebugVertex(h,u,s,p,d,new c(t,e)),this._addCollisionDebugVertex(h,u,s,p,d,new c(i,e)),this._addCollisionDebugVertex(h,u,s,p,d,new c(i,r)),this._addCollisionDebugVertex(h,u,s,p,d,new c(t,r)),a.vertexLength+=4;const f=n.indexArray;f.emplaceBack(l,l+1),f.emplaceBack(l+1,l+2),f.emplaceBack(l+2,l+3),f.emplaceBack(l+3,l),a.primitiveLength+=4}addDebugCollisionBoxes(t,e,i,r){for(let n=t;n<e;n++){const t=this.collisionBoxArray.get(n);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,r?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Ou(Wa,hu.members,Ja),this.iconCollisionBox=new Ou(Wa,hu.members,Ja);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,i,r,n,s,o,a,l){const c={};for(let r=e;r<i;r++){const e=t.get(r);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=r;e<n;e++){const i=t.get(e);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let e=s;e<o;e++){const i=t.get(e);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let e=a;e<l;e++){const i=t.get(e);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const i=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const i=t.placedSymbolArray.get(e),r=i.vertexStartIndex+4*i.numGlyphs;for(let e=i.vertexStartIndex;e<r;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),i=Math.cos(t),r=[],n=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);r.push(0|Math.round(e*o.anchorX+i*o.anchorY)),n.push(o.featureIndex)}return s.sort(((t,e)=>r[t]-r[e]||n[e]-n[t])),s}addToSortKeyRanges(t,e){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===e?i.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,i)=>{t>=0&&i.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let Vu,Nu;po("SymbolBucket",ju,{omit:["layers","collisionBoxArray","features","compareText"]}),ju.MAX_GLYPHS=65535,ju.addDynamicAttributes=Lu;var Uu={get paint(){return Nu=Nu||new qo({"icon-opacity":new Uo(Se.paint_symbol["icon-opacity"]),"icon-color":new Uo(Se.paint_symbol["icon-color"]),"icon-halo-color":new Uo(Se.paint_symbol["icon-halo-color"]),"icon-halo-width":new Uo(Se.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Uo(Se.paint_symbol["icon-halo-blur"]),"icon-translate":new No(Se.paint_symbol["icon-translate"]),"icon-translate-anchor":new No(Se.paint_symbol["icon-translate-anchor"]),"text-opacity":new Uo(Se.paint_symbol["text-opacity"]),"text-color":new Uo(Se.paint_symbol["text-color"],{runtimeType:qe,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Uo(Se.paint_symbol["text-halo-color"]),"text-halo-width":new Uo(Se.paint_symbol["text-halo-width"]),"text-halo-blur":new Uo(Se.paint_symbol["text-halo-blur"]),"text-translate":new No(Se.paint_symbol["text-translate"]),"text-translate-anchor":new No(Se.paint_symbol["text-translate-anchor"])})},get layout(){return Vu=Vu||new qo({"symbol-placement":new No(Se.layout_symbol["symbol-placement"]),"symbol-spacing":new No(Se.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new No(Se.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Uo(Se.layout_symbol["symbol-sort-key"]),"symbol-z-order":new No(Se.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new No(Se.layout_symbol["icon-allow-overlap"]),"icon-overlap":new No(Se.layout_symbol["icon-overlap"]),"icon-ignore-placement":new No(Se.layout_symbol["icon-ignore-placement"]),"icon-optional":new No(Se.layout_symbol["icon-optional"]),"icon-rotation-alignment":new No(Se.layout_symbol["icon-rotation-alignment"]),"icon-size":new Uo(Se.layout_symbol["icon-size"]),"icon-text-fit":new No(Se.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new No(Se.layout_symbol["icon-text-fit-padding"]),"icon-image":new Uo(Se.layout_symbol["icon-image"]),"icon-rotate":new Uo(Se.layout_symbol["icon-rotate"]),"icon-padding":new Uo(Se.layout_symbol["icon-padding"]),"icon-keep-upright":new No(Se.layout_symbol["icon-keep-upright"]),"icon-offset":new Uo(Se.layout_symbol["icon-offset"]),"icon-anchor":new Uo(Se.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new No(Se.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new No(Se.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new No(Se.layout_symbol["text-rotation-alignment"]),"text-field":new Uo(Se.layout_symbol["text-field"]),"text-font":new Uo(Se.layout_symbol["text-font"]),"text-size":new Uo(Se.layout_symbol["text-size"]),"text-max-width":new Uo(Se.layout_symbol["text-max-width"]),"text-line-height":new No(Se.layout_symbol["text-line-height"]),"text-letter-spacing":new Uo(Se.layout_symbol["text-letter-spacing"]),"text-justify":new Uo(Se.layout_symbol["text-justify"]),"text-radial-offset":new Uo(Se.layout_symbol["text-radial-offset"]),"text-variable-anchor":new No(Se.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Uo(Se.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Uo(Se.layout_symbol["text-anchor"]),"text-max-angle":new No(Se.layout_symbol["text-max-angle"]),"text-writing-mode":new No(Se.layout_symbol["text-writing-mode"]),"text-rotate":new Uo(Se.layout_symbol["text-rotate"]),"text-padding":new No(Se.layout_symbol["text-padding"]),"text-keep-upright":new No(Se.layout_symbol["text-keep-upright"]),"text-transform":new Uo(Se.layout_symbol["text-transform"]),"text-offset":new Uo(Se.layout_symbol["text-offset"]),"text-allow-overlap":new No(Se.layout_symbol["text-allow-overlap"]),"text-overlap":new No(Se.layout_symbol["text-overlap"]),"text-ignore-placement":new No(Se.layout_symbol["text-ignore-placement"]),"text-optional":new No(Se.layout_symbol["text-optional"])})}};class Zu{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Ue,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}po("FormatSectionOverride",Zu,{omit:["defaultValue"]});class Gu extends Ho{constructor(t){super(t,Uu)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const i of t)e.indexOf(i)<0&&e.push(i);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,i,r){const n=this.layout.get(t).evaluate(e,{},i,r),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||cs(s.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,((e,i)=>t&&i in t?String(t[i]):""))}(e.properties,n)}createBucket(t){return new ju(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Uu.paint.overridableProperties){if(!Gu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),i=new Zu(e),r=new ls(i,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new us("source",r):new ps("composite",r,e.value.zoomStops),this.paint._values[t]=new jo(e.property,n,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,i){return!(!this.layout||e.isDataDriven()||i.isDataDriven())&&Gu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const i=t.get("text-field"),r=Uu.paint.properties[e];let n=!1;const s=t=>{for(const e of t)if(r.overrides&&r.overrides.hasOverride(e))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Oi)s(i.value.value.sections);else if("source"===i.value.kind){const t=e=>{n||(e instanceof Ki&&Xi(e.value)===Ke?s(e.value.sections):e instanceof Lr?s(e.sections):e.eachChild(t))},e=i.value;e._styleExpression&&t(e._styleExpression.expression)}return n}}let $u;var qu={get paint(){return $u=$u||new qo({"background-color":new No(Se.paint_background["background-color"]),"background-pattern":new Go(Se.paint_background["background-pattern"]),"background-opacity":new No(Se.paint_background["background-opacity"])})}};class Wu extends Ho{constructor(t){super(t,qu)}}let Hu;var Xu={get paint(){return Hu=Hu||new qo({"raster-opacity":new No(Se.paint_raster["raster-opacity"]),"raster-hue-rotate":new No(Se.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new No(Se.paint_raster["raster-brightness-min"]),"raster-brightness-max":new No(Se.paint_raster["raster-brightness-max"]),"raster-saturation":new No(Se.paint_raster["raster-saturation"]),"raster-contrast":new No(Se.paint_raster["raster-contrast"]),"raster-resampling":new No(Se.paint_raster["raster-resampling"]),"raster-fade-duration":new No(Se.paint_raster["raster-fade-duration"])})}};class Yu extends Ho{constructor(t){super(t,Xu)}}class Ku extends Ho{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Ju(t){if("custom"===t.type)return new Ku(t);switch(t.type){case"background":return new Wu(t);case"circle":return new lc(t);case"color-relief":return new Cc(t);case"fill":return new yh(t);case"fill-extrusion":return new Zh(t);case"heatmap":return new vc(t);case"hillshade":return new Tc(t);case"line":return new su(t);case"raster":return new Yu(t);case"symbol":return new Gu(t)}}function Qu(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:r,url:n}of t){const t=`${r}${n}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:r,url:n}))}}return e}function tp(t,e,i){try{const r=new URL(t);return r.pathname+=`${e}${i}`,r.toString()}catch(e){throw new Error(`Invalid sprite URL "${t}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function ep(t){const{userImage:e}=t;return!!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class ip extends Pe{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new gc({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[]}}getImage(t){const e=this.images[t];if(e&&!e.data&&e.spriteData){const t=e.spriteData;e.data=new gc({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),e.spriteData=null}return e}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e)}_validate(t,e){let i=!0;const r=e.data||e.spriteData;return this._validateStretch(e.stretchX,r&&r.width)||(this.fire(new Te(new Error(`Image "${t}" has invalid "stretchX" value`))),i=!1),this._validateStretch(e.stretchY,r&&r.height)||(this.fire(new Te(new Error(`Image "${t}" has invalid "stretchY" value`))),i=!1),this._validateContent(e.content,e)||(this.fire(new Te(new Error(`Image "${t}" has invalid "content" value`))),i=!1),i}_validateStretch(t,e){if(!t)return!0;let i=0;for(const r of t){if(r[0]<i||r[1]<r[0]||e<r[1])return!1;i=r[1]}return!0}_validateContent(t,e){if(!t)return!0;if(4!==t.length)return!1;const i=e.spriteData,r=i&&i.width||e.data.width,n=i&&i.height||e.data.height;return!(t[0]<0||r<t[0]||t[1]<0||n<t[1]||t[2]<0||r<t[2]||t[3]<0||n<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const r=this.getImage(t);if(i&&(r.data.width!==e.data.width||r.data.height!==e.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=r.version+1,this.images[t]=e,this.updatedImages[t]=!0}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let r=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(r=!1);this.isLoaded()||r?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e})}))}_getImagesForIds(t){const e={};for(const i of t){let t=this.getImage(i);t||(this.fire(new we("styleimagemissing",{id:i})),t=this.getImage(i)),t?e[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:Bt(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return e}getPixelSize(){const{width:t,height:e}=this.atlasImage;return{width:t,height:e}}getPattern(t){const e=this.patterns[t],i=this.getImage(t);if(!i)return null;if(e&&e.position.version===i.version)return e.position;if(e)e.position.version=i.version;else{const e={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new Mu(e,i);this.patterns[t]={bin:e,position:r}}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Mc(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE)}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:e,h:i}=Su(t),r=this.atlasImage;r.resize({width:e||1,height:i||1});for(const t in this.patterns){const{bin:e}=this.patterns[t],i=e.x+1,n=e.y+1,s=this.getImage(t).data,o=s.width,a=s.height;gc.copy(s,r,{x:0,y:0},{x:i,y:n},{width:o,height:a}),gc.copy(s,r,{x:0,y:a-1},{x:i,y:n-1},{width:o,height:1}),gc.copy(s,r,{x:0,y:0},{x:i,y:n+a},{width:o,height:1}),gc.copy(s,r,{x:o-1,y:0},{x:i-1,y:n},{width:1,height:a}),gc.copy(s,r,{x:0,y:0},{x:i+o,y:n},{width:1,height:a})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.getImage(e);t||Bt(`Image with ID: "${e}" was not found`),ep(t)&&this.updateImage(e,t)}}}const rp=1e20;function np(t,e,i,r,n,s,o,a,l){for(let c=e;c<e+r;c++)sp(t,i*s+c,s,n,o,a,l);for(let c=i;c<i+n;c++)sp(t,c*s+e,1,r,o,a,l)}function sp(t,e,i,r,n,s,o){s[0]=0,o[0]=-rp,o[1]=rp,n[0]=t[e];for(let a=1,l=0,c=0;a<r;a++){n[a]=t[e+a*i];const r=a*a;do{const t=s[l];c=(n[a]-n[t]+r-t*t)/(a-t)/2}while(c<=o[l]&&--l>-1);l++,s[l]=a,o[l]=c,o[l+1]=rp}for(let a=0,l=0;a<r;a++){for(;o[l+1]<a;)l++;const r=s[l],c=a-r;t[e+a*i]=n[r]+c*c}}class op{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={}}setURL(t){this.url=t}getGlyphs(t){return n(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const r of t[i])e.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(e),r={};for(const{stack:t,id:e,glyph:n}of i)r[t]||(r[t]={}),r[t][e]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};return r}))}_getAndCacheGlyphsPromise(t,e){return n(this,void 0,void 0,(function*(){let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[e];if(void 0!==r)return{stack:t,id:e,glyph:r};if(r=this._tinySDF(i,t,e),r)return i.glyphs[e]=r,{stack:t,id:e,glyph:r};const n=Math.floor(e/256);if(256*n>65535)throw new Error("glyphs > 65535 not supported");if(i.ranges[n])return{stack:t,id:e,glyph:r};if(!this.url)throw new Error("glyphsUrl is not set");if(!i.requests[n]){const e=op.loadGlyphRange(t,n,this.url,this.requestManager);i.requests[n]=e}const s=yield i.requests[n];for(const t in s)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=s[+t]);return i.ranges[n]=!0,{stack:t,id:e,glyph:s[e]||null}}))}_doesCharSupportLocalGlyph(t){return!!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))||(e=t)>=19968&&e<=40959||(t=>t>=44032&&t<=55215)(t)||(t=>t>=12352&&t<=12447)(t)||bo(t)||vo(t)||wo(t));var e}_tinySDF(t,e,i){const r=this.localIdeographFontFamily;if(!r)return;if(!this._doesCharSupportLocalGlyph(i))return;let n=t.tinySDF;if(!n){let i="400";/bold/i.test(e)?i="900":/medium/i.test(e)?i="500":/light/i.test(e)&&(i="200"),n=t.tinySDF=new op.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:r,fontWeight:i})}const s=n.draw(String.fromCharCode(i));return{id:i,bitmap:new _c({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}}}}op.loadGlyphRange=function(t,e,i,r){return n(this,void 0,void 0,(function*(){const n=256*e,s=n+255,o=r.transformRequest(i.replace("{fontstack}",t).replace("{range}",`${n}-${s}`),"Glyphs"),a=yield(l=o,c=new AbortController,ce(St(l,{type:"arrayBuffer"}),c));var l,c;if(!a||!a.data)throw new Error(`Could not load glyph range. range: ${e}, ${n}-${s}`);const h={};for(const t of new bu(a.data).readFields(wu,[]))h[t.id]=t;return h}))},op.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:s="normal",fontStyle:o="normal"}={}){this.buffer=e,this.cutoff=r,this.radius=i;const a=this.size=t+4*e,l=this._createCanvas(a),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${o} ${s} ${t}px ${n}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(a*a),this.gridInner=new Float64Array(a*a),this.f=new Float64Array(a),this.z=new Float64Array(a+1),this.v=new Uint16Array(a)}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:s}=this.ctx.measureText(t),o=Math.ceil(i),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-n))),l=Math.min(this.size-this.buffer,o+Math.ceil(r)),c=a+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),p=new Uint8ClampedArray(u),d={data:p,width:c,height:h,glyphWidth:a,glyphHeight:l,glyphTop:o,glyphLeft:0,glyphAdvance:e};if(0===a||0===l)return d;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;f.clearRect(m,m,a,l),f.fillText(t,m,m+o);const y=f.getImageData(m,m,a,l);g.fill(rp,0,u),_.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<a;e++){const i=y.data[4*(t*a+e)+3]/255;if(0===i)continue;const r=(t+m)*c+e+m;if(1===i)g[r]=0,_[r]=rp;else{const t=.5-i;g[r]=t>0?t*t:0,_[r]=t<0?t*t:0}}np(g,0,0,c,h,c,this.f,this.v,this.z),np(_,m,m,a,l,c,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(_[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff))}return d}};class ap{constructor(){this.specification=Se.light.position}possiblyEvaluate(t,e){return function([t,e,i]){return e+=90,e*=Math.PI/180,i*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(i),y:t*Math.sin(e)*Math.sin(i),z:t*Math.cos(i)}}(t.expression.evaluate(e))}interpolate(t,e,i){return{x:wr.number(t.x,e.x,i),y:wr.number(t.y,e.y,i),z:wr.number(t.z,e.z,i)}}}let lp;class cp extends Pe{constructor(t){super(),lp=lp||new qo({anchor:new No(Se.light.anchor),position:new ap,color:new No(Se.light.color),intensity:new No(Se.light.intensity)}),this._transitionable=new Lo(lp),this.setLight(t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(t,e={}){if(!this._validate(so,t,e))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i){return(!i||!1!==i.validate)&&co(this,t.call(no,{value:e,style:{glyphs:!0,sprite:!0},styleSpec:Se}))}}const hp=new qo({"sky-color":new No(Se.sky["sky-color"]),"horizon-color":new No(Se.sky["horizon-color"]),"fog-color":new No(Se.sky["fog-color"]),"fog-ground-blend":new No(Se.sky["fog-ground-blend"]),"horizon-fog-blend":new No(Se.sky["horizon-fog-blend"]),"sky-horizon-blend":new No(Se.sky["sky-horizon-blend"]),"atmosphere-blend":new No(Se.sky["atmosphere-blend"])});class up extends Pe{constructor(t){super(),this._transitionable=new Lo(hp),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ko(0))}setSky(t,e={}){if(!this._validate(oo,t,e)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i={}){return!1!==(null==i?void 0:i.validate)&&co(this,t.call(no,St({value:e,style:{glyphs:!0,sprite:!0},styleSpec:Se})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class pp{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const r=[];let n=t.length%2==1?-t[t.length-1]*i:0,s=t[0]*i,o=!0;r.push({left:n,right:s,isDash:o,zeroLength:0===t[0]});let a=t[0];for(let e=1;e<t.length;e++){o=!o;const l=t[e];n=a*i,a+=l,s=a*i,r.push({left:n,right:s,isDash:o,zeroLength:0===l})}return r}addRoundDash(t,e,i){const r=e/2;for(let e=-i;e<=i;e++){const n=this.width*(this.nextRow+i+e);let s=0,o=t[s];for(let a=0;a<this.width;a++){a/o.right>1&&(o=t[++s]);const l=Math.abs(a-o.left),c=Math.abs(a-o.right),h=Math.min(l,c);let u;const p=e/i*(r+1);if(o.isDash){const t=r-Math.abs(p);u=Math.sqrt(h*h+t*t)}else u=r-Math.sqrt(h*h+p*p);this.data[n+a]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],r=t[e+1];i.zeroLength?t.splice(e,1):r&&r.isDash===i.isDash&&(r.left=i.left,t.splice(e,1))}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const r=this.width*this.nextRow;let n=0,s=t[n];for(let e=0;e<this.width;e++){e/s.right>1&&(s=t[++n]);const i=Math.abs(e-s.left),o=Math.abs(e-s.right),a=Math.min(i,o);this.data[r+e]=Math.max(0,Math.min(255,(s.isDash?a:-a)+128))}}addDash(t,e){const i=e?7:0,r=2*i+1;if(this.nextRow+r>this.height)return Bt("LineAtlas out of space"),null;let n=0;for(let e=0;e<t.length;e++)n+=t[e];if(0!==n){const r=this.width/n,s=this.getDashRanges(t,this.width,r);e?this.addRoundDash(s,r,i):this.addRegularDash(s)}const s={y:(this.nextRow+i+.5)/this.height,height:2*i/this.height,width:n};return this.nextRow+=r,this.dirty=!0,s}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data))}}class dp{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const fp={once:!0};class mp{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new dp((()=>this.process())),this.subscription=Ut(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=Ot(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((i,r)=>{const n=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?Ut(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[n];const e={id:n,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),fp):null;this.resolveRejects[n]={resolve:t=>{null==s||s.unsubscribe(),i(t)},reject:t=>{null==s||s.unsubscribe(),r(t)}};const o=[],a=Object.assign(Object.assign({},t),{id:n,sourceMapId:this.mapId,origin:location.origin,data:go(t.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(t){const e=t.data,i=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[i];const t=this.abortControllers[i];return delete this.abortControllers[i],void(t&&t.abort())}if(Ot(self)||e.mustQueue)return this.tasks[i]=e,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(t,e){return n(this,void 0,void 0,(function*(){if("<response>"===e.type){const i=this.resolveRejects[t];if(delete this.resolveRejects[t],!i)return;return void(e.error?i.reject(yo(e.error)):i.resolve(yo(e.data)))}if(!this.messageHandlers[e.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${e.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=yo(e.data),r=new AbortController;this.abortControllers[t]=r;try{const n=yield this.messageHandlers[e.type](e.sourceMapId,i,r);this.completeTask(t,null,n)}catch(e){this.completeTask(t,e)}}))}completeTask(t,e,i){const r=[];delete this.abortControllers[t];const n={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?go(e):null,data:go(i,r)};this.target.postMessage(n,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const _p="maplibre_preloaded_worker_pool";class gp{constructor(){this.active={}}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<gp.workerCount;)this.workers.push(new Worker(ne.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[_p]}numActive(){return Object.keys(this.active).length}}const yp=Math.floor(ie.hardwareConcurrency/2);let xp,vp;function bp(){return xp||(xp=new gp),xp}gp.workerCount=function(t){if(null==jt){const e=t.navigator?t.navigator.userAgent:null;jt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")))}return jt}(globalThis)?Math.max(Math.min(yp,3),1):1;class wp{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e;const i=this.workerPool.acquire(e);for(let t=0;t<i.length;t++){const r=new mp(i[t],e);r.name=`Worker ${t}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove()})),this.actors=[],t&&this.workerPool.release(this.id)}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e)}}function Tp(){return vp||(vp=new wp(bp(),oe),vp.registerMessageHandler("GR",((t,e,i)=>ce(e,i)))),vp}function Pp(t,e){const i=x();return P(i,i,[1,1,0]),S(i,i,[.5*t.width,.5*t.height,1]),t.calculatePosMatrix?T(i,i,t.calculatePosMatrix(e.toUnwrapped())):i}function Sp(t,e,i,r,n,s,o){var a;const l=function(t,e,i){if(t)for(const r of t){const t=e[r];if(t&&t.source===i&&"fill-extrusion"===t.type)return!0}else for(const t in e){const r=e[t];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(null!==(a=null==n?void 0:n.layers)&&void 0!==a?a:null,e,t.id),c=s.maxPitchScaleFactor(),h=t.tilesIn(r,c,l);h.sort(Mp);const u=[];for(const r of h)u.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(e,i,t._state,r.queryGeometry,r.cameraQueryGeometry,r.scale,n,s,c,Pp(t.transform,r.tileID),o?(t,e)=>o(r.tileID,t,e):void 0)});return function(t,e){for(const i in t)for(const r of t[i])Ip(r,e);return t}(function(t){const e={},i={};for(const r of t){const t=r.queryResults,n=r.wrappedTileID,s=i[n]=i[n]||{};for(const i in t){const r=t[i],n=s[i]=s[i]||{},o=e[i]=e[i]||[];for(const t of r)n[t.featureIndex]||(n[t.featureIndex]=!0,o.push(t))}}return e}(u),t)}function Mp(t,e){const i=t.tileID,r=e.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function Ip(t,e){const i=t.feature,r=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}function Cp(t,e,i){return n(this,void 0,void 0,(function*(){let r=t;if(t.url?r=(yield he(e.transformRequest(t.url,"Source"),i)).data:yield ie.frameAsync(i),!r)return null;const n=Mt(St(r,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(n.vectorLayerIds=r.vector_layers.map((t=>t.id))),n}))}const Ap=6371008.8;class Ep{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Ep(Pt(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,i=this.lat*e,r=t.lat*e,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((t.lng-this.lng)*e);return Ap*Math.acos(Math.min(n,1))}static convert(t){if(t instanceof Ep)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Ep(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Ep(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class zp{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])))}setNorthEast(t){return this._ne=t instanceof Ep?new Ep(t.lng,t.lat):Ep.convert(t),this}setSouthWest(t){return this._sw=t instanceof Ep?new Ep(t.lng,t.lat):Ep.convert(t),this}extend(t){const e=this._sw,i=this._ne;let r,n;if(t instanceof Ep)r=t,n=t;else{if(!(t instanceof zp))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(zp.convert(t)):this.extend(Ep.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(Ep.convert(t)):this;if(r=t._sw,n=t._ne,!r||!n)return this}return e||i?(e.lng=Math.min(r.lng,e.lng),e.lat=Math.min(r.lat,e.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new Ep(r.lng,r.lat),this._ne=new Ep(n.lng,n.lat)),this}getCenter(){return new Ep((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Ep(this.getWest(),this.getNorth())}getSouthEast(){return new Ep(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(t){const{lng:e,lat:i}=Ep.convert(t);let r=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(t){return t instanceof zp?t:t?new zp(t):t}static fromLngLat(t,e=0){const i=360*e/40075017,r=i/Math.cos(Math.PI/180*t.lat);return new zp(new Ep(t.lng-r,t.lat-i),new Ep(t.lng+r,t.lat+i))}adjustAntiMeridian(){const t=new Ep(this._sw.lng,this._sw.lat),e=new Ep(this._ne.lng,this._ne.lat);return new zp(t,t.lng>e.lng?new Ep(e.lng+360,e.lat):e)}}const kp=2*Math.PI*Ap;function Rp(t){return kp*Math.cos(t*Math.PI/180)}function Dp(t){return(180+t)/360}function Lp(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Bp(t,e){return t/Rp(e)}function Fp(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Op(t,e){return t*Rp(Fp(e))}class jp{constructor(t,e,i=0){this.x=+t,this.y=+e,this.z=+i}static fromLngLat(t,e=0){const i=Ep.convert(t);return new jp(Dp(i.lng),Lp(i.lat),Bp(e,i.lat))}toLngLat(){return new Ep(360*this.x-180,Fp(this.y))}toAltitude(){return Op(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/kp*(t=Fp(this.y),1/Math.cos(t*Math.PI/180));var t}}class Vp{constructor(t,e,i){this.bounds=zp.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const e=Math.pow(2,t.z),i=Math.floor(Dp(this.bounds.getWest())*e),r=Math.floor(Lp(this.bounds.getNorth())*e),n=Math.ceil(Dp(this.bounds.getEast())*e),s=Math.ceil(Lp(this.bounds.getSouth())*e);return t.x>=i&&t.x<n&&t.y>=r&&t.y<s}}class Np extends Pe{constructor(t,e,i,r){if(super(),this.id=t,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,St(this,Mt(e,["url","scheme","tileSize","promoteId"])),this._options=St({type:"vector"},e),this._collectResourceTiming=e.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield Cp(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(St(this,t),t.bounds&&(this.tileBounds=new Vp(t.bounds,this.minzoom,this.maxzoom)),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new we("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this.fire(new Te(t))}}))}loaded(){return this._loaded}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load()}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return St({},this._options)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,globalState:this.map.getGlobalState()};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i}}))}else t.actor=this.dispatcher.getActor(),r="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:r,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e)}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null)}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject)}}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class Up extends Pe{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=St({type:"raster"},e),St(this,Mt(e,["url","scheme","tileSize"]))}load(){return n(this,arguments,void 0,(function*(t=!1){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield Cp(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,e&&(St(this,e),e.bounds&&(this.tileBounds=new Vp(e.bounds,this.minzoom,this.maxzoom)),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new we("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:t})))}catch(t){this._tileJSONRequest=null,this.fire(new Te(t))}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load(!0)}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}serialize(){return St({},this._options)}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield ye.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,r=e.gl,n=i.data;t.texture=this.map.painter.getTileTexture(n.width),t.texture?t.texture.update(n,{useMipmap:!0}):(t.texture=new Mc(e,n,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),t.state="loaded"}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController)}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture)}))}hasTransition(){return!1}}function Zp(t,e,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[t*r-2*Math.PI*6378137/2,e*r-2*Math.PI*6378137/2]}class Gp{constructor(t,e,i){if(!function(t,e,i){return!(t<0||t>25||i<0||i>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,i))throw new Error(`x=${e}, y=${i}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=i,this.key=Wp(0,t,t,e,i)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,i){const r=(s=this.y,o=this.z,a=Zp(256*(n=this.x),256*(s=Math.pow(2,o)-s-1),o),l=Zp(256*(n+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var n,s,o,a,l;const c=function(t,e,i){let r,n="";for(let s=t;s>0;s--)r=1<<s-1,n+=(e&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new c((t.x*e-this.x)*it,(t.y*e-this.y)*it)}toString(){return`${this.z}/${this.x}/${this.y}`}}class $p{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Wp(t,e.z,e.z,e.x,e.y)}}class qp{constructor(t,e,i,r,n){if(this.terrainRttPosMatrix32f=null,t<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${i}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Gp(i,+r,+n),this.key=Wp(e,t,i,r,n)}clone(){return new qp(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new qp(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new qp(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-t;return t>this.canonical.z?Wp(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Wp(this.wrap*+e,t,t,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new qp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new qp(e,this.wrap,e,i,r),new qp(e,this.wrap,e,i+1,r),new qp(e,this.wrap,e,i,r+1),new qp(e,this.wrap,e,i+1,r+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new qp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new qp(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new $p(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new jp(t.x-this.wrap,t.y))}}function Wp(t,e,i,r,n){(t*=2)<0&&(t=-1*t-1);const s=1<<i;return(s*s*t+s*n+r).toString(36)+i.toString(36)+e.toString(36)}po("CanonicalTileID",Gp),po("OverscaledTileID",qp,{omit:["terrainRttPosMatrix32f"]});class Hp extends Up{constructor(t,e,i,r){super(t,e,i,r),this.type="raster-dem",this.maxzoom=22,this._options=St({type:"raster-dem"},e),this.encoding=e.encoding||"mapbox",this.redFactor=e.redFactor,this.greenFactor=e.greenFactor,this.blueFactor=e.blueFactor,this.baseShift=e.baseShift}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(e,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const e=yield ye.getImage(i,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(e&&e.data){const i=e.data;this.map._refreshExpiredTiles&&(e.cacheControl||e.expires)&&t.setExpiryData({cacheControl:e.cacheControl,expires:e.expires});const r=Vt(i)&&f()?i:yield this.readImageNow(i),n={type:this.type,uid:t.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:n});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded"}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return n(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==d&&(d=!1,f())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let i=0;i<t*t;i++){const r=4*i;e.fillStyle=`rgb(${r},${r+1},${r+2})`,e.fillRect(i%t,Math.floor(i/t),1,1)}const i=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&i[e]!==e){d=!0;break}}}return d||!1}()){const e=t.width+2,i=t.height+2;try{return new gc({width:e,height:i},yield function(t,e,i,r,s){return n(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const i=null==e?void 0:e.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const n=i.startsWith("BGR"),o=new Uint8ClampedArray(r*s*4);if(yield e.copyTo(o,function(t,e,i,r,n){const s=4*Math.max(1,0),o=(Math.max(0,-1)- -1)*r*4+s,a=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(t.width,-1+r)-l,height:Math.min(t.height,-1+n)-c},layout:[{offset:o,stride:a}]}}(t,0,0,r,s)),n)for(let t=0;t<o.length;t+=4){const e=o[t];o[t]=o[t+2],o[t+2]=e}return o}finally{e.close()}}))}(t,0,0,e,i))}catch(t){}}return ie.getImageData(t,1)}))}_getNeighboringTiles(t){const e=t.canonical,i=Math.pow(2,e.z),r=(e.x-1+i)%i,n=0===e.x?t.wrap-1:t.wrap,s=(e.x+1+i)%i,o=e.x+1===i?t.wrap+1:t.wrap,a={};return a[new qp(t.overscaledZ,n,e.z,r,e.y).key]={backfilled:!1},a[new qp(t.overscaledZ,o,e.z,s,e.y).key]={backfilled:!1},e.y>0&&(a[new qp(t.overscaledZ,n,e.z,r,e.y-1).key]={backfilled:!1},a[new qp(t.overscaledZ,t.wrap,e.z,e.x,e.y-1).key]={backfilled:!1},a[new qp(t.overscaledZ,o,e.z,s,e.y-1).key]={backfilled:!1}),e.y+1<i&&(a[new qp(t.overscaledZ,n,e.z,r,e.y+1).key]={backfilled:!1},a[new qp(t.overscaledZ,t.wrap,e.z,e.x,e.y+1).key]={backfilled:!1},a[new qp(t.overscaledZ,o,e.z,s,e.y+1).key]={backfilled:!1}),a}unloadTile(t){return n(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}))}))}}class Xp extends Pe{constructor(t,e,i,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=i.getActor(),this.setEventedParent(r),this._data=e.data,this._options=St({},e),this._collectResourceTiming=e.collectResourceTiming,void 0!==e.maxzoom&&(this.maxzoom=e.maxzoom),e.type&&(this.type=e.type),e.attribution&&(this.attribution=e.attribution),this.promoteId=e.promoteId,void 0!==e.clusterMaxZoom&&this.maxzoom<=e.clusterMaxZoom&&Bt(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${e.clusterMaxZoom}".`),this.workerOptions=St({source:this.id,cluster:e.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==e.buffer?e.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==e.tolerance?e.tolerance:.375),extent:it,maxZoom:this.maxzoom,lineMetrics:e.lineMetrics||!1,generateId:e.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(e.clusterMaxZoom),minPoints:Math.max(2,e.clusterMinPoints||2),extent:it,radius:this._pixelsToTileUnits(e.clusterRadius||50),log:!1,generateId:e.generateId||!1},clusterProperties:e.clusterProperties,filter:e.filter},e.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}_pixelsToTileUnits(t){return t*(it/this.tileSize)}_getClusterMaxZoom(t){const e=t?Math.round(t):this.maxzoom-1;return Number.isInteger(t)||void 0===t||Bt(`Integer expected for option 'clusterMaxZoom': provided value "${t}" rounded to "${e}"`),e}load(){return n(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(t){this.map=t,this.load()}setData(t){return this._data=t,this._updateWorkerData(),this}updateData(t){return this._updateWorkerData(t),this}getData(){return n(this,void 0,void 0,(function*(){const t=St({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}getCoordinatesFromGeometry(t){return"GeometryCollection"===t.type?t.geometries.map((t=>t.coordinates)).flat(1/0):t.coordinates.flat(1/0)}getBounds(){return n(this,void 0,void 0,(function*(){const t=new zp,e=yield this.getData();let i;switch(e.type){case"FeatureCollection":i=e.features.map((t=>this.getCoordinatesFromGeometry(t.geometry))).flat(1/0);break;case"Feature":i=this.getCoordinatesFromGeometry(e.geometry);break;default:i=this.getCoordinatesFromGeometry(e)}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(t.clusterRadius)),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(t.clusterMaxZoom))),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(t){return n(this,void 0,void 0,(function*(){const e=St({type:this.type},this.workerOptions);t?e.dataDiff=t:"string"==typeof this._data?(e.request=this.map._requestManager.transformRequest(ie.resolveURL(this._data),"Source"),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new we("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:e});if(this._pendingLoads--,this._removed||t.abandoned)return void this.fire(new we("dataabort",{dataType:"source"}));let i=null;t.resourceTiming&&t.resourceTiming[this.id]&&(i=t.resourceTiming[this.id].slice(0));const r={dataType:"source"};this._collectResourceTiming&&i&&i.length>0&&St(r,{resourceTiming:i}),this.fire(new we("data",Object.assign(Object.assign({},r),{sourceDataType:"metadata"}))),this.fire(new we("data",Object.assign(Object.assign({},r),{sourceDataType:"content"})))}catch(t){if(this._pendingLoads--,this._removed)return void this.fire(new we("dataabort",{dataType:"source"}));this.fire(new Te(t))}}))}loaded(){return 0===this._pendingLoads}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,globalState:this.map.getGlobalState()};t.abortController=new AbortController;const r=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(r,this.map.painter,"RT"===e)}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return St({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}}class Yp{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new Yp;return e.extend(t(new c(this.minX,this.minY))),e.extend(t(new c(this.maxX,this.minY))),e.extend(t(new c(this.minX,this.maxY))),e.extend(t(new c(this.maxX,this.maxY))),e}static fromPoints(t){const e=new Yp;for(const i of t)e.extend(i);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class Kp extends Pe{constructor(t,e,i,r){super(),this.flippedWindingOrder=!1,this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=e}load(t){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield ye.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading())}catch(t){this._request=null,this._loaded=!0,this.fire(new Te(t))}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(t){this.map=t,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(t){this.coordinates=t;const e=t.map(jp.fromLngLat);var i;return this.tileID=function(t){const e=Yp.fromPoints(t),i=e.width(),r=e.height(),n=Math.max(i,r),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),o=Math.pow(2,s);return new Gp(s,Math.floor((e.minX+e.maxX)/2*o),Math.floor((e.minY+e.maxY)/2*o))}(e),this.terrainTileRanges=this._getOverlappingTileRanges(e),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=e.map((t=>this.tileID.getTilePoint(t)._round())),this.flippedWindingOrder=((i=this.tileCoords)[1].x-i[0].x)*(i[2].y-i[0].y)-(i[1].y-i[0].y)*(i[2].x-i[0].x)<0,this.fire(new we("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,e=t.gl;this.texture||(this.texture=new Mc(t,this.image,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(t){return n(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}_getOverlappingTileRanges(t){const{minX:e,minY:i,maxX:r,maxY:n}=Yp.fromPoints(t),s={};for(let t=0;t<=25;t++){const o=Math.pow(2,t),a=Math.floor(e*o),l=Math.floor(i*o),c=Math.floor(r*o),h=Math.floor(n*o);s[t]={minTileX:a,minTileY:l,maxTileX:c,maxTileY:h}}return s}}class Jp extends Kp{constructor(t,e,i,r){super(t,e,i,r),this.roundZoom=!0,this.type="video",this.options=e}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield(t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((i=>{e.onloadstart=()=>{i(e)};for(const i of t){const t=window.document.createElement("source");ue(i)||(e.crossOrigin="Anonymous"),t.src=i,e.appendChild(t)}}))})(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(t){this.fire(new Te(t))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(t){if(this.video){const e=this.video.seekable;t<e.start(0)||t>e.end(0)?this.fire(new Te(new Oe(`sources.${this.id}`,null,`Playback for this video can be set only between the ${e.start(0)} and ${e.end(0)}-second mark.`))):this.video.currentTime=t}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,e=t.gl;this.texture?this.video.paused||(this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE),e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,this.video)):(this.texture=new Mc(t,this.video,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class Qp extends Kp{constructor(t,e,i,r){super(t,e,i,r),e.coordinates?Array.isArray(e.coordinates)&&4===e.coordinates.length&&!e.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new Te(new Oe(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new Te(new Oe(`sources.${t}`,null,'missing required property "coordinates"'))),e.animate&&"boolean"!=typeof e.animate&&this.fire(new Te(new Oe(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),e.canvas?"string"==typeof e.canvas||e.canvas instanceof HTMLCanvasElement||this.fire(new Te(new Oe(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new Te(new Oe(`sources.${t}`,null,'missing required property "canvas"'))),this.options=e,this.animate=void 0===e.animate||e.animate}load(){return n(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new Te(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const e=this.map.painter.context,i=e.gl;this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Mc(e,this.canvas,i.RGBA,{premultiply:!0});let r=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,r=!0)}r&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of[this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return!0;return!1}}const td={},ed=t=>{switch(t){case"geojson":return Xp;case"image":return Kp;case"raster":return Up;case"raster-dem":return Hp;case"vector":return Np;case"video":return Jp;case"canvas":return Qp}return td[t]};class id{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const i=t[e];this._stringToNumber[i]=e,this._numberToString[e]=i}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class rd{constructor(t,e,i,r,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=i,t._y=r,this.properties=t.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}function nd(t,e,i,r,n){return zt(t,((t,s)=>{const o=e instanceof Vo?e.get(s):null;return o&&o.evaluate?o.evaluate(i,r,n):o}))}function sd(t,e){return e-t}po("FeatureIndex",class{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ho(it,16,0),this.grid3D=new ho(it,16,0),this.featureIndexArray=new Da,this.promoteId=e}insert(t,e,i,r,n,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n);const a=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const i=e[t],r=[1/0,1/0,-1/0,-1/0];for(let t=0;t<i.length;t++){const e=i[t];r[0]=Math.min(r[0],e.x),r[1]=Math.min(r[1],e.y),r[2]=Math.max(r[2],e.x),r[3]=Math.max(r[3],e.y)}r[0]<it&&r[1]<it&&r[2]>=0&&r[3]>=0&&a.insert(o,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Rh.VectorTile(new bu(this.rawTileData)).layers,this.sourceLayerCoder=new id(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,i,r){this.loadVTLayers();const n=t.params,s=it/t.tileSize/t.scale,o=xs(n.filter),a=t.queryGeometry,l=t.queryPadding*s,h=Yp.fromPoints(a),u=this.grid.query(h.minX-l,h.minY-l,h.maxX+l,h.maxY+l),p=Yp.fromPoints(t.cameraQueryGeometry).expandBy(l),d=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((e,i,r,n)=>function(t,e,i,r,n){for(const s of t)if(e<=s.x&&i<=s.y&&r>=s.x&&n>=s.y)return!0;const s=[new c(e,i),new c(e,n),new c(r,n),new c(r,i)];if(t.length>2)for(const e of s)if(tc(t,e))return!0;for(let e=0;e<t.length-1;e++)if(ec(t[e],t[e+1],s))return!0;return!1}(t.cameraQueryGeometry,e-l,i-l,r+l,n+l)));for(const t of d)u.push(t);u.sort(sd);const f={};let m;for(let l=0;l<u.length;l++){const c=u[l];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let p=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,o,n.layers,n.availableImages,e,i,r,((e,i,r)=>(p||(p=Vl(e)),i.queryIntersectsFeature({queryGeometry:a,feature:e,featureState:r,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:s,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return f}loadMatchingFeature(t,e,i,r,n,s,o,a,l,c,h){const u=this.bucketLayerIDs[e];if(s&&!u.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(i),d=this.vtLayers[p].feature(r);if(n.needGeometry){const t=Nl(d,!0);if(!n.filter(new ko(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!n.filter(new ko(this.tileID.overscaledZ),d))return;const f=this.getId(d,p);for(let e=0;e<u.length;e++){const i=u[e];if(s&&!s.has(i))continue;const n=a[i];if(!n)continue;let p={};f&&c&&(p=c.getState(n.sourceLayer||"_geojsonTileLayer",f));const m=St({},l[i]);m.paint=nd(m.paint,n.paint,d,p,o),m.layout=nd(m.layout,n.layout,d,p,o);const _=!h||h(d,n,p);if(!_)continue;const g=new rd(d,this.z,this.x,this.y,f);g.layer=m;let y=t[i];void 0===y&&(y=t[i]=[]),y.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(t,e,i,r,n,s,o,a){const l={};this.loadVTLayers();const c=xs(n);for(const n of t)this.loadMatchingFeature(l,i,r,n,c,s,o,a,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const i of e)if(t===i)return!0;return!1}getId(t,e){var i;let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r)),void 0===r&&(null===(i=t.properties)||void 0===i?void 0:i.cluster)&&this.promoteId&&(r=Number(t.properties.cluster_id))),r}},{omit:["rawTileData","sourceLayerCoder"]});const od="RTLPluginLoaded";class ad extends Pe{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Tp()}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(t){return n(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=ie.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return n(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new we(od))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let ld=null;function cd(){return ld||(ld=new ad),ld}class hd{constructor(t,e){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=Ct(),this.uses=0,this.tileSize=e,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(t,e,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const r of t){const t=r.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){r.layers=t,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=r}}return i}(t.buckets,null==e?void 0:e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof ju){if(this.hasSymbolBuckets=!0,!i)break;e.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof ju&&e.hasRTLText){this.hasRTLText=!0,cd().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const i=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(i))}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage)}else this.collisionBoxArray=new Pa}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t)}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Mc(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Mc(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null)}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture)}queryRenderedFeatures(t,e,i,r,n,s,o,a,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:n,scale:s,tileSize:this.tileSize,pixelPosMatrix:c,transform:a,params:o,queryPadding:this.queryPadding*l,getElevation:h},t,e,i):{}}querySourceFeatures(t,e){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=e&&e.sourceLayer?e.sourceLayer:"",s=r._geojsonTileLayer||r[n];if(!s)return;const o=xs(e&&e.filter),{z:a,x:l,y:c}=this.tileID.canonical,h={z:a,x:l,y:c};for(let e=0;e<s.length;e++){const r=s.feature(e);if(o.needGeometry){const t=Nl(r,!0);if(!o.filter(new ko(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!o.filter(new ko(this.tileID.overscaledZ),r))continue;const u=i.getId(r,n),p=new rd(r,a,l,c,u);p.tile=h,t.push(p)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,i,r,n)=>{const s=r||n;return e[i]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t}return e}(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"])}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let i=!1;if(this.expirationTime>t)i=!1;else if(e)if(this.expirationTime<e)i=!0;else{const r=this.expirationTime-e;r?this.expirationTime=t+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!e.style.hasLayer(r))continue;const n=this.buckets[r],s=n.layers[0].sourceLayer||"_geojsonTileLayer",o=i[s],a=t[s];if(!o||!a||0===Object.keys(a).length)continue;n.update(a,o,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<ie.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(t){this.symbolFadeHoldUntil=ie.now()+t}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return!0}return!1}}class ud{constructor(t,e){this.max=t,this.onRemove=e,this.reset()}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const r=t.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:e,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(t,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,r=void 0===e?0:this.data[i].indexOf(e),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}filter(t){const e=[];for(const i in this.data)for(const r of this.data[i])t(r.value)||e.push(r);for(const t of e)this.remove(t.value.tileID,t)}}class pd{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(t,e,i){const r=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},St(this.stateChanges[t][r],i),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null)}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])i[e]||(this.deletedStates[t][r][e]=null)}else for(const e in i)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e]}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const r=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][r]&&(this.deletedStates[t][r]=this.deletedStates[t][r]||{},this.deletedStates[t][r][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][r])for(i in this.deletedStates[t][r]={},this.stateChanges[t][r])this.deletedStates[t][r][i]=null;else this.deletedStates[t][r]=null;else this.deletedStates[t]=null}getState(t,e){const i=String(e),r=St({},(this.state[t]||{})[i],(this.stateChanges[t]||{})[i]);if(null===this.deletedStates[t])return{};if(this.deletedStates[t]){const i=this.deletedStates[t][e];if(null===i)return{};for(const t in i)delete r[t]}return r}initializeTileState(t,e){t.setFeatureState(this.state,e)}coalesceChanges(t,e){const i={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const i in this.stateChanges[t])this.state[t][i]||(this.state[t][i]={}),St(this.state[t][i],this.stateChanges[t][i]),e[i]=this.state[t][i];i[t]=e}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const i in this.state[t])e[i]={},this.state[t][i]={};else for(const i in this.deletedStates[t]){if(null===this.deletedStates[t][i])this.state[t][i]={};else for(const e of Object.keys(this.deletedStates[t][i]))delete this.state[t][i][e];e[i]=this.state[t][i]}i[t]=i[t]||{},St(i[t],e)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in t)t[r].setFeatureState(i,e)}}const dd=89.25;function fd(t,e){const i=Tt(e.lat,-85.051129,Ht);return new c(Dp(e.lng)*t,Lp(i)*t)}function md(t,e){return new jp(e.x/t,e.y/t).toLngLat()}function _d(t){return t.cameraToCenterDistance*Math.min(.85*Math.tan(Zt(90-t.pitch)),Math.tan(Zt(dd-t.pitch)))}function gd(t,e){const i=t.canonical,r=e/At(i.z),n=i.x+Math.pow(2,i.z)*t.wrap,s=b(new Float64Array(16));return P(s,s,[n*r,i.y*r,0]),S(s,s,[r/it,r/it,1]),s}function yd(t,e,i,r,n){const s=jp.fromLngLat(t,e),o=n*Bp(1,t.lat),a=o*Math.cos(Zt(i)),l=Math.sqrt(o*o-a*a),c=l*Math.sin(Zt(-r)),h=l*Math.cos(Zt(-r));return new jp(s.x+c,s.y+h,s.z+a)}function xd(t,e,i){const r=e.intersectsFrustum(t);if(!i||0===r)return r;const n=e.intersectsPlane(i);return 0===n?0:2===r&&2===n?2:1}function vd(t,e,i){let r=0;const n=(i-e)/10;for(let s=0;s<10;s++)r+=n*Math.pow(Math.cos(e+(s+.5)/10*(i-e)),t);return r}function bd(t,e){return function(i,r,n,s,o){const a=2*((t-1)/Et(Math.cos(Zt(dd-o))/Math.cos(Zt(dd)))-1),l=Math.acos(n/s),c=2*vd(a-1,0,Zt(o/2)),h=Math.min(Zt(dd),l+Zt(o/2)),u=vd(a-1,Math.min(h,l-Zt(o/2)),h),p=Math.atan(r/n);let d=i;return d+=Et(s/Math.hypot(r,n)/Math.max(.5,Math.cos(Zt(o/2)))),d+=a*Et(Math.cos(p))/2,d-=Et(Math.max(1,u/c/e))/2,d}}const wd=bd(9.314,3);function Td(t,e){const i=(e.roundZoom?Math.round:Math.floor)(t.zoom+Et(t.tileSize/e.tileSize));return Math.max(0,i)}function Pd(t,e){const i=t.getCameraFrustum(),r=t.getClippingPlane(),n=t.screenPointToMercatorCoordinate(t.getCameraPoint()),s=jp.fromLngLat(t.center,t.elevation);n.z=s.z+Math.cos(t.pitchInRadians)*t.cameraToCenterDistance/t.worldSize;const o=t.getCoveringTilesDetailsProvider(),a=o.allowVariableZoom(t,e),l=Td(t,e),c=e.minzoom||0,h=void 0!==e.maxzoom?e.maxzoom:t.maxZoom,u=Math.min(Math.max(0,l),h),p=Math.pow(2,u),d=[p*n.x,p*n.y,0],f=[p*s.x,p*s.y,0],m=Math.hypot(s.x-n.x,s.y-n.y),_=Math.abs(s.z-n.z),g=Math.hypot(m,_),y=t=>({zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),x=[],v=[];if(t.renderWorldCopies&&o.allowWorldCopies())for(let t=1;t<=3;t++)x.push(y(-t)),x.push(y(t));for(x.push(y(0));x.length>0;){const p=x.pop(),m=p.x,y=p.y;let b=p.fullyVisible;const w={x:m,y:y,z:p.zoom},T=o.getTileBoundingVolume(w,p.wrap,t.elevation,e);if(!b){const t=xd(i,T,r);if(0===t)continue;b=2===t}const P=o.distanceToTile2d(n.x,n.y,w,T);let S=l;a&&(S=(e.calculateTileZoom||wd)(t.zoom+Et(t.tileSize/e.tileSize),P,_,g,t.fov)),S=(e.roundZoom?Math.round:Math.floor)(S),S=Math.max(0,S);const M=Math.min(S,h);if(p.wrap=o.getWrap(s,w,p.wrap),p.zoom>=M){if(p.zoom<c)continue;const t=u-p.zoom,i=d[0]-.5-(m<<t),r=d[1]-.5-(y<<t),n=e.reparseOverscaled?Math.max(p.zoom,S):p.zoom;v.push({tileID:new qp(p.zoom===h?n:p.zoom,p.wrap,p.zoom,m,y),distanceSq:et([f[0]-.5-m,f[1]-.5-y]),tileDistanceToCamera:Math.sqrt(i*i+r*r)})}else for(let t=0;t<4;t++)x.push({zoom:p.zoom+1,x:(m<<1)+t%2,y:(y<<1)+(t>>1),wrap:p.wrap,fullyVisible:b})}return v.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}const Sd=Yp.fromPoints([new c(0,0),new c(it,it)]);class Md extends Pe{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((t,e,i,r)=>{const n=new(ed(e.type))(t,e,i,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return n})(t,e,i,this),this._tiles={},this._cache=new ud(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new pd,this._didEmitContent=!1,this._updated=!1}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t)}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t)}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(t,e,i){return n(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,e,i)}catch(e){t.state="errored",404!==e.status?this._source.fire(new Te(e,{tile:t})):this.update(this.transform,this.terrain)}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t)}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new we("dataabort",{tile:t,coord:t.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager)}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(Id).map((t=>t.key))}getRenderableIds(t){const e=[];for(const i in this._tiles)this._isIdRenderable(i,t)&&e.push(this._tiles[i]);return t?e.sort(((t,e)=>{const i=t.tileID,r=e.tileID,n=new c(i.canonical.x,i.canonical.y)._rotate(-this.transform.bearingInRadians),s=new c(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return i.overscaledZ-r.overscaledZ||s.y-n.y||s.x-n.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Id).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return!!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(t){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const e in this._tiles)t?this._reloadTile(e,"expired"):"errored"!==this._tiles[e].state&&this._reloadTile(e,"reloading")}}_reloadTile(t,e){return n(this,void 0,void 0,(function*(){const i=this._tiles[t];i&&("loading"!==i.state&&(i.state=e),yield this._loadTile(i,t,e))}))}_tileLoaded(t,e,i){t.timeAdded=ie.now(),"expired"===i&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new we("data",{dataType:"source",tile:t,coord:t.tileID}))}_backfillDEM(t){const e=this.getRenderableIds();for(let r=0;r<e.length;r++){const n=e[r];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);i(t,e),i(e,t)}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const r=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,r),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)))}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,r){for(const n in this._tiles){let s=this._tiles[n];if(r[n]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>i)continue;let o=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(o=t)}let a=o;for(;a.overscaledZ>e;)if(a=a.scaledTo(a.overscaledZ-1),t[a.key]||t[a.canonical.key]){r[o.key]=o;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),r=this._getLoadedTile(e);if(r)return r}}findLoadedSibling(t){return this._getLoadedTile(t)}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const e=Math.ceil(t.width/this._source.tileSize)+1,i=Math.ceil(t.height/this._source.tileSize)+1,r=Math.floor(e*i*(null===this._maxTileCacheZoomLevels?ne.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n)}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t])}}_updateCoveredAndRetainedTiles(t,e,i,r,n,s){const o={},a={},l=Object.keys(t),c=ie.now();for(const i of l){const r=t[i],n=this._tiles[i];if(!n||0!==n.fadeEndTime&&n.fadeEndTime<=c)continue;const s=this.findLoadedParent(r,e),l=this.findLoadedSibling(r),h=s||l||null;h&&(this._addTile(h.tileID),o[h.tileID.key]=h.tileID),a[i]=r}this._retainLoadedChildren(a,r,i,t);for(const e in o)t[e]||(this._coveredTiles[e]=!0,t[e]=o[e]);if(s){const e={},i={};for(const t of n)this._tiles[t.key].hasData()?e[t.key]=t:i[t.key]=t;for(const r in i){const n=i[r].children(this._source.maxzoom);this._tiles[n[0].key]&&this._tiles[n[1].key]&&this._tiles[n[2].key]&&this._tiles[n[3].key]&&(e[n[0].key]=t[n[0].key]=n[0],e[n[1].key]=t[n[1].key]=n[1],e[n[2].key]=t[n[2].key]=n[2],e[n[3].key]=t[n[3].key]=n[3],delete i[r])}for(const r in i){const n=i[r],s=this.findLoadedParent(n,this._source.minzoom),o=this.findLoadedSibling(n),a=s||o||null;if(a){e[a.tileID.key]=t[a.tileID.key]=a.tileID;for(const t in e)e[t].isChildOf(a.tileID)&&delete e[t]}}for(const t in this._tiles)e[t]||(this._coveredTiles[t]=!0)}}update(t,e){if(!this._sourceLoaded||this._paused)return;let i;this.transform=t,this.terrain=e,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new qp(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(i=Pd(t,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:e,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(i=i.filter((t=>this._source.hasTile(t))))):i=[];const r=Td(t,this._source),n=Math.max(r-Md.maxOverzooming,this._source.minzoom),s=Math.max(r+Md.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of i)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const r=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[r.key]=r}i=i.concat(Object.values(t))}const o=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,o&&this.fire(new we("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const a=this._updateRetainedTiles(i,r);Cd(this._source.type)&&this._updateCoveredAndRetainedTiles(a,n,s,r,i,e);for(const t in a)this._tiles[t].clearFadeHold();const l=function(t,e){const i=[];for(const r in t)r in e||i.push(r);return i}(this._tiles,a);for(const t of l){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t)}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache()}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t)}_updateRetainedTiles(t,e){var i;const r={},n={},s=Math.max(e-Md.maxOverzooming,this._source.minzoom),o=Math.max(e+Md.maxUnderzooming,this._source.minzoom),a={};for(const i of t){const t=this._addTile(i);r[i.key]=i,t.hasData()||e<this._source.maxzoom&&(a[i.key]=i)}this._retainLoadedChildren(a,e,o,r);for(const o of t){let t=this._tiles[o.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=o.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){r[t.key]=t;continue}}else{const t=o.children(this._source.maxzoom);if(r[t[0].key]&&r[t[1].key]&&r[t[2].key]&&r[t[3].key])continue}let a=t.wasRequested();for(let e=o.overscaledZ-1;e>=s;--e){const s=o.scaledTo(e);if(n[s.key])break;if(n[s.key]=!0,t=this.getTile(s),!t&&a&&(t=this._addTile(s)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||a)&&(r[s.key]=s),a=t.wasRequested(),e)break}}}return r}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,r=this._tiles[t].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}e.push(r.key);const t=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;r=t}for(const t of e)this._loadedParentTiles[t]=i}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const t in this._tiles){const e=this._tiles[t].tileID,i=this._getLoadedTile(e);this._loadedSiblingTiles[e.key]=i}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const i=e;return e||(e=new hd(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(e,t.key,e.state)),e.uses++,this._tiles[t.key]=e,i||this._source.fire(new we("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t]}),i))}refreshTiles(t){for(const e in this._tiles)(this._isIdRenderable(e)||"errored"==this._tiles[e].state)&&t.some((t=>t.equals(this._tiles[e].tileID.canonical)))&&this._reloadTile(e,"expired")}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))))}_dataHandler(t){const e=t.sourceDataType;"source"===t.dataType&&"metadata"===e&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===e&&(this.reload(t.sourceDataChanged),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset()}tilesIn(t,e,i){const r=[],n=this.transform;if(!n)return r;const s=n.getCoveringTilesDetailsProvider().allowWorldCopies(),o=i?n.getCameraQueryGeometry(t):t,a=t=>n.screenPointToMercatorCoordinate(t,this.terrain),l=this.transformBbox(t,a,!s),c=this.transformBbox(o,a,!s),h=this.getIds(),u=Yp.fromPoints(c);for(let t=0;t<h.length;t++){const i=this._tiles[h[t]];if(i.holdingForFade())continue;const o=s?[i.tileID]:[i.tileID.unwrapTo(-1),i.tileID.unwrapTo(0)],a=Math.pow(2,n.zoom-i.tileID.overscaledZ),p=e*i.queryPadding*it/i.tileSize/a;for(const t of o){const e=u.map((e=>t.getTilePoint(new jp(e.x,e.y))));if(e.expandBy(p),e.intersects(Sd)){const e=l.map((e=>t.getTilePoint(e))),n=c.map((e=>t.getTilePoint(e)));r.push({tile:i,tileID:s?t:t.unwrapTo(0),queryGeometry:e,cameraQueryGeometry:n,scale:a})}}}return r}transformBbox(t,e,i){let r=t.map(e);if(i){const i=Yp.fromPoints(t);i.shrinkBy(.001*Math.min(i.width(),i.height()));const n=i.map(e);Yp.fromPoints(r).covers(n)||(r=r.map((t=>t.x>.5?new jp(t.x-1,t.y,t.z):t)))}return r}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));return this.transform&&this.transform.populateCache(e),e}hasTransition(){if(this._source.hasTransition())return!0;if(Cd(this._source.type)){const t=ie.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return!0}return!1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i)}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i)}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const r=this._tiles[t];r&&r.setDependencies(e,i)}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)))}}function Id(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),r=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||r-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Cd(t){return"raster"===t||"image"===t||"video"===t}Md.maxOverzooming=10,Md.maxUnderzooming=3;class Ad{constructor(t,e){this.reset(t,e)}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(t){if(1===this.points.length)return this.points[0];t=Tt(t,0,1);let e=1,i=this._distances[e];const r=t*this.paddedLength+this.padding;for(;i<r&&e<this._distances.length;)i=this._distances[++e];const n=e-1,s=this._distances[n],o=i-s,a=o>0?(r-s)/o:0;return this.points[n].mult(1-a).add(this.points[e].mult(a))}}function Ed(t,e){let i=!0;return"always"===t||"never"!==t&&"never"!==e||(i=!1),i}class zd{constructor(t,e,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(t,e,i,r){this._forEachCell(e-r,i-r,e+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(r)}_insertBoxCell(t,e,i,r,n,s){this.boxCells[n].push(s)}_insertCircleCell(t,e,i,r,n,s){this.circleCells[n].push(s)}_query(t,e,i,r,n,s,o){if(i<0||t>this.width||r<0||e>this.height)return[];const a=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=r){if(n)return[{key:null,x1:t,y1:e,x2:i,y2:r}];for(let t=0;t<this.boxKeys.length;t++)a.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],r=this.circles[3*t+2];a.push({key:this.circleKeys[t],x1:e-r,y1:i-r,x2:e+r,y2:i+r})}}else this._forEachCell(t,e,i,r,this._queryCell,a,{hitTest:n,overlapMode:s,seenUids:{box:{},circle:{}}},o);return a}query(t,e,i,r){return this._query(t,e,i,r,!1,null)}hitTest(t,e,i,r,n,s){return this._query(t,e,i,r,!0,n,s).length>0}hitTestCircle(t,e,i,r,n){const s=t-i,o=t+i,a=e-i,l=e+i;if(o<0||s>this.width||l<0||a>this.height)return!1;const c=[];return this._forEachCell(s,a,o,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},n),c.length>0}_queryCell(t,e,i,r,n,s,o,a){const{seenUids:l,hitTest:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const n=this.bboxes;for(const o of u)if(!l.box[o]){l.box[o]=!0;const u=4*o,p=this.boxKeys[o];if(t<=n[u+2]&&e<=n[u+3]&&i>=n[u+0]&&r>=n[u+1]&&(!a||a(p))&&(!c||!Ed(h,p.overlapMode))&&(s.push({key:p,x1:n[u],y1:n[u+1],x2:n[u+2],y2:n[u+3]}),c))return!0}}const p=this.circleCells[n];if(null!==p){const n=this.circles;for(const o of p)if(!l.circle[o]){l.circle[o]=!0;const u=3*o,p=this.circleKeys[o];if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],t,e,i,r)&&(!a||a(p))&&(!c||!Ed(h,p.overlapMode))){const t=n[u],e=n[u+1],i=n[u+2];if(s.push({key:p,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),c)return!0}}}return!1}_queryCellCircle(t,e,i,r,n,s,o,a){const{circle:l,seenUids:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const t=this.bboxes;for(const e of u)if(!c.box[e]){c.box[e]=!0;const i=4*e,r=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!a||a(r))&&!Ed(h,r.overlapMode))return s.push(!0),!0}}const p=this.circleCells[n];if(null!==p){const t=this.circles;for(const e of p)if(!c.circle[e]){c.circle[e]=!0;const i=3*e,r=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!a||a(r))&&!Ed(h,r.overlapMode))return s.push(!0),!0}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++)if(n.call(this,t,e,i,r,this.xCellCount*l+p,s,o,a))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,r,n,s){const o=r-t,a=n-e,l=i+s;return l*l>o*o+a*a}_circleAndRectCollide(t,e,i,r,n,s,o){const a=(s-r)/2,l=Math.abs(t-(r+a));if(l>a+i)return!1;const c=(o-n)/2,h=Math.abs(e-(n+c));if(h>c+i)return!1;if(l<=a||h<=c)return!0;const u=l-a,p=h-c;return u*u+p*p<=i*i}}function kd(t,e,i){const r=x();if(!t){const{vecSouth:t,vecEast:i}=Dd(e),u=g();u[0]=i[0],u[1]=i[1],u[2]=t[0],u[3]=t[1],n=u,(h=(o=(s=u)[0])*(c=s[3])-(l=s[2])*(a=s[1]))&&(n[0]=c*(h=1/h),n[1]=-a*h,n[2]=-l*h,n[3]=o*h),r[0]=u[0],r[1]=u[1],r[4]=u[2],r[5]=u[3]}var n,s,o,a,l,c,h;return S(r,r,[1/i,1/i,1]),r}function Rd(t,e,i,r){if(t){const t=x();if(!e){const{vecSouth:e,vecEast:r}=Dd(i);t[0]=r[0],t[1]=r[1],t[4]=e[0],t[5]=e[1]}return S(t,t,[r,r,1]),t}return i.pixelsToClipSpaceMatrix}function Dd(t){const e=Math.cos(t.rollInRadians),i=Math.sin(t.rollInRadians),r=Math.cos(t.pitchInRadians),n=Math.cos(t.bearingInRadians),s=Math.sin(t.bearingInRadians),o=Y();o[0]=-n*r*i-s*e,o[1]=-s*r*i+n*e;const a=Q(o);a<1e-9?tt(o):J(o,o,1/a);const l=Y();l[0]=n*r*e-s*i,l[1]=s*r*e+n*i;const c=Q(l);return c<1e-9?tt(l):J(l,l,1/c),{vecEast:l,vecSouth:o}}function Ld(t,e,i,r){let n;r?(n=[t,e,r(t,e),1],W(n,n,i)):(n=[t,e,0,1],Jd(n,n,i));const s=n[3];return{point:new c(n[0]/s,n[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function Bd(t,e){return.5+t/e*.5}function Fd(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function Od(t,e,i,r,n,s,o,a,l,h,u,p,d){const f=i?t.textSizeData:t.iconSizeData,m=Eu(f,e.transform.zoom),_=[256/e.width*2+1,256/e.height*2+1],g=i?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;g.clear();const y=t.lineVertexArray,x=i?t.text.placedSymbolArray:t.icon.placedSymbolArray,v=e.transform.width/e.transform.height;let b=!1;for(let i=0;i<x.length;i++){const w=x.get(i);if(w.hidden||w.writingMode===xu.vertical&&!b){Kd(w.numGlyphs,g);continue}b=!1;const T=new c(w.anchorX,w.anchorY),P={getElevation:d,pitchedLabelPlaneMatrix:r,lineVertexArray:y,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:e.transform,tileAnchorPoint:T,unwrappedTileID:l,width:h,height:u,translation:p},S=qd(w.anchorX,w.anchorY,P);if(!Fd(S.point,_)){Kd(w.numGlyphs,g);continue}const M=Bd(e.transform.cameraToCenterDistance,S.signedDistanceFromCamera),I=Au(f,m,w),C=s?I*e.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,l)/M:I*M,A=Nd({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!1,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:a});b=A.useVertical,(A.notEnoughRoom||b||A.needsFlipping&&Nd({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!0,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:a}).notEnoughRoom)&&Kd(w.numGlyphs,g)}i?t.text.dynamicLayoutVertexBuffer.updateData(g):t.icon.dynamicLayoutVertexBuffer.updateData(g)}function jd(t,e,i,r,n,s,o,a){const l=s.glyphStartIndex+s.numGlyphs,c=s.lineStartIndex,h=s.lineStartIndex+s.lineLength,u=e.getoffsetX(s.glyphStartIndex),p=e.getoffsetX(l-1),d=Xd(t*u,i,r,n,s.segment,c,h,a,o);if(!d)return null;const f=Xd(t*p,i,r,n,s.segment,c,h,a,o);return f?a.projectionCache.anyProjectionOccluded?null:{first:d,last:f}:null}function Vd(t,e,i,r){return t===xu.horizontal&&Math.abs(i.y-e.y)>Math.abs(i.x-e.x)*r?{useVertical:!0}:(t===xu.vertical?e.y<i.y:e.x>i.x)?{needsFlipping:!0}:null}function Nd(t){const{projectionContext:e,pitchedLabelPlaneMatrixInverse:i,symbol:r,fontSize:n,flip:s,keepUpright:o,glyphOffsetArray:a,dynamicLayoutVertexArray:l,aspectRatio:h,rotateToLine:u}=t,p=n/24,d=r.lineOffsetX*p,f=r.lineOffsetY*p;let m;if(r.numGlyphs>1){const t=r.glyphStartIndex+r.numGlyphs,n=r.lineStartIndex,l=r.lineStartIndex+r.lineLength,c=jd(p,a,d,f,s,r,u,e);if(!c)return{notEnoughRoom:!0};const _=$d(c.first.point.x,c.first.point.y,e,i),g=$d(c.last.point.x,c.last.point.y,e,i);if(o&&!s){const t=Vd(r.writingMode,_,g,h);if(t)return t}m=[c.first];for(let i=r.glyphStartIndex+1;i<t-1;i++){const t=Xd(p*a.getoffsetX(i),d,f,s,r.segment,n,l,e,u);if(!t)return{notEnoughRoom:!0};m.push(t)}m.push(c.last)}else{if(o&&!s){const t=Gd(e.tileAnchorPoint.x,e.tileAnchorPoint.y,e).point,n=r.lineStartIndex+r.segment+1,s=new c(e.lineVertexArray.getx(n),e.lineVertexArray.gety(n)),o=Gd(s.x,s.y,e),a=o.signedDistanceFromCamera>0?o.point:Ud(e.tileAnchorPoint,s,t,1,e),l=$d(t.x,t.y,e,i),u=$d(a.x,a.y,e,i),p=Vd(r.writingMode,l,u,h);if(p)return p}const t=Xd(p*a.getoffsetX(r.glyphStartIndex),d,f,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,e,u);if(!t||e.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[t]}for(const t of m)Lu(l,t.point,t.angle);return{}}function Ud(t,e,i,r,n){const s=t.add(t.sub(e)._unit()),o=Gd(s.x,s.y,n).point,a=i.sub(o);return i.add(a._mult(r/a.mag()))}function Zd(t,e,i){const r=e.projectionCache;if(r.projections[t])return r.projections[t];const n=new c(e.lineVertexArray.getx(t),e.lineVertexArray.gety(t)),s=Gd(n.x,n.y,e);if(s.signedDistanceFromCamera>0)return r.projections[t]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const o=t-i.direction;return Ud(0===i.distanceFromAnchor?e.tileAnchorPoint:new c(e.lineVertexArray.getx(o),e.lineVertexArray.gety(o)),n,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,e)}function Gd(t,e,i){const r=t+i.translation[0],n=e+i.translation[1];let s;return i.pitchWithMap?(s=Ld(r,n,i.pitchedLabelPlaneMatrix,i.getElevation),s.isOccluded=!1):(s=i.transform.projectTileCoordinates(r,n,i.unwrappedTileID,i.getElevation),s.point.x=(.5*s.point.x+.5)*i.width,s.point.y=(.5*-s.point.y+.5)*i.height),s}function $d(t,e,i,r){if(i.pitchWithMap){const n=[t,e,0,1];return W(n,n,r),i.transform.projectTileCoordinates(n[0]/n[3],n[1]/n[3],i.unwrappedTileID,i.getElevation).point}return{x:t/i.width*2-1,y:1-e/i.height*2}}function qd(t,e,i){return i.transform.projectTileCoordinates(t,e,i.unwrappedTileID,i.getElevation)}function Wd(t,e,i){return t._unit()._perp()._mult(e*i)}function Hd(t,e,i,r,n,s,o,a,l){if(a.projectionCache.offsets[t])return a.projectionCache.offsets[t];const h=i.add(e);if(t+l.direction<r||t+l.direction>=n)return a.projectionCache.offsets[t]=h,h;const u=Zd(t+l.direction,a,l),p=Wd(u.sub(i),o,l.direction),d=i.add(p),f=u.add(p);return a.projectionCache.offsets[t]=function(t,e,i,r){const n=e.y-t.y,s=e.x-t.x,o=r.y-i.y,a=r.x-i.x,l=o*s-a*n;if(0===l)return null;const h=(a*(t.y-i.y)-o*(t.x-i.x))/l;return new c(t.x+h*s,t.y+h*n)}(s,h,d,f)||h,a.projectionCache.offsets[t]}function Xd(t,e,i,r,n,s,o,a,l){const c=r?t-e:t+e;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let p,d=h>0?s+n:s+n+1;a.projectionCache.cachedAnchorPoint?p=a.projectionCache.cachedAnchorPoint:(p=Gd(a.tileAnchorPoint.x,a.tileAnchorPoint.y,a).point,a.projectionCache.cachedAnchorPoint=p);let f,m,_=p,g=p,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(d+=h,d<s||d>=o)return null;y+=x,g=_,m=f;const t={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=Zd(d,a,t),0===i)b.push(g),w=_.sub(g);else{let e;const r=_.sub(g);e=0===r.mag()?Wd(Zd(d+h,a,t).sub(_),i,h):Wd(r,i,h),m||(m=g.add(e)),f=Hd(d,e,_,s,o,m,i,a,t),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),P=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?P:0,path:b}}const Yd=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function Kd(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(Yd,3*t)}}function Jd(t,e,i){const r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t[3]=i[3]*r+i[7]*n+i[15],t}const Qd=100;class tf{constructor(t,e=new zd(t.width+200,t.height+200,25),i=new zd(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchFactor=Math.cos(t.pitch*Math.PI/180)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+Qd,this.screenBottomBoundary=t.height+Qd,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.projectAndGetPerspectiveRatio(t.anchorPointX+a[0],t.anchorPointY+a[1],n,c,u),d=i*p.perspectiveRatio;let f;if(s||o)f=this._projectCollisionBox(t,d,r,n,s,o,a,p,c,h,u);else{const e=p.x+(h?h.x*d:0),i=p.y+(h?h.y*d:0);f={allPointsOccluded:!1,box:[e+t.x1*d,i+t.y1*d,e+t.x2*d,i+t.y2*d]}}const[m,_,g,y]=f.box,x=s?f.allPointsOccluded:p.isOccluded;let v=x;return v||(v=p.perspectiveRatio<this.perspectiveRatioCutoff),v||(v=!this.isInsideGrid(m,_,g,y)),v||"always"!==e&&this.grid.hitTest(m,_,g,y,e,l)?{box:[m,_,g,y],placeable:!1,offscreen:!1,occluded:x}:{box:[m,_,g,y],placeable:!0,offscreen:this.isOffscreen(m,_,g,y),occluded:x}}placeCollisionCircles(t,e,i,r,n,s,o,a,l,h,u,p,d,f){const m=[],_=new c(e.anchorX,e.anchorY),g=this.getPerspectiveRatio(_.x,_.y,s,f),y=(l?n*this.transform.getPitchedTextCorrection(e.anchorX,e.anchorY,s)/g:n*g)/24,x={getElevation:f,pitchedLabelPlaneMatrix:o,lineVertexArray:i,pitchWithMap:l,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:_,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:d},v=jd(y,r,e.lineOffsetX*y,e.lineOffsetY*y,!1,e,!1,x);let b=!1,w=!1,T=!0;if(v){const e=.5*u*g+p,i=new c(-100,-100),r=new c(this.screenRightBoundary,this.screenBottomBoundary),n=new Ad,s=v.first,o=v.last;let d=[];for(let t=s.path.length-1;t>=1;t--)d.push(s.path[t]);for(let t=1;t<o.path.length;t++)d.push(o.path[t]);const f=2.5*e;if(l){const t=this.projectPathToScreenSpace(d,x);d=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point))}let _=[];if(d.length>0){const t=d[0].clone(),e=d[0].clone();for(let i=1;i<d.length;i++)t.x=Math.min(t.x,d[i].x),t.y=Math.min(t.y,d[i].y),e.x=Math.max(e.x,d[i].x),e.y=Math.max(e.y,d[i].y);_=t.x>=i.x&&e.x<=r.x&&t.y>=i.y&&e.y<=r.y?[d]:e.x<i.x||t.x>r.x||e.y<i.y||t.y>r.y?[]:function(t,e,i,r,n){const s=[];for(let o=0;o<t.length;o++){const a=t[o];let l;for(let t=0;t<a.length-1;t++){let o=a[t],h=a[t+1];o.x<e&&h.x<e||(o.x<e?o=new c(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x<e&&(h=new c(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y<i&&h.y<i||(o.y<i?o=new c(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round():h.y<i&&(h=new c(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round()),o.x>=r&&h.x>=r||(o.x>=r?o=new c(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x>=r&&(h=new c(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y>=n&&h.y>=n||(o.y>=n?o=new c(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round():h.y>=n&&(h=new c(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round()),l&&o.equals(l[l.length-1])||(l=[o],s.push(l)),l.push(h)))))}}return s}([d],i.x,i.y,r.x,r.y)}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const s=i/Math.max(r-1,1),o=n.lerp(s),l=o.x+Qd,c=o.y+Qd;m.push(l,c,e,0);const u=l-e,p=c-e,d=l+e,f=c+e;if(T=T&&this.isOffscreen(u,p,d,f),w=w||this.isInsideGrid(u,p,d,f),"always"!==t&&this.grid.hitTestCircle(l,c,e,t,h)&&(b=!0,!a))return{circles:[],offscreen:!1,collisionDetected:b}}}}return{circles:!a&&b||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:b}}projectPathToScreenSpace(t,e){const i=function(t,e){const i=x();return w(i,e.pitchedLabelPlaneMatrix),t.map((t=>{const r=Ld(t.x,t.y,i,e.getElevation),n=e.transform.projectTileCoordinates(r.point.x,r.point.y,e.unwrappedTileID,e.getElevation);return n.point.x=(.5*n.point.x+.5)*e.width,n.point.y=(.5*-n.point.y+.5)*e.height,n}))}(t,e);return function(t){let e=0,i=0,r=0,n=0;for(let s=0;s<t.length;s++)t[s].isOccluded?(r=s+1,n=0):(n++,n>i&&(i=n,e=r));return t.slice(e,e+i)}(i)}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const e=[],i=new Yp;for(const r of t){const t=new c(r.x+Qd,r.y+Qd);i.extend(t),e.push(t)}const{minX:r,minY:n,maxX:s,maxY:o}=i,a=this.grid.query(r,n,s,o).concat(this.ignoredGrid.query(r,n,s,o)),l={},h={};for(const t of a){const i=t.key;void 0===l[i.bucketInstanceId]&&(l[i.bucketInstanceId]={}),l[i.bucketInstanceId][i.featureIndex]||$l(e,[new c(t.x1,t.y1),new c(t.x2,t.y1),new c(t.x2,t.y2),new c(t.x1,t.y2)])&&(l[i.bucketInstanceId][i.featureIndex]=!0,void 0===h[i.bucketInstanceId]&&(h[i.bucketInstanceId]=[]),h[i.bucketInstanceId].push(i.featureIndex))}return h}insertCollisionBox(t,e,i,r,n,s){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e},t[0],t[1],t[2],t[3])}insertCollisionCircles(t,e,i,r,n,s){const o=i?this.ignoredGrid:this.grid,a={bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e};for(let e=0;e<t.length;e+=4)o.insertCircle(a,t[e],t[e+1],t[e+2])}projectAndGetPerspectiveRatio(t,e,i,r,n){if(n){let i;r?(i=[t,e,r(t,e),1],W(i,i,n)):(i=[t,e,0,1],Jd(i,i,n));const s=i[3];return{x:(i[0]/s+1)/2*this.transform.width+Qd,y:(-i[1]/s+1)/2*this.transform.height+Qd,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const n=this.transform.projectTileCoordinates(t,e,i,r);return{x:(n.point.x+1)/2*this.transform.width+Qd,y:(1-n.point.y)/2*this.transform.height+Qd,perspectiveRatio:.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5,isOccluded:n.isOccluded,signedDistanceFromCamera:n.signedDistanceFromCamera}}}getPerspectiveRatio(t,e,i,r){const n=this.transform.projectTileCoordinates(t,e,i,r);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(t,e,i,r){return i<Qd||t>=this.screenRightBoundary||r<Qd||e>this.screenBottomBoundary}isInsideGrid(t,e,i,r){return i>=0&&t<this.gridRightBoundary&&r>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=b([]);return P(t,t,[-100,-100,0]),t}_projectCollisionBox(t,e,i,r,n,s,o,a,l,h,u){let p=1,d=0,f=0,m=1;const _=t.anchorPointX+o[0],g=t.anchorPointY+o[1];if(s&&!n){const t=this.projectAndGetPerspectiveRatio(_+1,g,r,l,u),e=t.x-a.x,i=Math.atan((t.y-a.y)/e)+(e<0?Math.PI:0),n=Math.sin(i),s=Math.cos(i);p=s,d=n,f=-n,m=s}else if(!s&&n){const t=Dd(this.transform);p=t.vecEast[0],d=t.vecEast[1],f=t.vecSouth[0],m=t.vecSouth[1]}let y=a.x,x=a.y,v=e;n&&(y=_,x=g,v=Math.pow(2,-(this.transform.zoom-i.overscaledZ)),v*=this.transform.getPitchedTextCorrection(_,g,r),h||(v*=Tt(.5+a.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(y+=p*h.x*v+f*h.y*v,x+=d*h.x*v+m*h.y*v);const b=t.x1*v,w=t.x2*v,T=(b+w)/2,P=t.y1*v,S=t.y2*v,M=(P+S)/2,I=[{offsetX:b,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:M},{offsetX:w,offsetY:S},{offsetX:T,offsetY:S},{offsetX:b,offsetY:S},{offsetX:b,offsetY:M}];let C=[];for(const{offsetX:t,offsetY:e}of I)C.push(new c(y+p*t+f*e,x+d*t+m*e));let A=!1;if(n){const t=C.map((t=>this.projectAndGetPerspectiveRatio(t.x,t.y,r,l,u)));A=t.some((t=>!t.isOccluded)),C=t.map((t=>new c(t.x,t.y)))}else A=!0;return{box:xt(C),allPointsOccluded:!A}}}class ef extends c{constructor(t,e,i,r){super(t,e),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new ef(this.x,this.y,this.angle,this.segment)}}var rf;po("Anchor",ef),function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(rf||(rf={}));class nf{constructor(t,e,i,r){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class sf{constructor(t,e,i,r,n){this.text=new nf(t?t.text:null,e,i,n),this.icon=new nf(t?t.icon:null,e,r,n)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class of{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i}}class af{constructor(t,e,i,r,n){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class lf{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={}}get(t){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e}}return this.collisionGroups[t]}}function cf(t,e,i,r,n){const{horizontalAlign:s,verticalAlign:o}=Iu(t);return new c(-(s-.5)*e+r[0]*n,-(o-.5)*i+r[1]*n)}class hf{constructor(t,e,i,r,n){this.transform=t.clone(),this.terrain=e,this.collisionIndex=new tf(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new lf(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,r)=>e.getElevation(t,i,r):null}getBucketParts(t,e,i,r){const n=i.getBucket(e),s=i.latestFeatureIndex;if(!n||!s||e.id!==n.layerIds[0])return;const o=i.collisionBoxArray,a=n.layers[0].layout,l=n.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/it,u=i.tileID.toUnwrapped(),p="map"===a.get("text-rotation-alignment"),d=rt(i,1,this.transform.zoom),f=ct(this.collisionIndex.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),m=ct(this.collisionIndex.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),_=kd(p,this.transform,d);this.retainedQueryData[n.bucketInstanceId]=new af(n.bucketInstanceId,s,n.sourceLayerIndex,n.index,i.tileID);const g={bucket:n,layout:a,translationText:f,translationIcon:m,unwrappedTileID:u,pitchedLabelPlaneMatrix:_,scale:c,textPixelRatio:h,holdingForFade:i.holdingForFade(),collisionBoxArray:o,partiallyEvaluatedTextSize:Eu(n.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=e;t.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:g})}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:g})}attemptAnchorPlacement(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x){const v=rf[t.textAnchor],b=[t.textOffset0,t.textOffset1],w=cf(v,i,r,b,n),T=this.collisionIndex.placeCollisionBox(e,u,a,l,c,o,s,m,h.predicate,y,w,x);if((!g||this.collisionIndex.placeCollisionBox(g,u,a,l,c,o,s,_,h.predicate,y,w,x).placeable)&&T.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID].text&&(t=this.prevPlacement.variableOffsets[p.crossTileID].anchor),0===p.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[p.crossTileID]={textOffset:b,width:i,height:r,anchor:v,textBoxScale:n,prevAnchor:t},this.markUsedJustification(d,v,p,f),d.allowVerticalPlacement&&(this.markUsedOrientation(d,f,p),this.placedOrientations[p.crossTileID]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,e,i){const{bucket:r,layout:n,translationText:s,translationIcon:o,unwrappedTileID:a,pitchedLabelPlaneMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:p,collisionGroup:d}=t.parameters,f=n.get("text-optional"),m=n.get("icon-optional"),_=zu(n,"text-overlap","text-allow-overlap"),g="always"===_,y=zu(n,"icon-overlap","icon-allow-overlap"),x="always"===y,v="map"===n.get("text-rotation-alignment"),b="map"===n.get("text-pitch-alignment"),w="none"!==n.get("icon-text-fit"),T="viewport-y"===n.get("symbol-z-order"),P=g&&(x||!r.hasIconData()||m),S=x&&(g||!r.hasTextData()||f);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u);const M=this.retainedQueryData[r.bucketInstanceId].tileID,I=this._getTerrainElevationFunc(M),C=this.transform.getFastPathSimpleProjectionMatrix(M),A=(t,u,x)=>{var T,A;if(e[t.crossTileID])return;if(h)return void(this.placements[t.crossTileID]=new of(!1,!1,!1));let E=!1,z=!1,k=!0,R=null,D={box:null,placeable:!1,offscreen:null,occluded:!1},L={placeable:!1},B=null,F=null,O=null,j=0,V=0,N=0;u.textFeatureIndex?j=u.textFeatureIndex:t.useRuntimeCollisionCircles&&(j=t.featureIndex),u.verticalTextFeatureIndex&&(V=u.verticalTextFeatureIndex);const U=u.textBox;if(U){const e=e=>{let i=xu.horizontal;if(r.allowVerticalPlacement&&!e&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,i=e,this.markUsedOrientation(r,i,t))}return i},n=(e,i)=>{if(r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const t of r.writingModes)if(t===xu.vertical?(D=i(),L=D):D=e(),D&&D.placeable)break}else D=e()},l=t.textAnchorOffsetStartIndex,h=t.textAnchorOffsetEndIndex;if(h===l){const i=(e,i)=>{const n=this.collisionIndex.placeCollisionBox(e,_,c,M,a,b,v,s,d.predicate,I,void 0,C);return n&&n.placeable&&(this.markUsedOrientation(r,i,t),this.placedOrientations[t.crossTileID]=i),n};n((()=>i(U,xu.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&e?i(e,xu.vertical):{box:null,offscreen:null}})),e(D&&D.placeable)}else{let p=rf[null===(A=null===(T=this.prevPlacement)||void 0===T?void 0:T.variableOffsets[t.crossTileID])||void 0===A?void 0:A.anchor];const f=(e,n,u)=>{const f=e.x2-e.x1,m=e.y2-e.y1,g=t.textBoxScale,x=w&&"never"===y?n:null;let T=null,P="never"===_?1:2,S="never";p&&P++;for(let i=0;i<P;i++){for(let i=l;i<h;i++){const n=r.textAnchorOffsets.get(i);if(p&&n.textAnchor!==p)continue;const l=this.attemptAnchorPlacement(n,e,f,m,g,v,b,c,M,a,d,S,t,r,u,s,o,x,I);if(l&&(T=l.placedGlyphBoxes,T&&T.placeable))return E=!0,R=l.shift,T}p?p=null:S=_}return i&&!T&&(T={box:this.collisionIndex.placeCollisionBox(U,"always",c,M,a,b,v,s,d.predicate,I,void 0,C).box,offscreen:!1,placeable:!1,occluded:!1}),T};n((()=>f(U,u.iconBox,xu.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&(!D||!D.placeable)&&t.numVerticalGlyphVertices>0&&e?f(e,u.verticalIconBox,xu.vertical):{box:null,occluded:!0,offscreen:null}})),D&&(E=D.placeable,k=D.offscreen);const m=e(D&&D.placeable);if(!E&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(r,e.anchor,t,m))}}}if(B=D,E=B&&B.placeable,k=B&&B.offscreen,t.useRuntimeCollisionCircles){const e=r.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),o=Au(r.textSizeData,p,e),c=n.get("text-padding");F=this.collisionIndex.placeCollisionCircles(_,e,r.lineVertexArray,r.glyphOffsetArray,o,a,l,i,b,d.predicate,t.collisionCircleDiameter,c,s,I),F.circles.length&&F.collisionDetected&&!i&&Bt("Collisions detected, but collision boxes are not shown"),E=g||F.circles.length>0&&!F.collisionDetected,k=k&&F.offscreen}if(u.iconFeatureIndex&&(N=u.iconFeatureIndex),u.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,y,c,M,a,b,v,o,d.predicate,I,w&&R?R:void 0,C);L&&L.placeable&&u.verticalIconBox?(O=t(u.verticalIconBox),z=O.placeable):(O=t(u.iconBox),z=O.placeable),k=k&&O.offscreen}const Z=f||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=m||0===t.numIconVertices;Z||G?G?Z||(z=z&&E):E=z&&E:z=E=z&&E;const $=z&&O.placeable;if(E&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,_,n.get("text-ignore-placement"),r.bucketInstanceId,L&&L.placeable&&V?V:j,d.ID),$&&this.collisionIndex.insertCollisionBox(O.box,y,n.get("icon-ignore-placement"),r.bucketInstanceId,N,d.ID),F&&E&&this.collisionIndex.insertCollisionCircles(F.circles,_,n.get("text-ignore-placement"),r.bucketInstanceId,j,d.ID),i&&this.storeCollisionData(r.bucketInstanceId,x,u,B,O,F),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new of((E||P)&&!(null==B?void 0:B.occluded),(z||S)&&!(null==O?void 0:O.occluded),k||r.justReloaded),e[t.crossTileID]=!0};if(T){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let t=e.length-1;t>=0;--t){const i=e[t];A(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)A(r.symbolInstances.get(e),r.collisionArrays[e],e);r.justReloaded=!1}storeCollisionData(t,e,i,r,n,s){if(i.textBox||i.iconBox){let s,o;this.collisionBoxArrays.has(t)?s=this.collisionBoxArrays.get(t):(s=new Map,this.collisionBoxArrays.set(t,s)),s.has(e)?o=s.get(e):(o={text:null,icon:null},s.set(e,o)),i.textBox&&(o.text=r.box),i.iconBox&&(o.icon=n.box)}if(s){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=[]);for(let t=0;t<s.circles.length;t+=4)e.push(s.circles[t+0]-Qd),e.push(s.circles[t+1]-Qd),e.push(s.circles[t+2]),e.push(s.collisionDetected?1:0)}}markUsedJustification(t,e,i,r){let n;n=r===xu.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(e)];const s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const e of s)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=n>=0&&e!==n?0:i.crossTileID)}markUsedOrientation(t,e,i){const r=e===xu.horizontal||e===xu.horizontalOnly?e:0,n=e===xu.vertical?e:0,s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const e of s)t.text.placedSymbolArray.get(e).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=n)}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const r=e?e.symbolFadeChange(t):1,n=e?e.opacities:{},s=e?e.variableOffsets:{},o=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],s=n[t];s?(this.opacities[t]=new sf(s,r,e.text,e.icon),i=i||e.text!==s.text.placed||e.icon!==s.icon.placed):(this.opacities[t]=new sf(null,r,e.text,e.icon,e.skipFade),i=i||e.text||e.icon)}for(const t in n){const e=n[t];if(!this.opacities[t]){const n=new sf(e,r,!1,!1);n.isHidden()||(this.opacities[t]=n,i=i||e.text.placed||e.icon.placed)}}for(const t in s)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=s[t]);for(const t in o)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=o[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t)}updateLayerOpacities(t,e){const i={};for(const r of e){const e=r.getBucket(t);e&&r.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(t,e,i,r){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const n=t.layers[0],s=n.layout,o=new sf(null,0,!1,!1,!0),a=s.get("text-allow-overlap"),l=s.get("icon-allow-overlap"),h=n._unevaluatedLayout.hasValue("text-variable-anchor")||n._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),p="map"===s.get("text-pitch-alignment"),d="none"!==s.get("icon-text-fit"),f=new sf(null,0,a&&(l||!t.hasIconData()||s.get("icon-optional")),l&&(a||!t.hasTextData()||s.get("text-optional")),!0);!t.collisionArrays&&r&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(r);const m=(t,e,i)=>{for(let r=0;r<e/4;r++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==vf},_=this.collisionBoxArrays.get(t.bucketInstanceId);for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:a}=r;let l=this.opacities[a];i[a]?l=o:l||(l=f,this.opacities[a]=l),i[a]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===xu.vertical,v=y===xu.horizontal||y===xu.horizontalOnly;if(n>0||s>0){const e=xf(l.text);m(t.text,n,x?vf:e),m(t.text,s,v?vf:e);const i=l.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const o=this.variableOffsets[r.crossTileID];o&&this.markUsedJustification(t,o.anchor,r,y);const a=this.placedOrientations[r.crossTileID];a&&(this.markUsedJustification(t,"left",r,a),this.markUsedOrientation(t,a,r))}if(g){const e=xf(l.icon),i=!(d&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(t.icon,r.numIconVertices,i?e:vf),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=l.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,r.numVerticalIconVertices,i?vf:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=l.icon.isHidden())}const b=_&&_.has(e)?_.get(e):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[e];if(i){let e=new c(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const t=this.variableOffsets[a];t?(e=cf(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&e._rotate(p?-this.transform.bearingInRadians:this.transform.bearingInRadians)):r=!1}if(i.textBox||i.verticalTextBox){let n;i.textBox&&(n=x),i.verticalTextBox&&(n=v),uf(t.textCollisionBox.collisionVertexArray,l.text.placed,!r||n,b.text,e.x,e.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let n;i.iconBox&&(n=r),i.verticalIconBox&&(n=!r),uf(t.iconCollisionBox.collisionVertexArray,l.icon.placed,n,b.icon,d?e.x:0,d?e.y:0)}}}}if(t.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);t.bucketInstanceId in this.collisionCircleArrays&&(t.collisionCircleArray=this.collisionCircleArrays[t.bucketInstanceId],delete this.collisionCircleArrays[t.bucketInstanceId])}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0}}function uf(t,e,i,r,n,s){r&&0!==r.length||(r=[0,0,0,0]);const o=r[0]-Qd,a=r[1]-Qd,l=r[2]-Qd,c=r[3]-Qd;t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,c),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,c)}const pf=Math.pow(2,25),df=Math.pow(2,24),ff=Math.pow(2,17),mf=Math.pow(2,16),_f=Math.pow(2,9),gf=Math.pow(2,8),yf=Math.pow(2,1);function xf(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*pf+e*df+i*ff+e*mf+i*_f+e*gf+i*yf+e}const vf=0;class bf{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(t,e,i,r,n){const s=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(s,r,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<s.length;)if(e.placeLayerBucketPart(s[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,n())return!0;return!1}}class wf{constructor(t,e,i,r,n,s,o,a){this.placement=new hf(t,e,s,o,a),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=n,this._done=!1}isDone(){return this._done}continuePlacement(t,e,i){const r=ie.now(),n=()=>!this._forceFullPlacement&&ie.now()-r>2;for(;this._currentPlacementIndex>=0;){const r=e[t[this._currentPlacementIndex]],s=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=s)&&(!r.maxzoom||r.maxzoom>s)){if(this._inProgressLayer||(this._inProgressLayer=new bf(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(t){return this.placement.commit(t),this.placement}}const Tf=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Pf{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,i]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=Tf[15&i];if(!n)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new Pf(o,s,n,t)}constructor(t,e=64,i=Float64Array,r){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=i,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const n=Tf.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=t,this.coords[this._pos++]=e,i}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Sf(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:s,nodeSize:o}=this,a=[0,n.length-1,0],l=[];for(;a.length;){const c=a.pop()||0,h=a.pop()||0,u=a.pop()||0;if(h-u<=o){for(let o=u;o<=h;o++){const a=s[2*o],c=s[2*o+1];a>=t&&a<=i&&c>=e&&c<=r&&l.push(n[o])}continue}const p=u+h>>1,d=s[2*p],f=s[2*p+1];d>=t&&d<=i&&f>=e&&f<=r&&l.push(n[p]),(0===c?t<=d:e<=f)&&(a.push(u),a.push(p-1),a.push(1-c)),(0===c?i>=d:r>=f)&&(a.push(p+1),a.push(h),a.push(1-c))}return l}within(t,e,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:s}=this,o=[0,r.length-1,0],a=[],l=i*i;for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=s){for(let i=u;i<=h;i++)Af(n[2*i],n[2*i+1],t,e)<=l&&a.push(r[i]);continue}const p=u+h>>1,d=n[2*p],f=n[2*p+1];Af(d,f,t,e)<=l&&a.push(r[p]),(0===c?t-i<=d:e-i<=f)&&(o.push(u),o.push(p-1),o.push(1-c)),(0===c?t+i>=d:e+i>=f)&&(o.push(p+1),o.push(h),o.push(1-c))}return a}}function Sf(t,e,i,r,n,s){if(n-r<=i)return;const o=r+n>>1;Mf(t,e,o,r,n,s),Sf(t,e,i,r,o-1,1-s),Sf(t,e,i,o+1,n,1-s)}function Mf(t,e,i,r,n,s){for(;n>r;){if(n-r>600){const o=n-r+1,a=i-r+1,l=Math.log(o),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(o-c)/o)*(a-o/2<0?-1:1);Mf(t,e,i,Math.max(r,Math.floor(i-a*c/o+h)),Math.min(n,Math.floor(i+(o-a)*c/o+h)),s)}const o=e[2*i+s];let a=r,l=n;for(If(t,e,r,i),e[2*n+s]>o&&If(t,e,r,n);a<l;){for(If(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--}e[2*r+s]===o?If(t,e,r,l):(l++,If(t,e,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function If(t,e,i,r){Cf(t,i,r),Cf(e,2*i,2*r),Cf(e,2*i+1,2*r+1)}function Cf(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function Af(t,e,i,r){const n=t-i,s=e-r;return n*n+s*s}const Ef=.03125;class zf{constructor(t,e,i){this.tileID=t,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let t=0;t<e.length;t++){const i=e.get(t),n=i.key,s=r.get(n);s?s.push(i):r.set(n,[i])}for(const[t,e]of r){const i={positions:e.map((t=>({x:Math.floor(t.anchorX*Ef),y:Math.floor(t.anchorY*Ef)}))),crossTileIDs:e.map((t=>t.crossTileID))};if(i.positions.length>128){const t=new Pf(i.positions.length,16,Uint16Array);for(const{x:e,y:r}of i.positions)t.add(e,r);t.finish(),delete i.positions,i.index=t}this._symbolsByKey[t]=i}}getScaledCoordinates(t,e){const{x:i,y:r,z:n}=this.tileID.canonical,{x:s,y:o,z:a}=e.canonical,l=Ef/Math.pow(2,a-n),c=(o*it+t.anchorY)*l,h=r*it*Ef;return{x:Math.floor((s*it+t.anchorX)*l-i*it*Ef),y:Math.floor(c-h)}}findMatches(t,e,i){const r=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let n=0;n<t.length;n++){const s=t.get(n);if(s.crossTileID)continue;const o=this._symbolsByKey[s.key];if(!o)continue;const a=this.getScaledCoordinates(s,e);if(o.index){const t=o.index.range(a.x-r,a.y-r,a.x+r,a.y+r).sort();for(const e of t){const t=o.crossTileIDs[e];if(!i[t]){i[t]=!0,s.crossTileID=t;break}}}else if(o.positions)for(let t=0;t<o.positions.length;t++){const e=o.positions[t],n=o.crossTileIDs[t];if(Math.abs(e.x-a.x)<=r&&Math.abs(e.y-a.y)<=r&&!i[n]){i[n]=!0,s.crossTileID=n;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class kf{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class Rf{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],r={};for(const t in i){const n=i[t];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),r[n.tileID.key]=n}this.indexes[t]=r}this.lng=t}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key])}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const r=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in n){const s=n[i];s.tileID.isChildOf(t)&&s.findMatches(e.symbolInstances,t,r)}else{const s=n[t.scaledTo(Number(i)).key];s&&s.findMatches(e.symbolInstances,t,r)}}for(let t=0;t<e.symbolInstances.length;t++){const n=e.symbolInstances.get(t);n.crossTileID||(n.crossTileID=i.generate(),r[n.crossTileID]=!0)}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new zf(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e]}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)t[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],e=!0)}return e}}class Df{constructor(){this.layerIndexes={},this.crossTileIDs=new kf,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(t,e,i){let r=this.layerIndexes[t.id];void 0===r&&(r=this.layerIndexes[t.id]=new Rf);let n=!1;const s={};r.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,e,this.crossTileIDs)&&(n=!0),s[e.bucketInstanceId]=!0)}return r.removeStaleBuckets(s)&&(n=!0),n}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t]}}var Lf="void main() {fragColor=vec4(1.0);}";const Bf={prelude:Ff("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:Ff("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:Ff("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:Ff("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:Ff("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Ff("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Ff(Lf,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:Ff("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:Ff("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Ff("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Ff("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:Ff("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:Ff("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:Ff(Lf,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:Ff("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:Ff("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:Ff("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:Ff("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Ff("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Ff("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Ff("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Ff("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:Ff("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Ff("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Ff("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Ff("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:Ff("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Ff("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:Ff("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Ff("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:Ff("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:Ff("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:Ff("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:Ff("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:Ff("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:Ff("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function Ff(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/in ([\w]+) ([\w]+)/g),n=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=s?s.concat(n):n,a={};return{fragmentSource:t=t.replace(i,((t,e,i,r,n)=>(a[n]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nin ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,r,n)=>{const s="float"===r?"vec2":"vec4",o=n.match(/color/)?"color":s;return a[n]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\nout ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:r,staticUniforms:o}}class Of{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}var jf=Jo([{name:"a_pos",type:"Int16",components:2}]);const Vf="#define PROJECTION_MERCATOR",Nf="mercator";class Uf{constructor(){this._cachedMesh=null}get name(){return"mercator"}get useSubdivision(){return!1}get shaderVariantName(){return Nf}get shaderDefine(){return Vf}get shaderPreludeCode(){return Bf.projectionMercator}get vertexShaderPreludeCode(){return Bf.projectionMercator.vertexSource}get subdivisionGranularity(){return sh.noSubdivision}get useGlobeControls(){return!1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(t){}getMeshFromTileID(t,e,i,r,n){if(this._cachedMesh)return this._cachedMesh;const s=new La;s.emplaceBack(0,0),s.emplaceBack(it,0),s.emplaceBack(0,it),s.emplaceBack(it,it);const o=t.createVertexBuffer(s,jf.members),a=il.simpleSegment(0,0,4,2),l=new Ka;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3);const c=t.createIndexBuffer(l);return this._cachedMesh=new Of(o,c,a),this._cachedMesh}recalculate(){}hasTransition(){return!1}setErrorQueryLatitudeDegrees(t){}}class Zf{constructor(t=0,e=0,i=0,r=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=r}interpolate(t,e,i){return null!=e.top&&null!=t.top&&(this.top=wr.number(t.top,e.top,i)),null!=e.bottom&&null!=t.bottom&&(this.bottom=wr.number(t.bottom,e.bottom,i)),null!=e.left&&null!=t.left&&(this.left=wr.number(t.left,e.left,i)),null!=e.right&&null!=t.right&&(this.right=wr.number(t.right,e.right,i)),this}getCenter(t,e){const i=Tt((this.left+t-this.right)/2,0,t),r=Tt((this.top+e-this.bottom)/2,0,e);return new c(i,r)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new Zf(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Gf(t,e){if(!t.renderWorldCopies||t.lngRange)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0}function $f(t){return Math.max(0,Math.floor(t))}class qf{constructor(t,e,i,r,n,s){this._callbacks=t,this._tileSize=512,this._renderWorldCopies=void 0===s||!!s,this._minZoom=e||0,this._maxZoom=i||22,this._minPitch=null==r?0:r,this._maxPitch=null==n?60:n,this.setMaxBounds(),this._width=0,this._height=0,this._center=new Ep(0,0),this._elevation=0,this._zoom=0,this._tileZoom=$f(this._zoom),this._scale=At(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new Zf,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0}apply(t,e,i){this._latRange=t.latRange,this._lngRange=t.lngRange,this._width=t.width,this._height=t.height,this._center=t.center,this._elevation=t.elevation,this._minElevationForCurrentTile=t.minElevationForCurrentTile,this._zoom=t.zoom,this._tileZoom=$f(this._zoom),this._scale=At(this._zoom),this._bearingInRadians=t.bearingInRadians,this._fovInRadians=t.fovInRadians,this._pitchInRadians=t.pitchInRadians,this._rollInRadians=t.rollInRadians,this._unmodified=t.unmodified,this._edgeInsets=new Zf(t.padding.top,t.padding.bottom,t.padding.left,t.padding.right),this._minZoom=t.minZoom,this._maxZoom=t.maxZoom,this._minPitch=t.minPitch,this._maxPitch=t.maxPitch,this._renderWorldCopies=t.renderWorldCopies,this._cameraToCenterDistance=t.cameraToCenterDistance,this._nearZ=t.nearZ,this._farZ=t.farZ,this._autoCalculateNearFarZ=!i&&t.autoCalculateNearFarZ,e&&this._constrain(),this._calcMatrices()}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(t){this._minElevationForCurrentTile=t}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(t){this._minZoom!==t&&(this._minZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get maxZoom(){return this._maxZoom}setMaxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get minPitch(){return this._minPitch}setMinPitch(t){this._minPitch!==t&&(this._minPitch=t,this.setPitch(Math.max(this.pitch,t)))}get maxPitch(){return this._maxPitch}setMaxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.setPitch(Math.min(this.pitch,t)))}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new c(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(t){const e=Pt(t,-180,180)*Math.PI/180;var i,r,n,s,o,a,l,c,h;this._bearingInRadians!==e&&(this._unmodified=!1,this._bearingInRadians=e,this._calcMatrices(),this._rotationMatrix=g(),i=this._rotationMatrix,n=-this._bearingInRadians,s=(r=this._rotationMatrix)[0],o=r[1],a=r[2],l=r[3],c=Math.sin(n),h=Math.cos(n),i[0]=s*h+a*c,i[1]=o*h+l*c,i[2]=s*-c+a*h,i[3]=o*-c+l*h)}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(t){const e=Tt(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==e&&(this._unmodified=!1,this._pitchInRadians=e,this._calcMatrices())}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(t){const e=t/180*Math.PI;this._rollInRadians!==e&&(this._unmodified=!1,this._rollInRadians=e,this._calcMatrices())}get fovInRadians(){return this._fovInRadians}get fov(){return Gt(this._fovInRadians)}setFov(t){t=Tt(t,.1,150),this.fov!==t&&(this._unmodified=!1,this._fovInRadians=Zt(t),this._calcMatrices())}get zoom(){return this._zoom}setZoom(t){const e=this.getConstrained(this._center,t).zoom;this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this._tileZoom=Math.max(0,Math.floor(e)),this._scale=At(e),this._constrain(),this._calcMatrices())}get center(){return this._center}setCenter(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices())}get elevation(){return this._elevation}setElevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}setPadding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(t,e){this._autoCalculateNearFarZ=!1,this._nearZ=t,this._farZ=e,this._calcMatrices()}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices()}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices()}resize(t,e,i=!0){this._width=t,this._height=e,i&&this._constrain(),this._calcMatrices()}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new zp([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(t){t?(this._lngRange=[t.getWest(),t.getEast()],this._latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this._lngRange=null,this._latRange=[-85.051129,Ht])}getConstrained(t,e){return this._callbacks.getConstrained(t,e)}getCameraQueryGeometry(t,e){if(1===e.length)return[e[0],t];{const{minX:i,minY:r,maxX:n,maxY:s}=Yp.fromPoints(e).extend(t);return[new c(i,r),new c(n,r),new c(n,s),new c(i,s),new c(i,r)]}}_constrain(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.getConstrained(this.center,this.zoom);this.setCenter(e),this.setZoom(i),this._unmodified=t,this._constraining=!1}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let t=b(new Float64Array(16));S(t,t,[this._width/2,-this._height/2,1]),P(t,t,[1,-1,0]),this._clipSpaceToPixelsMatrix=t,t=b(new Float64Array(16)),S(t,t,[1,-1,1]),P(t,t,[-1,-1,0]),S(t,t,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=t,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height}this._callbacks.calcMatrices()}calculateCenterFromCameraLngLatAlt(t,e,i,r){const n=void 0!==i?i:this.bearing,s=r=void 0!==r?r:this.pitch,o=jp.fromLngLat(t,e),a=-Math.cos(Zt(s)),l=Math.sin(Zt(s)),c=l*Math.sin(Zt(n)),h=-l*Math.cos(Zt(n));let u=this.elevation;const p=e-u;let d;a*p>=0||Math.abs(a)<.1?(d=1e4,u=e+d*a):d=-p/a;let f,m,_=Op(1,o.y),g=0;do{if(g+=1,g>10)break;m=d/_,f=new jp(o.x+c*m,o.y+h*m),_=1/f.meterInMercatorCoordinateUnits()}while(Math.abs(d-m*_)>1e-12);return{center:f.toLngLat(),elevation:u,zoom:Et(this.height/2/Math.tan(this.fovInRadians/2)/m/this.tileSize)}}recalculateZoomAndCenter(t){if(this.elevation-t==0)return;const e=Bp(1,this.center.lat)*this.worldSize,i=this.cameraToCenterDistance/e,r=jp.fromLngLat(this.center,this.elevation),n=yd(this.center,this.elevation,this.pitch,this.bearing,i);this._elevation=t;const s=this.calculateCenterFromCameraLngLatAlt(n.toLngLat(),Op(n.z,r.y),this.bearing,this.pitch);this._elevation=s.elevation,this._center=s.center,this.setZoom(s.zoom)}getCameraPoint(){const t=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new c(t*Math.sin(this.rollInRadians),t*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const t=Bp(1,this.center.lat)*this.worldSize;return yd(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/t).toLngLat()}getMercatorTileCoordinates(t){if(!t)return[0,0,1,1];const e=t.canonical.z>=0?1<<t.canonical.z:Math.pow(2,t.canonical.z);return[t.canonical.x/e,t.canonical.y/e,1/e/it,1/e/it]}}class Wf{constructor(t,e){this.min=t,this.max=e,this.center=B([],L([],this.min,this.max),.5)}quadrant(t){const e=[t%2==0,t<2],i=k(this.min),r=k(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],r[t]=e[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new Wf(i,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersectsFrustum(t){let e=!0;for(let i=0;i<t.planes.length;i++){const r=this.intersectsPlane(t.planes[i]);if(0===r)return 0;1===r&&(e=!1)}return e?2:t.aabb.min[0]>this.max[0]||t.aabb.min[1]>this.max[1]||t.aabb.min[2]>this.max[2]||t.aabb.max[0]<this.min[0]||t.aabb.max[1]<this.min[1]||t.aabb.max[2]<this.min[2]?0:1}intersectsPlane(t){let e=t[3],i=t[3];for(let r=0;r<3;r++)t[r]>0?(e+=t[r]*this.min[r],i+=t[r]*this.max[r]):(i+=t[r]*this.min[r],e+=t[r]*this.max[r]);return e>=0?2:i<0?0:1}}class Hf{distanceToTile2d(t,e,i,r){const n=r.distanceX([t,e]),s=r.distanceY([t,e]);return Math.hypot(n,s)}getWrap(t,e,i){return i}getTileBoundingVolume(t,e,i,r){var n,s;let o=i,a=i;if(null==r?void 0:r.terrain){const l=new qp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);o=null!==(n=c.minElevation)&&void 0!==n?n:i,a=null!==(s=c.maxElevation)&&void 0!==s?s:i}const l=1<<t.z;return new Wf([e+t.x/l,t.y/l,o],[e+(t.x+1)/l,(t.y+1)/l,a])}allowVariableZoom(t,e){const i=Tt(78.5-t.fov*(Math.abs(Math.cos(t.rollInRadians))*t.height+Math.abs(Math.sin(t.rollInRadians))*t.width)/t.height/2,0,60);return!!e.terrain||t.pitch>i}allowWorldCopies(){return!0}prepareNextFrame(){}}class Xf{constructor(t,e,i){this.points=t,this.planes=e,this.aabb=i}static fromInvProjectionMatrix(t,e=1,i=0,r,n){const s=n?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],o=Math.pow(2,i),a=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>function(t,e,i,r){const n=W([],t,e),s=1/n[3]/i*r;return function(t,e,i){return t[0]=e[0]*i[0],t[1]=e[1]*i[1],t[2]=e[2]*i[2],t[3]=e[3]*i[3],t}(n,n,[s,s,1/n[3],s])}(i,t,e,o)));r&&function(t,e,i,r){const n=r?4:0,s=r?0:4;let o=0;const a=[],l=[];for(let e=0;e<4;e++){const i=$([],t[e+s],t[e+n]),r=R(i);B(i,i,1/r),a.push(r),l.push(i)}for(let e=0;e<4;e++){const r=pt(t[e+n],l[e],i);o=null!==r&&r>=0?Math.max(o,r):Math.max(o,a[e])}const c=function(t,e){const i=[0,0,0,0];return F(i,j([],$([],t[e[0]],t[e[1]]),$([],t[e[2]],t[e[1]]))),i[3]=-O(i,t[e[0]]),i}(t,e),h=function(t,e){const i=q(t),r=((o=[])[0]=(a=t)[0]*(l=1/i),o[1]=a[1]*l,o[2]=a[2]*l,o[3]=a[3]*l,o),n=$([],e,B([],r,O(e,r))),s=q(n);var o,a,l;if(s>0){const t=Math.sqrt(1-r[3]*r[3]);return ht(e,L([],B([],r,-r[3]),B([],n,t/s)))}return null}(i,c);if(null!==h){const t=h/O(l[0],c);o=Math.min(o,t)}for(let e=0;e<4;e++){const i=Math.min(o,a[e]);t[e+s]=[t[e+n][0]+l[e][0]*i,t[e+n][1]+l[e][1]*i,t[e+n][2]+l[e][2]*i,1]}}(a,s[0],r,n);const l=s.map((t=>{const e=F([],j([],$([],a[t[0]],a[t[1]]),$([],a[t[2]],a[t[1]]))),i=-O(e,a[t[1]]);return e.concat(i)})),c=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],h=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const t of a)for(let e=0;e<3;e++)c[e]=Math.min(c[e],t[e]),h[e]=Math.max(h[e],t[e]);return new Xf(a,l,new Wf(c,h))}}class Yf{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t,e){}constructor(t,e,i,r,n){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this._helper=new qf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)},t,e,i,r,n),this._coveringTilesDetailsProvider=new Hf}clone(){const t=new Yf;return t.apply(this),t}apply(t,e,i){this._helper.apply(t,e,i)}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(t){const e=[new $p(0,t)];if(this._helper._renderWorldCopies){const i=this.screenPointToMercatorCoordinate(new c(0,0)),r=this.screenPointToMercatorCoordinate(new c(this._helper._width,0)),n=this.screenPointToMercatorCoordinate(new c(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new c(0,this._helper._height)),o=Math.floor(Math.min(i.x,r.x,n.x,s.x)),a=Math.floor(Math.max(i.x,r.x,n.x,s.x)),l=1;for(let i=o-l;i<=a+l;i++)0!==i&&e.push(new $p(i,t))}return e}getCameraFrustum(){return Xf.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){const e=this.screenPointToLocation(this.centerPoint,t),i=t?t.getElevationForLngLatZoom(e,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i)}setLocationAtPoint(t,e){const i=Bp(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(e,i),n=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,i),s=jp.fromLngLat(t),o=new jp(s.x-(r.x-n.x),s.y-(r.y-n.y));this.setCenter(null==o?void 0:o.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap())}locationToScreenPoint(t,e){return e?this.coordinatePoint(jp.fromLngLat(t),e.getElevationForLngLatZoom(t,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(jp.fromLngLat(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(t)}screenPointToMercatorCoordinateAtZ(t,e){const i=e||0,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];W(r,r,this._pixelMatrixInverse),W(n,n,this._pixelMatrixInverse);const s=r[3],o=n[3],a=r[1]/s,l=n[1]/o,c=r[2]/s,h=n[2]/o,u=c===h?0:(i-c)/(h-c);return new jp(wr.number(r[0]/s,n[0]/o,u)/this.worldSize,wr.number(a,l,u)/this.worldSize,i)}coordinatePoint(t,e=0,i=this._pixelMatrix){const r=[t.x*this.worldSize,t.y*this.worldSize,e,1];return W(r,r,i),new c(r[0]/r[3],r[1]/r[3])}getBounds(){const t=Math.max(0,this._helper._height/2-_d(this));return(new zp).extend(this.screenPointToLocation(new c(0,t))).extend(this.screenPointToLocation(new c(this._helper._width,t))).extend(this.screenPointToLocation(new c(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new c(0,this._helper._height)))}isPointOnMapSurface(t,e){return e?null!=e.pointCoordinate(t):t.y>this.height/2-_d(this)}calculatePosMatrix(t,e=!1,i){var r;const n=null!==(r=t.key)&&void 0!==r?r:Wp(t.wrap,t.canonical.z,t.canonical.z,t.canonical.x,t.canonical.y),s=e?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(n)){const t=s.get(n);return i?t.f32:t.f64}const o=gd(t,this.worldSize);T(o,e?this._alignedProjMatrix:this._viewProjMatrix,o);const a={f64:o,f32:new Float32Array(o)};return s.set(n,a),i?a.f32:a.f64}calculateFogMatrix(t){const e=t.key,i=this._fogMatrixCacheF32;if(i.has(e))return i.get(e);const r=gd(t,this.worldSize);return T(r,this._fogMatrix,r),i.set(e,new Float32Array(r)),i.get(e)}getConstrained(t,e){e=Tt(+e,this.minZoom,this.maxZoom);const i={center:new Ep(t.lng,t.lat),zoom:e};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const t=180-1e-10;r=[-t,t]}const n=this.tileSize*At(i.zoom);let s=0,o=n,a=0,l=n,h=0,u=0;const{x:p,y:d}=this.size;if(this._helper._latRange){const t=this._helper._latRange;s=Lp(t[1])*n,o=Lp(t[0])*n,o-s<d&&(h=d/(o-s))}r&&(a=Pt(Dp(r[0])*n,0,n),l=Pt(Dp(r[1])*n,0,n),l<a&&(l+=n),l-a<p&&(u=p/(l-a)));const{x:f,y:m}=fd(n,t);let _,g;const y=Math.max(u||0,h||0);if(y){const t=new c(u?(l+a)/2:f,h?(o+s)/2:m);return i.center=md(n,t).wrap(),i.zoom+=Et(y),i}if(this._helper._latRange){const t=d/2;m-t<s&&(g=s+t),m+t>o&&(g=o-t)}if(r){const t=(a+l)/2;let e=f;this._helper._renderWorldCopies&&(e=Pt(f,t-n/2,t+n/2));const i=p/2;e-i<a&&(_=a+i),e+i>l&&(_=l-i)}if(void 0!==_||void 0!==g){const t=new c(null!=_?_:f,null!=g?g:m);i.center=md(n,t).wrap()}return i}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}_calculateNearFarZIfNeeded(t,e,i){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),n=t-r*this._helper._pixelPerMeter/Math.cos(e),s=r<0?n:t,o=Math.PI/2+this.pitchInRadians,a=Zt(this.fov)*(Math.abs(Math.cos(Zt(this.roll)))*this.height+Math.abs(Math.sin(Zt(this.roll)))*this.width)/this.height*(.5+i.y/this.height),l=Math.sin(a)*s/Math.sin(Tt(Math.PI-o-a,.01,Math.PI-.01)),c=_d(this),h=Math.atan(c/this._helper.cameraToCenterDistance),u=Zt(.75),p=h>u?2*h*(.5+i.y/(2*c)):u,d=Math.sin(p)*s/Math.sin(Tt(Math.PI-o-p,.01,Math.PI-.01)),f=Math.min(l,d);this._helper._farZ=1.01*(Math.cos(Math.PI/2-e)*f+s),this._helper._nearZ=this._helper._height/50}_calcMatrices(){if(!this._helper._height)return;const t=this.centerOffset,e=fd(this.worldSize,this.center),i=e.x,r=e.y;this._helper._pixelPerMeter=Bp(1,this.center.lat)*this.worldSize;const n=Zt(Math.min(this.pitch,dd)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(n));let o;this._calculateNearFarZIfNeeded(s,n,t),o=new Float64Array(16),A(o,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),w(this._invProjMatrix,o),o[8]=2*-t.x/this._helper._width,o[9]=2*t.y/this._helper._height,this._projectionMatrix=v(o),S(o,o,[1,-1,1]),P(o,o,[0,0,-this._helper.cameraToCenterDistance]),C(o,o,-this.rollInRadians),M(o,o,this.pitchInRadians),C(o,o,-this.bearingInRadians),P(o,o,[-i,-r,0]),this._mercatorMatrix=S([],o,[this.worldSize,this.worldSize,this.worldSize]),S(o,o,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=T(new Float64Array(16),this.clipSpaceToPixelsMatrix,o),P(o,o,[0,0,-this.elevation]),this._viewProjMatrix=o,this._invViewProjMatrix=w([],o);const a=[0,0,-1,1];W(a,a,this._invViewProjMatrix),this._cameraPosition=[a[0]/a[3],a[1]/a[3],a[2]/a[3]],this._fogMatrix=new Float64Array(16),A(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-t.x/this.width,this._fogMatrix[9]=2*t.y/this.height,S(this._fogMatrix,this._fogMatrix,[1,-1,1]),P(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),C(this._fogMatrix,this._fogMatrix,-this.rollInRadians),M(this._fogMatrix,this._fogMatrix,this.pitchInRadians),C(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),P(this._fogMatrix,this._fogMatrix,[-i,-r,0]),S(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),P(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=T(new Float64Array(16),this.clipSpaceToPixelsMatrix,o);const l=this._helper._width%2/2,c=this._helper._height%2/2,h=Math.cos(this.bearingInRadians),u=Math.sin(-this.bearingInRadians),p=i-Math.round(i)+h*l+u*c,d=r-Math.round(r)+h*c+u*l,f=new Float64Array(o);if(P(f,f,[p>.5?p-1:p,d>.5?d-1:d,0]),this._alignedProjMatrix=f,o=w(new Float64Array(16),this._pixelMatrix),!o)throw new Error("failed to invert matrix");this._pixelMatrixInverse=o,this._clearMatrixCaches()}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear()}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const t=this.screenPointToMercatorCoordinate(new c(0,0)),e=[t.x*this.worldSize,t.y*this.worldSize,0,1];return W(e,e,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const t=Bp(1,this.center.lat)*this.worldSize;return yd(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/t).toLngLat()}lngLatToCameraDepth(t,e){const i=jp.fromLngLat(t),r=[i.x*this.worldSize,i.y*this.worldSize,e,1];return W(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(t){const{overscaledTileID:e,aligned:i,applyTerrainMatrix:r}=t,n=this._helper.getMercatorTileCoordinates(e),s=e?this.calculatePosMatrix(e,i,!0):null;let o;return o=e&&e.terrainRttPosMatrix32f&&r?e.terrainRttPosMatrix32f:s||lt(),{mainMatrix:o,tileMercatorCoords:n,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:o}}isLocationOccluded(t){return!1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(t,e,i){return 1}transformLightDirection(t){return k(t)}getRayDirectionFromPixel(t){throw new Error("Not implemented.")}projectTileCoordinates(t,e,i,r){const n=this.calculatePosMatrix(i);let s;r?(s=[t,e,r(t,e),1],W(s,s,n)):(s=[t,e,0,1],Jd(s,s,n));const o=s[3];return{point:new c(s[0]/o,s[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}populateCache(t){for(const e of t)this.calculatePosMatrix(e)}getMatrixForModel(t,e){const i=jp.fromLngLat(t,e),r=i.meterInMercatorCoordinateUnits(),n=at();return P(n,n,[i.x,i.y,i.z]),C(n,n,Math.PI),M(n,n,Math.PI/2),S(n,n,[-r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=new qp(0,0,0,0,0),i=this.getProjectionData({overscaledTileID:e,applyGlobeMatrix:t}),r=gd(e,this.worldSize);T(r,this._viewProjMatrix,r),i.tileMercatorCoords=[0,0,1,1];const n=[it,it,this.worldSize/this._helper.pixelsPerMeter],s=ot();return S(s,r,n),i.fallbackMatrix=s,i.mainMatrix=s,i}getFastPathSimpleProjectionMatrix(t){return this.calculatePosMatrix(t)}}function Kf(){Bt("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}function Jf(t){if(t.useSlerp)if(t.k<1){const e=Wt(t.startEulerAngles.roll,t.startEulerAngles.pitch,t.startEulerAngles.bearing),i=Wt(t.endEulerAngles.roll,t.endEulerAngles.pitch,t.endEulerAngles.bearing),r=new Float64Array(4);!function(t,e,i,r){var n,s,o,a,l,c=e[0],h=e[1],u=e[2],p=e[3],d=i[0],f=i[1],_=i[2],g=i[3];(s=c*d+h*f+u*_+p*g)<0&&(s=-s,d=-d,f=-f,_=-_,g=-g),1-s>m?(n=Math.acos(s),o=Math.sin(n),a=Math.sin((1-r)*n)/o,l=Math.sin(r*n)/o):(a=1-r,l=r),t[0]=a*c+l*d,t[1]=a*h+l*f,t[2]=a*u+l*_,t[3]=a*p+l*g}(r,e,i,t.k);const n=function(t){const e=new Float64Array(9);var i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x;u=(n=(r=t)[0])*(l=n+n),p=(s=r[1])*l,f=(o=r[2])*l,m=o*(c=s+s),g=(a=r[3])*l,y=a*c,x=a*(h=o+o),(i=e)[0]=1-(d=s*c)-(_=o*h),i[3]=p-x,i[6]=f+y,i[1]=p+x,i[4]=1-u-_,i[7]=m-g,i[2]=f-y,i[5]=m+g,i[8]=1-u-d;const v=Gt(-Math.asin(Tt(e[2],-1,1)));let b,w;return Math.hypot(e[5],e[8])<.001?(b=0,w=-Gt(Math.atan2(e[3],e[4]))):(b=Gt(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),w=Gt(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:b,pitch:v+90,bearing:w}}(r);t.tr.setRoll(n.roll),t.tr.setPitch(n.pitch),t.tr.setBearing(n.bearing)}else t.tr.setRoll(t.endEulerAngles.roll),t.tr.setPitch(t.endEulerAngles.pitch),t.tr.setBearing(t.endEulerAngles.bearing);else t.tr.setRoll(wr.number(t.startEulerAngles.roll,t.endEulerAngles.roll,t.k)),t.tr.setPitch(wr.number(t.startEulerAngles.pitch,t.endEulerAngles.pitch,t.k)),t.tr.setBearing(wr.number(t.startEulerAngles.bearing,t.endEulerAngles.bearing,t.k))}function Qf(t,e,i,r,n){const s=n.padding,o=fd(n.worldSize,i.getNorthWest()),a=fd(n.worldSize,i.getNorthEast()),l=fd(n.worldSize,i.getSouthEast()),h=fd(n.worldSize,i.getSouthWest()),u=Zt(-r),p=o.rotate(u),d=a.rotate(u),f=l.rotate(u),m=h.rotate(u),_=new c(Math.max(p.x,d.x,m.x,f.x),Math.max(p.y,d.y,m.y,f.y)),g=new c(Math.min(p.x,d.x,m.x,f.x),Math.min(p.y,d.y,m.y,f.y)),y=_.sub(g),x=(n.width-(s.left+s.right+e.left+e.right))/y.x,v=(n.height-(s.top+s.bottom+e.top+e.bottom))/y.y;if(v<0||x<0)return void Kf();const b=Math.min(Et(n.scale*Math.min(x,v)),t.maxZoom),w=c.convert(t.offset),T=new c((e.left-e.right)/2,(e.top-e.bottom)/2).rotate(Zt(r)),P=w.add(T).mult(n.scale/At(b));return{center:md(n.worldSize,o.add(l).div(2).sub(P)),zoom:b,bearing:r}}class tm{get useGlobeControls(){return!1}handlePanInertia(t,e){return{easingOffset:t,easingCenter:e.center}}handleMapControlsRollPitchBearingZoom(t,e){t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta),t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta)}handleMapControlsPan(t,e,i){t.around.distSqr(e.centerPoint)<.01||e.setLocationAtPoint(i,t.around)}cameraForBoxAndBearing(t,e,i,r,n){return Qf(t,e,i,r,n)}handleJumpToCenterZoom(t,e){t.zoom!==(void 0!==e.zoom?+e.zoom:t.zoom)&&t.setZoom(+e.zoom),void 0!==e.center&&t.setCenter(Ep.convert(e.center))}handleEaseTo(t,e){const i=t.zoom,r=t.padding,n={roll:t.roll,pitch:t.pitch,bearing:t.bearing},s={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},o=void 0!==e.zoom,a=!t.isPaddingEqual(e.padding);let l=!1;const c=o?+e.zoom:t.zoom;let h=t.centerPoint.add(e.offsetAsPoint);const u=t.screenPointToLocation(h),{center:p,zoom:d}=t.getConstrained(Ep.convert(e.center||u),null!=c?c:i);Gf(t,p);const f=fd(t.worldSize,u),m=fd(t.worldSize,p).sub(f),_=At(d-i);return l=d!==i,{easeFunc:o=>{if(l&&t.setZoom(wr.number(i,d,o)),$t(n,s)||Jf({startEulerAngles:n,endEulerAngles:s,tr:t,k:o,useSlerp:n.roll!=s.roll}),a&&(t.interpolatePadding(r,e.padding,o),h=t.centerPoint.add(e.offsetAsPoint)),e.around)t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=At(t.zoom-i),r=d>i?Math.min(2,_):Math.max(.5,_),n=Math.pow(r,1-o),s=md(t.worldSize,f.add(m.mult(o*n)).mult(e));t.setLocationAtPoint(t.renderWorldCopies?s.wrap():s,h)}},isZooming:l,elevationCenter:p}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.zoom,n=t.getConstrained(Ep.convert(e.center||e.locationAtOffset),i?+e.zoom:r),s=n.center,o=n.zoom;Gf(t,s);const a=fd(t.worldSize,e.locationAtOffset),l=fd(t.worldSize,s).sub(a),c=l.mag(),h=At(o-r);let u;if(void 0!==e.minZoom){const i=Math.min(+e.minZoom,r,o);u=At(t.getConstrained(s,i).zoom-r)}return{easeFunc:(e,i,n,c)=>{t.setZoom(1===e?o:r+Et(i));const h=1===e?s:md(t.worldSize,a.add(l.mult(n)).mult(i));t.setLocationAtPoint(t.renderWorldCopies?h.wrap():h,c)},scaleOfZoom:h,targetCenter:s,scaleOfMinZoom:u,pixelPathLength:c}}}class em{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i}}em.Replace=[1,0],em.disabled=new em(em.Replace,Di.transparent,[!1,!1,!1,!1]),em.unblended=new em(em.Replace,Di.transparent,[!0,!0,!0,!0]),em.alphaBlended=new em([1,771],Di.transparent,[!0,!0,!0,!0]);const im=2305;class rm{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i}}rm.disabled=new rm(!1,1029,im),rm.backCCW=new rm(!0,1029,im),rm.frontCCW=new rm(!0,1028,im);class nm{constructor(t,e,i){this.func=t,this.mask=e,this.range=i}}nm.ReadOnly=!1,nm.ReadWrite=!0,nm.disabled=new nm(519,nm.ReadOnly,[0,1]);const sm=7680;class om{constructor(t,e,i,r,n,s){this.test=t,this.ref=e,this.mask=i,this.fail=r,this.depthFail=n,this.pass=s}}om.disabled=new om({func:519,mask:0},0,0,sm,sm,sm);const am=new WeakMap;function lm(t){var e;if(am.has(t))return am.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return am.set(t,i),i}}class cm{get awaitingQuery(){return!!this._readbackQueue}constructor(t){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=t;const e=t.context,i=e.gl;this._texFormat=i.RGBA,this._texType=i.UNSIGNED_BYTE;const r=new La;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const n=new Ka;n.emplaceBack(0,1,2),this._fullscreenTriangle=new Of(e.createVertexBuffer(r,jf.members),e.createIndexBuffer(n),il.simpleSegment(0,0,r.length,n.length)),this._resultBuffer=new Uint8Array(4),e.activeTexture.set(i.TEXTURE1);const s=i.createTexture();i.bindTexture(i.TEXTURE_2D,s),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texImage2D(i.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=e.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),lm(i)&&(this._pbo=i.createBuffer(),i.bindBuffer(i.PIXEL_PACK_BUFFER,this._pbo),i.bufferData(i.PIXEL_PACK_BUFFER,4,i.STREAM_READ),i.bindBuffer(i.PIXEL_PACK_BUFFER,null))}destroy(){const t=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),t.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null}updateErrorLoop(t,e){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(t,e),this._updateCount++,this._measuredError}_bindFramebuffer(){const t=this._cachedRenderContext.context,e=t.gl;t.activeTexture.set(e.TEXTURE1),e.bindTexture(e.TEXTURE_2D,this._fbo.colorAttachment.get()),t.bindFramebuffer.set(this._fbo.framebuffer)}_renderErrorTexture(t,e){const i=this._cachedRenderContext.context,r=i.gl;if(this._bindFramebuffer(),i.viewport.set([0,0,this._texWidth,this._texHeight]),i.clear({color:Di.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(i,r.TRIANGLES,nm.disabled,om.disabled,em.unblended,rm.disabled,((t,e)=>({u_input:t,u_output_expected:e}))(t,e),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&lm(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const t=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:t}}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null}}_tryReadback(){const t=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&lm(t)){const e=t.clientWaitSync(this._readbackQueue.sync,0,0);if(e===t.WAIT_FAILED)return Bt("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(e===t.TIMEOUT_EXPIRED)return;t.bindBuffer(t.PIXEL_PACK_BUFFER,this._pbo),t.getBufferSubData(t.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),t.bindBuffer(t.PIXEL_PACK_BUFFER,null)}else this._bindFramebuffer(),t.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=cm._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount}static _parseRGBA8float(t){let e=0;return e+=t[0]/256,e+=t[1]/65536,e+=t[2]/16777216,t[3]<127&&(e=-e),e/128}}function hm(t,e){const i=void 0!==t.granularity?Math.max(t.granularity,1):1,r=i+(t.generateBorders?2:0),n=i+(t.extendToNorthPole||t.generateBorders?1:0)+(t.extendToSouthPole||t.generateBorders?1:0),s=r+1,o=n+1,a=t.generateBorders?-1:0,l=t.generateBorders||t.extendToNorthPole?-1:0,c=i+(t.generateBorders?1:0),h=i+(t.generateBorders||t.extendToSouthPole?1:0),u=s*o,p=r*n*6,d=s*o>65536;if(d&&"16bit"===e)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const f=d||"32bit"===e,m=new Int16Array(2*u);let _=0;for(let e=l;e<=h;e++)for(let r=a;r<=c;r++){let n=r/i*it;-1===r&&(n=-64),r===i+1&&(n=8256);let s=e/i*it;-1===e&&(s=t.extendToNorthPole?oh:-64),e===i+1&&(s=t.extendToSouthPole?ah:8256),m[_++]=n,m[_++]=s}const g=f?new Uint32Array(p):new Uint16Array(p);let y=0;for(let t=0;t<n;t++)for(let e=0;e<r;e++){const i=e+1+t*s,r=e+(t+1)*s,n=e+1+(t+1)*s;g[y++]=e+t*s,g[y++]=r,g[y++]=i,g[y++]=i,g[y++]=r,g[y++]=n}return{vertices:m.buffer.slice(0),indices:g.buffer.slice(0),uses32bitIndices:f}}const um=new sh({fill:new nh(128,2),line:new nh(512,0),tile:new nh(128,32),stencil:new nh(128,1),circle:3});class pm{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3}get name(){return"vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return!0}get shaderVariantName(){return"globe"}get shaderDefine(){return"#define GLOBE"}get shaderPreludeCode(){return Bf.projectionGlobe}get vertexShaderPreludeCode(){return Bf.projectionMercator.vertexSource}get subdivisionGranularity(){return um}get useGlobeControls(){return!0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy()}updateGPUdependent(t){this._errorMeasurement||(this._errorMeasurement=new cm(t));const e=Lp(this._errorQueryLatitudeDegrees),i=2*Math.atan(Math.exp(Math.PI-e*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(e,i),n=ie.now();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=n);const s=Math.min(Math.max((n-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=yt(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,vt(s))}_getMeshKey(t){return`${t.granularity.toString(36)}_${t.generateBorders?"b":""}${t.extendToNorthPole?"n":""}${t.extendToSouthPole?"s":""}`}getMeshFromTileID(t,e,i,r,n){const s=("stencil"===n?um.stencil:um.tile).getGranularityForZoomLevel(e.z);return this._getMesh(t,{granularity:s,generateBorders:i,extendToNorthPole:0===e.y&&r,extendToSouthPole:e.y===(1<<e.z)-1&&r})}_getMesh(t,e){const i=this._getMeshKey(e);if(i in this._tileMeshCache)return this._tileMeshCache[i];const r=function(t,e){const i=hm(e,"16bit"),r=La.deserialize({arrayBuffer:i.vertices,length:i.vertices.byteLength/2/2}),n=Ka.deserialize({arrayBuffer:i.indices,length:i.indices.byteLength/2/3});return new Of(t.createVertexBuffer(r,jf.members),t.createIndexBuffer(n),il.simpleSegment(0,0,r.length,n.length))}(t,e);return this._tileMeshCache[i]=r,r}recalculate(t){}hasTransition(){const t=ie.now();let e=!1;return e=e||(t-this._errorMeasurementLastChangeTime)/1e3<.7,e=e||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,e}setErrorQueryLatitudeDegrees(t){this._errorQueryLatitudeDegrees=t}}const dm=new qo({type:new No(Se.projection.type)});class fm extends Pe{constructor(t){super(),this._transitionable=new Lo(dm),this.setProjection(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ko(0)),this._mercatorProjection=new Uf,this._verticalPerspectiveProjection=new pm}get transitionState(){const t=this.properties.get("type");if("string"==typeof t&&"mercator"===t)return 0;if("string"==typeof t&&"vertical-perspective"===t)return 1;if(t instanceof qi){if("vertical-perspective"===t.from&&"mercator"===t.to)return 1-t.transition;if("mercator"===t.from&&"vertical-perspective"===t.to)return t.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return"globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy()}updateGPUdependent(t){this._mercatorProjection.updateGPUdependent(t),this._verticalPerspectiveProjection.updateGPUdependent(t)}getMeshFromTileID(t,e,i,r,n){return this.currentProjection.getMeshFromTileID(t,e,i,r,n)}setProjection(t){this._transitionable.setValue("type",(null==t?void 0:t.type)||"mercator")}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}setErrorQueryLatitudeDegrees(t){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(t),this._mercatorProjection.setErrorQueryLatitudeDegrees(t)}}function mm(t){const e=ym(t.worldSize,t.center.lat);return 2*Math.PI*e}function _m(t,e,i,r,n){const s=1/(1<<n),o=e/it*s+r*s,a=_t((t/it*s+i*s)*Math.PI*2+Math.PI,2*Math.PI),l=2*Math.atan(Math.exp(Math.PI-o*Math.PI*2))-.5*Math.PI,c=Math.cos(l),h=new Float64Array(3);return h[0]=Math.sin(a)*c,h[1]=Math.sin(l),h[2]=Math.cos(a)*c,h}function gm(t){return function(t,e){const i=Math.cos(e),r=new Float64Array(3);return r[0]=Math.sin(t)*i,r[1]=Math.sin(e),r[2]=Math.cos(t)*i,r}(t.lng*Math.PI/180,t.lat*Math.PI/180)}function ym(t,e){return t/(2*Math.PI)/Math.cos(e*Math.PI/180)}function xm(t){const e=Math.asin(t[1])/Math.PI*180,i=Math.sqrt(t[0]*t[0]+t[2]*t[2]);if(i>1e-6){const r=t[0]/i,n=Math.acos(t[2]/i),s=(r>0?n:-n)/Math.PI*180;return new Ep(Pt(s,-180,180),e)}return new Ep(0,e)}function vm(t){return Math.cos(t*Math.PI/180)}function bm(t,e){const i=vm(t);return Et(vm(e)/i)}function wm(t,e){const i=t.rotate(e.bearingInRadians),r=e.zoom+bm(e.center.lat,0),n=yt(1/vm(e.center.lat),1/vm(Math.min(Math.abs(e.center.lat),60)),gt(r,7,3,0,1)),s=360/mm({worldSize:e.worldSize,center:{lat:e.center.lat}});return new Ep(e.center.lng-i.x*s*n,Tt(e.center.lat+i.y*s,-85.051129,Ht))}function Tm(t){const e=.5*t,i=Math.sin(e),r=Math.cos(e);return Math.log(i+r)-Math.log(r-i)}function Pm(t,e,i,r){const n=t.lat+i*r;if(Math.abs(i)>1){const s=(Math.sign(t.lat+i)!==Math.sign(t.lat)?-Math.abs(t.lat):Math.abs(t.lat))*Math.PI/180,o=Math.abs(t.lat+i)*Math.PI/180,a=Tm(s+r*(o-s)),l=Tm(s),c=Tm(o);return new Ep(t.lng+e*((a-l)/(c-l)),n)}return new Ep(t.lng+e*r,n)}class Sm{constructor(t){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=t}swapBuffers(){if(!this._hadAnyChanges)return;const t=this._cachePrevious;this._cachePrevious=this._cache,this._cache=t,this._cache.clear(),this._hadAnyChanges=!1}getTileBoundingVolume(t,e,i,r){const n=`${t.z}_${t.x}_${t.y}_${(null==r?void 0:r.terrain)?"t":""}`,s=this._cache.get(n);if(s)return s;const o=this._cachePrevious.get(n);if(o)return this._cache.set(n,o),o;const a=this._boundingVolumeFactory(t,e,i,r);return this._cache.set(n,a),this._hadAnyChanges=!0,a}}class Mm{constructor(t,e,i,r){this.min=i,this.max=r,this.points=t,this.planes=e}static fromAabb(t,e){const i=[];for(let r=0;r<8;r++)i.push([1&~r?t[0]:e[0],1==(r>>1&1)?e[1]:t[1],1==(r>>2&1)?e[2]:t[2]]);return new Mm(i,[[-1,0,0,e[0]],[1,0,0,-t[0]],[0,-1,0,e[1]],[0,1,0,-t[1]],[0,0,-1,e[2]],[0,0,1,-t[2]]],t,e)}static fromCenterSizeAngles(t,e,i){const r=X([],i[0],i[1],i[2]),n=V([],[e[0],0,0],r),s=V([],[0,e[1],0],r),o=V([],[0,0,e[2]],r),a=[...t],l=[...t];for(let e=0;e<8;e++)for(let i=0;i<3;i++){const r=t[i]+n[i]*(1&~e?-1:1)+s[i]*(1==(e>>1&1)?1:-1)+o[i]*(1==(e>>2&1)?1:-1);a[i]=Math.min(a[i],r),l[i]=Math.max(l[i],r)}const c=[];for(let e=0;e<8;e++){const i=[...t];L(i,i,B([],n,1&~e?-1:1)),L(i,i,B([],s,1==(e>>1&1)?1:-1)),L(i,i,B([],o,1==(e>>2&1)?1:-1)),c.push(i)}return new Mm(c,[[...n,-O(n,c[0])],[...s,-O(s,c[0])],[...o,-O(o,c[0])],[-n[0],-n[1],-n[2],-O(n,c[7])],[-s[0],-s[1],-s[2],-O(s,c[7])],[-o[0],-o[1],-o[2],-O(o,c[7])]],a,l)}intersectsFrustum(t){let e=!0;const i=this.points.length,r=this.planes.length,n=t.planes.length,s=t.points.length;for(let r=0;r<n;r++){const n=t.planes[r];let s=0;for(let t=0;t<i;t++){const e=this.points[t];n[0]*e[0]+n[1]*e[1]+n[2]*e[2]+n[3]>=0&&s++}if(0===s)return 0;s<i&&(e=!1)}if(e)return 2;for(let e=0;e<r;e++){const i=this.planes[e];let r=0;for(let e=0;e<s;e++){const n=t.points[e];i[0]*n[0]+i[1]*n[1]+i[2]*n[2]+i[3]>=0&&r++}if(0===r)return 0}return 1}intersectsPlane(t){const e=this.points.length;let i=0;for(let r=0;r<e;r++){const e=this.points[r];t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0&&i++}return i===e?2:0===i?0:1}}function Im(t,e,i){const r=t-e;return r<0?-r:Math.max(0,r-i)}function Cm(t,e,i,r,n){const s=t-i;let o;return o=s<0?Math.min(-s,1+s-n):s>1?Math.min(Math.max(s-n,0),1-s):0,Math.max(o,Im(e,r,n))}class Am{constructor(){this._boundingVolumeCache=new Sm(this._computeTileBoundingVolume)}prepareNextFrame(){this._boundingVolumeCache.swapBuffers()}distanceToTile2d(t,e,i,r){const n=1<<i.z,s=1/n,o=i.x/n,a=i.y/n;let l=2;return l=Math.min(l,Cm(t,e,o,a,s)),l=Math.min(l,Cm(t,e,o+.5,-a-s,s)),l=Math.min(l,Cm(t,e,o+.5,2-a-s,s)),l}getWrap(t,e,i){const r=1<<e.z,n=1/r,s=e.x/r,o=Im(t.x,s,n),a=Im(t.x,s-1,n),l=Im(t.x,s+1,n),c=Math.min(o,a,l);return c===l?1:c===a?-1:0}allowVariableZoom(t,e){return Td(t,e)>4}allowWorldCopies(){return!1}getTileBoundingVolume(t,e,i,r){return this._boundingVolumeCache.getTileBoundingVolume(t,e,i,r)}_computeTileBoundingVolume(t,e,i,r){var n,s;let o=i,a=i;if(null==r?void 0:r.terrain){const l=new qp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);o=null!==(n=c.minElevation)&&void 0!==n?n:i,a=null!==(s=c.maxElevation)&&void 0!==s?s:i}if(o/=Ap,a/=Ap,o+=1,a+=1,t.z<=0)return Mm.fromAabb([-a,-a,-a],[a,a,a]);if(1===t.z)return Mm.fromAabb([0===t.x?-a:0,0===t.y?0:-a,-a],[0===t.x?0:a,0===t.y?a:0,a]);{const e=[_m(0,0,t.x,t.y,t.z),_m(it,0,t.x,t.y,t.z),_m(it,it,t.x,t.y,t.z),_m(0,it,t.x,t.y,t.z)],i=[];for(const t of e)i.push(B([],t,a));if(a!==o)for(const t of e)i.push(B([],t,o));0===t.y&&i.push([0,1,0]),t.y===(1<<t.z)-1&&i.push([0,-1,0]);const r=[1,1,1],n=[-1,-1,-1];for(const t of i)for(let e=0;e<3;e++)r[e]=Math.min(r[e],t[e]),n[e]=Math.max(n[e],t[e]);const s=_m(4096,4096,t.x,t.y,t.z),l=j([],[0,1,0],s);F(l,l);const c=j([],s,l);F(c,c);const h=j([],e[2],e[1]);F(h,h);const u=j([],e[0],e[3]);F(u,u),i.push(B([],s,a)),t.y>=(1<<t.z)/2&&i.push(B([],_m(4096,0,t.x,t.y,t.z),a)),t.y<(1<<t.z)/2&&i.push(B([],_m(4096,it,t.x,t.y,t.z),a));const p=Em(s,i),d=Em(c,i),f=[-s[0],-s[1],-s[2],p.max],m=[s[0],s[1],s[2],-p.min],_=[-c[0],-c[1],-c[2],d.max],g=[c[0],c[1],c[2],-d.min],y=[...h,0],x=[...u,0],v=[];return 0===t.y?v.push(ut(x,y,f),ut(x,y,m)):v.push(ut(_,y,f),ut(_,y,m),ut(_,x,f),ut(_,x,m)),t.y===(1<<t.z)-1?v.push(ut(x,y,f),ut(x,y,m)):v.push(ut(g,y,f),ut(g,y,m),ut(g,x,f),ut(g,x,m)),new Mm(v,[f,m,_,g,y,x],r,n)}}}function Em(t,e){let i=1/0,r=-1/0;for(const n of e){const e=O(t,n);i=Math.min(i,e),r=Math.max(r,e)}return{min:i,max:r}}class zm{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e){this._helper.resize(t,e)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t){}constructor(){this._cachedClippingPlane=nt(),this._projectionMatrix=at(),this._globeViewProjMatrix32f=lt(),this._globeViewProjMatrixNoCorrection=at(),this._globeViewProjMatrixNoCorrectionInverted=at(),this._globeProjMatrixInverted=at(),this._cameraPosition=st(),this._globeLatitudeErrorCorrectionRadians=0,this._helper=new qf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._coveringTilesDetailsProvider=new Am}clone(){const t=new zm;return t.apply(this),t}apply(t,e){this._globeLatitudeErrorCorrectionRadians=e||0,this._helper.apply(t)}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const t=st();return t[0]=this._cameraPosition[0],t[1]=this._cameraPosition[1],t[2]=this._cameraPosition[2],t}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(t){const{overscaledTileID:e,applyGlobeMatrix:i}=t,r=this._helper.getMercatorTileCoordinates(e);return{mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(t){const e=this.pitchInRadians,i=this.cameraToCenterDistance/t,r=Math.sin(e)*i,n=Math.cos(e)*i+1,s=1/Math.sqrt(r*r+n*n)*1;let o=-r,a=n;const l=Math.sqrt(o*o+a*a);o/=l,a/=l;const c=[0,o,a];Z(c,c,[0,0,0],-this.bearingInRadians),N(c,c,[0,0,0],-1*this.center.lat*Math.PI/180),U(c,c,[0,0,0],this.center.lng*Math.PI/180);const h=1/R(c);return B(c,c,h),[...c,-s*h]}isLocationOccluded(t){return!this.isSurfacePointVisible(gm(t))}transformLightDirection(t){const e=this._helper._center.lng*Math.PI/180,i=this._helper._center.lat*Math.PI/180,r=Math.cos(i),n=[Math.sin(e)*r,Math.sin(i),Math.cos(e)*r],s=[n[2],0,-n[0]],o=[0,0,0];j(o,s,n),F(s,s),F(o,o);const a=[0,0,0];return F(a,[s[0]*t[0]+o[0]*t[1]+n[0]*t[2],s[1]*t[0]+o[1]*t[1]+n[1]*t[2],s[2]*t[0]+o[2]*t[1]+n[2]*t[2]]),a}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(t,e,i){const r=function(t,e,i){const r=1/(1<<i.z);return new jp(t/it*r+i.x*r,e/it*r+i.y*r)}(t,e,i.canonical),n=(s=r.y,[_t(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(n[1])}projectTileCoordinates(t,e,i,r){const n=i.canonical,s=_m(t,e,n.x,n.y,n.z),o=1+(r?r(t,e):0)/Ap,a=[s[0]*o,s[1]*o,s[2]*o,1];W(a,a,this._globeViewProjMatrixNoCorrection);const l=this._cachedClippingPlane,h=l[0]*s[0]+l[1]*s[1]+l[2]*s[2]+l[3]<0;return{point:new c(a[0]/a[3],a[1]/a[3]),signedDistanceFromCamera:a[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const t=ym(this.worldSize,this.center.lat),e=ot(),i=ot();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*t),A(e,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;e[8]=2*-r.x/this._helper._width,e[9]=2*r.y/this._helper._height,this._projectionMatrix=v(e),this._globeProjMatrixInverted=ot(),w(this._globeProjMatrixInverted,e),P(e,e,[0,0,-this.cameraToCenterDistance]),C(e,e,this.rollInRadians),M(e,e,-this.pitchInRadians),C(e,e,this.bearingInRadians),P(e,e,[0,0,-t]);const n=st();n[0]=t,n[1]=t,n[2]=t,M(i,e,this.center.lat*Math.PI/180),I(i,i,-this.center.lng*Math.PI/180),S(i,i,n),this._globeViewProjMatrixNoCorrection=i,M(e,e,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),I(e,e,-this.center.lng*Math.PI/180),S(e,e,n),this._globeViewProjMatrix32f=new Float32Array(e),this._globeViewProjMatrixNoCorrectionInverted=ot(),w(this._globeViewProjMatrixNoCorrectionInverted,i);const s=st();this._cameraPosition=st(),this._cameraPosition[2]=this.cameraToCenterDistance/t,Z(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),N(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),Z(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),L(this._cameraPosition,this._cameraPosition,[0,0,1]),N(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),U(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(t);const o=v(this._globeViewProjMatrixNoCorrectionInverted);S(o,o,[1,1,-1]),this._cachedFrustum=Xf.fromInvProjectionMatrix(o,1,0,this._cachedClippingPlane,!0)}calculateFogMatrix(t){Bt("calculateFogMatrix is not supported on globe projection.");const e=ot();return b(e),e}getVisibleUnwrappedCoordinates(t){return[new $p(0,t)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){t&&Bt("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0)}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){if(!this._globeViewProjMatrixNoCorrection)return 1;const i=gm(t);B(i,i,1+e/Ap);const r=nt();return W(r,[i[0],i[1],i[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(t){}getBounds(){const t=.5*this.width,e=.5*this.height,i=[new c(0,0),new c(t,0),new c(this.width,0),new c(this.width,e),new c(this.width,this.height),new c(t,this.height),new c(0,this.height),new c(0,e)],r=[];for(const t of i)r.push(this.unprojectScreenPoint(t));let n=0,s=0,o=0,a=0;const l=this.center;for(const t of r){const e=ft(l.lng,t.lng),i=ft(l.lat,t.lat);e<s&&(s=e),e>n&&(n=e),i<a&&(a=i),i>o&&(o=i)}const h=[l.lng+s,l.lat+a,l.lng+n,l.lat+o];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new zp(h)}getConstrained(t,e){const i=Tt(t.lat,-85.051129,Ht),r=Tt(+e,this.minZoom+bm(0,i),this.maxZoom);return{center:new Ep(t.lng,i),zoom:r}}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){const i=gm(this.unprojectScreenPoint(e)),r=gm(t),n=st();var s;(s=n)[0]=0,s[1]=0,s[2]=0;const o=st();U(o,i,n,-this.center.lng*Math.PI/180),N(o,o,n,this.center.lat*Math.PI/180);const a=r[0]*r[0]+r[2]*r[2],l=o[0]*o[0];if(a<l)return;const c=Math.sqrt(a-l),h=-c,u=dt(r[0],r[2],o[0],c),p=dt(r[0],r[2],o[0],h),d=st();U(d,r,n,-u);const f=dt(d[1],d[2],o[1],o[2]),m=st();U(m,r,n,-p);const _=dt(m[1],m[2],o[1],o[2]),g=.5*Math.PI,y=f>=-g&&f<=g,x=_>=-g&&_<=g;let v,b;if(y&&x){const t=this.center.lng*Math.PI/180,e=this.center.lat*Math.PI/180;mt(u,t)+mt(f,e)<mt(p,t)+mt(_,e)?(v=u,b=f):(v=p,b=_)}else if(y)v=u,b=f;else{if(!x)return;v=p,b=_}const w=v/Math.PI*180,T=b/Math.PI*180,P=this.center.lat;this.setCenter(new Ep(w,Tt(T,-90,90))),this.setZoom(this.zoom+bm(P,this.center.lat))}locationToScreenPoint(t,e){const i=gm(t);return e&&B(i,i,1+e.getElevationForLngLatZoom(t,this._helper._tileZoom)/Ap),this._projectSurfacePointToScreen(i)}_projectSurfacePointToScreen(t){const e=nt();return W(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],new c((.5*e[0]+.5)*this.width,(.5*-e[1]+.5)*this.height)}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(i)return i}return jp.fromLngLat(this.unprojectScreenPoint(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(t,e){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(t);return!!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(t){const e=nt();e[0]=t.x/this.width*2-1,e[1]=-1*(t.y/this.height*2-1),e[2]=1,e[3]=1,W(e,e,this._globeViewProjMatrixNoCorrectionInverted),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3];const i=st();i[0]=e[0]-this._cameraPosition[0],i[1]=e[1]-this._cameraPosition[1],i[2]=e[2]-this._cameraPosition[2];const r=st();return F(r,i),r}isSurfacePointVisible(t){const e=this._cachedClippingPlane;return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0}isSurfacePointOnScreen(t){if(!this.isSurfacePointVisible(t))return!1;const e=nt();return W(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3],e[0]>-1&&e[0]<1&&e[1]>-1&&e[1]<1&&e[2]>-1&&e[2]<1}rayPlanetIntersection(t,e){const i=O(t,e),r=st(),n=st();B(n,e,i),$(r,t,n);const s=1-O(r,r);if(s<0)return null;const o=O(t,t)-1,a=-i+(i<0?1:-1)*Math.sqrt(s),l=o/a,c=a;return{tMin:Math.min(l,c),tMax:Math.max(l,c)}}unprojectScreenPoint(t){const e=this._cameraPosition,i=this.getRayDirectionFromPixel(t),r=this.rayPlanetIntersection(e,i);if(r){const t=st();L(t,e,[i[0]*r.tMin,i[1]*r.tMin,i[2]*r.tMin]);const n=st();return F(n,t),xm(n)}const n=this._cachedClippingPlane,s=n[0]*i[0]+n[1]*i[1]+n[2]*i[2],o=-ht(n,e)/s,a=st();if(o>0)L(a,e,[i[0]*o,i[1]*o,i[2]*o]);else{const t=st();L(t,e,[2*i[0],2*i[1],2*i[2]]);const r=ht(this._cachedClippingPlane,t);$(a,t,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r])}const l=function(t){const e=st();return e[0]=t[0]*-t[3],e[1]=t[1]*-t[3],e[2]=t[2]*-t[3],{center:e,radius:Math.sqrt(1-t[3]*t[3])}}(n),c=function(t,e,i){const r=st();$(r,i,t);const n=st();return function(t,e,i,r){t[0]=e[0]+i[0]*r,t[1]=e[1]+i[1]*r,t[2]=e[2]+i[2]*r}(n,t,r,e/q(r)),n}(l.center,l.radius,a);return xm(c)}getMatrixForModel(t,e){const i=Ep.convert(t),r=1/Ap,n=at();return I(n,n,i.lng/180*Math.PI),M(n,n,-i.lat/180*Math.PI),P(n,n,[0,0,1+e/Ap]),M(n,n,.5*Math.PI),S(n,n,[r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=this.getProjectionData({overscaledTileID:new qp(0,0,0,0,0),applyGlobeMatrix:t});return e.tileMercatorCoords=[0,0,1,1],e}getFastPathSimpleProjectionMatrix(t){}}class km{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(t,e){this._globeness=t,this._globeLatitudeErrorCorrectionRadians=e,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame()}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this._helper=new qf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._globeness=1,this._mercatorTransform=new Yf,this._verticalPerspectiveTransform=new zm}clone(){const t=new km;return t._globeness=this._globeness,t._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,t.apply(this),t}apply(t){this._helper.apply(t),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians)}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(t){const e=this._mercatorTransform.getProjectionData(t),i=this._verticalPerspectiveTransform.getProjectionData(t);return{mainMatrix:this.isGlobeRendering?i.mainMatrix:e.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:t.applyGlobeMatrix?this._globeness:0,fallbackMatrix:e.fallbackMatrix}}isLocationOccluded(t){return this.currentTransform.isLocationOccluded(t)}transformLightDirection(t){return this.currentTransform.transformLightDirection(t)}getPixelScale(){return yt(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return yt(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(t,e,i){return yt(this._mercatorTransform.getPitchedTextCorrection(t,e,i),this._verticalPerspectiveTransform.getPitchedTextCorrection(t,e,i),this._globeness)}projectTileCoordinates(t,e,i,r){return this.currentTransform.projectTileCoordinates(t,e,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ)}calculateFogMatrix(t){return this.currentTransform.calculateFogMatrix(t)}getVisibleUnwrappedCoordinates(t){return this.currentTransform.getVisibleUnwrappedCoordinates(t)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(t){this._mercatorTransform.recalculateZoomAndCenter(t),this._verticalPerspectiveTransform.recalculateZoomAndCenter(t)}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){return this.currentTransform.lngLatToCameraDepth(t,e)}populateCache(t){this._mercatorTransform.populateCache(t),this._verticalPerspectiveTransform.populateCache(t)}getBounds(){return this.currentTransform.getBounds()}getConstrained(t,e){return this.currentTransform.getConstrained(t,e)}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(t,e),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(t,e),this.apply(this._verticalPerspectiveTransform)}locationToScreenPoint(t,e){return this.currentTransform.locationToScreenPoint(t,e)}screenPointToMercatorCoordinate(t,e){return this.currentTransform.screenPointToMercatorCoordinate(t,e)}screenPointToLocation(t,e){return this.currentTransform.screenPointToLocation(t,e)}isPointOnMapSurface(t,e){return this.currentTransform.isPointOnMapSurface(t,e)}getRayDirectionFromPixel(t){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(t)}getMatrixForModel(t,e){return this.currentTransform.getMatrixForModel(t,e)}getProjectionDataForCustomLayer(t=!0){const e=this._mercatorTransform.getProjectionDataForCustomLayer(t);if(!this.isGlobeRendering)return e;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(t);return i.fallbackMatrix=e.mainMatrix,i}getFastPathSimpleProjectionMatrix(t){return this.currentTransform.getFastPathSimpleProjectionMatrix(t)}}class Rm{get useGlobeControls(){return!0}handlePanInertia(t,e){const i=wm(t,e);return Math.abs(i.lng-e.center.lng)>180&&(i.lng=e.center.lng+179.5*Math.sign(i.lng-e.center.lng)),{easingCenter:i,easingOffset:new c(0,0)}}handleMapControlsRollPitchBearingZoom(t,e){const i=t.around,r=e.screenPointToLocation(i);t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta);const n=e.zoom;t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta);const s=e.zoom-n;if(0===s)return;const o=ft(e.center.lng,r.lng),a=o/(Math.abs(o/180)+1),l=ft(e.center.lat,r.lat),c=e.getRayDirectionFromPixel(i),h=e.cameraPosition,u=-1*O(h,c),p=st();L(p,h,[c[0]*u,c[1]*u,c[2]*u]);const d=R(p)-1,f=Math.exp(.5*-Math.max(d-.3,0)),m=ym(e.worldSize,e.center.lat)/Math.min(e.width,e.height),_=gt(m,.9,.5,1,.25),g=(1-At(-s))*Math.min(f,_),y=e.center.lat,x=e.zoom,v=new Ep(e.center.lng+a*g,Tt(e.center.lat+l*g,-85.051129,Ht));e.setLocationAtPoint(r,i);const b=e.center,w=gt(Math.abs(o),45,85,0,1),T=gt(m,.75,.35,0,1),P=Math.pow(Math.max(w,T),.25),S=ft(b.lng,v.lng),M=ft(b.lat,v.lat);e.setCenter(new Ep(b.lng+S*P,b.lat+M*P).wrap()),e.setZoom(x+bm(y,e.center.lat))}handleMapControlsPan(t,e,i){if(!t.panDelta)return;const r=e.center.lat,n=e.zoom;e.setCenter(wm(t.panDelta,e).wrap()),e.setZoom(n+bm(r,e.center.lat))}cameraForBoxAndBearing(t,e,i,r,n){const s=Qf(t,e,i,r,n),o=e.left/n.width*2-1,a=(n.width-e.right)/n.width*2-1,l=e.top/n.height*-2+1,c=(n.height-e.bottom)/n.height*-2+1,h=ft(i.getWest(),i.getEast())<0,u=h?i.getEast():i.getWest(),p=h?i.getWest():i.getEast(),d=Math.max(i.getNorth(),i.getSouth()),f=Math.min(i.getNorth(),i.getSouth()),m=u+.5*ft(u,p),_=d+.5*ft(d,f),g=n.clone();g.setCenter(s.center),g.setBearing(s.bearing),g.setPitch(0),g.setRoll(0),g.setZoom(s.zoom);const y=g.modelViewProjectionMatrix,x=[gm(i.getNorthWest()),gm(i.getNorthEast()),gm(i.getSouthWest()),gm(i.getSouthEast()),gm(new Ep(p,_)),gm(new Ep(u,_)),gm(new Ep(m,d)),gm(new Ep(m,f))],v=gm(s.center);let b=Number.POSITIVE_INFINITY;for(const t of x)o<0&&(b=Rm.getLesserNonNegativeNonNull(b,Rm.solveVectorScale(t,v,y,"x",o))),a>0&&(b=Rm.getLesserNonNegativeNonNull(b,Rm.solveVectorScale(t,v,y,"x",a))),l>0&&(b=Rm.getLesserNonNegativeNonNull(b,Rm.solveVectorScale(t,v,y,"y",l))),c<0&&(b=Rm.getLesserNonNegativeNonNull(b,Rm.solveVectorScale(t,v,y,"y",c)));if(Number.isFinite(b)&&0!==b)return s.zoom=g.zoom+Et(b),s;Kf()}handleJumpToCenterZoom(t,e){const i=t.center.lat,r=t.getConstrained(e.center?Ep.convert(e.center):t.center,t.zoom).center;t.setCenter(r.wrap());const n=void 0!==e.zoom?+e.zoom:t.zoom+bm(i,r.lat);t.zoom!==n&&t.setZoom(n)}handleEaseTo(t,e){const i=t.zoom,r=t.center,n=t.padding,s={roll:t.roll,pitch:t.pitch,bearing:t.bearing},o={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},a=void 0!==e.zoom,l=!t.isPaddingEqual(e.padding);let h=!1;const u=e.center?Ep.convert(e.center):r,p=t.getConstrained(u,i).center;Gf(t,p);const d=t.clone();d.setCenter(p),d.setZoom(a?+e.zoom:i+bm(r.lat,u.lat)),d.setBearing(e.bearing);const f=new c(Tt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),Tt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));d.setLocationAtPoint(p,f);const m=(e.offset&&e.offsetAsPoint.mag())>0?d.center:p,_=a?+e.zoom:i+bm(r.lat,m.lat),g=i+bm(r.lat,0),y=_+bm(m.lat,0),x=ft(r.lng,m.lng),v=ft(r.lat,m.lat),b=At(y-g);return h=_!==i,{easeFunc:i=>{if($t(s,o)||Jf({startEulerAngles:s,endEulerAngles:o,tr:t,k:i,useSlerp:s.roll!=o.roll}),l&&t.interpolatePadding(n,e.padding,i),e.around)Bt("Easing around a point is not supported under globe projection."),t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=y>g?Math.min(2,b):Math.max(.5,b),n=Math.pow(e,1-i),s=Pm(r,x,v,i*n);t.setCenter(s.wrap())}if(h){const e=wr.number(g,y,i)+bm(0,t.center.lat);t.setZoom(e)}},isZooming:h,elevationCenter:m}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.center,n=t.zoom,s=t.padding,o=!t.isPaddingEqual(e.padding),a=t.getConstrained(Ep.convert(e.center||e.locationAtOffset),n).center,l=i?+e.zoom:t.zoom+bm(t.center.lat,a.lat),h=t.clone();h.setCenter(a),h.setZoom(l),h.setBearing(e.bearing);const u=new c(Tt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),Tt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));h.setLocationAtPoint(a,u);const p=h.center;Gf(t,p);const d=function(t,e,i){const r=O(gm(e),gm(i)),n=Math.acos(r),s=mm(t);return n/(2*Math.PI)*s}(t,r,p),f=n+bm(r.lat,0),m=l+bm(p.lat,0),_=At(m-f);let g;if("number"==typeof e.minZoom){const i=+e.minZoom+bm(p.lat,0),r=Math.min(i,f,m)+bm(0,p.lat);g=At(t.getConstrained(p,r).zoom+bm(p.lat,0)-f)}const y=ft(r.lng,p.lng),x=ft(r.lat,p.lat);return{easeFunc:(i,n,a,c)=>{const h=Pm(r,y,x,a);o&&t.interpolatePadding(s,e.padding,i);const u=1===i?p:h;t.setCenter(u.wrap());const d=f+Et(n);t.setZoom(1===i?l:d+bm(0,u.lat))},scaleOfZoom:_,targetCenter:p,scaleOfMinZoom:g,pixelPathLength:d}}static solveVectorScale(t,e,i,r,n){const s="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],o=[i[3],i[7],i[11],i[15]],a=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],l=t[0]*o[0]+t[1]*o[1]+t[2]*o[2],c=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],h=e[0]*o[0]+e[1]*o[1]+e[2]*o[2];return c+n*l===a+n*h||o[3]*(a-c)+s[3]*(h-l)+a*h==c*l?null:(c+s[3]-n*h-n*o[3])/(c-a-n*h+n*l)}static getLesserNonNegativeNonNull(t,e){return null!==e&&e>=0&&e<t?e:t}}class Dm{constructor(t){this._globe=t,this._mercatorCameraHelper=new tm,this._verticalPerspectiveCameraHelper=new Rm}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(t,e){return this.currentHelper.handlePanInertia(t,e)}handleMapControlsRollPitchBearingZoom(t,e){return this.currentHelper.handleMapControlsRollPitchBearingZoom(t,e)}handleMapControlsPan(t,e,i){this.currentHelper.handleMapControlsPan(t,e,i)}cameraForBoxAndBearing(t,e,i,r,n){return this.currentHelper.cameraForBoxAndBearing(t,e,i,r,n)}handleJumpToCenterZoom(t,e){this.currentHelper.handleJumpToCenterZoom(t,e)}handleEaseTo(t,e){return this.currentHelper.handleEaseTo(t,e)}handleFlyTo(t,e){return this.currentHelper.handleFlyTo(t,e)}}const Lm=(t,e)=>co(t,e&&e.filter((t=>"source.canvas"!==t.identifier))),Bm=function(){const t={},e=Se.$version;for(const i in Se.$root){const r=Se.$root[i];if(r.required){let n=null;n="version"===i?e:"array"===r.type?[]:{},null!=n&&(t[i]=n)}}return t}();class Fm extends Pe{constructor(t,e={}){super(),this._rtlPluginLoaded=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload()}},this.map=t,this.dispatcher=new wp(bp(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.imageManager=new ip,this.imageManager.setEventedParent(this),this.glyphManager=new op(t._requestManager,e.localIdeographFontFamily),this.lineAtlas=new pp(256,512),this.crossTileSymbolIndex=new Df,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new xo,this._loaded=!1,this._availableImages=[],this._globalState={},this._resetUpdates(),this.dispatcher.broadcast("SR",le()),cd().on(od,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e)}}))}setGlobalStateProperty(t,e){var i,r,n;this._checkLoaded();const s=null===e?null!==(n=null===(r=null===(i=this.stylesheet.state)||void 0===i?void 0:i[t])||void 0===r?void 0:r.default)&&void 0!==n?n:null:e;if(Rt(s,this._globalState[t]))return this;this._globalState[t]=s;const o=this._findGlobalStateAffectedSources([t]);for(const t in this.sourceCaches)o.has(t)&&(this._reloadSource(t),this._changed=!0)}getGlobalState(){return this._globalState}setGlobalState(t){this._checkLoaded();const e=[];for(const i in t)!Rt(this._globalState[i],t[i].default)&&(e.push(i),this._globalState[i]=t[i].default);const i=this._findGlobalStateAffectedSources(e);for(const t in this.sourceCaches)i.has(t)&&(this._reloadSource(t),this._changed=!0)}_findGlobalStateAffectedSources(t){if(0===t.length)return new Set;const e=new Set;for(const i in this._layers){const r=this._layers[i],n=r.getLayoutAffectingGlobalStateRefs();for(const i of t)n.has(i)&&e.add(r.source)}return e}loadURL(t,e={},i){this.fire(new we("dataloading",{dataType:"style"})),e.validate="boolean"!=typeof e.validate||e.validate;const r=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const n=this._loadStyleRequest;he(r,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,e,i)})).catch((t=>{this._loadStyleRequest=null,t&&!n.signal.aborted&&this.fire(new Te(t))}))}loadJSON(t,e={},i){this.fire(new we("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,ie.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,e.validate=!1!==e.validate,this._load(t,e,i)})).catch((()=>{}))}loadEmpty(){this.fire(new we("dataloading",{dataType:"style"})),this._load(Bm,{validate:!1})}_load(t,e,i){var r,n,s;const o=e.transformStyle?e.transformStyle(i,t):t;if(!e.validate||!Lm(this,no(o))){this._loaded=!0,this.stylesheet=o;for(const t in o.sources)this.addSource(t,o.sources[t],{validate:!1});o.sprite?this._loadSprite(o.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(o.glyphs),this._createLayers(),this.light=new cp(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new up(this.stylesheet.sky),this.map.setTerrain(null!==(n=this.stylesheet.terrain)&&void 0!==n?n:null),this.setGlobalState(null!==(s=this.stylesheet.state)&&void 0!==s?s:null),this.fire(new we("data",{dataType:"style"})),this.fire(new we("style.load"))}}_createLayers(){const t=Ce(this.stylesheet.layers);this.dispatcher.broadcast("SL",t),this._order=t.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const e of t){const t=Ju(e);t.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=t}}_loadSprite(t,e=!1,i=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,e,i,r){return n(this,void 0,void 0,(function*(){const s=Qu(t),o=i>1?"@2x":"",a={},l={};for(const{id:t,url:i}of s){const n=e.transformRequest(tp(i,o,".json"),"SpriteJSON");a[t]=he(n,r);const s=e.transformRequest(tp(i,o,".png"),"SpriteImage");l[t]=ye.getImage(s,r)}return yield Promise.all([...Object.values(a),...Object.values(l)]),function(t,e){return n(this,void 0,void 0,(function*(){const i={};for(const r in t){i[r]={};const n=ie.getImageCanvasContext((yield e[r]).data),s=(yield t[r]).data;for(const t in s){const{width:e,height:o,x:a,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m}=s[t];i[r][t]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m,spriteData:{width:e,height:o,x:a,y:l,context:n}}}}return i}))}(a,l)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const i in t){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((e=>!(e in t))):[];for(const t of r)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const r in t[i]){const n="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(n),n in this.imageManager.images?this.imageManager.updateImage(n,t[i][r],!1):this.imageManager.addImage(n,t[i][r]),e&&(this._changedImages[n]=!0)}}})).catch((t=>{this._spriteRequest=null,r=t,this.fire(new Te(r))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),e&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"})),i&&i(r)}))}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}_validateLayer(t){const e=this.sourceCaches[t.source];if(!e)return;const i=t.sourceLayer;if(!i)return;const r=e.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new Te(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${t.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(t,e=!1){const i=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e?Dt(i):i);const r=[];for(const n of t)if(i[n]){const t=e?Dt(i[n]):i[n];r.push(t)}return r}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize())}return t}hasTransitions(){var t,e,i;if(null===(t=this.light)||void 0===t?void 0:t.hasTransition())return!0;if(null===(e=this.sky)||void 0===e?void 0:e.hasTransition())return!0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return!0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return!0;for(const t in this._layers)if(this._layers[t].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const e=this._changed;if(e){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else{if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates()}const i={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];i[t]=e.used,e.used=!1}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0)}for(const t in i){const e=this.sourceCaches[t];!!i[t]!=!!e.used&&e.fire(new we("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}))}this.light.recalculate(t),this.sky.recalculate(t),this.projection.recalculate(t),this.z=t.zoom,e&&this.fire(new we("data",{dataType:"style"}))}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(t,e={}){var i;this._checkLoaded();const r=this.serialize();if(t=e.transformStyle?e.transformStyle(r,t):t,(null===(i=e.validate)||void 0===i||i)&&Lm(this,no(t)))return!1;(t=Dt(t)).layers=Ce(t.layers);const n=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let i=[];try{if(!Ae(t.version,e.version))return[{command:"setStyle",args:[e]}];Ae(t.center,e.center)||i.push({command:"setCenter",args:[e.center]}),Ae(t.state,e.state)||i.push({command:"setGlobalState",args:[e.state]}),Ae(t.centerAltitude,e.centerAltitude)||i.push({command:"setCenterAltitude",args:[e.centerAltitude]}),Ae(t.zoom,e.zoom)||i.push({command:"setZoom",args:[e.zoom]}),Ae(t.bearing,e.bearing)||i.push({command:"setBearing",args:[e.bearing]}),Ae(t.pitch,e.pitch)||i.push({command:"setPitch",args:[e.pitch]}),Ae(t.roll,e.roll)||i.push({command:"setRoll",args:[e.roll]}),Ae(t.sprite,e.sprite)||i.push({command:"setSprite",args:[e.sprite]}),Ae(t.glyphs,e.glyphs)||i.push({command:"setGlyphs",args:[e.glyphs]}),Ae(t.transition,e.transition)||i.push({command:"setTransition",args:[e.transition]}),Ae(t.light,e.light)||i.push({command:"setLight",args:[e.light]}),Ae(t.terrain,e.terrain)||i.push({command:"setTerrain",args:[e.terrain]}),Ae(t.sky,e.sky)||i.push({command:"setSky",args:[e.sky]}),Ae(t.projection,e.projection)||i.push({command:"setProjection",args:[e.projection]});const r={},n=[];!function(t,e,i,r){let n;for(n in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,n)&&(Object.prototype.hasOwnProperty.call(e,n)||ke(n,i,r));for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&(Object.prototype.hasOwnProperty.call(t,n)?Ae(t[n],e[n])||("geojson"===t[n].type&&"geojson"===e[n].type&&De(t,e,n)?Ee(i,{command:"setGeoJSONSourceData",args:[n,e[n].data]}):Re(n,e,i,r)):ze(n,e,i))}(t.sources,e.sources,n,r);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&r[t.source]?i.push({command:"removeLayer",args:[t.id]}):s.push(t)})),i=i.concat(n),function(t,e,i){e=e||[];const r=(t=t||[]).map(Be),n=e.map(Be),s=t.reduce(Fe,{}),o=e.reduce(Fe,{}),a=r.slice(),l=Object.create(null);let c,h,u,p,d;for(let t=0,e=0;t<r.length;t++)c=r[t],Object.prototype.hasOwnProperty.call(o,c)?e++:(Ee(i,{command:"removeLayer",args:[c]}),a.splice(a.indexOf(c,e),1));for(let t=0,e=0;t<n.length;t++)c=n[n.length-1-t],a[a.length-1-t]!==c&&(Object.prototype.hasOwnProperty.call(s,c)?(Ee(i,{command:"removeLayer",args:[c]}),a.splice(a.lastIndexOf(c,a.length-e),1)):e++,p=a[a.length-t],Ee(i,{command:"addLayer",args:[o[c],p]}),a.splice(a.length-t,0,c),l[c]=!0);for(let t=0;t<n.length;t++)if(c=n[t],h=s[c],u=o[c],!l[c]&&!Ae(h,u))if(Ae(h.source,u.source)&&Ae(h["source-layer"],u["source-layer"])&&Ae(h.type,u.type)){for(d in Le(h.layout,u.layout,i,c,null,"setLayoutProperty"),Le(h.paint,u.paint,i,c,null,"setPaintProperty"),Ae(h.filter,u.filter)||Ee(i,{command:"setFilter",args:[c,u.filter]}),Ae(h.minzoom,u.minzoom)&&Ae(h.maxzoom,u.maxzoom)||Ee(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?Le(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):Ae(h[d],u[d])||Ee(i,{command:"setLayerProperty",args:[c,d,u[d]]}));for(d in u)Object.prototype.hasOwnProperty.call(u,d)&&!Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?Le(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):Ae(h[d],u[d])||Ee(i,{command:"setLayerProperty",args:[c,d,u[d]]}))}else Ee(i,{command:"removeLayer",args:[c]}),p=a[a.lastIndexOf(c)+1],Ee(i,{command:"addLayer",args:[u,p]})}(s,e.layers,i)}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:"setStyle",args:[e]}]}return i}(r,t),s=this._getOperationsToPerform(n);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return!1;for(const t of s.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const r of t)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":case"setRoll":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,r.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,r.args)));break;case"setProjection":this.setProjection.apply(this,r.args);break;case"setGlobalState":e.push((()=>this.setGlobalState.apply(this,r.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(r.command)}return{operations:e,unimplemented:i}}addImage(t,e){if(this.getImage(t))return this.fire(new Te(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,e),this._afterImageUpdated(t)}updateImage(t,e){this.imageManager.updateImage(t,e)}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new Te(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t)}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,e,i={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!e.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(e).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(e.type)>=0&&this._validate(no.source,`sources.${t}`,e,null,i))return;this.map&&this.map._collectResourceTiming&&(e.collectResourceTiming=!0);const r=this.sourceCaches[t]=new Md(t,e,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:t}))),r.onAdd(this.map),this._changed=!0}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const e in this._layers)if(this._layers[e].source===t)return this.fire(new Te(new Error(`Source "${t}" cannot be removed while layer "${e}" is using it.`)));const e=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],e.fire(new we("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),e.setEventedParent(null),e.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,e,i={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new Te(new Error(`Layer "${r}" already exists on this map.`)));let n;if("custom"===t.type){if(Lm(this,function(t){const e=[],i=t.id;return void 0===i&&e.push({message:`layers.${i}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${i}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),e}(t)))return;n=Ju(t)}else{if("source"in t&&"object"==typeof t.source&&(this.addSource(r,t.source),t=St(t=Dt(t),{source:r})),this._validate(no.layer,`layers.${r}`,t,{arrayIndex:-1},i))return;n=Ju(t),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}})}const s=e?this._order.indexOf(e):this._order.length;if(e&&-1===s)this.fire(new Te(new Error(`Cannot add layer "${r}" before non-existing layer "${e}".`)));else{if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=n,this._removedLayers[r]&&n.source&&"custom"!==n.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",this.sourceCaches[n.source].pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map)}}moveLayer(t,e){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new Te(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===e)return;const i=this._order.indexOf(t);this._order.splice(i,1);const r=e?this._order.indexOf(e):this._order.length;e&&-1===r?this.fire(new Te(new Error(`Cannot move layer "${t}" before non-existing layer "${e}".`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0)}removeLayer(t){this._checkLoaded();const e=this._layers[t];if(!e)return void this.fire(new Te(new Error(`Cannot remove non-existing layer "${t}".`)));e.setEventedParent(null);const i=this._order.indexOf(t);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=e,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],e.onRemove&&e.onRemove(this.map)}getLayer(t){return this._layers[t]}getLayersOrder(){return[...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,e,i){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===e&&r.maxzoom===i||(null!=e&&(r.minzoom=e),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new Te(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)))}setFilter(t,e,i={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!Rt(r.filter,e))return null==e?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(no.filter,`layers.${r.id}.filter`,e,null,i)||(r.setFilter(Dt(e)),this._updateLayer(r)))}else this.fire(new Te(new Error(`Cannot filter non-existing layer "${t}".`)))}getFilter(t){return Dt(this.getLayer(t).filter)}setLayoutProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?Rt(n.getLayoutProperty(e),i)||(n.setLayoutProperty(e,i,r),this._updateLayer(n)):this.fire(new Te(new Error(`Cannot style non-existing layer "${t}".`)))}getLayoutProperty(t,e){const i=this.getLayer(t);if(i)return i.getLayoutProperty(e);this.fire(new Te(new Error(`Cannot get style of non-existing layer "${t}".`)))}setPaintProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?Rt(n.getPaintProperty(e),i)||(n.setPaintProperty(e,i,r)&&this._updateLayer(n),this._changed=!0,this._updatedPaintProps[t]=!0,this._serializedLayers=null):this.fire(new Te(new Error(`Cannot style non-existing layer "${t}".`)))}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,e){this._checkLoaded();const i=t.source,r=t.sourceLayer,n=this.sourceCaches[i];if(void 0===n)return void this.fire(new Te(new Error(`The source '${i}' does not exist in the map's style.`)));const s=n.getSource().type;"geojson"===s&&r?this.fire(new Te(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===t.id&&this.fire(new Te(new Error("The feature id parameter must be provided."))),n.setFeatureState(r,t.id,e)):this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(t,e){this._checkLoaded();const i=t.source,r=this.sourceCaches[i];if(void 0===r)return void this.fire(new Te(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.getSource().type,s="vector"===n?t.sourceLayer:void 0;"vector"!==n||s?e&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new Te(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,t.id,e):this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(t){this._checkLoaded();const e=t.source,i=t.sourceLayer,r=this.sourceCaches[e];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===t.id&&this.fire(new Te(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,t.id)):void this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new Te(new Error(`The source '${e}' does not exist in the map's style.`)))}getTransition(){return St({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=zt(this.sourceCaches,(t=>t.serialize())),e=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return kt({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:t,layers:e,terrain:i},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const s=this._order[n];if(e(s)){i[s]=n;for(const e of t){const t=e[s];if(t)for(const e of t)r.push(e)}}}r.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const n=[];for(let s=this._order.length-1;s>=0;s--){const o=this._order[s];if(e(o))for(let t=r.length-1;t>=0;t--){const e=r[t].feature;if(i[e.layer.id]<s)break;n.push(e),r.pop()}else for(const e of t){const t=e[o];if(t)for(const e of t)n.push(e.feature)}}return n}queryRenderedFeatures(t,e,i){e&&e.filter&&this._validate(no.filter,"queryRenderedFeatures.filter",e.filter,null,e);const r={};if(e&&e.layers){if(!(Array.isArray(e.layers)||e.layers instanceof Set))return this.fire(new Te(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const t of e.layers){const e=this._layers[t];if(!e)return this.fire(new Te(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[e.source]=!0}}const n=[];e.availableImages=this._availableImages;const s=this._serializedAllLayers(),o=e.layers instanceof Set?e.layers:Array.isArray(e.layers)?new Set(e.layers):null,a=Object.assign(Object.assign({},e),{layers:o});for(const o in this.sourceCaches)e.layers&&!r[o]||n.push(Sp(this.sourceCaches[o],this._layers,s,t,a,i,this.map.terrain?(t,e,i)=>this.map.terrain.getElevation(t,e,i):void 0));return this.placement&&n.push(function(t,e,i,r,n,s,o){const a={},l=s.queryRenderedSymbols(r),c=[];for(const t of Object.keys(l).map(Number))c.push(o[t]);c.sort(Mp);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,n.filter,n.layers,n.availableImages,t);for(const t in r){const e=a[t]=a[t]||[],n=r[t];n.sort(((t,e)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(t.featureIndex);return r.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of n)e.push(t)}}return function(t,e,i){for(const r in t)for(const n of t[r])Ip(n,i[e[r].source]);return t}(a,t,i)}(this._layers,s,this.sourceCaches,t,a,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,e){e&&e.filter&&this._validate(no.filter,"querySourceFeatures.filter",e.filter,null,e);const i=this.sourceCaches[t];return i?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),r=[],n={};for(let t=0;t<i.length;t++){const s=i[t],o=s.tileID.canonical.key;n[o]||(n[o]=!0,s.querySourceFeatures(r,e))}return r}(i,e):[]}getLight(){return this.light.getLight()}setLight(t,e={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const e in t)if(!Rt(t[e],i[e])){r=!0;break}if(!r)return;const n={now:ie.now(),transition:St({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,e),this.light.updateTransitions(n)}getProjection(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.projection}setProjection(t){if(this._checkLoaded(),this.projection){if(this.projection.name===t.type)return;this.projection.destroy(),delete this.projection}this.stylesheet.projection=t,this._setProjectionInternal(t.type)}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,e={}){this._checkLoaded();const i=this.getSky();let r=!1;if(!t&&!i)return;if(t&&!i)r=!0;else if(!t&&i)r=!0;else for(const e in t)if(!Rt(t[e],i[e])){r=!0;break}if(!r)return;const n={now:ie.now(),transition:St({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,e),this.sky.updateTransitions(n)}_setProjectionInternal(t){const e=function(t){if(Array.isArray(t)){const e=new fm({type:t});return{projection:e,transform:new km,cameraHelper:new Dm(e)}}switch(t){case"mercator":return{projection:new Uf,transform:new Yf,cameraHelper:new tm};case"globe":{const t=new fm({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return{projection:t,transform:new km,cameraHelper:new Dm(t)}}case"vertical-perspective":return{projection:new pm,transform:new zm,cameraHelper:new Rm};default:return Bt(`Unknown projection name: ${t}. Falling back to mercator projection.`),{projection:new Uf,transform:new Yf,cameraHelper:new tm}}}(t);this.projection=e.projection,this.map.migrateProjection(e.transform,e.cameraHelper);for(const t in this.sourceCaches)this.sourceCaches[t].reload()}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&Lm(this,t.call(no,St({key:e,style:this.serialize(),value:i,styleSpec:Se},r)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),cd().off(od,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t)}_clearSource(t){this.sourceCaches[t].clearTiles()}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload()}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain)}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t)}_updatePlacement(t,e,i,r,n=!1){let s=!1,o=!1;const a={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!a[i.source]){const t=this.sourceCaches[i.source];a[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,a[i.source],t.center.lng);s=s||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((n=n||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(ie.now(),t.zoom))&&(this.pauseablePlacement=new wf(t,this.map.terrain,this._order,n,e,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,a),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(ie.now()),o=!0),s&&this.pauseablePlacement.placement.setStale()),o||s)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,a[e.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(ie.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles()}getImages(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(e.icons);this._updateTilesForChangedImages();const i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,e.icons),t}))}getGlyphs(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(e.stacks),i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,e={}){this._checkLoaded(),t&&this._validate(no.glyphs,"glyphs",t,null,e)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t))}addSprite(t,e,i={},r){this._checkLoaded();const n=[{id:t,url:e}],s=[...Qu(this.stylesheet.sprite),...n];this._validate(no.sprite,"sprite",s,null,i)||(this.stylesheet.sprite=s,this._loadSprite(n,!0,r))}removeSprite(t){this._checkLoaded();const e=Qu(this.stylesheet.sprite);if(e.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;e.splice(e.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=e.length>0?e:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}else this.fire(new Te(new Error(`Sprite "${t}" doesn't exists on this map.`)))}getSprite(){return Qu(this.stylesheet.sprite)}setSprite(t,e={},i){this._checkLoaded(),t&&this._validate(no.sprite,"sprite",t,null,e)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,i):(this._unloadSprite(),i&&i(null)))}}var Om=Jo([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class jm{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(t,e,i,r,n,s,o,a,l){this.context=t;let c=this.boundPaintVertexBuffers.length!==r.length;for(let t=0;!c&&t<r.length;t++)this.boundPaintVertexBuffers[t]!==r[t]&&(c=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==s||this.boundDynamicVertexBuffer!==o||this.boundDynamicVertexBuffer2!==a||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,r,n,s,o,a,l):(t.bindVertexArray.set(this.vao),o&&o.bind(),n&&n.dynamicDraw&&n.bind(),a&&a.bind(),l&&l.bind())}freshBind(t,e,i,r,n,s,o,a){const l=t.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffer=s,this.boundDynamicVertexBuffer2=o,this.boundDynamicVertexBuffer3=a,e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);s&&s.enableAttributes(h,t),o&&o.enableAttributes(h,t),a&&a.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,n);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,n);s&&(s.bind(),s.setVertexAttribPointers(h,t,n)),r&&r.bind(),o&&(o.bind(),o.setVertexAttribPointers(h,t,n)),a&&(a.bind(),a.setVertexAttribPointers(h,t,n)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const Vm=(t,e,i,r,n)=>({u_texture:0,u_ele_delta:t,u_fog_matrix:e,u_fog_color:i?i.properties.get("fog-color"):Di.white,u_fog_ground_blend:i?i.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:n?0:i?i.calculateFogBlendOpacity(r):0,u_horizon_color:i?i.properties.get("horizon-color"):Di.white,u_horizon_fog_blend:i?i.properties.get("horizon-fog-blend"):1,u_is_globe_mode:n?1:0}),Nm={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function Um(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const r=t[i].split(" ");e.push(r.pop())}return e}class Zm{constructor(t,e,i,r,n,s,o,a,l=[]){const c=t.gl;this.program=c.createProgram();const h=Um(e.staticAttributes),u=i?i.getBinderAttributes():[],p=h.concat(u),d=Bf.prelude.staticUniforms?Um(Bf.prelude.staticUniforms):[],f=o.staticUniforms?Um(o.staticUniforms):[],m=e.staticUniforms?Um(e.staticUniforms):[],_=i?i.getBinderUniforms():[],g=d.concat(f).concat(m).concat(_),y=[];for(const t of g)y.indexOf(t)<0&&y.push(t);const x=i?i.defines():[];lm(c)&&x.unshift("#version 300 es"),n&&x.push("#define OVERDRAW_INSPECTOR;"),s&&x.push("#define TERRAIN3D;"),a&&x.push(a),l&&x.push(...l);let v=x.concat(Bf.prelude.fragmentSource,o.fragmentSource,e.fragmentSource).join("\n"),b=x.concat(Bf.prelude.vertexSource,o.vertexSource,e.vertexSource).join("\n");lm(c)||(v=function(t){return t.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(v),b=function(t){return t.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(b));const w=c.createShader(c.FRAGMENT_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(w,v),c.compileShader(w),!c.getShaderParameter(w,c.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${c.getShaderInfoLog(w)}`);c.attachShader(this.program,w);const T=c.createShader(c.VERTEX_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(T,b),c.compileShader(T),!c.getShaderParameter(T,c.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${c.getShaderInfoLog(T)}`);c.attachShader(this.program,T),this.attributes={};const P={};this.numAttributes=p.length;for(let t=0;t<this.numAttributes;t++)p[t]&&(c.bindAttribLocation(this.program,t,p[t]),this.attributes[p[t]]=t);if(c.linkProgram(this.program),!c.getProgramParameter(this.program,c.LINK_STATUS))throw new Error(`Program failed to link: ${c.getProgramInfoLog(this.program)}`);c.deleteShader(T),c.deleteShader(w);for(let t=0;t<y.length;t++){const e=y[t];if(e&&!P[e]){const t=c.getUniformLocation(this.program,e);t&&(P[e]=t)}}this.fixedUniforms=r(t,P),this.terrainUniforms=((t,e)=>({u_depth:new yl(t,e.u_depth),u_terrain:new yl(t,e.u_terrain),u_terrain_dim:new xl(t,e.u_terrain_dim),u_terrain_matrix:new Il(t,e.u_terrain_matrix),u_terrain_unpack:new wl(t,e.u_terrain_unpack),u_terrain_exaggeration:new xl(t,e.u_terrain_exaggeration)}))(t,P),this.projectionUniforms=((t,e)=>({u_projection_matrix:new Il(t,e.u_projection_matrix),u_projection_tile_mercator_coords:new wl(t,e.u_projection_tile_mercator_coords),u_projection_clipping_plane:new wl(t,e.u_projection_clipping_plane),u_projection_transition:new xl(t,e.u_projection_transition),u_projection_fallback_matrix:new Il(t,e.u_projection_fallback_matrix)}))(t,P),this.binderUniforms=i?i.getUniforms(t,P):[]}draw(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y){const x=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(r),t.setColorMode(n),t.setCullFace(s),a){t.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,a.depthTexture),t.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,a.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(a[t])}if(l)for(const t in l)this.projectionUniforms[Nm[t]].set(l[t]);if(o)for(const t in this.fixedUniforms)this.fixedUniforms[t].set(o[t]);m&&m.setUniforms(t,this.binderUniforms,d,{zoom:f});let v=0;switch(e){case x.LINES:v=2;break;case x.TRIANGLES:v=3;break;case x.LINE_STRIP:v=1}for(const i of p.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new jm)).bind(t,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,_,g,y),x.drawElements(e,i.primitiveLength*v,x.UNSIGNED_SHORT,i.primitiveOffset*v*2)}}}function Gm(t,e,i){const r=1/rt(i,1,e.transform.tileZoom),n=Math.pow(2,i.tileID.overscaledZ),s=i.tileSize*Math.pow(2,e.transform.tileZoom)/n,o=s*(i.tileID.canonical.x+i.tileID.wrap*n),a=s*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[o>>16,a>>16],u_pixel_coord_lower:[65535&o,65535&a]}}const $m=(t,e,i,r)=>{const n=t.style.light,s=n.properties.get("position"),o=[s.x,s.y,s.z],a=y();var l,c,h,u;"viewport"===n.properties.get("anchor")&&(l=a,c=t.transform.bearingInRadians,h=Math.sin(c),u=Math.cos(c),l[0]=u,l[1]=h,l[2]=0,l[3]=-h,l[4]=u,l[5]=0,l[6]=0,l[7]=0,l[8]=1),function(t,e,i){var r=e[0],n=e[1],s=e[2];t[0]=r*i[0]+n*i[3]+s*i[6],t[1]=r*i[1]+n*i[4]+s*i[7],t[2]=r*i[2]+n*i[5]+s*i[8]}(o,o,a);const p=t.transform.transformLightDirection(o),d=n.properties.get("color");return{u_lightpos:o,u_lightpos_globe:p,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[d.r,d.g,d.b],u_vertical_gradient:+e,u_opacity:i,u_fill_translate:r}},qm=(t,e,i,r,n,s,o)=>St($m(t,e,i,r),Gm(s,t,o),{u_height_factor:-Math.pow(2,n.overscaledZ)/o.tileSize/8}),Wm=(t,e,i,r)=>St(Gm(e,t,i),{u_fill_translate:r}),Hm=t=>({u_fill_translate:t}),Xm=(t,e)=>({u_world:t,u_fill_translate:e}),Ym=(t,e,i,r,n)=>St(Wm(t,e,i,n),{u_world:r}),Km=(t,e,i,r,n)=>{const s=t.transform;let o,a,l=0;if("map"===i.paint.get("circle-pitch-alignment")){const t=rt(e,1,s.zoom);o=!0,a=[t,t],l=t/(it*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*n}else o=!1,a=s.pixelsToGLUnits;return{u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===i.paint.get("circle-pitch-scale")),u_pitch_with_map:+o,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:a,u_globe_extrude_scale:l,u_translate:r}},Jm=t=>({u_pixel_extrude_scale:[1/t.width,1/t.height]}),Qm=t=>({u_viewport_size:[t.width,t.height]}),t_=(t,e=1)=>({u_color:t,u_overlay:0,u_overlay_scale:e}),e_=(t,e,i,r)=>{const n=rt(t,1,e)/(it*Math.pow(2,t.tileID.overscaledZ))*2*Math.PI*r;return{u_extrude_scale:rt(t,1,e),u_intensity:i,u_globe_extrude_scale:n}},i_=(t,e,i,r)=>{const n=x();E(n,0,t.width,t.height,0,0,1);const s=t.context.gl;return{u_matrix:n,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:e.paint.get("heatmap-opacity")}},r_=(t,e,i)=>{const r=i.paint.get("hillshade-accent-color");let n;switch(i.paint.get("hillshade-method")){case"basic":n=4;break;case"combined":n=1;break;case"igor":n=2;break;case"multidirectional":n=3;break;default:n=0}const s=i.getIlluminationProperties();for(let e=0;e<s.directionRadians.length;e++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s.directionRadians[e]+=t.transform.bearingInRadians);return{u_image:0,u_latrange:s_(0,e.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:s.altitudeRadians,u_azimuths:s.directionRadians,u_accent:r,u_method:n,u_highlights:s.highlightColor,u_shadows:s.shadowColor}},n_=(t,e)=>{const i=e.stride,r=x();return E(r,0,it,-8192,0,0,1),P(r,r,[0,-8192,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:t.overscaledZ,u_unpack:e.getUnpackVector()}};function s_(t,e){const i=Math.pow(2,e.canonical.z),r=e.canonical.y;return[new jp(0,r/i).toLngLat().lat,new jp(0,(r+1)/i).toLngLat().lat]}const o_=(t,e,i=0)=>({u_image:0,u_unpack:e.getUnpackVector(),u_dimension:[e.stride,e.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:t.paint.get("color-relief-opacity")}),a_=(t,e,i,r)=>{const n=t.transform;return{u_translation:p_(t,e,i),u_ratio:r/rt(e,1,n.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},l_=(t,e,i,r,n)=>St(a_(t,e,i,r),{u_image:0,u_image_height:n}),c_=(t,e,i,r,n)=>{const s=t.transform,o=u_(e,s);return{u_translation:p_(t,e,i),u_texsize:e.imageAtlasTexture.size,u_ratio:r/rt(e,1,s.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[o,n.fromScale,n.toScale],u_fade:n.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},h_=(t,e,i,r,n,s)=>{const o=t.lineAtlas,a=u_(e,t.transform),l="round"===i.layout.get("line-cap"),c=o.getDash(n.from,l),h=o.getDash(n.to,l),u=c.width*s.fromScale,p=h.width*s.toScale;return St(a_(t,e,i,r),{u_patternscale_a:[a/u,-c.height/2],u_patternscale_b:[a/p,-h.height/2],u_sdfgamma:o.width/(256*Math.min(u,p)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:h.y,u_mix:s.t})};function u_(t,e){return 1/rt(t,1,e.tileZoom)}function p_(t,e,i){return ct(t.transform,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const d_=(t,e,i,r,n)=>{return{u_tl_parent:t,u_scale_parent:e,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(o=r.paint.get("raster-saturation"),o>0?1-1/(1.001-o):-o),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:f_(r.paint.get("raster-hue-rotate")),u_coords_top:[n[0].x,n[0].y,n[1].x,n[1].y],u_coords_bottom:[n[3].x,n[3].y,n[2].x,n[2].y]};var s,o};function f_(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return[(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const m_=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>{const d=o.transform;return{u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:d.cameraToCenterDistance,u_pitch:d.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:d.width/d.height,u_fade_change:o.options.fadeDuration?o.symbolFadeChange:1,u_label_plane_matrix:a,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:n,u_is_variable_anchor:s,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:p}},__=(t,e,i,r,n,s,o,a,l,c,h,u,p,d)=>{const f=o.transform;return St(m_(t,e,i,r,n,s,o,a,l,c,h,u,d),{u_gamma_scale:r?Math.cos(f.pitch*Math.PI/180)*f.cameraToCenterDistance:1,u_device_pixel_ratio:o.pixelRatio,u_is_halo:1})},g_=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>St(__(t,e,i,r,n,s,o,a,l,c,!0,h,0,p),{u_texsize_icon:u,u_texture_icon:1}),y_=(t,e)=>({u_opacity:t,u_color:e}),x_=(t,e,i,r,n)=>St(function(t,e,i,r){const n=i.imageManager.getPattern(t.from.toString()),s=i.imageManager.getPattern(t.to.toString()),{width:o,height:a}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:n.tl,u_pattern_br_a:n.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[o,a],u_mix:e.t,u_pattern_size_a:n.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/rt(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(i,n,e,r),{u_opacity:t}),v_=(t,e)=>{},b_={fillExtrusion:(t,e)=>({u_lightpos:new bl(t,e.u_lightpos),u_lightpos_globe:new bl(t,e.u_lightpos_globe),u_lightintensity:new xl(t,e.u_lightintensity),u_lightcolor:new bl(t,e.u_lightcolor),u_vertical_gradient:new xl(t,e.u_vertical_gradient),u_opacity:new xl(t,e.u_opacity),u_fill_translate:new vl(t,e.u_fill_translate)}),fillExtrusionPattern:(t,e)=>({u_lightpos:new bl(t,e.u_lightpos),u_lightpos_globe:new bl(t,e.u_lightpos_globe),u_lightintensity:new xl(t,e.u_lightintensity),u_lightcolor:new bl(t,e.u_lightcolor),u_vertical_gradient:new xl(t,e.u_vertical_gradient),u_height_factor:new xl(t,e.u_height_factor),u_opacity:new xl(t,e.u_opacity),u_fill_translate:new vl(t,e.u_fill_translate),u_image:new yl(t,e.u_image),u_texsize:new vl(t,e.u_texsize),u_pixel_coord_upper:new vl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new vl(t,e.u_pixel_coord_lower),u_scale:new bl(t,e.u_scale),u_fade:new xl(t,e.u_fade)}),fill:(t,e)=>({u_fill_translate:new vl(t,e.u_fill_translate)}),fillPattern:(t,e)=>({u_image:new yl(t,e.u_image),u_texsize:new vl(t,e.u_texsize),u_pixel_coord_upper:new vl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new vl(t,e.u_pixel_coord_lower),u_scale:new bl(t,e.u_scale),u_fade:new xl(t,e.u_fade),u_fill_translate:new vl(t,e.u_fill_translate)}),fillOutline:(t,e)=>({u_world:new vl(t,e.u_world),u_fill_translate:new vl(t,e.u_fill_translate)}),fillOutlinePattern:(t,e)=>({u_world:new vl(t,e.u_world),u_image:new yl(t,e.u_image),u_texsize:new vl(t,e.u_texsize),u_pixel_coord_upper:new vl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new vl(t,e.u_pixel_coord_lower),u_scale:new bl(t,e.u_scale),u_fade:new xl(t,e.u_fade),u_fill_translate:new vl(t,e.u_fill_translate)}),circle:(t,e)=>({u_camera_to_center_distance:new xl(t,e.u_camera_to_center_distance),u_scale_with_map:new yl(t,e.u_scale_with_map),u_pitch_with_map:new yl(t,e.u_pitch_with_map),u_extrude_scale:new vl(t,e.u_extrude_scale),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_globe_extrude_scale:new xl(t,e.u_globe_extrude_scale),u_translate:new vl(t,e.u_translate)}),collisionBox:(t,e)=>({u_pixel_extrude_scale:new vl(t,e.u_pixel_extrude_scale)}),collisionCircle:(t,e)=>({u_viewport_size:new vl(t,e.u_viewport_size)}),debug:(t,e)=>({u_color:new Tl(t,e.u_color),u_overlay:new yl(t,e.u_overlay),u_overlay_scale:new xl(t,e.u_overlay_scale)}),depth:v_,clippingMask:v_,heatmap:(t,e)=>({u_extrude_scale:new xl(t,e.u_extrude_scale),u_intensity:new xl(t,e.u_intensity),u_globe_extrude_scale:new xl(t,e.u_globe_extrude_scale)}),heatmapTexture:(t,e)=>({u_matrix:new Il(t,e.u_matrix),u_world:new vl(t,e.u_world),u_image:new yl(t,e.u_image),u_color_ramp:new yl(t,e.u_color_ramp),u_opacity:new xl(t,e.u_opacity)}),hillshade:(t,e)=>({u_image:new yl(t,e.u_image),u_latrange:new vl(t,e.u_latrange),u_exaggeration:new xl(t,e.u_exaggeration),u_altitudes:new Sl(t,e.u_altitudes),u_azimuths:new Sl(t,e.u_azimuths),u_accent:new Tl(t,e.u_accent),u_method:new yl(t,e.u_method),u_shadows:new Pl(t,e.u_shadows),u_highlights:new Pl(t,e.u_highlights)}),hillshadePrepare:(t,e)=>({u_matrix:new Il(t,e.u_matrix),u_image:new yl(t,e.u_image),u_dimension:new vl(t,e.u_dimension),u_zoom:new xl(t,e.u_zoom),u_unpack:new wl(t,e.u_unpack)}),colorRelief:(t,e)=>({u_image:new yl(t,e.u_image),u_unpack:new wl(t,e.u_unpack),u_dimension:new vl(t,e.u_dimension),u_elevation_stops:new yl(t,e.u_elevation_stops),u_color_stops:new yl(t,e.u_color_stops),u_color_ramp_size:new yl(t,e.u_color_ramp_size),u_opacity:new xl(t,e.u_opacity)}),line:(t,e)=>({u_translation:new vl(t,e.u_translation),u_ratio:new xl(t,e.u_ratio),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_units_to_pixels:new vl(t,e.u_units_to_pixels)}),lineGradient:(t,e)=>({u_translation:new vl(t,e.u_translation),u_ratio:new xl(t,e.u_ratio),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_units_to_pixels:new vl(t,e.u_units_to_pixels),u_image:new yl(t,e.u_image),u_image_height:new xl(t,e.u_image_height)}),linePattern:(t,e)=>({u_translation:new vl(t,e.u_translation),u_texsize:new vl(t,e.u_texsize),u_ratio:new xl(t,e.u_ratio),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_image:new yl(t,e.u_image),u_units_to_pixels:new vl(t,e.u_units_to_pixels),u_scale:new bl(t,e.u_scale),u_fade:new xl(t,e.u_fade)}),lineSDF:(t,e)=>({u_translation:new vl(t,e.u_translation),u_ratio:new xl(t,e.u_ratio),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_units_to_pixels:new vl(t,e.u_units_to_pixels),u_patternscale_a:new vl(t,e.u_patternscale_a),u_patternscale_b:new vl(t,e.u_patternscale_b),u_sdfgamma:new xl(t,e.u_sdfgamma),u_image:new yl(t,e.u_image),u_tex_y_a:new xl(t,e.u_tex_y_a),u_tex_y_b:new xl(t,e.u_tex_y_b),u_mix:new xl(t,e.u_mix)}),raster:(t,e)=>({u_tl_parent:new vl(t,e.u_tl_parent),u_scale_parent:new xl(t,e.u_scale_parent),u_buffer_scale:new xl(t,e.u_buffer_scale),u_fade_t:new xl(t,e.u_fade_t),u_opacity:new xl(t,e.u_opacity),u_image0:new yl(t,e.u_image0),u_image1:new yl(t,e.u_image1),u_brightness_low:new xl(t,e.u_brightness_low),u_brightness_high:new xl(t,e.u_brightness_high),u_saturation_factor:new xl(t,e.u_saturation_factor),u_contrast_factor:new xl(t,e.u_contrast_factor),u_spin_weights:new bl(t,e.u_spin_weights),u_coords_top:new wl(t,e.u_coords_top),u_coords_bottom:new wl(t,e.u_coords_bottom)}),symbolIcon:(t,e)=>({u_is_size_zoom_constant:new yl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new yl(t,e.u_is_size_feature_constant),u_size_t:new xl(t,e.u_size_t),u_size:new xl(t,e.u_size),u_camera_to_center_distance:new xl(t,e.u_camera_to_center_distance),u_pitch:new xl(t,e.u_pitch),u_rotate_symbol:new yl(t,e.u_rotate_symbol),u_aspect_ratio:new xl(t,e.u_aspect_ratio),u_fade_change:new xl(t,e.u_fade_change),u_label_plane_matrix:new Il(t,e.u_label_plane_matrix),u_coord_matrix:new Il(t,e.u_coord_matrix),u_is_text:new yl(t,e.u_is_text),u_pitch_with_map:new yl(t,e.u_pitch_with_map),u_is_along_line:new yl(t,e.u_is_along_line),u_is_variable_anchor:new yl(t,e.u_is_variable_anchor),u_texsize:new vl(t,e.u_texsize),u_texture:new yl(t,e.u_texture),u_translation:new vl(t,e.u_translation),u_pitched_scale:new xl(t,e.u_pitched_scale)}),symbolSDF:(t,e)=>({u_is_size_zoom_constant:new yl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new yl(t,e.u_is_size_feature_constant),u_size_t:new xl(t,e.u_size_t),u_size:new xl(t,e.u_size),u_camera_to_center_distance:new xl(t,e.u_camera_to_center_distance),u_pitch:new xl(t,e.u_pitch),u_rotate_symbol:new yl(t,e.u_rotate_symbol),u_aspect_ratio:new xl(t,e.u_aspect_ratio),u_fade_change:new xl(t,e.u_fade_change),u_label_plane_matrix:new Il(t,e.u_label_plane_matrix),u_coord_matrix:new Il(t,e.u_coord_matrix),u_is_text:new yl(t,e.u_is_text),u_pitch_with_map:new yl(t,e.u_pitch_with_map),u_is_along_line:new yl(t,e.u_is_along_line),u_is_variable_anchor:new yl(t,e.u_is_variable_anchor),u_texsize:new vl(t,e.u_texsize),u_texture:new yl(t,e.u_texture),u_gamma_scale:new xl(t,e.u_gamma_scale),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_is_halo:new yl(t,e.u_is_halo),u_translation:new vl(t,e.u_translation),u_pitched_scale:new xl(t,e.u_pitched_scale)}),symbolTextAndIcon:(t,e)=>({u_is_size_zoom_constant:new yl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new yl(t,e.u_is_size_feature_constant),u_size_t:new xl(t,e.u_size_t),u_size:new xl(t,e.u_size),u_camera_to_center_distance:new xl(t,e.u_camera_to_center_distance),u_pitch:new xl(t,e.u_pitch),u_rotate_symbol:new yl(t,e.u_rotate_symbol),u_aspect_ratio:new xl(t,e.u_aspect_ratio),u_fade_change:new xl(t,e.u_fade_change),u_label_plane_matrix:new Il(t,e.u_label_plane_matrix),u_coord_matrix:new Il(t,e.u_coord_matrix),u_is_text:new yl(t,e.u_is_text),u_pitch_with_map:new yl(t,e.u_pitch_with_map),u_is_along_line:new yl(t,e.u_is_along_line),u_is_variable_anchor:new yl(t,e.u_is_variable_anchor),u_texsize:new vl(t,e.u_texsize),u_texsize_icon:new vl(t,e.u_texsize_icon),u_texture:new yl(t,e.u_texture),u_texture_icon:new yl(t,e.u_texture_icon),u_gamma_scale:new xl(t,e.u_gamma_scale),u_device_pixel_ratio:new xl(t,e.u_device_pixel_ratio),u_is_halo:new yl(t,e.u_is_halo),u_translation:new vl(t,e.u_translation),u_pitched_scale:new xl(t,e.u_pitched_scale)}),background:(t,e)=>({u_opacity:new xl(t,e.u_opacity),u_color:new Tl(t,e.u_color)}),backgroundPattern:(t,e)=>({u_opacity:new xl(t,e.u_opacity),u_image:new yl(t,e.u_image),u_pattern_tl_a:new vl(t,e.u_pattern_tl_a),u_pattern_br_a:new vl(t,e.u_pattern_br_a),u_pattern_tl_b:new vl(t,e.u_pattern_tl_b),u_pattern_br_b:new vl(t,e.u_pattern_br_b),u_texsize:new vl(t,e.u_texsize),u_mix:new xl(t,e.u_mix),u_pattern_size_a:new vl(t,e.u_pattern_size_a),u_pattern_size_b:new vl(t,e.u_pattern_size_b),u_scale_a:new xl(t,e.u_scale_a),u_scale_b:new xl(t,e.u_scale_b),u_pixel_coord_upper:new vl(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new vl(t,e.u_pixel_coord_lower),u_tile_units_to_pixels:new xl(t,e.u_tile_units_to_pixels)}),terrain:(t,e)=>({u_texture:new yl(t,e.u_texture),u_ele_delta:new xl(t,e.u_ele_delta),u_fog_matrix:new Il(t,e.u_fog_matrix),u_fog_color:new Tl(t,e.u_fog_color),u_fog_ground_blend:new xl(t,e.u_fog_ground_blend),u_fog_ground_blend_opacity:new xl(t,e.u_fog_ground_blend_opacity),u_horizon_color:new Tl(t,e.u_horizon_color),u_horizon_fog_blend:new xl(t,e.u_horizon_fog_blend),u_is_globe_mode:new xl(t,e.u_is_globe_mode)}),terrainDepth:(t,e)=>({u_ele_delta:new xl(t,e.u_ele_delta)}),terrainCoords:(t,e)=>({u_texture:new yl(t,e.u_texture),u_terrain_coords_id:new xl(t,e.u_terrain_coords_id),u_ele_delta:new xl(t,e.u_ele_delta)}),projectionErrorMeasurement:(t,e)=>({u_input:new xl(t,e.u_input),u_output_expected:new xl(t,e.u_output_expected)}),atmosphere:(t,e)=>({u_sun_pos:new bl(t,e.u_sun_pos),u_atmosphere_blend:new xl(t,e.u_atmosphere_blend),u_globe_position:new bl(t,e.u_globe_position),u_globe_radius:new xl(t,e.u_globe_radius),u_inv_proj_matrix:new Il(t,e.u_inv_proj_matrix)}),sky:(t,e)=>({u_sky_color:new Tl(t,e.u_sky_color),u_horizon_color:new Tl(t,e.u_horizon_color),u_horizon:new vl(t,e.u_horizon),u_horizon_normal:new vl(t,e.u_horizon_normal),u_sky_horizon_blend:new xl(t,e.u_sky_horizon_blend),u_sky_blend:new xl(t,e.u_sky_blend)})};class w_{constructor(t,e,i){this.context=t;const r=t.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const T_={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class P_{constructor(t,e,i,r){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=r,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer)}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const r=e.attributes[this.attributes[i].name];void 0!==r&&t.enableVertexAttribArray(r)}}setVertexAttribPointers(t,e,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],s=e.attributes[n.name];void 0!==s&&t.vertexAttribPointer(s,n.components,t[T_[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class S_{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class M_ extends S_{getDefault(){return Di.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class I_ extends S_{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1)}}class C_ extends S_{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1)}}class A_ extends S_{getDefault(){return[!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class E_ extends S_{getDefault(){return!0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1)}}class z_ extends S_{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1)}}class k_ extends S_{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1)}}class R_ extends S_{getDefault(){const t=this.gl;return[t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1)}}class D_ extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1}}class L_ extends S_{getDefault(){return[0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1)}}class B_ extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1}}class F_ extends S_{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1)}}class O_ extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1}}class j_ extends S_{getDefault(){const t=this.gl;return[t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1)}}class V_ extends S_{getDefault(){return Di.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class N_ extends S_{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1)}}class U_ extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1}}class Z_ extends S_{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1)}}class G_ extends S_{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1)}}class $_ extends S_{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1)}}class q_ extends S_{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1)}}class W_ extends S_{getDefault(){const t=this.gl;return[0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class H_ extends S_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1}}class X_ extends S_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class Y_ extends S_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1}}class K_ extends S_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class J_ extends S_{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class Q_ extends S_{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;lm(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1}}class tg extends S_{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1}}class eg extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1}}class ig extends S_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1}}class rg extends S_{constructor(t,e){super(t),this.context=t,this.parent=e}getDefault(){return null}}class ng extends rg{setDirty(){this.dirty=!0}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1}}class sg extends rg{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class og extends rg{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}const ag="Framebuffer is not complete";class lg{constructor(t,e,i,r,n){this.context=t,this.width=e,this.height=i;const s=t.gl,o=this.framebuffer=s.createFramebuffer();if(this.colorAttachment=new ng(t,o),r)this.depthAttachment=n?new og(t,o):new sg(t,o);else if(n)throw new Error("Stencil cannot be set without depth");if(s.checkFramebufferStatus(s.FRAMEBUFFER)!==s.FRAMEBUFFER_COMPLETE)throw new Error(ag)}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e)}t.deleteFramebuffer(this.framebuffer)}}class cg{constructor(t){var e,i;if(this.gl=t,this.clearColor=new M_(this),this.clearDepth=new I_(this),this.clearStencil=new C_(this),this.colorMask=new A_(this),this.depthMask=new E_(this),this.stencilMask=new z_(this),this.stencilFunc=new k_(this),this.stencilOp=new R_(this),this.stencilTest=new D_(this),this.depthRange=new L_(this),this.depthTest=new B_(this),this.depthFunc=new F_(this),this.blend=new O_(this),this.blendFunc=new j_(this),this.blendColor=new V_(this),this.blendEquation=new N_(this),this.cullFace=new U_(this),this.cullFaceSide=new Z_(this),this.frontFace=new G_(this),this.program=new $_(this),this.activeTexture=new q_(this),this.viewport=new W_(this),this.bindFramebuffer=new H_(this),this.bindRenderbuffer=new X_(this),this.bindTexture=new Y_(this),this.bindVertexBuffer=new K_(this),this.bindElementBuffer=new J_(this),this.bindVertexArray=new Q_(this),this.pixelStoreUnpack=new tg(this),this.pixelStoreUnpackPremultiplyAlpha=new eg(this),this.pixelStoreUnpackFlipY=new ig(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),lm(t)){this.HALF_FLOAT=t.HALF_FLOAT;const r=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,t.getExtension("EXT_color_buffer_float")}else{t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(t,e){return new w_(this,t,e)}createVertexBuffer(t,e,i){return new P_(this,t,e,i)}createRenderbuffer(t,e,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,i,r){return new lg(this,t,e,i,r)}clear({color:t,depth:e,stencil:i}){const r=this.gl;let n=0;t&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace))}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1)}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1)}setColorMode(t){Rt(t.blendFunction,em.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask)}createVertexArray(){var t;return lm(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return lm(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null)}}let hg;function ug(t,e,i,r,n){const s=t.context,o=t.transform,a=s.gl,l=t.useProgram("collisionBox"),c=[];let h=0,u=0;for(let p=0;p<r.length;p++){const d=r[p],f=e.getTile(d).getBucket(i);if(!f)continue;const m=n?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;_.length>0&&(c.push({circleArray:_,circleOffset:u,coord:d}),h+=_.length/4,u=h),m&&l.draw(s,a.LINES,nm.disabled,om.disabled,t.colorModeForRenderPass(),rm.disabled,Jm(t.transform),t.style.map.terrain&&t.style.map.terrain.getTerrainData(d),o.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,t.transform.zoom,null,null,m.collisionVertexBuffer)}if(!n||!c.length)return;const p=t.useProgram("collisionCircle"),d=new Ha;d.resize(4*h),d._trim();let f=0;for(const t of c)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,r=t.circleArray[i+0],n=t.circleArray[i+1],s=t.circleArray[i+2],o=t.circleArray[i+3];d.emplace(f++,r,n,s,o,0),d.emplace(f++,r,n,s,o,1),d.emplace(f++,r,n,s,o,2),d.emplace(f++,r,n,s,o,3)}(!hg||hg.length<2*h)&&(hg=function(t){const e=2*t,i=new Ya;i.resize(e),i._trim();for(let t=0;t<e;t++){const e=6*t;i.uint16[e+0]=4*t+0,i.uint16[e+1]=4*t+1,i.uint16[e+2]=4*t+2,i.uint16[e+3]=4*t+2,i.uint16[e+4]=4*t+3,i.uint16[e+5]=4*t+0}return i}(h));const m=s.createIndexBuffer(hg,!0),_=s.createVertexBuffer(d,uu.members,!0);for(const e of c){const r=Qm(t.transform);p.draw(s,a.TRIANGLES,nm.disabled,om.disabled,t.colorModeForRenderPass(),rm.disabled,r,t.style.map.terrain&&t.style.map.terrain.getTerrainData(e.coord),null,i.id,_,m,il.simpleSegment(0,2*e.circleOffset,e.circleArray.length,e.circleArray.length/2),null,t.transform.zoom,null,null,null)}_.destroy(),m.destroy()}const pg=b(new Float32Array(16));function dg(t,e,i,r,n,s){const{horizontalAlign:o,verticalAlign:a}=Iu(t);return new c((-(o-.5)*e/n+r[0])*s,(-(a-.5)*i/n+r[1])*s)}function fg(t,e,i,r,n,s){const o=e.tileAnchorPoint.add(new c(e.translation[0],e.translation[1]));if(e.pitchWithMap){let t=r.mult(s);i||(t=t.rotate(-n));const a=o.add(t);return Ld(a.x,a.y,e.pitchedLabelPlaneMatrix,e.getElevation).point}if(i){const i=Gd(e.tileAnchorPoint.x+1,e.tileAnchorPoint.y,e).point.sub(t),n=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return t.add(r.rotate(n))}return t.add(r)}function mg(t,e,i,r,n,s,o,a,l,h,u,p){const d=t.text.placedSymbolArray,f=t.text.dynamicLayoutVertexArray,m=t.icon.dynamicLayoutVertexArray,_={};f.clear();for(let m=0;m<d.length;m++){const g=d.get(m),y=g.hidden||!g.crossTileID||t.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(y){const r=new c(g.anchorX,g.anchorY),d={getElevation:p,width:n.width,height:n.height,pitchedLabelPlaneMatrix:s,pitchWithMap:i,transform:n,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=i?qd(r.x,r.y,d):Gd(r.x,r.y,d),x=Bd(n.cameraToCenterDistance,m.signedDistanceFromCamera);let v=Au(t.textSizeData,a,g)*x/24;i&&(v*=t.tilePixelRatio/o);const{width:b,height:w,anchor:T,textOffset:P,textBoxScale:S}=y,M=dg(T,b,w,P,S,v),I=n.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),C=fg(m.point,d,e,M,-n.bearingInRadians,I),A=t.allowVerticalPlacement&&g.placedOrientation===xu.vertical?Math.PI/2:0;for(let t=0;t<g.numGlyphs;t++)Lu(f,C,A);l&&g.associatedIconIndex>=0&&(_[g.associatedIconIndex]={shiftedAnchor:C,angle:A})}else Kd(g.numGlyphs,f)}if(l){m.clear();const e=t.icon.placedSymbolArray;for(let t=0;t<e.length;t++){const i=e.get(t);if(i.hidden)Kd(i.numGlyphs,m);else{const e=_[t];if(e)for(let t=0;t<i.numGlyphs;t++)Lu(m,e.shiftedAnchor,e.angle);else Kd(i.numGlyphs,m)}}t.icon.dynamicLayoutVertexBuffer.updateData(m)}t.text.dynamicLayoutVertexBuffer.updateData(f)}function _g(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function gg(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=t.context,f=d.gl,m=t.transform,_="map"===a,g="map"===l,y="viewport"!==a&&"point"!==i.layout.get("symbol-placement"),v=_&&!g&&!y,b=!i.layout.get("symbol-sort-key").isConstant();let T=!1;const P=t.getDepthModeForSublayer(0,nm.ReadOnly),S=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),M=[],I=m.getCircleRadiusCorrection();for(const a of r){const r=e.getTile(a),l=r.getBucket(i);if(!l)continue;const h=n?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),d=n||l.sdfIcons,P=n?l.textSizeData:l.iconSizeData,C=g||0!==m.pitch,A=t.useProgram(_g(d,n,l),u),E=Eu(P,m.zoom),z=t.style.map.terrain&&t.style.map.terrain.getTerrainData(a);let k,R,D,L,B=[0,0],F=null;if(n)R=r.glyphAtlasTexture,D=f.LINEAR,k=r.glyphAtlasTexture.size,l.iconsInText&&(B=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=C||t.options.rotating||t.options.zooming||"composite"===P.kind||"camera"===P.kind?f.LINEAR:f.NEAREST);else{const e=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;R=r.imageAtlasTexture,D=d||t.options.rotating||t.options.zooming||e||C?f.LINEAR:f.NEAREST,k=r.imageAtlasTexture.size}const O=rt(r,1,t.transform.zoom),j=kd(_,t.transform,O),V=x();w(V,j);const N=Rd(g,_,t.transform,O),U=ct(m,r,s,o),Z=m.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!p,applyTerrainMatrix:!0}),G=S&&l.hasTextData(),$="none"!==i.layout.get("icon-text-fit")&&G&&l.hasIconData();if(y){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(a,e,i):null,r="map"===i.layout.get("text-rotation-alignment");Od(l,t,n,j,V,g,c,r,a.toUnwrapped(),m.width,m.height,U,e)}const q=n&&S||$,W=y||q?pg:g?j:t.transform.clipSpaceToPixelsMatrix,H=d&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=d?l.iconsInText?g_(P.kind,E,v,g,y,q,t,W,N,U,k,B,I):__(P.kind,E,v,g,y,q,t,W,N,U,n,k,0,I):m_(P.kind,E,v,g,y,q,t,W,N,U,n,k,I);const Y={program:A,buffers:h,uniformValues:X,projectionData:Z,atlasTexture:R,atlasTextureIcon:F,atlasInterpolation:D,atlasInterpolationIcon:L,isSDF:d,hasHalo:H};if(b&&l.canOverlap){T=!0;const t=h.segments.get();for(const e of t)M.push({segments:new il([e]),sortKey:e.sortKey,state:Y,terrainData:z})}else M.push({segments:h.segments,sortKey:0,state:Y,terrainData:z})}T&&M.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of M){const r=e.state;if(d.activeTexture.set(f.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,f.CLAMP_TO_EDGE),r.atlasTextureIcon&&(d.activeTexture.set(f.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,f.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,yg(r.buffers,e.segments,i,t,r.program,P,h,u,n,r.projectionData,e.terrainData)),n.u_is_halo=0}yg(r.buffers,e.segments,i,t,r.program,P,h,u,r.uniformValues,r.projectionData,e.terrainData)}}function yg(t,e,i,r,n,s,o,a,l,c,h){const u=r.context;n.draw(u,u.gl.TRIANGLES,s,o,a,rm.backCCW,l,h,c,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,r.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer)}function xg(t,e,i,r,n){const s=t.context,o=s.gl,a=om.disabled,l=new em([o.ONE,o.ONE],Di.transparent,[!0,!0,!0,!0]),c=e.getBucket(i);if(!c)return;const h=r.key;let u=i.heatmapFbos.get(h);u||(u=bg(s,e.tileSize,e.tileSize),i.heatmapFbos.set(h,u)),s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,e.tileSize,e.tileSize]),s.clear({color:Di.transparent});const p=c.programConfigurations.get(i.id),d=t.useProgram("heatmap",p,!n),f=t.transform.getProjectionData({overscaledTileID:e.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),m=t.style.map.terrain.getTerrainData(r);d.draw(s,o.TRIANGLES,nm.disabled,a,l,rm.disabled,e_(e,t.transform.zoom,i.paint.get("heatmap-intensity"),1),m,f,i.id,c.layoutVertexBuffer,c.indexBuffer,c.segments,i.paint,t.transform.zoom,p)}function vg(t,e,i,r,n){const s=t.context,o=s.gl,a=t.transform;s.setColorMode(t.colorModeForRenderPass());const l=wg(s,e),c=i.key,h=e.heatmapFbos.get(c);if(!h)return;s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,h.colorAttachment.get()),s.activeTexture.set(o.TEXTURE1),l.bind(o.LINEAR,o.CLAMP_TO_EDGE);const u=a.getProjectionData({overscaledTileID:i,applyTerrainMatrix:n,applyGlobeMatrix:!r});t.useProgram("heatmapTexture").draw(s,o.TRIANGLES,nm.disabled,om.disabled,t.colorModeForRenderPass(),rm.disabled,i_(t,e,0,1),null,u,e.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments,e.paint,a.zoom),h.destroy(),e.heatmapFbos.delete(c)}function bg(t,e,i){var r,n;const s=t.gl,o=s.createTexture();s.bindTexture(s.TEXTURE_2D,o),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR);const a=null!==(r=t.HALF_FLOAT)&&void 0!==r?r:s.UNSIGNED_BYTE,l=null!==(n=t.RGBA16F)&&void 0!==n?n:s.RGBA;s.texImage2D(s.TEXTURE_2D,0,l,e,i,0,s.RGBA,a,null);const c=t.createFramebuffer(e,i,!1,!1);return c.colorAttachment.set(o),c}function wg(t,e){return e.colorRampTexture||(e.colorRampTexture=new Mc(t,e.colorRamp,t.gl.RGBA)),e.colorRampTexture}function Tg(t,e,i,r,n){if(!i||!r||!r.imageAtlas)return;const s=r.imageAtlas.patternPositions;let o=s[i.to.toString()],a=s[i.from.toString()];if(!o&&a&&(o=a),!a&&o&&(a=o),!o||!a){const t=n.getPaintProperty(e);o=s[t],a=s[t]}o&&a&&t.setConstantPatternPositions(o,a)}function Pg(t,e,i,r,n,s,o,a){const l=t.context.gl,c="fill-pattern",h=i.paint.get(c),u=h&&h.constantOr(1),p=i.getCrossfadeParameters();let d,f,m,_,g;const y=t.transform,x=i.paint.get("fill-translate"),v=i.paint.get("fill-translate-anchor");o?(f=u&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(f=u?"fillPattern":"fill",d=l.TRIANGLES);const b=h.constantOr(null);for(const h of r){const r=e.getTile(h);if(u&&!r.patternsLoaded())continue;const w=r.getBucket(i);if(!w)continue;const T=w.programConfigurations.get(i.id),P=t.useProgram(f,T),S=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);u&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),T.updatePaintBuffers(p)),Tg(T,c,b,r,i);const M=y.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),I=ct(y,r,x,v);if(o){_=w.indexBuffer2,g=w.segments2;const e=[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===f&&u?Ym(t,p,r,e,I):Xm(e,I)}else _=w.indexBuffer,g=w.segments,m=u?Wm(t,p,r,I):Hm(I);const C=t.stencilModeForClipping(h);P.draw(t.context,d,n,C,s,rm.backCCW,m,S,M,i.id,w.layoutVertexBuffer,_,g,i.paint,t.transform.zoom,T)}}function Sg(t,e,i,r,n,s,o,a){const l=t.context,c=l.gl,h="fill-extrusion-pattern",u=i.paint.get(h),p=u.constantOr(1),d=i.getCrossfadeParameters(),f=i.paint.get("fill-extrusion-opacity"),m=u.constantOr(null),_=t.transform;for(const u of r){const r=e.getTile(u),g=r.getBucket(i);if(!g)continue;const y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(u),x=g.programConfigurations.get(i.id),v=t.useProgram(p?"fillExtrusionPattern":"fillExtrusion",x);p&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),x.updatePaintBuffers(d));const b=_.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!a,applyTerrainMatrix:!0});Tg(x,h,m,r,i);const w=ct(_,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),T=i.paint.get("fill-extrusion-vertical-gradient"),P=p?qm(t,T,f,w,u,d,r):$m(t,T,f,w);v.draw(l,l.gl.TRIANGLES,n,s,o,rm.backCCW,P,y,b,i.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,i.paint,t.transform.zoom,x,t.style.map.terrain&&g.centroidVertexBuffer)}}function Mg(t,e,i,r,n,s,o,a,l){var c;const h=t.style.projection,u=t.context,p=t.transform,d=u.gl,f=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=t.useProgram("hillshade",null,!1,f),_=!t.options.moving;for(const f of r){const r=e.getTile(f),g=r.fbo;if(!g)continue;const y=h.getMeshFromTileID(u,f.canonical,a,!0,"raster"),x=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(f);u.activeTexture.set(d.TEXTURE0),d.bindTexture(d.TEXTURE_2D,g.colorAttachment.get());const v=p.getProjectionData({overscaledTileID:f,aligned:_,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,d.TRIANGLES,s,n[f.overscaledZ],o,rm.backCCW,r_(t,r,i),x,v,i.id,y.vertexBuffer,y.indexBuffer,y.segments)}}function Ig(t,e,i,r,n,s,o,a,l){var c;const h=t.style.projection,u=t.context,p=t.transform,d=u.gl,f=t.useProgram("colorRelief"),m=!t.options.moving;let _=!0,g=0;for(const y of r){const r=e.getTile(y),x=r.dem;if(_){const t=d.getParameter(d.MAX_TEXTURE_SIZE),{elevationTexture:e,colorTexture:r}=i.getColorRampTextures(u,t,x.getUnpackVector());u.activeTexture.set(d.TEXTURE1),e.bind(d.NEAREST,d.CLAMP_TO_EDGE),u.activeTexture.set(d.TEXTURE4),r.bind(d.LINEAR,d.CLAMP_TO_EDGE),_=!1,g=e.size[0]}if(!x||!x.data)continue;const v=x.stride,b=x.getPixels();if(u.activeTexture.set(d.TEXTURE0),u.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||t.getTileTexture(v),r.demTexture){const t=r.demTexture;t.update(b,{premultiply:!1}),t.bind(d.LINEAR,d.CLAMP_TO_EDGE)}else r.demTexture=new Mc(u,b,d.RGBA,{premultiply:!1}),r.demTexture.bind(d.LINEAR,d.CLAMP_TO_EDGE);const w=h.getMeshFromTileID(u,y.canonical,a,!0,"raster"),T=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(y),P=p.getProjectionData({overscaledTileID:y,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});f.draw(u,d.TRIANGLES,s,n[y.overscaledZ],o,rm.backCCW,o_(i,r.dem,g),T,P,i.id,w.vertexBuffer,w.indexBuffer,w.segments)}}const Cg=[new c(0,0),new c(it,0),new c(it,it),new c(0,it)];function Ag(t,e,i,r,n,s,o,a,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=t.context,p=u.gl,d=t.useProgram("raster"),f=t.transform,m=t.style.projection,_=t.colorModeForRenderPass(),g=!t.options.moving;for(const y of r){const r=t.getDepthModeForSublayer(y.overscaledZ-h,1===i.paint.get("raster-opacity")?nm.ReadWrite:nm.ReadOnly,p.LESS),x=e.getTile(y);x.registerFadeDuration(i.paint.get("raster-fade-duration"));const v=e.findLoadedParent(y,0),b=e.findLoadedSibling(y),w=Eg(x,v||b||null,e,i,t.transform,t.style.map.terrain);let T,P;const S="nearest"===i.paint.get("raster-resampling")?p.NEAREST:p.LINEAR;u.activeTexture.set(p.TEXTURE0),x.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(p.TEXTURE1),v?(v.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),T=Math.pow(2,v.tileID.overscaledZ-x.tileID.overscaledZ),P=[x.tileID.canonical.x*T%1,x.tileID.canonical.y*T%1]):x.texture.bind(S,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),x.texture.useMipmap&&u.extTextureFilterAnisotropic&&t.transform.pitch>20&&p.texParameterf(p.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const M=t.style.map.terrain&&t.style.map.terrain.getTerrainData(y),I=f.getProjectionData({overscaledTileID:y,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),C=d_(P||[0,0],T||1,w,i,a),A=m.getMeshFromTileID(u,y.canonical,s,o,"raster");d.draw(u,p.TRIANGLES,r,n?n[y.overscaledZ]:om.disabled,_,l?rm.frontCCW:rm.backCCW,C,M,I,i.id,A.vertexBuffer,A.indexBuffer,A.segments)}}function Eg(t,e,i,r,n,s){const o=r.paint.get("raster-fade-duration");if(!s&&o>0){const r=ie.now(),s=(r-t.timeAdded)/o,a=e?(r-e.timeAdded)/o:-1,l=i.getSource(),c=Td(n,{tileSize:l.tileSize,roundZoom:l.roundZoom}),h=!e||Math.abs(e.tileID.overscaledZ-c)>Math.abs(t.tileID.overscaledZ-c),u=h&&t.refreshedUponExpiration?1:Tt(h?s:1-a,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),e?{opacity:1,mix:1-u}:{opacity:u,mix:0}}return{opacity:1,mix:0}}const zg=new Di(1,0,0,1),kg=new Di(0,1,0,1),Rg=new Di(0,0,1,1),Dg=new Di(1,0,1,1),Lg=new Di(0,1,1,1);function Bg(t,e,i,r){Og(t,0,e+i/2,t.transform.width,i,r)}function Fg(t,e,i,r){Og(t,e-i/2,0,i,t.transform.height,r)}function Og(t,e,i,r,n,s){const o=t.context,a=o.gl;a.enable(a.SCISSOR_TEST),a.scissor(e*t.pixelRatio,i*t.pixelRatio,r*t.pixelRatio,n*t.pixelRatio),o.clear({color:s}),a.disable(a.SCISSOR_TEST)}function jg(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("debug"),o=nm.disabled,a=om.disabled,l=t.colorModeForRenderPass(),c="$debug",h=t.style.map.terrain&&t.style.map.terrain.getTerrainData(i);r.activeTexture.set(n.TEXTURE0);const u=e.getTileByID(i.key).latestRawTileData,p=Math.floor((u&&u.byteLength||0)/1024),d=e.getTile(i).tileSize,f=512/Math.min(d,512)*(i.overscaledZ/t.transform.zoom)*.5;let m=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(m+=` => ${i.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,r=t.context.gl,n=t.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(e,5,5),n.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(t,`${m} ${p}kB`);const _=t.transform.getProjectionData({overscaledTileID:i,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,n.TRIANGLES,o,a,em.alphaBlended,rm.disabled,t_(Di.transparent,f),null,_,c,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),s.draw(r,n.LINE_STRIP,o,a,l,rm.disabled,t_(Di.red),h,_,c,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments)}function Vg(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=s.gl,a=t.transform,l=t.colorModeForRenderPass(),c=t.getDepthModeFor3D(),h=t.useProgram("terrain");s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);for(const r of i){const i=e.getTerrainMesh(r.tileID),u=t.renderToTexture.getTexture(r),p=e.getTerrainData(r.tileID);s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,u.texture);const d=e.getMeshFrameDelta(a.zoom),f=a.calculateFogMatrix(r.tileID.toUnwrapped()),m=Vm(d,f,t.style.sky,a.pitch,n),_=a.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(s,o.TRIANGLES,c,om.disabled,l,rm.backCCW,m,p,_,"terrain",i.vertexBuffer,i.indexBuffer,i.segments)}}function Ng(t,e){if(!e.mesh){const i=new La;i.emplaceBack(-1,-1),i.emplaceBack(1,-1),i.emplaceBack(1,1),i.emplaceBack(-1,1);const r=new Ka;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),e.mesh=new Of(t.createVertexBuffer(i,jf.members),t.createIndexBuffer(r),il.simpleSegment(0,0,i.length,r.length))}return e.mesh}class Ug{constructor(t,e){this.context=new cg(t),this.transform=e,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:b(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=Md.maxUnderzooming+Md.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Df}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize()}setup(){const t=this.context,e=new La;e.emplaceBack(0,0),e.emplaceBack(it,0),e.emplaceBack(0,it),e.emplaceBack(it,it),this.tileExtentBuffer=t.createVertexBuffer(e,jf.members),this.tileExtentSegments=il.simpleSegment(0,0,4,2);const i=new La;i.emplaceBack(0,0),i.emplaceBack(it,0),i.emplaceBack(0,it),i.emplaceBack(it,it),this.debugBuffer=t.createVertexBuffer(i,jf.members),this.debugSegments=il.simpleSegment(0,0,4,5);const r=new Fa;r.emplaceBack(0,0,0,0),r.emplaceBack(it,0,it,0),r.emplaceBack(0,it,0,it),r.emplaceBack(it,it,it,it),this.rasterBoundsBuffer=t.createVertexBuffer(r,Om.members),this.rasterBoundsSegments=il.simpleSegment(0,0,4,2);const n=new La;n.emplaceBack(0,0),n.emplaceBack(it,0),n.emplaceBack(0,it),n.emplaceBack(it,it),this.rasterBoundsBufferPosOnly=t.createVertexBuffer(n,jf.members),this.rasterBoundsSegmentsPosOnly=il.simpleSegment(0,0,4,5);const s=new La;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(s,jf.members),this.viewportSegments=il.simpleSegment(0,0,4,2);const o=new Qa;o.emplaceBack(0),o.emplaceBack(1),o.emplaceBack(3),o.emplaceBack(2),o.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(o);const a=new Ka;a.emplaceBack(1,0,2),a.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(a);const l=this.context.gl;this.stencilClearMode=new om({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.tileExtentMesh=new Of(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}clearStencil(){const t=this.context,e=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=x();E(i,0,this.width,this.height,0,0,1),S(i,i,[e.drawingBufferWidth,e.drawingBufferHeight,0]);const r={mainMatrix:i,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:i};this.useProgram("clippingMask",null,!0).draw(t,e.TRIANGLES,nm.disabled,this.stencilClearMode,em.disabled,rm.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(t,e,i){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source,this.nextStencilID+e.length>256&&this.clearStencil();const r=this.context;r.setColorMode(em.disabled),r.setDepthMode(nm.disabled);const n={};for(const t of e)n[t.key]=this.nextStencilID++;this._renderTileMasks(n,e,i,!0),this._renderTileMasks(n,e,i,!1),this._tileClippingMaskIDs=n}_renderTileMasks(t,e,i,r){const n=this.context,s=n.gl,o=this.style.projection,a=this.transform,l=this.useProgram("clippingMask");for(const c of e){const e=t[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=o.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),p=a.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(n,s.TRIANGLES,nm.disabled,new om({func:s.ALWAYS,mask:0},e,255,s.KEEP,s.KEEP,s.REPLACE),em.disabled,i?rm.disabled:rm.backCCW,null,h,p,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments)}}_renderTilesDepthBuffer(){const t=this.context,e=t.gl,i=this.style.projection,r=this.transform,n=this.useProgram("depth"),s=this.getDepthModeFor3D(),o=Pd(r,{tileSize:r.tileSize});for(const a of o){const o=this.style.map.terrain&&this.style.map.terrain.getTerrainData(a),l=i.getMeshFromTileID(this.context,a.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!0,applyTerrainMatrix:!0});n.draw(t,e.TRIANGLES,s,om.disabled,em.disabled,rm.backCCW,null,o,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new om({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new om({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let i=0;i<n;i++)t[i+r]=new om({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=n,[t,i]}return[{[r]:om.disabled},i]}stencilConfigForOverlapTwoPass(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(this.clearStencil(),n>1){const t={},s={};for(let i=0;i<n;i++)t[i+r]=new om({func:e.GREATER,mask:255},n+1+i,255,e.KEEP,e.KEEP,e.REPLACE),s[i+r]=new om({func:e.GREATER,mask:255},1+i,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID=2*n+1,[t,s,i]}return this.nextStencilID=3,[{[r]:new om({func:e.GREATER,mask:255},2,255,e.KEEP,e.KEEP,e.REPLACE)},{[r]:new om({func:e.GREATER,mask:255},1,255,e.KEEP,e.KEEP,e.REPLACE)},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const e=1/8;return new em([t.CONSTANT_COLOR,t.ONE],new Di(e,e,e,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?em.unblended:em.alphaBlended}getDepthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return nm.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new nm(i||this.context.gl.LEQUAL,e,[r,r])}getDepthModeFor3D(){return new nm(this.context.gl.LEQUAL,nm.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,e){var i,r;this.style=t,this.options=e,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(ie.now()),this.imageManager.beginFrame();const n=this.style._order,s=this.style.sourceCaches,o={},a={},l={},c={isRenderingToTexture:!1,isRenderingGlobe:(null===(i=t.projection)||void 0===i?void 0:i.transitionState)>0};for(const t in s){const e=s[t];e.used&&e.prepare(this.context),o[t]=e.getVisibleCoordinates(!1),a[t]=o[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let t=0;t<n.length;t++)if(this.style._layers[n[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of n){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=a[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,s[e.source],e,i,c)}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:t=>this.useProgram(t)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:e.showOverdrawInspector?Di.black:Di.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,e){const i=t.context,r=i.gl,n=((t,e,i)=>{const r=Math.cos(e.rollInRadians),n=Math.sin(e.rollInRadians),s=_d(e),o=e.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return{u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:[(e.width/2-s*n)*i,(e.height/2+s*r)*i],u_horizon_normal:[-n,r],u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i,u_sky_blend:o}})(e,t.style.map.transform,t.pixelRatio),s=new nm(r.LEQUAL,nm.ReadWrite,[0,1]),o=om.disabled,a=t.colorModeForRenderPass(),l=t.useProgram("sky"),c=Ng(i,e);l.draw(i,r.TRIANGLES,s,o,a,rm.disabled,n,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments)}(this,this.style.sky),this._showOverdrawInspector=e.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=n.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[n[this.currentLayer]],e=s[t.source],i=o[t.source];this._renderTileClippingMasks(t,i,!1),this.renderLayer(this,e,t,i,c)}this.renderPass="translucent";let h=!1;for(this.currentLayer=0;this.currentLayer<n.length;this.currentLayer++){const t=this.style._layers[n[this.currentLayer]],e=s[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t,c))continue;this.opaquePassEnabledForLayer()||h||(h=!0,c.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===t.type?l:a)[t.source];this._renderTileClippingMasks(t,o[t.source],!!this.renderToTexture),this.renderLayer(this,e,t,i,c)}if(c.isRenderingGlobe&&function(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("atmosphere"),o=new nm(n.LEQUAL,nm.ReadOnly,[0,1]),a=t.transform,l=function(t,e){const i=t.properties.get("position"),r=[-i.x,-i.y,-i.z],n=b(new Float64Array(16));var s,o,a,l,c,h,u;return"map"===t.properties.get("anchor")&&(C(n,n,e.rollInRadians),M(n,n,-e.pitchInRadians),C(n,n,e.bearingInRadians),M(n,n,e.center.lat*Math.PI/180),I(n,n,-e.center.lng*Math.PI/180)),(s=r)[0]=((a=n)[0]*(l=(o=r)[0])+a[4]*(c=o[1])+a[8]*(h=o[2])+a[12])/(u=(u=a[3]*l+a[7]*c+a[11]*h+a[15])||1),s[1]=(a[1]*l+a[5]*c+a[9]*h+a[13])/u,s[2]=(a[2]*l+a[6]*c+a[10]*h+a[14])/u,r}(i,t.transform),c=a.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),h=e.properties.get("atmosphere-blend")*c.projectionTransition;if(0===h)return;const u=ym(a.worldSize,a.center.lat),p=a.inverseProjectionMatrix,d=new Float64Array(4);d[3]=1,W(d,d,a.modelViewProjectionMatrix),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1,W(d,d,p),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1;const f=((t,e,i,r,n)=>({u_sun_pos:t,u_atmosphere_blend:e,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:n}))(l,h,[d[0],d[1],d[2]],u,p),m=Ng(r,e);s.draw(r,n.TRIANGLES,o,om.disabled,em.alphaBlended,rm.disabled,f,null,null,"atmosphere",m.vertexBuffer,m.indexBuffer,m.segments)}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const t=function(t,e){let i=null;const r=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),n=r.filter((t=>"vector"===t.getSource().type)),s=r.filter((t=>"vector"!==t.getSource().type)),o=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t)};return n.forEach((t=>o(t))),i||s.forEach((t=>o(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let r=0;r<i.length;r++)jg(t,e,i[r])}(this,t,t.getVisibleCoordinates())}this.options.showPadding&&function(t){const e=t.transform.padding;Bg(t,t.transform.height-(e.top||0),3,zg),Bg(t,e.bottom||0,3,kg),Fg(t,e.left||0,3,Rg),Fg(t,t.transform.width-(e.right||0),3,Dg);const i=t.transform.centerPoint;!function(t,e,i,r){Og(t,e-1,i-10,2,20,r),Og(t,e-10,i-1,20,2,r)}(t,i.x,t.transform.height-i.y,Lg)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const e=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var n,s;r||(r=t?!((n=e)[0]===(s=i)[0]&&n[1]===s[1]&&n[2]===s[2]&&n[3]===s[3]&&n[4]===s[4]&&n[5]===s[5]&&n[6]===s[6]&&n[7]===s[7]&&n[8]===s[8]&&n[9]===s[9]&&n[10]===s[10]&&n[11]===s[11]&&n[12]===s[12]&&n[13]===s[13]&&n[14]===s[14]&&n[15]===s[15]):!function(t,e){var i=t[0],r=t[1],n=t[2],s=t[3],o=t[4],a=t[5],l=t[6],c=t[7],h=t[8],u=t[9],p=t[10],d=t[11],f=t[12],_=t[13],g=t[14],y=t[15],x=e[0],v=e[1],b=e[2],w=e[3],T=e[4],P=e[5],S=e[6],M=e[7],I=e[8],C=e[9],A=e[10],E=e[11],z=e[12],k=e[13],R=e[14],D=e[15];return Math.abs(i-x)<=m*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(r-v)<=m*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=m*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(s-w)<=m*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(o-T)<=m*Math.max(1,Math.abs(o),Math.abs(T))&&Math.abs(a-P)<=m*Math.max(1,Math.abs(a),Math.abs(P))&&Math.abs(l-S)<=m*Math.max(1,Math.abs(l),Math.abs(S))&&Math.abs(c-M)<=m*Math.max(1,Math.abs(c),Math.abs(M))&&Math.abs(h-I)<=m*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(u-C)<=m*Math.max(1,Math.abs(u),Math.abs(C))&&Math.abs(p-A)<=m*Math.max(1,Math.abs(p),Math.abs(A))&&Math.abs(d-E)<=m*Math.max(1,Math.abs(d),Math.abs(E))&&Math.abs(f-z)<=m*Math.max(1,Math.abs(f),Math.abs(z))&&Math.abs(_-k)<=m*Math.max(1,Math.abs(_),Math.abs(k))&&Math.abs(g-R)<=m*Math.max(1,Math.abs(g),Math.abs(R))&&Math.abs(y-D)<=m*Math.max(1,Math.abs(y),Math.abs(D))}(e,i)),r||(r=this.style.map.terrain.sourceCache.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]}(e,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,e){const i=t.context,r=i.gl,n=t.transform,s=em.unblended,o=new nm(r.LEQUAL,nm.ReadWrite,[0,1]),a=e.sourceCache.getRenderableTiles(),l=t.useProgram("terrainDepth");i.bindFramebuffer.set(e.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:Di.transparent,depth:1});for(const t of a){const a=e.getTerrainMesh(t.tileID),c=e.getTerrainData(t.tileID),h=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:e.getMeshFrameDelta(n.zoom)};l.draw(i,r.TRIANGLES,o,om.disabled,s,rm.backCCW,u,c,h,"terrain",a.vertexBuffer,a.indexBuffer,a.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain),function(t,e){const i=t.context,r=i.gl,n=t.transform,s=em.unblended,o=new nm(r.LEQUAL,nm.ReadWrite,[0,1]),a=e.getCoordsTexture(),l=e.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");i.bindFramebuffer.set(e.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:Di.transparent,depth:1}),e.coordsIndex=[];for(const t of l){const l=e.getTerrainMesh(t.tileID),h=e.getTerrainData(t.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,a.texture);const u={u_terrain_coords_id:(255-e.coordsIndex.length)/255,u_texture:0,u_ele_delta:e.getMeshFrameDelta(n.zoom)},p=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});c.draw(i,r.TRIANGLES,o,om.disabled,s,rm.backCCW,u,h,p,"terrain",l.vertexBuffer,l.indexBuffer,l.segments),e.coordsIndex.push(t.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain))}renderLayer(t,e,i,r,n){i.isHidden(this.transform.zoom)||("background"===i.type||"custom"===i.type||(r||[]).length)&&(this.id=i.id,(t=>"symbol"===t.type)(i)?function(t,e,i,r,n,s){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:o}=s,a=om.disabled,l=t.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,e,i,r,n,s,o,a,l){const c=e.transform,h=e.style.map.terrain,u="map"===n,p="map"===s;for(const n of t){const t=r.getTile(n),s=t.getBucket(i);if(!s||!s.text||!s.text.segments.get().length)continue;const d=Eu(s.textSizeData,c.zoom),f=rt(t,1,e.transform.zoom),m=kd(u,e.transform,f),_="none"!==i.layout.get("icon-text-fit")&&s.hasIconData();if(d){const e=Math.pow(2,c.zoom-t.tileID.overscaledZ),i=h?(t,e)=>h.getElevation(n,t,e):null;mg(s,u,p,l,c,m,e,d,_,ct(c,t,o,a),n.toUnwrapped(),i)}}}(r,t,i,e,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&gg(t,e,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),a,l,o),0!==i.paint.get("text-opacity").constantOr(1)&&gg(t,e,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),a,l,o),e.map.showCollisionBoxes&&(ug(t,e,i,r,!0),ug(t,e,i,r,!1))}(t,e,i,r,this.style.placement.variableOffsets,n):(t=>"circle"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("circle-opacity"),a=i.paint.get("circle-stroke-width"),l=i.paint.get("circle-stroke-opacity"),c=!i.layout.get("circle-sort-key").isConstant();if(0===o.constantOr(1)&&(0===a.constantOr(1)||0===l.constantOr(1)))return;const h=t.context,u=h.gl,p=t.transform,d=t.getDepthModeForSublayer(0,nm.ReadOnly),f=om.disabled,m=t.colorModeForRenderPass(),_=[],g=p.getCircleRadiusCorrection();for(let n=0;n<r.length;n++){const o=r[n],a=e.getTile(o),l=a.getBucket(i);if(!l)continue;const h=ct(p,a,i.paint.get("circle-translate"),i.paint.get("circle-translate-anchor")),u=l.programConfigurations.get(i.id),d=t.useProgram("circle",u),f=l.layoutVertexBuffer,m=l.indexBuffer,y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o),x={programConfiguration:u,program:d,layoutVertexBuffer:f,indexBuffer:m,uniformValues:Km(t,a,i,h,g),terrainData:y,projectionData:p.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(c){const t=l.segments.get();for(const e of t)_.push({segments:new il([e]),sortKey:e.sortKey,state:x})}else _.push({segments:l.segments,sortKey:0,state:x})}c&&_.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of _){const{programConfiguration:r,program:n,layoutVertexBuffer:s,indexBuffer:o,uniformValues:a,terrainData:l,projectionData:c}=e.state;n.draw(h,u.TRIANGLES,d,f,m,rm.backCCW,a,l,c,i.id,s,o,e.segments,i.paint,t.transform.zoom,r)}}(t,e,i,r,n):(t=>"heatmap"===t.type)(i)?function(t,e,i,r,n){if(0===i.paint.get("heatmap-opacity"))return;const s=t.context,{isRenderingToTexture:o,isRenderingGlobe:a}=n;if(t.style.map.terrain){for(const n of r){const r=e.getTile(n);e.hasRenderableParent(n)||("offscreen"===t.renderPass?xg(t,r,i,n,a):"translucent"===t.renderPass&&vg(t,i,n,o,a))}s.viewport.set([0,0,t.width,t.height])}else"offscreen"===t.renderPass?function(t,e,i,r){const n=t.context,s=n.gl,o=t.transform,a=om.disabled,l=new em([s.ONE,s.ONE],Di.transparent,[!0,!0,!0,!0]);(function(t,e,i){const r=t.gl;t.activeTexture.set(r.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let n=i.heatmapFbos.get(xc);n?(r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),t.bindFramebuffer.set(n.framebuffer)):(n=bg(t,e.width/4,e.height/4),i.heatmapFbos.set(xc,n))})(n,t,i),n.clear({color:Di.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(e.hasRenderableParent(h))continue;const u=e.getTile(h),p=u.getBucket(i);if(!p)continue;const d=p.programConfigurations.get(i.id),f=t.useProgram("heatmap",d),m=o.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),_=o.getCircleRadiusCorrection();f.draw(n,s.TRIANGLES,nm.disabled,a,l,rm.backCCW,e_(u,o.zoom,i.paint.get("heatmap-intensity"),_),null,m,i.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,i.paint,o.zoom,d)}n.viewport.set([0,0,t.width,t.height])}(t,e,i,r):"translucent"===t.renderPass&&function(t,e){const i=t.context,r=i.gl;i.setColorMode(t.colorModeForRenderPass());const n=e.heatmapFbos.get(xc);n&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),wg(i,e).bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(i,r.TRIANGLES,nm.disabled,om.disabled,t.colorModeForRenderPass(),rm.disabled,i_(t,e,0,1),null,null,e.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,e.paint,t.transform.zoom))}(t,i)}(t,e,i,r,n):(t=>"line"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("line-opacity"),a=i.paint.get("line-width");if(0===o.constantOr(1)||0===a.constantOr(1))return;const l=t.getDepthModeForSublayer(0,nm.ReadOnly),c=t.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=i.paint.get("line-pattern"),p=u.constantOr(1),d=i.paint.get("line-gradient"),f=i.getCrossfadeParameters(),m=p?"linePattern":h?"lineSDF":d?"lineGradient":"line",_=t.context,g=_.gl,y=t.transform;let x=!0;for(const n of r){const r=e.getTile(n);if(p&&!r.patternsLoaded())continue;const o=r.getBucket(i);if(!o)continue;const a=o.programConfigurations.get(i.id),b=t.context.program.get(),w=t.useProgram(m,a),T=x||w.program!==b,P=t.style.map.terrain&&t.style.map.terrain.getTerrainData(n),S=u.constantOr(null);if(S&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[S.to.toString()],i=t.patternPositions[S.from.toString()];e&&i&&a.setConstantPatternPositions(e,i)}const M=y.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0}),I=y.getPixelScale(),C=p?c_(t,r,i,I,f):h?h_(t,r,i,I,h,f):d?l_(t,r,i,I,o.lineClipsArray.length):a_(t,r,i,I);if(p)_.activeTexture.set(g.TEXTURE0),r.imageAtlasTexture.bind(g.LINEAR,g.CLAMP_TO_EDGE),a.updatePaintBuffers(f);else if(h&&(T||t.lineAtlas.dirty))_.activeTexture.set(g.TEXTURE0),t.lineAtlas.bind(_);else if(d){const r=o.gradients[i.id];let s=r.texture;if(i.gradientVersion!==r.version){let a=256;if(i.stepInterpolant){const i=e.getSource().maxzoom,r=n.canonical.z===i?Math.ceil(1<<t.transform.maxZoom-n.canonical.z):1;a=Tt((v=o.maxLineLength/it*1024*r)<=1?1:Math.pow(2,Math.ceil(Math.log(v)/Math.LN2)),256,_.maxTextureSize)}r.gradient=yc({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:a,image:r.gradient||void 0,clips:o.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Mc(_,r.gradient,g.RGBA),r.version=i.gradientVersion,s=r.texture}_.activeTexture.set(g.TEXTURE0),s.bind(i.stepInterpolant?g.NEAREST:g.LINEAR,g.CLAMP_TO_EDGE)}const A=t.stencilModeForClipping(n);w.draw(_,g.TRIANGLES,l,A,c,rm.disabled,C,P,M,i.id,o.layoutVertexBuffer,o.indexBuffer,o.segments,i.paint,t.transform.zoom,a,o.layoutVertexBuffer2),x=!1}var v}(t,e,i,r,n):(t=>"fill"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-color"),o=i.paint.get("fill-opacity");if(0===o.constantOr(1))return;const{isRenderingToTexture:a}=n,l=t.colorModeForRenderPass(),c=i.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!c.constantOr(1)&&1===s.constantOr(Di.transparent).a&&1===o.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const n=t.getDepthModeForSublayer(1,"opaque"===t.renderPass?nm.ReadWrite:nm.ReadOnly);Pg(t,e,i,r,n,l,!1,a)}if("translucent"===t.renderPass&&i.paint.get("fill-antialias")){const n=t.getDepthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,nm.ReadOnly);Pg(t,e,i,r,n,l,!0,a)}}(t,e,i,r,n):(t=>"fill-extrusion"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-extrusion-opacity");if(0===s)return;const{isRenderingToTexture:o}=n;if("translucent"===t.renderPass){const n=new nm(t.context.gl.LEQUAL,nm.ReadWrite,t.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))Sg(t,e,i,r,n,om.disabled,em.disabled,o),Sg(t,e,i,r,n,t.stencilModeFor3D(),t.colorModeForRenderPass(),o);else{const s=t.colorModeForRenderPass();Sg(t,e,i,r,n,om.disabled,s,o)}}}(t,e,i,r,n):(t=>"hillshade"===t.type)(i)?function(t,e,i,r,n){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=t.context,a=t.style.projection.useSubdivision,l=t.getDepthModeForSublayer(0,nm.ReadOnly),c=t.colorModeForRenderPass();if("offscreen"===t.renderPass)!function(t,e,i,r,n,s,o){const a=t.context,l=a.gl;for(const c of i){const i=e.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,p=h.stride,d=h.getPixels();if(a.activeTexture.set(l.TEXTURE1),a.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(p),i.demTexture){const t=i.demTexture;t.update(d,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE)}else i.demTexture=new Mc(a,d,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);a.activeTexture.set(l.TEXTURE0);let f=i.fbo;if(!f){const t=new Mc(a,{width:u,height:u,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),f=i.fbo=a.createFramebuffer(u,u,!0,!1),f.colorAttachment.set(t.texture)}a.bindFramebuffer.set(f.framebuffer),a.viewport.set([0,0,u,u]),t.useProgram("hillshadePrepare").draw(a,l.TRIANGLES,n,s,o,rm.disabled,n_(i.tileID,h),null,null,r.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1}}(t,e,r,i,l,om.disabled,c),o.viewport.set([0,0,t.width,t.height]);else if("translucent"===t.renderPass)if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);Mg(t,e,i,a,n,l,c,!1,s),Mg(t,e,i,a,o,l,c,!0,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Mg(t,e,i,o,n,l,c,!1,s)}}(t,e,i,r,n):(t=>"color-relief"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(!r.length)return;const{isRenderingToTexture:s}=n,o=t.style.projection.useSubdivision,a=t.getDepthModeForSublayer(0,nm.ReadOnly),l=t.colorModeForRenderPass();if(o){const[n,o,c]=t.stencilConfigForOverlapTwoPass(r);Ig(t,e,i,c,n,a,l,!1,s),Ig(t,e,i,c,o,a,l,!0,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Ig(t,e,i,o,n,a,l,!1,s)}}(t,e,i,r,n):(t=>"raster"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:s}=n,o=e.getSource(),a=t.style.projection.useSubdivision;if(o instanceof Kp)Ag(t,e,i,r,null,!1,!1,o.tileCoords,o.flippedWindingOrder,s);else if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);Ag(t,e,i,a,n,!1,!0,Cg,!1,s),Ag(t,e,i,a,o,!0,!0,Cg,!1,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Ag(t,e,i,o,n,!1,!0,Cg,!1,s)}}(t,e,i,r,n):(t=>"background"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const{isRenderingToTexture:a}=n,l=t.context,c=l.gl,h=t.style.projection,u=t.transform,p=u.tileSize,d=i.paint.get("background-pattern");if(t.isPatternMissing(d))return;const f=!d&&1===s.a&&1===o&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==f)return;const m=om.disabled,_=t.getDepthModeForSublayer(0,"opaque"===f?nm.ReadWrite:nm.ReadOnly),g=t.colorModeForRenderPass(),y=t.useProgram(d?"backgroundPattern":"background"),x=r||Pd(u,{tileSize:p,terrain:t.style.map.terrain});d&&(l.activeTexture.set(c.TEXTURE0),t.imageManager.bind(t.context));const v=i.getCrossfadeParameters();for(const e of x){const r=u.getProjectionData({overscaledTileID:e,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),n=d?x_(o,t,d,{tileID:e,tileSize:p},v):y_(o,s),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e),x=h.getMeshFromTileID(l,e.canonical,!1,!0,"raster");y.draw(l,c.TRIANGLES,_,m,g,rm.backCCW,n,f,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments)}}(t,0,i,r,n):(t=>"custom"===t.type)(i)&&function(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=i.implementation,a=t.style.projection,l=t.transform,c=l.getProjectionDataForCustomLayer(n),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:a.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${a.shaderPreludeCode.vertexSource}`,define:a.shaderDefine},defaultProjectionData:c},u=o.renderingMode?o.renderingMode:"2d";if("offscreen"===t.renderPass){const e=o.prerender;e&&(t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),e.call(o,s.gl,h),s.setDirty(),t.setBaseState())}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),s.setStencilMode(om.disabled);const e="3d"===u?t.getDepthModeFor3D():t.getDepthModeForSublayer(0,nm.ReadOnly);s.setDepthMode(e),o.render(s.gl,h),s.setDirty(),t.setBaseState(),s.bindFramebuffer.set(null)}}(t,0,i,n))}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t]}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return!1;if(!t.from||!t.to)return!0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return!e||!i}useProgram(t,e,i=!1,r=[]){this.cache=this.cache||{};const n=!!this.style.map.terrain,s=this.style.projection,o=i?Bf.projectionMercator:s.shaderPreludeCode,a=i?Vf:s.shaderDefine,l=t+(e?e.cacheKey:"")+`/${i?Nf:s.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(n?"/terrain":"")+(r?`/${r.join("/")}`:"");return this.cache[l]||(this.cache[l]=new Zm(this.context,Bf[t],e,b_[t],this._showOverdrawInspector,n,o,a,r)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Mc(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy()}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}function Zg(t,e){let i,r=!1,n=null,s=null;const o=()=>{n=null,r&&(t.apply(s,i),n=setTimeout(o,e),r=!1)};return(...t)=>(r=!0,s=this,i=t,n||o(),n)}class Gg{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(!this._isValidHash(t))return!1;const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t)},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let n=window.location.href.replace(/(#.+)?$/,r);n=n.replace("&&","&"),window.history.replaceState(window.history.state,null,n)},this._updateHash=Zg(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t)}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),s=Math.round(e.lng*n)/n,o=Math.round(e.lat*n)/n,a=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=t?`/${s}/${o}/${i}`:`${i}/${o}/${s}`,(a||l)&&(c+="/"+Math.round(10*a)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===t?(e=!0,`${r}=${c}`):i})).filter((t=>t));return e||i.push(`${t}=${c}`),`#${i.join("&")}`}return`#${c}`}_isValidHash(t){if(t.length<3||t.some(isNaN))return!1;try{new Ep(+t[2],+t[1])}catch(t){return!1}const e=+t[0],i=+(t[3]||0),r=+(t[4]||0);return e>=this._map.getMinZoom()&&e<=this._map.getMaxZoom()&&i>=-180&&i<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const $g={linearity:.3,easing:bt(0,0,.3,1)},qg=St({deceleration:2500,maxSpeed:1400},$g),Wg=St({deceleration:20,maxSpeed:1400},$g),Hg=St({deceleration:1e3,maxSpeed:360},$g),Xg=St({deceleration:1e3,maxSpeed:90},$g),Yg=St({deceleration:1e3,maxSpeed:360},$g);class Kg{constructor(t){this._map=t,this.clear()}clear(){this._inertiaBuffer=[]}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:ie.now(),settings:t})}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=ie.now();for(;t.length>0&&e-t[0].time>160;)t.shift()}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const e={zoom:0,bearing:0,pitch:0,roll:0,pan:new c(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)e.zoom+=t.zoomDelta||0,e.bearing+=t.bearingDelta||0,e.pitch+=t.pitchDelta||0,e.roll+=t.rollDelta||0,t.panDelta&&e.pan._add(t.panDelta),t.around&&(e.around=t.around),t.pinchAround&&(e.pinchAround=t.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(e.pan.mag()){const n=Qg(e.pan.mag(),i,St({},qg,t||{})),s=e.pan.mult(n.amount/e.pan.mag()),o=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=o.easingCenter,r.offset=o.easingOffset,Jg(r,n)}if(e.zoom){const t=Qg(e.zoom,i,Wg);r.zoom=this._map.transform.zoom+t.amount,Jg(r,t)}if(e.bearing){const t=Qg(e.bearing,i,Hg);r.bearing=this._map.transform.bearing+Tt(t.amount,-179,179),Jg(r,t)}if(e.pitch){const t=Qg(e.pitch,i,Xg);r.pitch=this._map.transform.pitch+t.amount,Jg(r,t)}if(e.roll){const t=Qg(e.roll,i,Yg);r.roll=this._map.transform.roll+Tt(t.amount,-179,179),Jg(r,t)}if(r.zoom||r.bearing){const t=void 0===e.pinchAround?e.around:e.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter()}return this.clear(),St(r,{noMoveStart:!0})}}function Jg(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing)}function Qg(t,e,i){const{maxSpeed:r,linearity:n,deceleration:s}=i,o=Tt(t*n/(e/1e3),-r,r),a=Math.abs(o)/(s*n);return{easing:i.easing,duration:1e3*a,amount:o*(a/2)}}class ty extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i,r={}){i=i instanceof MouseEvent?i:new MouseEvent(t,i);const n=re.mousePos(e.getCanvas(),i);super(t,St({point:n,lngLat:e.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=e}}class ey extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){const r="touchend"===t?i.changedTouches:i.touches,n=re.touchPos(e.getCanvasContainer(),r),s=n.map((t=>e.unproject(t))),o=n.reduce(((t,e,i,r)=>t.add(e.div(r.length))),new c(0,0));super(t,{points:n,point:o,lngLats:s,lngLat:e.unproject(o),originalEvent:i}),this._defaultPrevented=!1}}class iy extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1}}class ry{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance}reset(){delete this._mousedownPos}wheel(t){return this._firePreventable(new iy(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new ty(t.type,this._map,t))}mouseup(t){this._map.fire(new ty(t.type,this._map,t))}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new ty(t.type,this._map,t))}dblclick(t){return this._firePreventable(new ty(t.type,this._map,t))}mouseover(t){this._map.fire(new ty(t.type,this._map,t))}mouseout(t){this._map.fire(new ty(t.type,this._map,t))}touchstart(t){return this._firePreventable(new ey(t.type,this._map,t))}touchmove(t){this._map.fire(new ey(t.type,this._map,t))}touchend(t){this._map.fire(new ey(t.type,this._map,t))}touchcancel(t){this._map.fire(new ey(t.type,this._map,t))}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class ny{constructor(t){this._map=t}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(t){this._map.fire(new ty(t.type,this._map,t))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new ty("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new ty(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class sy{constructor(t){this._map=t}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.screenPointToLocation(c.convert(t),this._map.terrain)}}class oy{constructor(t,e){this._map=t,this._tr=new sy(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(re.disableDrag(),this._startPos=this._lastPos=e,this._active=!0)}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=re.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const n=Math.min(r.x,i.x),s=Math.max(r.x,i.x),o=Math.min(r.y,i.y),a=Math.max(r.y,i.y);re.setTransform(this._box,`translate(${n}px,${o}px)`),this._box.style.width=s-n+"px",this._box.style.height=a-o+"px"}mouseupWindow(t,e){if(!this._active)return;if(0!==t.button)return;const i=this._startPos,r=e;if(this.reset(),re.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new we("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t)}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(re.remove(this._box),this._box=null),re.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(t,e){return this._map.fire(new we(t,{originalEvent:e}))}}function ay(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let r=0;r<t.length;r++)i[t[r].identifier]=e[r];return i}class ly{constructor(t){this.reset(),this.numTouches=t.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(t,e,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),i.length===this.numTouches&&(this.centroid=function(t){const e=new c(0,0);for(const i of t)e._add(i);return e.div(t.length)}(e),this.touches=ay(i,e)))}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const r=ay(i,e);for(const t in this.touches){const e=r[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0)}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class cy{constructor(t){this.singleTap=new ly(t),this.numTaps=t.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(t,e,i){this.singleTap.touchstart(t,e,i)}touchmove(t,e,i){this.singleTap.touchmove(t,e,i)}touchend(t,e,i){const r=this.singleTap.touchend(t,e,i);if(r){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class hy{constructor(t){this._tr=new sy(t),this._zoomIn=new cy({numTouches:1,numTaps:2}),this._zoomOut=new cy({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i)}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i)}touchend(t,e,i){const r=this._zoomIn.touchend(t,e,i),n=this._zoomOut.touchend(t,e,i),s=this._tr;return r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom+1,around:s.unproject(r)},{originalEvent:t})}):n?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom-1,around:s.unproject(n)},{originalEvent:t})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class uy{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset()}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t)}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.rollDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=Array.isArray(e)?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const r=Array.isArray(e)?e[0]:e;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&re.suppressClick(),this.reset(t))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const py=0,dy=2,fy={[py]:1,[dy]:2};class my{constructor(t){this._correctEvent=t.checkCorrectEvent}startMove(t){const e=re.mouseButton(t);this._eventButton=e}endMove(t){delete this._eventButton}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return!function(t,e){const i=fy[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return re.mouseButton(t)===this._eventButton}}class _y{constructor(){this._firstTouch=void 0}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier}endMove(t){delete this._firstTouch}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}class gy{constructor(t=new my({checkCorrectEvent:()=>!0}),e=new _y){this.mouseMoveStateManager=t,this.oneFingerTouchMoveStateManager=e}_executeRelevantHandler(t,e,i){return t instanceof MouseEvent?e(t):"undefined"!=typeof TouchEvent&&t instanceof TouchEvent?i(t):void 0}startMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.startMove(t)),(t=>this.oneFingerTouchMoveStateManager.startMove(t)))}endMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.endMove(t)),(t=>this.oneFingerTouchMoveStateManager.endMove(t)))}isValidStartEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidStartEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidStartEvent(t)))}isValidMoveEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidMoveEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(t)))}isValidEndEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidEndEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidEndEvent(t)))}}const yy=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault()}};class xy{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new c(0,0)}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t)}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(t,e,i){i.length>0&&(this._active=!0);const r=ay(i,e),n=new c(0,0),s=new c(0,0);let o=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(n._add(e),s._add(e.sub(i)),o++,r[t]=e)}if(this._touches=r,this._shouldBePrevented(o)||!s.mag())return;const a=s.div(o);return this._sum._add(a),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(o),panDelta:a}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class vy{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]))}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[r,n]=this._firstTwoTouches,s=by(i,e,r),o=by(i,e,n);if(!s||!o)return;const a=this._aroundCenter?null:s.add(o).div(2);return this._move([s,o],a,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,s=by(i,e,r),o=by(i,e,n);s&&o||(this._active&&re.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function by(t,e,i){for(let r=0;r<t.length;r++)if(t[r].identifier===i)return e[r]}function wy(t,e){return Math.log(t/e)/Math.LN2}class Ty extends vy{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(t){this._startDistance=this._distance=t[0].dist(t[1])}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(wy(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:wy(this._distance,i),pinchAround:e}}}function Py(t,e){return 180*t.angleWith(e)/Math.PI}class Sy extends vy{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1])}_move(t,e,i){const r=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Py(this._vector,r),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Py(t,this._startVector);return Math.abs(i)<e}}function My(t){return Math.abs(t.y)>Math.abs(t.x)}class Iy extends vy{constructor(t){super(),this._currentTouchCount=0,this._map=t}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length}_start(t){this._lastPoints=t,My(t[0].sub(t[1]))&&(this._valid=!1)}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=t[0].sub(this._lastPoints[0]),n=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,n,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(r.y+n.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const r=t.mag()>=2,n=e.mag()>=2;if(!r&&!n)return;if(!r||!n)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const s=t.y>0==e.y>0;return My(t)&&My(e)&&s}}const Cy={panStep:100,bearingStep:15,pitchStep:10};class Ay{constructor(t){this._tr=new sy(t);const e=Cy;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,r=0,n=0,s=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),n=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),n=1);break;case 38:t.shiftKey?r=1:(t.preventDefault(),s=-1);break;case 40:t.shiftKey?r=-1:(t.preventDefault(),s=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:o=>{const a=this._tr;o.easeTo({duration:300,easeId:"keyboardHandler",easing:Ey,zoom:e?Math.round(a.zoom)+e*(t.shiftKey?2:1):a.zoom,bearing:a.bearing+i*this._bearingStep,pitch:a.pitch+r*this._pitchStep,offset:[-n*this._panStep,-s*this._panStep],center:a.center},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function Ey(t){return t*(2-t)}const zy=4.000244140625,ky=1/450;class Ry{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t)},this._map=t,this._tr=new sy(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=ky}setZoomRate(t){this._defaultZoomRate=t}setWheelZoomRate(t){this._wheelZoomRate=t}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(t){return!!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=ie.now(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%zy==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault()}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=re.mousePos(this._map.getCanvas(),t),i=this._tr;this._aroundPoint=this._aroundCenter?i.transform.locationToScreenPoint(Ep.convert(i.center)):e,this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const e=t.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=e),"number"==typeof this._targetZoom&&(this._targetZoom+=e)}if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>zy?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const r="number"!=typeof this._targetZoom?t.scale:At(this._targetZoom);this._targetZoom=t.getConstrained(t.getCameraLngLat(),Et(r*i)).zoom,"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const e="number"!=typeof this._targetZoom?t.zoom:this._targetZoom,i=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&i&&r){const t=ie.now()-this._lastWheelEventTime,o=Math.min((t+5)/200,1),a=r(o);n=wr.number(i,e,a),o<1?this._frameId||(this._frameId=!0):s=!0}else n=e,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout}),200)),this._lastExpectedZoom=n,{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let e=wt;if(this._prevEase){const t=this._prevEase,i=(ie.now()-t.start)/t.duration,r=t.easing(i+.01)-t.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;e=bt(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:ie.now(),duration:t,easing:e},e}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class Dy{constructor(t,e){this._clickZoom=t,this._tapZoom=e}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class Ly{constructor(t){this._tr=new sy(t),this.reset()}reset(){this._active=!1}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class By{constructor(){this._tap=new cy({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const r=e[0],n=t.timeStamp-this._tapTime<500,s=this._tapPoint.dist(r)<30;n&&s?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(t,e,i)}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=e[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,t.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(t,e,i)}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(t,e,i);r&&(this._tapTime=t.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Fy{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Oy{constructor(t,e,i,r){this._pitchWithRotate=t.pitchWithRotate,this._rollEnabled=t.rollEnabled,this._mouseRotate=e,this._mousePitch=i,this._mouseRoll=r}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class jy{constructor(t,e,i,r){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class Vy{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=re.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=e,this._container.appendChild(r);const n=document.createElement("div");n.className="maplibregl-mobile-message",n.textContent=i,this._container.appendChild(n),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(re.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,e){this._enabled&&(this._map.fire(new we("cooperativegestureprevented",{gestureType:t,originalEvent:e})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const Ny=t=>t.zoom||t.drag||t.roll||t.pitch||t.rotate;class Uy extends we{}function Zy(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta||t.rollDelta}class Gy{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`)},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,r={needsRenderFrame:!1},n={},s={};for(const{handlerName:l,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;if(this._blockedByActive(s,h,l))c.reset();else if(c[e||t.type]){if(a=t,Yt[e||t.type]&&(a instanceof MouseEvent||a instanceof WheelEvent)){const i=re.mousePos(this._map.getCanvas(),t);u=c[e||t.type](t,i)}else if(Kt(t,e||t.type)){const i=this._getMapTouches(t.touches),r=re.touchPos(this._map.getCanvas(),i);u=c[e||t.type](t,r,i)}else Xt[o=e||t.type]||Yt[o]||(u=c[e||t.type](t));this.mergeHandlerResult(r,n,u,l,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()}(u||c.isActive())&&(s[l]=c)}var o,a;const l={};for(const t in this._previousActiveHandlers)s[t]||(l[t]=i);this._previousActiveHandlers=s,(Object.keys(l).length||Zy(r))&&(this._changes.push([r,n,l]),this._triggerRenderFrame()),(Object.keys(s).length||Zy(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:c}=r;c&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],c(this._map))},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Kg(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)re.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[t,e,i]of this._listeners)re.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new ry(e,t));const r=e.boxZoom=new oy(e,t);this._add("boxZoom",r),t.interactive&&t.boxZoom&&r.enable();const n=e.cooperativeGestures=new Vy(e,t.cooperativeGestures);this._add("cooperativeGestures",n),t.cooperativeGestures&&n.enable();const s=new hy(e),o=new Ly(e);e.doubleClickZoom=new Dy(o,s),this._add("tapZoom",s),this._add("clickZoom",o),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const a=new By;this._add("tapDragZoom",a);const l=e.touchPitch=new Iy(e);this._add("touchPitch",l),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const h=()=>e.project(e.getCenter()),u=function({enable:t,clickTolerance:e,aroundCenter:i=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:n=.8},s){const o=new my({checkCorrectEvent:t=>0===re.mouseButton(t)&&t.ctrlKey||2===re.mouseButton(t)&&!t.ctrlKey});return new uy({clickTolerance:e,move:(t,e)=>{const o=s();if(i&&Math.abs(o.y-t.y)>r)return{bearingDelta:qt(new c(t.x,e.y),e,o)};let a=(e.x-t.x)*n;return i&&e.y<o.y&&(a=-a),{bearingDelta:a}},moveStateManager:o,enable:t,assignEvents:yy})}(t,h),p=function({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5}){const r=new my({checkCorrectEvent:t=>0===re.mouseButton(t)&&t.ctrlKey||2===re.mouseButton(t)});return new uy({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:yy})}(t),d=function({enable:t,clickTolerance:e,rollDegreesPerPixelMoved:i=.3},r){const n=new my({checkCorrectEvent:t=>2===re.mouseButton(t)&&t.ctrlKey});return new uy({clickTolerance:e,move:(t,e)=>{const n=r();let s=(e.x-t.x)*i;return e.y<n.y&&(s=-s),{rollDelta:s}},moveStateManager:n,enable:t,assignEvents:yy})}(t,h);e.dragRotate=new Oy(t,u,p,d),this._add("mouseRotate",u,["mousePitch"]),this._add("mousePitch",p,["mouseRotate","mouseRoll"]),this._add("mouseRoll",d,["mousePitch"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const f=function({enable:t,clickTolerance:e}){const i=new my({checkCorrectEvent:t=>0===re.mouseButton(t)&&!t.ctrlKey});return new uy({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:yy})}(t),m=new xy(t,e);e.dragPan=new Fy(i,f,m),this._add("mousePan",f),this._add("touchPan",m,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const _=new Sy,g=new Ty;e.touchZoomRotate=new jy(i,g,_,a),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",g,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const y=e.scrollZoom=new Ry(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",y,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const x=e.keyboard=new Ay(e);this._add("keyboard",x),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new ny(e))}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[]}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(Ny(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const r in t)if(r!==i&&(!e||e.indexOf(r)<0))return!0;return!1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,e,i,r,n){if(!i)return;St(t,i);const s={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(e.zoom=s),void 0!==i.panDelta&&(e.drag=s),void 0!==i.rollDelta&&(e.roll=s),void 0!==i.pitchDelta&&(e.pitch=s),void 0!==i.bearingDelta&&(e.rotate=s)}_applyChanges(){const t={},e={},i={};for(const[r,n,s]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new c(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(t.rollDelta=(t.rollDelta||0)+r.rollDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),St(e,n),St(i,s);this._updateMapTransform(t,e,i),this._changes=[]}_updateMapTransform(t,e,i){const r=this._map,n=r._getTransformForUpdate(),s=r.terrain;if(!(Zy(t)||s&&this._terrainMovement))return this._fireEvents(e,i,!0);r._stop(!0);let{panDelta:o,zoomDelta:a,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:p}=t;void 0!==p&&(u=p),u=u||r.transform.centerPoint,s&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const d={panDelta:o,zoomDelta:a,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const f=u.distSqr(n.centerPoint)<.01?n.center:n.screenPointToLocation(o?u.sub(o):u);s?(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?n.setCenter(n.screenPointToLocation(n.centerPoint.sub(o))):this._map.cameraHelper.handleMapControlsPan(d,n,f):(this._terrainMovement=!0,this._map._elevationFreeze=!0,this._map.cameraHelper.handleMapControlsPan(d,n,f))):(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._map.cameraHelper.handleMapControlsPan(d,n,f)),r._applyUpdatedTransform(n),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0)}_fireEvents(t,e,i){const r=Ny(this._eventsInProgress),n=Ny(t),s={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(s[`${e}start`]=i),this._eventsInProgress[e]=t[e]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const t in s)this._fireEvent(t,s[t]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i)}const o={};let a;for(const t in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[t];this._handlersById[i].isActive()||(delete this._eventsInProgress[t],a=e[i]||r,o[`${t}end`]=a)}for(const t in o)this._fireEvent(t,o[t]);const l=Ny(this._eventsInProgress),c=(r||n)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&t.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(t)}if(i&&c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),e=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&ie.prefersReducedMotion?(this._map.fire(new we("moveend",{originalEvent:a})),e(this._map.getBearing())&&this._map.resetNorth()):(e(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:a})),this._updatingCamera=!1}}_fireEvent(t,e){this._map.fire(new we(t,e?{originalEvent:e}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new Uy("renderFrame",{timeStamp:t})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class $y extends Pe{constructor(t,e,i){super(),this._renderFrameCallback=()=>{const t=Math.min((ie.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,this.cameraHelper=e,this.on("moveend",(()=>{delete this._requestedCameraState}))}migrateProjection(t,e){t.apply(this.transform),this.transform=t,this.cameraHelper=e}getCenter(){return new Ep(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}getCenterElevation(){return this.transform.elevation}setCenterElevation(t,e){return this.jumpTo({elevation:t},e),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(t){this._centerClampedToGround=t}panBy(t,e,i){return t=c.convert(t).mult(-1),this.panTo(this.transform.center,St({offset:t},e),i)}panTo(t,e,i){return this.easeTo(St({center:t},e),i)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,e,i){return this.easeTo(St({zoom:t},e),i)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(t,e){return t!=this.transform.fov&&(this.transform.setFov(t),this.fire(new we("movestart",e)).fire(new we("move",e)).fire(new we("moveend",e))),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,e,i){return this.easeTo(St({bearing:t},e),i)}resetNorth(t,e){return this.rotateTo(0,St({duration:1e3},t),e),this}resetNorthPitch(t,e){return this.easeTo(St({bearing:0,pitch:0,roll:0,duration:1e3},t),e),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}getRoll(){return this.transform.roll}setRoll(t,e){return this.jumpTo({roll:t},e),this}cameraForBounds(t,e){t=zp.convert(t).adjustAntiMeridian();const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,e,i,r){const n={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=St({padding:n,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const t=r.padding;r.padding={top:t,bottom:t,right:t,left:t}}const s=St(n,r.padding);r.padding=s;const o=this.transform,a=new zp(t,e);return this.cameraHelper.cameraForBoxAndBearing(r,s,a,i,o)}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,e,i,r,n){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(c.convert(t)),this.transform.screenPointToLocation(c.convert(e)),i,r),r,n)}_fitInternal(t,e,i){return t?(delete(e=St(t,e)).padding,e.linear?this.easeTo(e,i):this.flyTo(e,i)):this}jumpTo(t,e){this.stop();const i=this._getTransformForUpdate();let r=!1,n=!1,s=!1;const o=i.zoom;this.cameraHelper.handleJumpToCenterZoom(i,t);const a=i.zoom!==o;return"elevation"in t&&i.elevation!==+t.elevation&&i.setElevation(+t.elevation),"bearing"in t&&i.bearing!==+t.bearing&&(r=!0,i.setBearing(+t.bearing)),"pitch"in t&&i.pitch!==+t.pitch&&(n=!0,i.setPitch(+t.pitch)),"roll"in t&&i.roll!==+t.roll&&(s=!0,i.setRoll(+t.roll)),null==t.padding||i.isPaddingEqual(t.padding)||i.setPadding(t.padding),this._applyUpdatedTransform(i),this.fire(new we("movestart",e)).fire(new we("move",e)),a&&this.fire(new we("zoomstart",e)).fire(new we("zoom",e)).fire(new we("zoomend",e)),r&&this.fire(new we("rotatestart",e)).fire(new we("rotate",e)).fire(new we("rotateend",e)),n&&this.fire(new we("pitchstart",e)).fire(new we("pitch",e)).fire(new we("pitchend",e)),s&&this.fire(new we("rollstart",e)).fire(new we("roll",e)).fire(new we("rollend",e)),this.fire(new we("moveend",e))}calculateCameraOptionsFromTo(t,e,i,r=0){const n=jp.fromLngLat(t,e),s=jp.fromLngLat(i,r),o=s.x-n.x,a=s.y-n.y,l=s.z-n.z,c=Math.hypot(o,a,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(o,a),u=Et(this.transform.cameraToCenterDistance/c/this.transform.tileSize),p=180*Math.atan2(o,-a)/Math.PI;let d=180*Math.acos(h/c)/Math.PI;return d=l<0?90-d:90+d,{center:s.toLngLat(),elevation:r,zoom:u,pitch:d,bearing:p}}calculateCameraOptionsFromCameraLngLatAltRotation(t,e,i,r,n){const s=this.transform.calculateCenterFromCameraLngLatAlt(t,e,i,r);return{center:s.center,elevation:s.elevation,zoom:s.zoom,bearing:i,pitch:r,roll:n}}easeTo(t,e){this._stop(!1,t.easeId),(!1===(t=St({offset:[0,0],duration:500,easing:wt},t)).animate||!t.essential&&ie.prefersReducedMotion)&&(t.duration=0);const i=this._getTransformForUpdate(),r=this.getBearing(),n=i.pitch,s=i.roll,o="bearing"in t?this._normalizeBearing(t.bearing,r):r,a="pitch"in t?+t.pitch:n,l="roll"in t?this._normalizeBearing(t.roll,s):s,h="padding"in t?t.padding:i.padding,u=c.convert(t.offset);let p,d;t.around&&(p=Ep.convert(t.around),d=i.locationToScreenPoint(p));const f={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},m=this.cameraHelper.handleEaseTo(i,{bearing:o,pitch:a,roll:l,padding:h,around:p,aroundPoint:d,offsetAsPoint:u,offset:t.offset,zoom:t.zoom,center:t.center});return this._rotating=this._rotating||r!==o,this._pitching=this._pitching||a!==n,this._rolling=this._rolling||l!==s,this._padding=!i.isPaddingEqual(h),this._zooming=this._zooming||m.isZooming,this._easeId=t.easeId,this._prepareEase(e,t.noMoveStart,f),this.terrain&&this._prepareElevation(m.elevationCenter),this._ease((r=>{m.easeFunc(r),this.terrain&&!t.freezeElevation&&this._updateElevation(r),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(i=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e,i)}),t),this}_prepareEase(t,e,i={}){this._moving=!0,e||i.moving||this.fire(new we("movestart",t)),this._zooming&&!i.zooming&&this.fire(new we("zoomstart",t)),this._rotating&&!i.rotating&&this.fire(new we("rotatestart",t)),this._pitching&&!i.pitching&&this.fire(new we("pitchstart",t)),this._rolling&&!i.rolling&&this.fire(new we("rollstart",t))}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(t){this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const e=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&e!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(i-(e-(i*t+this._elevationStart))/(1-t)),this._elevationTarget=e}this.transform.setElevation(wr.number(this._elevationStart,this._elevationTarget,t))}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){if(!this.terrain&&t.elevation>=0&&t.pitch<=90)return{};const e=t.getCameraLngLat(),i=t.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(e,t.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(e,r,t.center,t.elevation);return{pitch:i.pitch,zoom:i.zoom}}return{}}_applyUpdatedTransform(t){const e=[];if(e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:r,zoom:n,roll:s,pitch:o,bearing:a,elevation:l}=t(e);r&&e.setCenter(r),void 0!==l&&e.setElevation(l),void 0!==n&&e.setZoom(n),void 0!==s&&e.setRoll(s),void 0!==o&&e.setPitch(o),void 0!==a&&e.setBearing(a),i.apply(e)}this.transform.apply(i)}_fireMoveEvents(t){this.fire(new we("move",t)),this._zooming&&this.fire(new we("zoom",t)),this._rotating&&this.fire(new we("rotate",t)),this._pitching&&this.fire(new we("pitch",t)),this._rolling&&this.fire(new we("roll",t))}_afterEase(t,e){if(this._easeId&&e&&this._easeId===e)return;delete this._easeId;const i=this._zooming,r=this._rotating,n=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,i&&this.fire(new we("zoomend",t)),r&&this.fire(new we("rotateend",t)),n&&this.fire(new we("pitchend",t)),s&&this.fire(new we("rollend",t)),this.fire(new we("moveend",t))}flyTo(t,e){if(!t.essential&&ie.prefersReducedMotion){const i=Mt(t,["center","zoom","bearing","pitch","roll","elevation"]);return this.jumpTo(i,e)}this.stop(),t=St({offset:[0,0],speed:1.2,curve:1.42,easing:wt},t);const i=this._getTransformForUpdate(),r=i.bearing,n=i.pitch,s=i.roll,o=i.padding,a="bearing"in t?this._normalizeBearing(t.bearing,r):r,l="pitch"in t?+t.pitch:n,h="roll"in t?this._normalizeBearing(t.roll,s):s,u="padding"in t?t.padding:i.padding,p=c.convert(t.offset);let d=i.centerPoint.add(p);const f=i.screenPointToLocation(d),m=this.cameraHelper.handleFlyTo(i,{bearing:a,pitch:l,roll:h,padding:u,locationAtOffset:f,offsetAsPoint:p,center:t.center,minZoom:t.minZoom,zoom:t.zoom});let _=t.curve;const g=Math.max(i.width,i.height),y=g/m.scaleOfZoom,x=m.pixelPathLength;"number"==typeof m.scaleOfMinZoom&&(_=Math.sqrt(g/m.scaleOfMinZoom/x*2));const v=_*_;function b(t){const e=(y*y-g*g+(t?-1:1)*v*v*x*x)/(2*(t?y:g)*v*x);return Math.log(Math.sqrt(e*e+1)-e)}function w(t){return(Math.exp(t)-Math.exp(-t))/2}function T(t){return(Math.exp(t)+Math.exp(-t))/2}const P=b(!1);let S=function(t){return T(P)/T(P+_*t)},M=function(t){return g*((T(P)*(w(e=P+_*t)/T(e))-w(P))/v)/x;var e},I=(b(!0)-P)/_;if(Math.abs(x)<2e-6||!isFinite(I)){if(Math.abs(g-y)<1e-6)return this.easeTo(t,e);const i=y<g?-1:1;I=Math.abs(Math.log(y/g))/_,M=()=>0,S=t=>Math.exp(i*_*t)}return t.duration="duration"in t?+t.duration:1e3*I/("screenSpeed"in t?+t.screenSpeed/_:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==a,this._pitching=l!==n,this._rolling=h!==s,this._padding=!i.isPaddingEqual(u),this._prepareEase(e,!1),this.terrain&&this._prepareElevation(m.targetCenter),this._ease((c=>{const f=c*I,_=1/S(f),g=M(f);this._rotating&&i.setBearing(wr.number(r,a,c)),this._pitching&&i.setPitch(wr.number(n,l,c)),this._rolling&&i.setRoll(wr.number(s,h,c)),this._padding&&(i.interpolatePadding(o,u,c),d=i.centerPoint.add(p)),m.easeFunc(c,_,g,d),this.terrain&&!t.freezeElevation&&this._updateElevation(c),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e)}),t),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e)}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=ie.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(t,e){t=Pt(t,-180,180);const i=Math.abs(t-e);return Math.abs(t-360-e)<i&&(t-=360),Math.abs(t+360-e)<i&&(t+=360),t}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(Ep.convert(t),this.transform.tileZoom):null}}const qy={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class Wy{constructor(t=qy){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=t}getDefaultPosition(){return"bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=re.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=re.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=re.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){re.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id}const e=this._map.style.sourceCaches;for(const i in e){const r=e[i];if(r.used||r.usedForTerrain){const e=r.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution)}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let r=i+1;r<t.length;r++)if(t[r].indexOf(e)>=0)return!1;return!0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=re.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class Hy{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact")}},this.options=t}getDefaultPosition(){return"bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=re.create("div","maplibregl-ctrl");const e=re.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){re.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class Xy{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var Yy;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(Yy||(Yy={}));let Ky=null,Jy=[];const Qy=1e3/60,tx="loadTime",ex="fullLoadTime",ix={mark(t){performance.mark(t)},frame(t){const e=t;null!=Ky&&Jy.push(e-Ky),Ky=e},clearMetrics(){Ky=null,Jy=[],performance.clearMeasures(tx),performance.clearMeasures(ex);for(const t in Yy)performance.clearMarks(Yy[t])},getPerformanceMetrics(){performance.measure(tx,Yy.create,Yy.load),performance.measure(ex,Yy.create,Yy.fullLoad);const t=performance.getEntriesByName(tx)[0].duration,e=performance.getEntriesByName(ex)[0].duration,i=Jy.length,r=1/(Jy.reduce(((t,e)=>t+e),0)/i/1e3),n=Jy.filter((t=>t>Qy)).reduce(((t,e)=>t+(e-Qy)/Qy),0);return{loadTime:t,fullLoadTime:e,fps:r,percentDroppedFrames:n/(i+n)*100,totalFrames:i}}};var rx=Jo([{name:"a_pos3d",type:"Int16",components:3}]);class nx extends Pe{constructor(t){super(),this._lastTilesetChange=ie.now(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=t._source.tileSize*2**this.deltaZoom,t.usedForTerrain=!0,t.tileSize=this.tileSize}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null}update(t,e){this.sourceCache.update(t,e),this._renderableTilesKeys=[];const i={};for(const r of Pd(t,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:e,calculateTileZoom:this.sourceCache._source.calculateTileZoom}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),E(r.terrainRttPosMatrix32f,0,it,it,0,0,1),this._tiles[r.key]=new hd(r,this.tileSize),this._lastTilesetChange=ie.now());for(const t in this._tiles)i[t]||delete this._tiles[t]}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t,e){return e?this._getTerrainCoordsForTileRanges(t,e):this._getTerrainCoordsForRegularTile(t)}_getTerrainCoordsForRegularTile(t){const e={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID,n=t.clone(),s=ot();if(r.canonical.equals(t.canonical))E(s,0,it,it,0,0,1);else if(r.canonical.isChildOf(t.canonical)){const e=r.canonical.z-t.canonical.z,i=r.canonical.x-(r.canonical.x>>e<<e),n=r.canonical.y-(r.canonical.y>>e<<e),o=it>>e;E(s,0,o,o,0,0,1),P(s,s,[-i*o,-n*o,0])}else{if(!t.canonical.isChildOf(r.canonical))continue;{const e=t.canonical.z-r.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),n=t.canonical.y-(t.canonical.y>>e<<e),o=it>>e;E(s,0,it,it,0,0,1),P(s,s,[i*o,n*o,0]),S(s,s,[1/2**e,1/2**e,0])}}n.terrainRttPosMatrix32f=new Float32Array(s),e[i]=n}return e}_getTerrainCoordsForTileRanges(t,e){const i={};for(const r of this._renderableTilesKeys){const n=this._tiles[r].tileID;if(!this._isWithinTileRanges(n,e))continue;const s=t.clone(),o=ot();if(n.canonical.z===t.canonical.z){const e=t.canonical.x-n.canonical.x,i=t.canonical.y-n.canonical.y;E(o,0,it,it,0,0,1),P(o,o,[e*it,i*it,0])}else if(n.canonical.z>t.canonical.z){const e=n.canonical.z-t.canonical.z,i=n.canonical.x-(n.canonical.x>>e<<e),r=n.canonical.y-(n.canonical.y>>e<<e),s=t.canonical.x-(n.canonical.x>>e),a=t.canonical.y-(n.canonical.y>>e),l=it>>e;E(o,0,l,l,0,0,1),P(o,o,[-i*l+s*it,-r*l+a*it,0])}else{const e=t.canonical.z-n.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),r=t.canonical.y-(t.canonical.y>>e<<e),s=(t.canonical.x>>e)-n.canonical.x,a=(t.canonical.y>>e)-n.canonical.y,l=it<<e;E(o,0,l,l,0,0,1),P(o,o,[i*it+s*l,r*it+a*l,0])}s.terrainRttPosMatrix32f=new Float32Array(o),i[r]=s}return i}getSourceTile(t,e){const i=this.sourceCache._source;let r=t.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(r).key);let n=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!n||!n.dem)&&e)for(;r>=i.minzoom&&(!n||!n.dem);)n=this.sourceCache.getTileByID(t.scaledTo(r--).key);return n}anyTilesAfterTime(t=Date.now()){return this._lastTilesetChange>=t}_isWithinTileRanges(t,e){return e[t.canonical.z]&&t.canonical.x>=e[t.canonical.z].minTileX&&t.canonical.x<=e[t.canonical.z].maxTileX&&t.canonical.y>=e[t.canonical.z].minTileY&&t.canonical.y<=e[t.canonical.z].maxTileY}}class sx{constructor(t,e,i){this._meshCache={},this.painter=t,this.sourceCache=new nx(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(t,e,i,r=8192){var n;if(!(e>=0&&e<r&&i>=0&&i<r))return 0;const s=this.getTerrainData(t),o=null===(n=s.tile)||void 0===n?void 0:n.dem;if(!o)return 0;const a=function(t,e,i){var r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t}([],[e/r*it,i/r*it],s.u_terrain_matrix),l=[a[0]*o.dim,a[1]*o.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,p=l[1]-h;return o.get(c,h)*(1-u)*(1-p)+o.get(c+1,h)*u*(1-p)+o.get(c,h+1)*(1-u)*p+o.get(c+1,h+1)*u*p}getElevationForLngLatZoom(t,e){if(!function(t,e){const{x:i,y:r}=jp.fromLngLat(e);return!(t<0||t>25||r<0||r>=1||i<0||i>=1)}(e,t.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:n}=this._getOverscaledTileIDFromLngLatZoom(t,e);return this.getElevation(i,r%it,n%it,it)}getElevation(t,e,i,r=8192){return this.getDEMElevation(t,e,i,r)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,e=new gc({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Mc(t,e,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Mc(t,new gc({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=b([])}const e=this.sourceCache.getSourceTile(t,!0);if(e&&e.dem&&(!e.demTexture||e.needsTerrainPrepare)){const t=this.painter.context;e.demTexture=this.painter.getTileTexture(e.dem.stride),e.demTexture?e.demTexture.update(e.dem.getPixels(),{premultiply:!1}):e.demTexture=new Mc(t,e.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),e.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),e.needsTerrainPrepare=!1}const i=e&&e+e.tileID.key+t.key;if(i&&!this._demMatrixCache[i]){const i=this.sourceCache.sourceCache._source.maxzoom;let s=t.canonical.z-e.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=i?s=t.canonical.z-i:Bt("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=t.canonical.x-(t.canonical.x>>s<<s),a=t.canonical.y-(t.canonical.y>>s<<s),l=((r=new Float64Array(16))[0]=(n=[1/(it<<s),1/(it<<s),0])[0],r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=n[1],r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=n[2],r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r);P(l,l,[o*it,a*it,0]),this._demMatrixCache[t.key]={matrix:l,coord:t}}var r,n;return{u_depth:2,u_terrain:3,u_terrain_dim:e&&e.dem&&e.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:e&&e.dem&&e.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(e&&e.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:e}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,r=e.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Mc(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Mc(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const e=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,i=0;t<this._coordsTextureSize;t++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)e[i+0]=255&r,e[i+1]=255&t,e[i+2]=r>>8<<4|t>>8,e[i+3]=0;const i=new gc({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(e.buffer)),r=new Mc(t,i,t.gl.RGBA,{premultiply:!1});return r.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const e=new Uint8Array(4),i=this.painter.context,r=i.gl,n=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),o=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(n,o-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null);const a=e[0]+(e[2]>>4<<8),l=e[1]+((15&e[2])<<8),c=this.coordsIndex[255-e[3]],h=c&&this.sourceCache.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,p=(1<<h.tileID.canonical.z)*u;return new jp((h.tileID.canonical.x*u+a)/p+h.tileID.wrap,(h.tileID.canonical.y*u+l)/p,this.getElevation(h.tileID,a,l,u))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(t){var e;const i=(null===(e=this.painter.style.projection)||void 0===e?void 0:e.transitionState)>0,r=i&&0===t.canonical.y,n=i&&t.canonical.y===(1<<t.canonical.z)-1,s=`m_${r?"n":""}_${n?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const o=this.painter.context,a=new Ba,l=new Ka,c=this.meshSize,h=it/c,u=c*c;for(let t=0;t<=c;t++)for(let e=0;e<=c;e++)a.emplaceBack(e*h,t*h,0);for(let t=0;t<u;t+=c+1)for(let e=0;e<c;e++)l.emplaceBack(e+t,c+e+t+1,c+e+t+2),l.emplaceBack(e+t,c+e+t+2,e+t+1);const p=a.length,d=p+(c+1),f=(c+1)*c,m=r?oh:0,_=r?0:1,g=n?ah:it,y=n?0:1;for(let t=0;t<=c;t++)a.emplaceBack(t*h,m,_);for(let t=0;t<=c;t++)a.emplaceBack(t*h,g,y);for(let t=0;t<c;t++)l.emplaceBack(f+t,d+t,d+t+1),l.emplaceBack(f+t,d+t+1,f+t+1),l.emplaceBack(0+t,p+t+1,p+t),l.emplaceBack(0+t,0+t+1,p+t+1);const x=a.length,v=x+2*(c+1);for(const t of[0,1])for(let e=0;e<=c;e++)for(const i of[0,1])a.emplaceBack(t*it,e*h,i);for(let t=0;t<2*c;t+=2)l.emplaceBack(x+t,x+t+1,x+t+3),l.emplaceBack(x+t,x+t+3,x+t+2),l.emplaceBack(v+t,v+t+3,v+t+1),l.emplaceBack(v+t,v+t+2,v+t+3);const b=new Of(o.createVertexBuffer(a,rx.members),o.createIndexBuffer(l),il.simpleSegment(0,0,a.length,l.length));return this._meshCache[s]=b,b}getMeshFrameDelta(t){return 2*Math.PI*Ap/Math.pow(2,Math.max(t,0))/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,e){const i=jp.fromLngLat(t.wrap()),r=(1<<e)*it,n=i.x*r,s=i.y*r,o=Math.floor(n/it),a=Math.floor(s/it);return{tileID:new qp(e,0,e,o,a),mercatorX:n,mercatorY:s}}}class ox{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy()}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Mc(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id)}stampObject(t){t.stamp=++this._stamp}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1}freeAllObjects(){for(const t of this._objects)this.freeObject(t)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const ax={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class lx{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new ox(t.context,30,e.sourceCache.tileSize*e.qualityFactor)}destruct(){this.pool.destruct()}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsAscending={};for(const e in t.sourceCaches){this._coordsAscending[e]={};const i=t.sourceCaches[e].getVisibleCoordinates(),r=t.sourceCaches[e].getSource(),n=r instanceof Kp?r.terrainTileRanges:null;for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t,n);for(const t in i)this._coordsAscending[e][t]||(this._coordsAscending[e][t]=[]),this._coordsAscending[e][t].push(i[t])}}this._coordsAscendingStr={};for(const e of t._order){const i=t._layers[e],r=i.source;if(ax[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const t in this._coordsAscending[r])this._coordsAscendingStr[r][t]=this._coordsAscending[r][t].map((t=>t.key)).sort().join()}}for(const t of this._renderableTiles)for(const e in this._coordsAscendingStr){const i=this._coordsAscendingStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[])}}renderLayer(t,e){if(t.isHidden(this.painter.transform.zoom))return!1;const i=Object.assign(Object.assign({},e),{isRenderingToTexture:!0}),r=t.type,n=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(ax[r]&&(this._prevType&&ax[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(t.id),!s))return!0;if(ax[this._prevType]||ax[r]&&s){this._prevType=r;const t=this._stacks.length-1,e=this._stacks[t]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(Vg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[t]){const e=this.pool.getObjectForId(r.rtt[t].id);if(e.stamp===r.rtt[t].stamp){this.pool.useObject(e);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[t]={id:s.id,stamp:s.stamp},n.context.bindFramebuffer.set(s.fbo.framebuffer),n.context.clear({color:Di.transparent,stencil:0}),n.currentStencilSource=void 0;for(let t=0;t<e.length;t++){const o=n.style._layers[e[t]],a=o.source?this._coordsAscending[o.source][r.tileID.key]:[r.tileID];n.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),n._renderTileClippingMasks(o,a,!0),n.renderLayer(n,n.style.sourceCaches[o.source],o,a,i),o.source&&(r.rttCoords[o.source]=this._coordsAscendingStr[o.source][r.tileID.key])}}return Vg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects(),ax[r]}return!1}}const cx={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},hx=r,ux={hash:!1,interactive:!0,bearingSnap:7,attributionControl:qy,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:ne.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},px={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class dx{constructor(t,e,i=!1){this.mousedown=t=>{this.startMove(t,re.mousePos(this.element,t)),re.addEventListener(window,"mousemove",this.mousemove),re.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=t=>{this.move(t,re.mousePos(this.element,t))},this.mouseup=t=>{this._rotatePitchHanlder.dragEnd(t),this.offTemp()},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=re.touchPos(this.element,t.targetTouches)[0],this.startMove(t,this._startPos),re.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.addEventListener(window,"touchend",this.touchend))},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=re.touchPos(this.element,t.targetTouches)[0],this.move(t,this._lastPos))},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this._rotatePitchHanlder.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10,this.element=e;const r=new gy;this._rotatePitchHanlder=new uy({clickTolerance:3,move:(t,r)=>{const n=e.getBoundingClientRect(),s=new c((n.bottom-n.top)/2,(n.right-n.left)/2);return{bearingDelta:qt(new c(t.x,r.y),r,s),pitchDelta:i?-.5*(r.y-t.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=t,re.addEventListener(e,"mousedown",this.mousedown),re.addEventListener(e,"touchstart",this.touchstart,{passive:!1}),re.addEventListener(e,"touchcancel",this.reset)}startMove(t,e){this._rotatePitchHanlder.dragStart(t,e),re.disableDrag()}move(t,e){const i=this.map,{bearingDelta:r,pitchDelta:n}=this._rotatePitchHanlder.dragMove(t,e)||{};r&&i.setBearing(i.getBearing()+r),n&&i.setPitch(i.getPitch()+n)}off(){const t=this.element;re.removeEventListener(t,"mousedown",this.mousedown),re.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),re.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.removeEventListener(window,"touchend",this.touchend),re.removeEventListener(t,"touchcancel",this.reset),this.offTemp()}offTemp(){re.enableDrag(),re.removeEventListener(window,"mousemove",this.mousemove),re.removeEventListener(window,"mouseup",this.mouseup),re.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.removeEventListener(window,"touchend",this.touchend)}}let fx;function mx(t,e,i,r=!1){if(r||!i.getCoveringTilesDetailsProvider().allowWorldCopies())return null==t?void 0:t.wrap();const n=new Ep(t.lng,t.lat);if(t=new Ep(t.lng,t.lat),e){const r=new Ep(t.lng-360,t.lat),n=new Ep(t.lng+360,t.lat),s=i.locationToScreenPoint(t).distSqr(e);i.locationToScreenPoint(r).distSqr(e)<s?t=r:i.locationToScreenPoint(n).distSqr(e)<s&&(t=n)}for(;Math.abs(t.lng-i.center.lng)>180;){const e=i.locationToScreenPoint(t);if(e.x>=0&&e.y>=0&&e.x<=i.width&&e.y<=i.height)break;t.lng>i.center.lng?t.lng-=360:t.lng+=360}return t.lng!==n.lng&&i.isPointOnMapSurface(i.locationToScreenPoint(t))?t:n}const _x={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function gx(t,e,i){const r=t.classList;for(const t in _x)r.remove(`maplibregl-${i}-anchor-${t}`);r.add(`maplibregl-${i}-anchor-${e}`)}class yx extends Pe{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup()},this._update=t=>{if(!this._map)return;const e=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!e)&&this._map.once("render",this._update),this._lngLat=mx(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let r="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?r="rotateX(0deg)":"map"===this._pitchAlignment&&(r=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),re.setTransform(this._element,`${_x[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${r} ${i}`),ie.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type)})).catch((()=>{}))},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new we("dragstart"))),this.fire(new we("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new we("dragend")),this._state="inactive"},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=c.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=re.create("div");const e=re.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;e.setAttributeNS(null,"display","block"),e.setAttributeNS(null,"height",`${i}px`),e.setAttributeNS(null,"width",`${r}px`),e.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const n=re.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=re.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const o=re.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"transform","translate(3.0, 29.0)"),o.setAttributeNS(null,"fill","#000000");const a=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of a){const e=re.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),o.appendChild(e)}const l=re.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"fill",this._color);const h=re.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),l.appendChild(h);const u=re.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const p=re.createNS("http://www.w3.org/2000/svg","path");p.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(p);const d=re.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"transform","translate(6.0, 7.0)"),d.setAttributeNS(null,"fill","#FFFFFF");const f=re.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=re.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=re.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),s.appendChild(o),s.appendChild(l),s.appendChild(u),s.appendChild(d),s.appendChild(f),e.appendChild(s),e.setAttributeNS(null,"height",i*this._scale+"px"),e.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(e),this._offset=c.convert(t&&t.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault()})),this._element.addEventListener("mousedown",(t=>{t.preventDefault()})),gx(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null}addTo(t){return this.remove(),this._map=t,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),t.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),re.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=Ep.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[r,-1*(e-i+r)],"bottom-right":[-r,-1*(e-i+r)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var e,i;const r=null===(e=this._map)||void 0===e?void 0:e.terrain,n=this._map.transform.isLocationOccluded(this._lngLat);if(!r||n){const t=n?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==t&&(this._element.style.opacity=t))}if(t)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const s=this._map,o=s.terrain.depthAtPoint(this._pos),a=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,a)-o<.006)return void(this._element.style.opacity=this._opacity);const l=-this._offset.y/s.transform.pixelsPerMeter,h=Math.sin(s.getPitch()*Math.PI/180)*l,u=s.terrain.depthAtPoint(new c(this._pos.x,this._pos.y-this._offset.y)),p=s.transform.lngLatToCameraDepth(this._lngLat,a+h)-u>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&p&&this._popup.remove(),this._element.style.opacity=p?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(t){return this._offset=c.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t)}removeClassName(t){this._element.classList.remove(t)}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return(void 0===this._opacity||void 0===t&&void 0===e)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const xx={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let vx=0,bx=!1;const wx={maxWidth:100,unit:"metric"};function Tx(t,e,i){const r=i&&i.maxWidth||100,n=t._container.clientHeight/2,s=t._container.clientWidth/2,o=t.unproject([s-r/2,n]),a=t.unproject([s+r/2,n]),l=Math.round(t.project(a).x-t.project(o).x),c=Math.min(r,l,t._container.clientWidth),h=o.distanceTo(a);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?Px(e,c,i/5280,t._getUIString("ScaleControl.Miles")):Px(e,c,i,t._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?Px(e,c,h/1852,t._getUIString("ScaleControl.NauticalMiles")):h>=1e3?Px(e,c,h/1e3,t._getUIString("ScaleControl.Kilometers")):Px(e,c,h,t._getUIString("ScaleControl.Meters"))}function Px(t,e,i,r){const n=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(n/i)+"px",t.innerHTML=`${n}&nbsp;${r}`}const Sx={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},Mx=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Ix(t){if(t){if("number"==typeof t){const e=Math.round(Math.abs(t)/Math.SQRT2);return{center:new c(0,0),top:new c(0,t),"top-left":new c(e,e),"top-right":new c(-e,e),bottom:new c(0,-t),"bottom-left":new c(e,-e),"bottom-right":new c(-e,-e),left:new c(t,0),right:new c(-t,0)}}if(t instanceof c||Array.isArray(t)){const e=c.convert(t);return{center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return{center:c.convert(t.center||[0,0]),top:c.convert(t.top||[0,0]),"top-left":c.convert(t["top-left"]||[0,0]),"top-right":c.convert(t["top-right"]||[0,0]),bottom:c.convert(t.bottom||[0,0]),"bottom-left":c.convert(t["bottom-left"]||[0,0]),"bottom-right":c.convert(t["bottom-right"]||[0,0]),left:c.convert(t.left||[0,0]),right:c.convert(t.right||[0,0])}}return Ix(new c(0,0))}const Cx=r;t.AJAXError=ae,t.AttributionControl=Wy,t.BoxZoomHandler=oy,t.CanvasSource=Qp,t.CooperativeGesturesHandler=Vy,t.DoubleClickZoomHandler=Dy,t.DragPanHandler=Fy,t.DragRotateHandler=Oy,t.EdgeInsets=Zf,t.Event=we,t.Evented=Pe,t.FullscreenControl=class extends Pe{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:Bt("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){re.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const t=this._fullscreenButton=re.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);re.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new we("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new we("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},t.GeoJSONSource=Xp,t.GeolocateControl=class extends Pe{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new we("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new we("geolocate",t)),this._finish()}},this._updateCamera=t=>{const e=new Ep(t.coords.longitude,t.coords.latitude),i=t.coords.accuracy,r=St({bearing:this._map.getBearing()},this.options.fitBoundsOptions),n=zp.fromLngLat(e,i);this._map.fitBounds(n,r,{geolocateSource:!0})},this._updateMarker=t=>{if(t){const e=new Ep(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(e).addTo(this._map),this._userLocationDotMarker.setLngLat(e).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()},this._onError=t=>{if(this._map){if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===t.code&&bx)return;this.options.trackUserLocation&&this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new we("error",t)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=re.create("button","maplibregl-ctrl-geolocate",this._container),re.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=t=>{if(this._map){if(!1===t){Bt("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}else{const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=re.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new yx({element:this._dotElement}),this._circleElement=re.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new yx({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new we("trackuserlocationend")),this.fire(new we("userlocationlostfocus")))}))}},this.options=St({},xx,t)}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return n(this,arguments,void 0,(function*(t=!1){if(void 0!==fx&&!t)return fx;if(void 0===window.navigator.permissions)return fx=!!window.navigator.geolocation,fx;try{const t=yield window.navigator.permissions.query({name:"geolocation"});fx="denied"!==t.state}catch(t){fx=!!window.navigator.geolocation}return fx}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),re.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,vx=0,bx=!1}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const t=this._map.getBounds(),e=t.getSouthEast(),i=t.getNorthEast(),r=e.distanceTo(i),n=Math.ceil(this._accuracy/(r/this._map._container.clientHeight)*2);this._circleElement.style.width=`${n}px`,this._circleElement.style.height=`${n}px`}trigger(){if(!this._setup)return Bt("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new we("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":vx--,bx=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new we("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new we("trackuserlocationstart")),this.fire(new we("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),vx++,vx>1?(t={maximumAge:6e5,timeout:0},bx=!0):(t=this.options.positionOptions,bx=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},t.GlobeControl=class{constructor(){this._toggleProjection=()=>{var t;const e=null===(t=this._map.getProjection())||void 0===t?void 0:t.type;this._map.setProjection("mercator"!==e&&e?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon()},this._updateGlobeIcon=()=>{var t;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(t=this._map.getProjection())||void 0===t?void 0:t.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"))}}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=re.create("button","maplibregl-ctrl-globe",this._container),re.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){re.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0}},t.Hash=Gg,t.ImageSource=Kp,t.KeyboardHandler=Ay,t.LngLat=Ep,t.LngLatBounds=zp,t.LogoControl=Hy,t.Map=class extends $y{constructor(t){var e,i;ix.mark(Yy.create);const r=Object.assign(Object.assign(Object.assign({},ux),t),{canvasContextAttributes:Object.assign(Object.assign({},ux.canvasContextAttributes),t.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const n=new Yf,s=new tm;if(void 0!==r.minZoom&&n.setMinZoom(r.minZoom),void 0!==r.maxZoom&&n.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&n.setMinPitch(r.minPitch),void 0!==r.maxPitch&&n.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&n.setRenderWorldCopies(r.renderWorldCopies),super(n,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new Xy,this._controls=[],this._mapId=Ct(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new we("webglcontextlost",{originalEvent:t}))},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new we("webglcontextrestored",{originalEvent:t}))},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},cx),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this.transformCameraUpdate=r.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=ye.addThrottleControl((()=>this.isMoving())),this._requestManager=new xe(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else{if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})),this.once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=Zg((t=>{this._trackResize&&!this._removed&&(this.resize(t),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0})),this._resizeObserver.observe(this._container)}this.handlers=new Gy(this,r),this._hash=r.hash&&new Gg("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,St({},r.fitBoundsOptions,{duration:0}))));const o="string"==typeof r.style||!("globe"===(null===(i=null===(e=r.style)||void 0===e?void 0:e.projection)||void 0===i?void 0:i.type));this.resize(null,o),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new Wy("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new Hy,r.logoPosition),this.on("style.load",(()=>{if(o||this._resizeTransform(),this.transform.unmodified){const t=Mt(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(t)}})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new we(`${t.dataType}data`,t))})),this.on("dataloading",(t=>{this.fire(new we(`${t.dataType}dataloading`,t))})),this.on("dataabort",(t=>{this.fire(new we("sourcedataabort",t))}))}_getMapId(){return this._mapId}setGlobalStateProperty(t,e){return this.style.setGlobalStateProperty(t,e),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(t,e){if(void 0===e&&(e=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new Te(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[e];return-1!==e.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new Te(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const e=this._controls.indexOf(t);return e>-1&&this._controls.splice(e,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}calculateCameraOptionsFromTo(t,e,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,r)}resize(t,e=!0){const[i,r]=this._containerDimensions(),n=this._getClampedPixelRatio(i,r);if(this._resizeCanvas(i,r,n),this.painter.resize(i,r,n),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(i,r);this._resizeCanvas(i,r,e),this.painter.resize(i,r,e)}this._resizeTransform(e);const s=!this._moving;return s&&(this.stop(),this.fire(new we("movestart",t)).fire(new we("move",t))),this.fire(new we("resize",t)),s&&this.fire(new we("moveend",t)),this}_resizeTransform(t=!0){var e;const[i,r]=this._containerDimensions();this.transform.resize(i,r,t),null===(e=this._requestedCameraState)||void 0===e||e.resize(i,r,t)}_getClampedPixelRatio(t,e){const{0:i,1:r}=this._maxCanvasSize,n=this.getPixelRatio(),s=t*n,o=e*n;return Math.min(s>i?i/s:1,o>r?r/o:1)*n}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(zp.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.setMinZoom(t),this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.setMaxZoom(t),this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.setMinPitch(t),this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>180)throw new Error("maxPitch must be less than or equal to 180");if(t>=this.transform.minPitch)return this.transform.setMaxPitch(t),this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.setRenderWorldCopies(t),this._update()}project(t){return this.transform.locationToScreenPoint(Ep.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.screenPointToLocation(c.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t))),o=0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[];o.length?r||(r=!0,i.call(this,new ty(t,this,n.originalEvent,{features:o}))):r=!1};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:()=>{r=!1}}}}if("mouseleave"===t||"mouseout"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t)));(0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[]).length?r=!0:r&&(r=!1,i.call(this,new ty(t,this,n.originalEvent)))},s=e=>{r&&(r=!1,i.call(this,new ty(t,this,e.originalEvent)))};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:s}}}{const r=t=>{const r=e.filter((t=>this.getLayer(t))),n=0!==r.length?this.queryRenderedFeatures(t.point,{layers:r}):[];n.length&&(t.features=n,i.call(this,t),delete t.features)};return{layers:e,listener:i,delegates:{[t]:r}}}}_saveDelegatedListener(t,e){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(e)}_removeDelegatedListener(t,e,i){if(!this._delegatedListeners||!this._delegatedListeners[t])return;const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const n=r[t];if(n.listener===i&&n.layers.length===e.length&&n.layers.every((t=>e.includes(t)))){for(const t in n.delegates)this.off(t,n.delegates[t]);return void r.splice(t,1)}}}on(t,e,i){if(void 0===i)return super.on(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);this._saveDelegatedListener(t,n);for(const t in n.delegates)this.on(t,n.delegates[t]);return{unsubscribe:()=>{this._removeDelegatedListener(t,r,i)}}}once(t,e,i){if(void 0===i)return super.once(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);for(const e in n.delegates){const s=n.delegates[e];n.delegates[e]=(...e)=>{this._removeDelegatedListener(t,r,i),s(...e)}}this._saveDelegatedListener(t,n);for(const t in n.delegates)this.once(t,n.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._removeDelegatedListener(t,"string"==typeof e?[e]:e,i),this)}queryRenderedFeatures(t,e){if(!this.style)return[];let i;const r=t instanceof c||Array.isArray(t),n=r?t:[[0,0],[this.transform.width,this.transform.height]];if(e=e||(r?{}:t)||{},n instanceof c||"number"==typeof n[0])i=[c.convert(n)];else{const t=c.convert(n[0]),e=c.convert(n[1]);i=[t,new c(e.x,t.y),e,new c(t.x,e.y),t]}return this.style.queryRenderedFeatures(i,e,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,e){return!1!==(e=St({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},e)).diff&&e.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,e),this):(this._localIdeographFontFamily=e.localIdeographFontFamily,this._updateStyle(t,e))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){var i,r;if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const n=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new Fm(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,n):this.style.loadJSON(t,e,n),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new Fm(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(t,e){if("string"==typeof t){const i=this._requestManager.transformRequest(t,"Style");he(i,new AbortController).then((t=>{this._updateDiff(t.data,e)})).catch((t=>{t&&this.fire(new Te(t))}))}else"object"==typeof t&&this._updateDiff(t,e)}_updateDiff(t,e){try{this.style.setState(t,e)&&this._update(!0)}catch(i){Bt(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(t,e)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():Bt("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const e=this.style&&this.style.sourceCaches[t];if(void 0!==e)return e.loaded();this.fire(new Te(new Error(`There is no source with ID '${t}'`)))}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const e=this.style.sourceCaches[t.source];if(!e)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&e.reload();for(const e in this.style._layers){const i=this.style._layers[e];"hillshade"===i.type&&i.source===t.source&&Bt("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===i.type&&i.source===t.source&&Bt("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new sx(this.painter,e,t),this.painter.renderToTexture=new lx(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=e=>{var i;"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=e.source)||void 0===i?void 0:i.type)?this.terrain.sourceCache.freeRtt():this.terrain.sourceCache.freeRtt(e.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new we("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}}return!0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}setSourceTileLodParams(t,e,i){if(i){const r=this.getSource(i);if(!r)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);r.calculateTileZoom=bd(Math.max(1,t),Math.max(1,e))}else for(const i in this.style.sourceCaches)this.style.sourceCaches[i].getSource().calculateTileZoom=bd(Math.max(1,t),Math.max(1,e));return this._update(!0),this}refreshTiles(t,e){const i=this.style.sourceCaches[t];if(!i)throw new Error(`There is no source cache with ID "${t}", cannot refresh tile`);void 0===e?i.reload(!0):i.refreshTiles(e.map((t=>new Gp(t.z,t.x,t.y))))}addImage(t,e,i={}){const{pixelRatio:r=1,sdf:n=!1,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(e instanceof HTMLImageElement||Vt(e))){if(void 0===e.width||void 0===e.height)return this.fire(new Te(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=e,p=e;return this.style.addImage(t,{data:new gc({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0,userImage:p}),p.onAdd&&p.onAdd(this,t),this}}{const{width:i,height:h,data:u}=ie.getImageData(e);this.style.addImage(t,{data:new gc({width:i,height:h},u),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0})}}updateImage(t,e){const i=this.style.getImage(t);if(!i)return this.fire(new Te(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=e instanceof HTMLImageElement||Vt(e)?ie.getImageData(e):e,{width:n,height:s,data:o}=r;if(void 0===n||void 0===s)return this.fire(new Te(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(n!==i.data.width||s!==i.data.height)return this.fire(new Te(new Error("The width and height of the updated image must be that same as the previous version of the image")));const a=!(e instanceof HTMLImageElement||Vt(e));return i.data.replace(o,a),this.style.updateImage(t,i),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new Te(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t)}loadImage(t){return ye.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,r={}){return this.style.setPaintProperty(t,e,i,r),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,r={}){return this.style.setLayoutProperty(t,e,i,r),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0)})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0)})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSky(t,e),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=re.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=re.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const n=this._controlContainer=re.create("div","maplibregl-control-container",t),s=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{s[t]=re.create("div",`maplibregl-ctrl-${t} `,n)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`}_setupPainter(){const t=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type)}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,t):this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t),!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new Ug(i,this.transform),pe.testSupport(i)}migrateProjection(t,e){super.migrateProjection(t,e),this.painter.transform=t,this.fire(new we("projectiontransition",{newProjection:this.style.projection.name}))}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t)}_render(t){var e,i,r,n,s;const o=this._idleTriggered?this._fadeDuration:0,a=(null===(e=this.style.projection)||void 0===e?void 0:e.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let l=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,e=ie.now();this.style.zoomHistory.update(t,e);const i=new ko(t,{now:e,fadeDuration:o,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition(),globalState:this.style.getGlobalState()}),r=i.crossFadingFactor();1===r&&r===this._crossFadingFactor||(l=!0,this._crossFadingFactor=r),this.style.update(i)}const c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0!==a;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(n=this.style.projection)||void 0===n?void 0:n.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||c)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,o,this._crossSourceCollisions,c),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:o,showPadding:this.showPadding}),this.fire(new we("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,ix.mark(Yy.load),this.fire(new we("load"))),this.style&&(this.style.hasTransitions()||l)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const h=this._sourcesDirty||this._styleDirty||this._placementDirty;return h||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new we("idle")),!this._loaded||this._fullyLoaded||h||(this._fullyLoaded=!0,ix.mark(Yy.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),ye.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const e=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==e?void 0:e.loseContext)&&e.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),re.remove(this._canvasContainer),re.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),ix.clearMetrics(),this._removed=!0,this.fire(new we("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,ie.frame(this._frameRequest,(t=>{ix.frame(t),this._frameRequest=null;try{this._render(t)}catch(t){if(!function(t){return t.message===Jt}(t)&&!function(t){return t.message===ag}(t))throw t}}),(()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update())}get showPadding(){return!!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update())}get repaint(){return!!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(t){this._vertices=t,this._update()}get version(){return hx}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(t){return this._lazyInitEmptyStyle(),this.style.setProjection(t),this._update(!0)}},t.MapMouseEvent=ty,t.MapTouchEvent=ey,t.MapWheelEvent=iy,t.Marker=yx,t.MercatorCoordinate=jp,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i)},this.options=St({},px,t),this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),re.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),re.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t})})),this._compassIcon=re.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new dx(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){re.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(t,e){const i=re.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Point=c,t.Popup=class extends Pe{constructor(t){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:"")},this.remove=()=>(this._content&&re.remove(this._content),this._container&&(re.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new we("close"))),this),this._onMouseUp=t=>{this._update(t.point)},this._onMouseMove=t=>{this._update(t.point)},this._onDrag=t=>{this._update(t.point)},this._update=t=>{if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=re.create("div","maplibregl-popup",this._map.getContainer()),this._tip=re.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=mx(this._lngLat,this._flatPos,this._map.transform,this._trackPointer),this._trackPointer&&!t)return;const e=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationToScreenPoint(this._lngLat));let i=this.options.anchor;const r=Ix(this.options.offset);if(!i){const t=this._container.offsetWidth,n=this._container.offsetHeight;let s;s=e.y+r.bottom.y<n?["top"]:e.y>this._map.transform.height-n?["bottom"]:[],e.x<t/2?s.push("left"):e.x>this._map.transform.width-t/2&&s.push("right"),i=0===s.length?"bottom":s.join("-")}let n=e.add(r[i]);this.options.subpixelPositioning||(n=n.round()),re.setTransform(this._container,`${_x[i]} translate(${n.x}px,${n.y}px)`),gx(this._container,i,"popup"),this._updateOpacity()},this._onClose=()=>{this.remove()},this.options=St(Object.create(Sx),t)}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new we("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=Ep.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=t;r=i.firstChild,r;)e.appendChild(r);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=re.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t}_createCloseButton(){this.options.closeButton&&(this._closeButton=re.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(Mx);t&&t.focus()}},t.RasterDEMTileSource=Hp,t.RasterTileSource=Up,t.ScaleControl=class{constructor(t){this._onMove=()=>{Tx(this._map,this._container,this.options)},this.setUnit=t=>{this.options.unit=t,Tx(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},wx),t)}getDefaultPosition(){return"bottom-left"}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){re.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},t.ScrollZoomHandler=Ry,t.Style=Fm,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=t}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=re.create("button","maplibregl-ctrl-terrain",this._container),re.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){re.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},t.TwoFingersTouchPitchHandler=Iy,t.TwoFingersTouchRotateHandler=Sy,t.TwoFingersTouchZoomHandler=Ty,t.TwoFingersTouchZoomRotateHandler=jy,t.VectorTileSource=Np,t.VideoSource=Jp,t.addProtocol=function(t,e){ne.REGISTERED_PROTOCOLS[t]=e},t.addSourceType=(t,e)=>n(void 0,void 0,void 0,(function*(){if(ed(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{td[t]=e})(t,e)})),t.clearPrewarmedResources=function(){const t=xp;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(_p),xp=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},t.config=ne,t.createTileMesh=hm,t.getMaxParallelImageRequests=function(){return ne.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return cd().getRTLTextPluginStatus()},t.getVersion=function(){return Cx},t.getWorkerCount=function(){return gp.workerCount},t.getWorkerUrl=function(){return ne.WORKER_URL},t.importScriptInWorkers=function(t){return Tp().broadcast("IS",t)},t.prewarm=function(){bp().acquire(_p)},t.removeProtocol=function(t){delete ne.REGISTERED_PROTOCOLS[t]},t.setMaxParallelImageRequests=function(t){ne.MAX_PARALLEL_IMAGE_REQUESTS=t},t.setRTLTextPlugin=function(t,e){return cd().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){gp.workerCount=t},t.setWorkerUrl=function(t){ne.WORKER_URL=t}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
