import React from 'react';
import { Paper, Typography, useMediaQuery } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import { useTheme } from '@mui/material/styles';

const useStyles = makeStyles()((theme) => ({
  root: {
    display: 'flex',
    height: '100%',
  },
  sidebar: {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    background: '#1E90FF', // azul
    paddingBottom: theme.spacing(5),
    width: theme.dimensions.sidebarWidth,
    [theme.breakpoints.down('lg')]: {
      width: theme.dimensions.sidebarWidthTablet,
    },
    [theme.breakpoints.down('sm')]: {
      width: '0px', // some no mobile (mostraremos a marca no Paper)
    },
  },
  paper: {
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
    boxShadow: '-2px 0px 16px rgba(0, 0, 0, 0.25)',
    [theme.breakpoints.up('lg')]: {
      padding: theme.spacing(0, 25, 0, 0),
    },
  },
  form: {
    maxWidth: theme.spacing(52),
    padding: theme.spacing(5),
    width: '100%',
  },
  brandWrap: {
    textAlign: 'center',
    color: '#fff',
    userSelect: 'none',
  },
  // logo grande no sidebar
  brandLogo: {
    display: 'block',
    maxWidth: 240,
    width: '80%',
    height: 'auto',
    margin: '0 auto',
    filter: 'brightness(100%)',
  },
  brandSubtitle: {
    opacity: 0.95,
    marginTop: theme.spacing(0.5), // mais perto do logo
    fontWeight: 500,
  },
  // Marca para telas pequenas (dentro do Paper)
  mobileBrand: {
    textAlign: 'center',
    marginBottom: theme.spacing(3),
    userSelect: 'none',
  },
  mobileLogo: {
    display: 'block',
    maxWidth: 160,
    width: '60%',
    height: 'auto',
    margin: '0 auto',
  },
}));

const LoginLayout = ({ children }) => {
  const { classes } = useStyles();
  const theme = useTheme();
  const isLgDown = useMediaQuery(theme.breakpoints.down('lg'));
  const isSmDown = useMediaQuery(theme.breakpoints.down('sm'));

  return (
    <main className={classes.root}>
      {/* Lateral esquerda (mostra logo em telas médias/grandes) */}
      <div className={classes.sidebar}>
        {!isLgDown && (
          <div className={`${classes.brandWrap} notranslate`} translate="no">
            <img
              src="/logo_achaeu.png" // coloque o arquivo em /public
              alt="AchaEU"
              className={classes.brandLogo}
              loading="eager"
            />
            <Typography variant="h6" className={classes.brandSubtitle} translate="no">
              Plataforma de Rastreamento
            </Typography>
          </div>
        )}
      </div>

      {/* Área do formulário */}
      <Paper className={classes.paper}>
        <form className={classes.form}>
          {/* Em telas pequenas, mostra o logo aqui */}
          {isSmDown && (
            <div className="notranslate" translate="no">
              <img
                src="/logo_achaeu.png"
                alt="AchaEU"
                className={classes.mobileLogo}
                loading="eager"
              />
              <Typography
                variant="body2"
                className={classes.mobileBrand}
                sx={{ marginTop: 0, marginBottom: 2, fontWeight: 500, color: 'text.secondary' }}
                translate="no"
              >
                Central de Monitoramento
              </Typography>
            </div>
          )}

          {children}
        </form>
      </Paper>
    </main>
  );
};

export default LoginLayout;
