import React from 'react';
import Drawer from '@mui/material/Drawer';
import { useSelector } from 'react-redux';
import { Box, Typography, Divider, List, ListItem, ListItemText } from '@mui/material';

const DeviceDetailsDrawer = ({ open, onClose }) => {
  const devices = useSelector((state) => state.devices.items || {});
  const selectedDeviceId = useSelector((state) => state.devices.selectedId);
  const positions = useSelector((state) => state.session.positions || {});

  const device = devices?.[selectedDeviceId];
  const position = positions?.[selectedDeviceId];

  if (!device) return null;

  return (
    <Drawer anchor="right" open={open} onClose={onClose}>
      <Box sx={{ width: 350, p: 2 }}>
        <Typography variant="h6" gutterBottom>
          {device.name || 'Dispositivo'}
        </Typography>

        <Divider sx={{ my: 2 }} />

        <List dense>
          <ListItem>
            <ListItemText primary="ID" secondary={device.id} />
          </ListItem>
          <ListItem>
            <ListItemText primary="Modelo" secondary={device.model || '—'} />
          </ListItem>
          <ListItem>
            <ListItemText primary="Grupo" secondary={device.groupId || '—'} />
          </ListItem>
          <ListItem>
            <ListItemText primary="Status" secondary={device.status || '—'} />
          </ListItem>
          <ListItem>
            <ListItemText
              primary="Última posição"
              secondary={
                position?.fixTime
                  ? new Date(position.fixTime).toLocaleString()
                  : 'Sem dados'
              }
            />
          </ListItem>
          <ListItem>
            <ListItemText
              primary="Velocidade"
              secondary={
                position?.speed != null ? `${(position.speed * 1.852).toFixed(1)} km/h` : '—'
              }
            />
          </ListItem>
          <ListItem>
            <ListItemText
              primary="Endereço"
              secondary={position?.address || '—'}
            />
          </ListItem>
        </List>
      </Box>
    </Drawer>
  );
};

export default DeviceDetailsDrawer;
