import { useSelector } from 'react-redux';
import { Paper, Typography, Divider, Grid } from '@mui/material';

const DeviceDetailsPanel = () => {
  const selectedDeviceId = useSelector((state) => state.devices.selectedId);
  const devices = useSelector((state) => state.devices.items);
  const positions = useSelector((state) => state.session.positions);

  if (!selectedDeviceId) return null;

  const device = devices.find((d) => d.id === selectedDeviceId);
  const position = positions.find((p) => p.deviceId === selectedDeviceId);

  if (!device || !position) return null;

  const deviceTime = new Date(position.deviceTime);
  const now = new Date();
  const diffMs = now - deviceTime;
  const diffMin = Math.floor(diffMs / 60000);
  const diffDays = Math.floor(diffMs / 1000 / 60 / 60 / 24);

  return (
    <Paper elevation={3} sx={{ p: 2, width: 420, height: '100%', overflowY: 'auto', bgcolor: '#fff' }}>
      <Typography variant="h6" gutterBottom>
        {device.name}
      </Typography>

      <Grid container spacing={1}>
        <Grid item xs={6}><strong>IMEI:</strong></Grid>
        <Grid item xs={6}>{device.uniqueId}</Grid>

        <Grid item xs={6}><strong>Modelo:</strong></Grid>
        <Grid item xs={6}>{device.model || 'GT06'}</Grid>

        <Grid item xs={6}><strong>Velocidade:</strong></Grid>
        <Grid item xs={6}>{(position.speed * 1.852).toFixed(1)} km/h</Grid>

        <Grid item xs={6}><strong>Latitude:</strong></Grid>
        <Grid item xs={6}>{position.latitude}</Grid>

        <Grid item xs={6}><strong>Longitude:</strong></Grid>
        <Grid item xs={6}>{position.longitude}</Grid>

        <Grid item xs={6}><strong>Altitude:</strong></Grid>
        <Grid item xs={6}>{position.altitude} m</Grid>

        <Grid item xs={6}><strong>Hora GPS:</strong></Grid>
        <Grid item xs={6}>{deviceTime.toLocaleString()}</Grid>

        <Grid item xs={6}><strong>Parado há:</strong></Grid>
        <Grid item xs={6}>
          {diffDays > 0 ? `${diffDays} dia(s)` : `${diffMin} minutos`}
        </Grid>

        <Grid item xs={12}>
          <Divider sx={{ my: 1 }} />
        </Grid>

        <Grid item xs={12}>
          <Typography variant="body2" color="text.secondary">
            Endereço: <br />
            <em>{position.address || 'Endereço não disponível'}</em>
          </Typography>
        </Grid>
      </Grid>
    </Paper>
  );
};

export default DeviceDetailsPanel;
