// src/main/FilterPopover.jsx
import {
  Popover,
  FormControl,
  InputLabel,
  Select,
  MenuItem,
  FormGroup,
  FormControlLabel,
  Checkbox,
} from '@mui/material';
import { useTranslation } from '../common/components/LocalizationProvider';
import FilterPopover from './FilterPopover';


const FilterPopover = ({
  anchorEl,
  onClose,
  filter,
  setFilter,
  filterSort,
  setFilterSort,
  filterMap,
  setFilterMap,
}) => {
  const t = useTranslation();

  const handleStatusChange = (event) => {
    const value = event.target.value;
    setFilter((prev) => ({
      ...prev,
      statuses: value.length ? [value] : [],
    }));
  };

  const handleGroupChange = (event) => {
    const value = event.target.value;
    setFilter((prev) => ({
      ...prev,
      groups: value.length ? [value] : [],
    }));
  };

  const handleSortChange = (event) => {
    setFilterSort(event.target.value);
  };

  const handleMapChange = (event) => {
    setFilterMap(event.target.checked);
  };

  return (
    <Popover
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      onClose={onClose}
      anchorOrigin={{ vertical: 'bottom', horizontal: 'left' }}
    >
      <div style={{ padding: 16, width: 220 }}>
        <FormControl fullWidth size="small" margin="dense">
          <InputLabel>Estado</InputLabel>
          <Select value={filter.statuses[0] || ''} onChange={handleStatusChange}>
            <MenuItem value=""><em>Todos</em></MenuItem>
            <MenuItem value="online">Online</MenuItem>
            <MenuItem value="offline">Offline</MenuItem>
            <MenuItem value="unknown">Desconhecido</MenuItem>
          </Select>
        </FormControl>

        <FormControl fullWidth size="small" margin="dense">
          <InputLabel>Grupos</InputLabel>
          <Select value={filter.groups[0] || ''} onChange={handleGroupChange}>
            <MenuItem value=""><em>Todos</em></MenuItem>
            {/* Os grupos vêm do Redux. Você pode passar como prop também se quiser. */}
          </Select>
        </FormControl>

        <FormControl fullWidth size="small" margin="dense">
          <InputLabel>Organizar por</InputLabel>
          <Select value={filterSort} onChange={handleSortChange}>
            <MenuItem value=""><em>Padrão</em></MenuItem>
            <MenuItem value="name">Nome</MenuItem>
            <MenuItem value="lastUpdate">Última atualização</MenuItem>
          </Select>
        </FormControl>

        <FormGroup>
          <FormControlLabel
            control={<Checkbox checked={filterMap} onChange={handleMapChange} />}
            label="Filtrar no mapa"
          />
        </FormGroup>
      </div>
    </Popover>
  );
};

export default FilterPopover;
