// useFilter.js
import { useEffect } from 'react';
import { useSelector } from 'react-redux';
import dayjs from 'dayjs';

export default (keyword, filter, filterSort, filterMap, positions, setFilteredDevices, setFilteredPositions) => {
  const groups = useSelector((state) => state.groups.items);
  const devices = useSelector((state) => state.devices.items);

  useEffect(() => {
    const deviceGroups = (device) => {
      const groupIds = [];
      let { groupId } = device;
      while (groupId) {
        groupIds.push(groupId);
        groupId = groups[groupId]?.groupId || 0;
      }
      return groupIds;
    };

    // comece sempre de uma cópia e imponha uma ordem base
    const base = Object.values(devices).slice()
      .sort((a, b) => String(a.id).localeCompare(String(b.id)));

    const filtered = base
      .filter((device) => !filter.statuses.length || filter.statuses.includes(device.status))
      .filter((device) => !filter.groups.length || deviceGroups(device).some((id) => filter.groups.includes(id)))
      .filter((device) => {
        const lower = keyword.toLowerCase();
        return [device.name, device.uniqueId, device.phone, device.model, device.contact]
          .some((s) => s && s.toLowerCase().includes(lower));
      });

    switch (filterSort) {
      case 'name':
        filtered.sort((a, b) => a.name.localeCompare(b.name));
        break;
      case 'lastUpdate':
        filtered.sort((a, b) => {
          const t1 = a.lastUpdate ? dayjs(a.lastUpdate).valueOf() : 0;
          const t2 = b.lastUpdate ? dayjs(b.lastUpdate).valueOf() : 0;
          return t2 - t1;
        });
        break;
      default:
        // já está estável por id
        break;
    }

    setFilteredDevices(filtered);

    setFilteredPositions(
      filterMap
        ? filtered.map((d) => positions[d.id]).filter(Boolean)
        : Object.values(positions)
    );
  }, [keyword, filter, filterSort, filterMap, groups, devices, positions, setFilteredDevices, setFilteredPositions]);
};
