import React, { useState } from 'react';
import { TextField, Button, MenuItem, Grid, Paper, Typography } from '@mui/material';

const SalesForm = ({ onSubmit }) => {
  const [form, setForm] = useState({
    buyerName: '',
    buyerRg: '',
    buyerCpf: '',
    buyerBirthDate: '',
    buyerPhone: '',
    buyerEmail: '',
    buyerPassword: '',
    deviceName: '',
    deviceImei: '',
    vehiclePlate: '',
    vehicleChassi: '',
    vehicleRenavam: '',
    vehicleYear: '',
    plan: 'basic'
  });

  const handleChange = (e) => {
    setForm({ ...form, [e.target.name]: e.target.value });
  };

  const handleSubmit = () => {
    onSubmit(form);
  };

  return (
    <Paper sx={{ p: 3 }}>
      <Typography variant="h6" gutterBottom>Nova Venda</Typography>
      <Grid container spacing={2}>
        <Grid item xs={6}><TextField fullWidth label="Nome do Cliente" name="buyerName" value={form.buyerName} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="RG" name="buyerRg" value={form.buyerRg} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="CPF" name="buyerCpf" value={form.buyerCpf} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth type="date" label="Data de Nascimento" name="buyerBirthDate" value={form.buyerBirthDate} onChange={handleChange} InputLabelProps={{ shrink: true }} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Telefone" name="buyerPhone" value={form.buyerPhone} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="E-mail" name="buyerEmail" value={form.buyerEmail} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth type="password" label="Senha" name="buyerPassword" value={form.buyerPassword} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Nome do Dispositivo" name="deviceName" value={form.deviceName} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="IMEI do Dispositivo" name="deviceImei" value={form.deviceImei} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Placa" name="vehiclePlate" value={form.vehiclePlate} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Chassi" name="vehicleChassi" value={form.vehicleChassi} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Renavam" name="vehicleRenavam" value={form.vehicleRenavam} onChange={handleChange} /></Grid>
        <Grid item xs={6}><TextField fullWidth label="Ano de Fabricação" name="vehicleYear" value={form.vehicleYear} onChange={handleChange} /></Grid>
        <Grid item xs={12}>
          <TextField select fullWidth label="Plano" name="plan" value={form.plan} onChange={handleChange}>
            <MenuItem value="basic">Básico - R$ 59,90</MenuItem>
            <MenuItem value="standard">Padrão - R$ 79,90</MenuItem>
            <MenuItem value="premium">Premium - R$ 99,90</MenuItem>
          </TextField>
        </Grid>
        <Grid item xs={12}>
          <Button variant="contained" color="primary" onClick={handleSubmit} fullWidth>Fazer Venda</Button>
        </Grid>
      </Grid>
    </Paper>
  );
};

export default SalesForm;
