import { useNavigate } from 'react-router-dom';
import {
  Paper, Typography, IconButton, List, ListItem, ListItemText, Divider,
} from '@mui/material';
import AddIcon from '@mui/icons-material/Add';

const mockSales = [
  { id: 1, client: 'Cliente A', value: 1500 },
  { id: 2, client: 'Cliente B', value: 2500 },
];

const SalesList = () => {
  const navigate = useNavigate();

  return (
    <Paper style={{ padding: 16 }}>
      <Typography variant="h6" gutterBottom>Vendas</Typography>
      <IconButton onClick={() => navigate('/sales/new')}>
        <AddIcon />
      </IconButton>
      <List>
        {mockSales.map((sale) => (
          <div key={sale.id}>
            <ListItem button onClick={() => navigate(`/sales/${sale.id}`)}>
              <ListItemText
                primary={sale.client}
                secondary={`Valor: R$ ${sale.value}`}
              />
            </ListItem>
            <Divider />
          </div>
        ))}
      </List>
    </Paper>
  );
};

export default SalesList;
